
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for 13geng.pov
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare Side_entab_infill =
union {
	cylinder {<.5,7,-3><4.75,12,-3>,.25}
	cylinder {<.5,12,-3><4.75,7,-3>,.25}
	cylinder {<1.13,9.5,-3><4.13,9.5,-3>,.2}
	cylinder {<2.63,11,-3><2.63,8,-3>,.2}
	cylinder {<5,7,-3><5,12,-3>,.25}
	cylinder {<5.25,7,-3><9.5,12,-3>,.25}
	cylinder {<5.25,12,-3><9.5,7,-3>,.25}
	cylinder {<5.88,9.5,-3><8.88,9.5,-3>,.2}
	cylinder {<7.38,8,-3><7.38,11,-3>,.2}
}

#declare Side_entab =
union {
	box {<65,3,0><-65,5,-6> texture{T_Render}}
	box {<65,2,0><-65,3,-3> texture{T_Render}}

	#declare Count = 0
	#while (Count < 27)
		box {<-66,1,0><-64,3,-4> translate <(Count * 5),0,0> texture{T_Wall1}}
		#declare Count = (Count + 1)
	#end

	#declare Count = 0
	#while (Count < 14)
		box {<-65.5,5,-2.5><-64.5,13,-3.5> translate <(Count * 10),0,0> texture{T_rail}}
		sphere {<-65,13.5,-3>,.5 translate <(Count * 10),0,0> texture{T_rail}}
		#declare Count = (Count + 1)
	#end

	#declare Count = 0
	#while (Count < 13)
		object {Side_entab_infill translate <(-65 + (Count * 10)),0,0> texture{T_rail2}}
		#declare Count = (Count + 1)
	#end

	box {<-65,6.25,-3.32><65,7,-2.68> texture{T_rail}}
	box {<-65,12,-3.32><65,12.75,-2.68> texture{T_rail}}
}

#declare Entab_post =
union {
	box {<.5,5,.5><-.5,13,-.5>}
	sphere {<0,13.5,0>,.5}
}

#declare Entab_infill =
union {
	cylinder {<0,7,0><5.75,12,0>,.25}
	cylinder {<0,12,0><5.75,7,0>,.25}
	cylinder {<1.38,9.5,0><4.38,9.5,0>,.2}
	cylinder {<2.88,8,0><2.88,11,0>,.2}
}

#declare Entab_corner =
union {
	box {<-26,3,-6><6,5,6> texture{T_Render}}
	box {<-23,2,-3><3,3,6> texture{T_Render}}

	box {<-24,1,0><-20,3,2> texture{T_Wall1}}
	box {<-20,1,-4><-18,3,0> texture{T_Wall1}}
	box {<-15.5,1,-4><-13.5,3,0> texture{T_Wall1}}
	box {<-11,1,-4><-9,3,0> texture{T_Wall1}}
	box {<-6.5,1,-4><-4.5,3,0> texture{T_Wall1}}
	box {<-2,1,-4><0,3,0> texture{T_Wall1}}
	box {<0,1,0><4,3,2> texture{T_Wall1}}

	object {Entab_post translate <-23,0,0> texture{T_rail}}
	object {Entab_post translate <-23,0,-3> texture{T_rail}}
	object {Entab_post translate <-10,0,-3> texture{T_rail}}
	object {Entab_post translate <3,0,-3> texture{T_rail}}
	object {Entab_post translate <3,0,0> texture{T_rail}}

	object {Entab_infill translate <-22.5,0,-3> texture{T_rail2}}
	object {Entab_infill translate <-16.25,0,-3> texture{T_rail2}}
	object {Entab_infill translate <-10,0,-3> texture{T_rail2}}
	object {Entab_infill translate <-3.5,0,-3> texture{T_rail2}}

	box {<-22.5,6.25,-2.68><2.5,7,-3.32> texture{T_rail}}
	box {<-22.5,12,-2.68><2.5,12.75,-3.32> texture{T_rail}}
	cylinder {<-16.5,7,-3><-16.5,12,-3>,.25 texture{T_rail2}}
	cylinder {<-3.5,7,-3><-3.5,12,-3>,.25 texture{T_rail2}}

}

#declare Entab_post2 =
union {
	cylinder {<0,5,0><0,13,0>,.5}
	sphere {<0,13.5,0>,.5}
}

#declare Entab_infill2 =
union {
	cylinder {<0,6.675,0><13.3,6.675,0>,.325 texture{T_rail}}
	cylinder {<0,12.425,0><13.3,12.425,0>,.325 texture{T_rail}}
	cylinder {<6.65,7,0><6.65,12,0>,.25 texture{T_rail}}
	cylinder {<.5,7,0><6.4,12,0>,.25 texture{T_rail2}}
	cylinder {<.5,12,0><6.4,7,0>,.25 texture{T_rail2}}
	cylinder {<6.9,7,0><12.8,12,0>,.25 texture{T_rail}}
	cylinder {<6.9,12,0><12.8,7,0>,.25 texture{T_rail}}
	cylinder {<3.45,8,0><3.45,11,0>,.2 texture{T_rail}}
	cylinder {<1.95,9.5,0><4.95,9.5,0>,.2 texture{T_rail}}
	cylinder {<9.85,8,0><9.85,11,0>,.2 texture{T_rail}}
	cylinder {<8.35,9.5,0><11.35,9.5,0>,.2 texture{T_rail}}
}

#declare Entab_dentil =
box {<-1,1,1><1,3,-4> texture{T_Wall1}}

#declare Entab_round =
union {
	difference {
		union {
			difference {
				union {
					cylinder {<0,3,0><0,5,0>,65}
					cylinder {<-25,3,53><-25,5,53>,28}
				}
				cylinder {<0,0,0><0,10,0>,59}
				cylinder {<-25,0,53><-25,10,53>,22}
			}
			difference {
				union {
					cylinder {<0,2,0><0,3,0>,65}
					cylinder {<-25,2,53><-25,3,53>,28}
				}
				cylinder {<0,0,0><0,10,0>,62}
				cylinder {<-25,0,53><-25,10,53>,25}
			}
		}
		box {<0,-100,500><500,500,-500>}
		box {<-200,-200,-200><200,200,28>}
	}

	object {Entab_post2 texture{T_rail} translate <-54,0,30>}
	object {Entab_post2 texture{T_rail} translate <-46,0,41>}
	object {Entab_post2 texture{T_rail} translate <-49,0,54>}
	object {Entab_post2 texture{T_rail} translate <-45,0,67>}
	object {Entab_post2 texture{T_rail} translate <-35,0,76>}
	object {Entab_post2 texture{T_rail} translate <-22,0,78>}
	object {Entab_post2 texture{T_rail} translate <-10,0,73>}
	object {Entab_post2 texture{T_rail} translate <-2,0,62>}

	object {Entab_infill2 translate <0,0,25> rotate <0,-119.5,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,25> rotate <0,-88.01,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,25> rotate <0,-56.52,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,25> rotate <0,-25.03,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,25> rotate <0,6.46,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,25> rotate <0,37.95,0> translate <-25,0,53>}
//	object {Entab_infill2 translate <0,0,25> rotate <0,69.44,0> translate <-25,0,53>}
	object {Entab_infill2 translate <0,0,62> rotate <0,-60.54,0>}

	object {Entab_dentil translate <0,0,28> rotate <0,-108,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,-90,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,-72,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,-54,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,-36,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,-18,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,18,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,36,0> translate <-25,0,53>}
	object {Entab_dentil translate <0,0,28> rotate <0,54,0> translate <-25,0,53>}

	object {Entab_dentil translate <0,0,65> rotate <0,-54,0>}
	object {Entab_dentil translate <0,0,65> rotate <0,-60,0>}

}
