
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for 13geng.pov
// Date: Feb 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare Top_cut =
merge {
	box {<2.5,170,500><-2.5,188,-500>}
	cylinder {<0,188,500><0,188,-500>,2.5}
}

#declare Top_button =
box {<1,0,64.6><-1,2,65>
	pigment { color <0.9,0.8,0.4>}
	finish{phong 1 reflection 0.15 metallic}
}

#declare Top_rib =
union {
difference {
	sphere {<0,178,0>,72}
	sphere {<0,178,0>,64.8}
	box {<2,500,500><500,-500,-500>}
	box {<-2,500,500><-500,-500,-500>}
	box {<600,178,600><-600,-600,-600>}
}
#declare Count = 0
#while (Count < 30)
	object {Top_button rotate <(Count * -6),0,0> translate <0,177,0>}
	#declare Count = (Count + 1)
#end
}

#declare Top_dome =
union {

difference {
	sphere {<0,178,0>,67 texture{T_Top_dome}}
	sphere {<0,178,0>,65 texture{T_Top_dome}}
	box {<200,0,200><-200,178,-200> texture{T_Top_dome}}

	#declare Count = 0
	#while (Count < 20)
		object {Top_cut rotate <0,(Count * 9),0> texture{T_Top_dome}}
		#declare Count = (Count + 1)
	#end
}

#declare Count = 0
#while (Count < 20)
	object {Top_rib rotate <0,((Count * 9) + 4.5),0> pigment{colour <.3,.1,.1>} finish{phong .5}}
#declare Count = (Count + 1)
#end

}
