
// Persistence of Vision Ray Tracer Scene Description File
// File: Board_ISA_FDD.inc
// Vers: 3
// Desc: Floppy disk drive controller for IBM PC (8088 motherboard)
// Date: Feb 9th 1998
// Auth: morgan Fraser

#declare Chip_SN74LS191N=union{
    box{<-5/2,0.5,-17/2>,<5/2,3,17/2>}

    union{
        #declare Pins_Count=6
        #declare Pins_Height=1.5
        #declare Pins_ChipWidth=5
        #declare Pins_Length=12.25
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_BIGONE=union{

    box{<-50/2,1,-13/2>,<50/2,4.5,13/2>}

    union{
        #declare Pins_Count=20
        #declare Pins_Height=2.5
        #declare Pins_ChipWidth=13
        #declare Pins_Length=48
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
    }

    texture{T_ChipBody}

}

#declare Chip_7438PC=union{
    difference{
        box{<-3,0.5,-19/2>,<3,3,19/2>}
        cylinder{<0,2,19/2>,<0,3.01,19/2>,0.5}
    }

    union{
        #declare Pins_Count=7
        #declare Pins_Height=2
        #declare Pins_ChipWidth=6
        #declare Pins_Length=14
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_SN74LS153N=union{

    difference{
        box{<-3,0.25,-19/2>,<3,3,19/2>}
        box{<-1.7/2,2.25,19.01/2>,<1.7/2,3.01,19/2-2>}
        cylinder{<0,2.5,-19/2+1.5>,<0,3.01,19/2+1.5>,0.5}
    }

    union{
        #declare Pins_Count=6
        #declare Pins_Height=2
        #declare Pins_ChipWidth=6
        #declare Pins_Length=13
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_74LS175PC=union{
    difference{
        box{<-3,0.5,-19/2>,<3,3,19/2>}
        cylinder{<0,2.25,19/2>,<0,3.01,19/2>,1.5/2}
        cylinder{<-2,2.5,19/2-1.75>,<-2,3.01,19/2-1.75>,0.6}
    }

    union{
        #declare Pins_Count=6
        #declare Pins_Height=2
        #declare Pins_ChipWidth=6
        #declare Pins_Length=13
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_Q5520002=union{
    box{<-3,2.5,-11>,<3,2.7,11>}
    box{<-3,0.95,-11>,<3,2.5,11> texture{T_ChipWhiteBody}}
    box{<-3,0.75,-11>,<3,0.95,11>}

    union{
        #declare Pins_Count=8
        #declare Pins_Height=2
        #declare Pins_ChipWidth=5.5
        #declare Pins_Length=18
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_74LS02=union{
    difference{
        box{<-3,0.75,-19/2>,<3,3,19/2>}
        cylinder{<0,1.9,19/2>,<0,3.01,19/2>,0.8/2}
    }

    union{
        #declare Pins_Count=7
        #declare Pins_Height=2
        #declare Pins_ChipWidth=5.7
        #declare Pins_Length=15.5
        #declare Pins_IncludeSoderPoint=1
        #include "ChipPins.inc"
        rotate<0,90,0>
    }

    texture{T_ChipBody}
}

#declare Chip_SN74LS112AN=object{Chip_SN74LS191N}
#declare Chip_SN74LS161AN=object{Chip_SN74LS191N}
#declare Chip_SN74S153N=object{Chip_SN74LS191N}

#declare Crystal_16MHZ=union{
    box{<-5,.5,-9>,<5,5,9>}
    box{<-5.5,0.25,-9.5>,<5.5,0.5,9.5>}
    texture{T_Steel}
}

#declare Resistor_FDDR6=union{
    sphere{<-2,1,0>,1}
    sphere{<2,1,0>,1}
    cylinder{<-2,1,0>,<2,1,0>,0.5}
    union{
        object{SoderPoint translate<-6,0,0>}
        #declare Wire_Width=.4
        #declare Wire_StartSeg=<-6,0,0>
        #declare Wire_EndSeg=<-5,1,0>
        #include "Wire.inc"
        #declare Wire_EndSeg=<5,1,0>
        #include "Wire.inc"
        #declare Wire_EndSeg=<6,0,0>
        #include "Wire.inc"
        object{SoderPoint translate<6,0,0>}

        texture{T_Steel}
     }
    texture{
        pigment{
            gradient x
            color_map{
                [0.0 rgb <0.4,0.8,0.4>] // green
                [0.001 rgb <0.8,0.1,0.1>] // red
                [0.05 rgb <0.8,0.1,0.1>] // red
                [0.05 rgb <0.4,0.8,0.4>] // green
                [0.10 rgb <0.4,0.8,0.4>] // green
                [0.10 rgb <0.05,0.05,0.4>] // blue
                [0.20 rgb <0.05,0.05,0.4>] // blue
                [0.20 rgb <0.4,0.8,0.4>] // green
                [0.30 rgb <0.4,0.8,0.4>] // green
                [0.30 rgb <0.8,0.1,0.1>] // red
                [0.35 rgb <0.8,0.1,0.1>] // red
                [0.35 rgb <0.4,0.8,0.4>] // green
                [0.40 rgb <0.4,0.8,0.4>] // green
                [0.40 rgb <0.9,0.9,0.4>] // gold
                [0.45 rgb <0.9,0.9,0.4>] // gold
                [0.45 rgb <0.4,0.8,0.4>] // green
                [1.00 rgb <0.4,0.8,0.4>] // green
            }
            scale 10
            translate<-2,0,0>
        }
    }
}

union{
    box{<0,0,-1>,<228,99,1>}
    box{<0,33,-1>,<-8.5,78,1>
        texture{T_ClearBoard}
    }

    union{
        #declare Counter=0
        #while (Counter<17)
            box{<-8.1,0.5,-1.1>,<0,-0.5,-1>
                translate<0,36+(41/16)*Counter,0>
            }
            #declare Counter=Counter+1
        #end

        texture{T_GoldWire}
    }

    // everything within this union is on an x-z plane board
    // & rotated into position
    union{
        // bottom row
        object{Chip_SN74LS191N translate<18.5,0,20+17/2>}
        object{Chip_SN74LS112AN translate<54.25,0,20+17/2>}
        object{Chip_SN74LS161AN translate<77,0,20+17/2>}
        object{Chip_SN74S153N translate<90,0,20+17/2>}
        object{Chip_SN74LS112AN translate<102.5,0,20+17/2>}
        object{Chip_74LS02 translate<120,0,21+19/2>}
        object{Chip_74LS02 translate<170,0,21+19/2>}


        object{Capacitor_K5M_473 rotate<0,90,0> translate<48,0,22>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<66,0,35>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<83.5,0,35>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<111,0,35>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<144,0,35>}

        // middle row
        object{Chip_7438PC translate<18,0,51+19/2>}
        object{Chip_SN74LS153N translate<36,0,50+19/2>}
        object{Chip_74LS175PC translate<54,0,50+19/2>}
        object{Chip_Q5520002 translate<69,0,49+11>}
        object{Chip_7438PC translate<154,0,51+19/2>}
        object{Chip_7438PC translate<169,0,51+19/2>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<27,0,64>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<45,0,66>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<79,0,66>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<111,0,66>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<144,0,66>}

        // top row
        object{Chip_BIGONE translate<127,0,86>}
        object{Chip_7438PC translate<184,0,76+19/2>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<28,0,91>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<45,0,78>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<77,0,91>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<160,0,78>}
        object{Capacitor_K5M_473 rotate<0,90,0> translate<207,0,78>}
        object{Crystal_16MHZ translate<18,0,87>}

        // resistors
        object{Resistor_FDDR6 translate<49.5,0,7>}

        // circuits
        #declare Wire_Width=0.25

        #declare Wire_StartSeg=<10,0,4>
        object{SoderPoint translate Wire_StartSeg}
        #declare Wire_EndSeg=<16,0,4>
        #include "wire.inc"
        #declare Wire_EndSeg=<16,0,3.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<60,0,3.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<60,0,4>
        #include "wire.inc"
        #declare Wire_EndSeg=<110.5,0,4>
        #include "wire.inc"
        object{SoderPoint translate Wire_EndSeg}

        #declare Wire_StartSeg=<120,0,7>
        object{SoderPoint translate Wire_StartSeg}
        #declare Wire_EndSeg=<121,0,7>
        #include "wire.inc"
        #declare Wire_EndSeg=<123,0,7>
        #include "wire.inc"
        #declare Wire_EndSeg=<129,0,8.75>
        #include "wire.inc"
        #declare Wire_EndSeg=<131.5,0,10.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<161,0,10.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<165,0,6.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<173.5,0,6.5>
        #include "wire.inc"
        #declare Wire_EndSeg=<175,0,4>
        #include "wire.inc"
        object{SoderPoint translate Wire_EndSeg}

        // extra soder points
        object{SoderPoint translate <167.5,0,4>}
        object{SoderPoint translate <165,0,4>}
        object{SoderPoint translate <162.5,0,4>}
        object{SoderPoint translate <160,0,4>}
        object{SoderPoint translate <157.5,0,4>}
        object{SoderPoint translate <155,0,4>}
        object{SoderPoint translate <152.5,0,4>}
        object{SoderPoint translate <150,0,4>}
        object{SoderPoint translate <147.5,0,4>}
        object{SoderPoint translate <145,0,4>}
        object{SoderPoint translate <142,0,4>}
        object{SoderPoint translate <139.5,0,4>}
        object{SoderPoint translate <137,0,4>}
        object{SoderPoint translate <134.5,0,4>}
        object{SoderPoint translate <132,0,4>}
        
        // soder points near end connector on left side of board
        #declare Counter=0
        #while (Counter<17)
            object{SoderPoint translate<2,0,36+(41/16)*Counter>}
            object{SoderPoint translate<4,0,36+(41/16)*Counter>}
            #declare Counter=Counter+1
        #end
        #declare FDD_TextHeight=0.1
        #declare FDD_TextSize=2/0.75
        
        // board writing
        union{
            text {
                ttf "arial.TTF","R4",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<58,0,13>
            }
            text {
                ttf "arial.TTF","R5",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<58,0,9.5>
            }
            text {
                ttf "arial.TTF","R6",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<58,0,6>
            }
            text {
                ttf "arial.TTF","C20",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<58,0,3.7>
            }
            text {
                ttf "arial.TTF","R2",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<14,0,15.2>
            }
            text {
                ttf "arial.TTF","C17",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<13.5,0,13>
            }
            text {
                ttf "arial.TTF","R3",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<14,0,10>
            }
            text {
                ttf "arial.TTF","D2",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<14,0,7.5>
            }
            text {
                ttf "arial.TTF","D1",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<14,0,5>
            }
            text {
                ttf "arial.TTF","C21",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<3.5,0,18>
            }
            text {
                ttf "arial.TTF","P2",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<1,0,80>
            }
            text {
                ttf "arial.TTF","P3",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<5,0,96>
            }
            text {
                ttf "arial.TTF","C11",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<27,0,45>
            }
            text {
                ttf "arial.TTF","VCO",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<110,0,53>
            }
            text {
                ttf "arial.TTF","C18",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<130,0,11>
            }
            text {
                ttf "arial.TTF","U19",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<39,0,16>
            }
            text {
                ttf "arial.TTF","U20",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<26.25,0,38.5>
            }
            text {
                ttf "arial.TTF","U21",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<39,0,39>
            }
            text {
                ttf "arial.TTF","U22",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<51,0,39>
            }
            text {
                ttf "arial.TTF","U23",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<74.5,0,39.5>
            }
            text {
                ttf "arial.TTF","U24",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<87,0,39>
            }
            text {
                ttf "arial.TTF","U25",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<102,0,39.5>
            }
            text {
                ttf "arial.TTF","U26",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<117,0,39>
            }
            text {
                ttf "arial.TTF","U27",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<133,0,39>
            }
            text {
                ttf "arial.TTF","U28",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<151,0,39.6>
            }
            text {
                ttf "arial.TTF","U29",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<164,0,38.7>
            }
            text {
                ttf "arial.TTF","U30",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<181,0,38.5>
            }
            text {
                ttf "arial.TTF","U9",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<17,0,69>
            }
            text {
                ttf "arial.TTF","U10",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<34,0,69>
            }
            text {
                ttf "arial.TTF","U11",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<51,0,69>
            }
            text {
                ttf "arial.TTF","RP2",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<70,0,70.5>
            }
            text {
                ttf "arial.TTF","U12",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<84,0,69>
            }
            text {
                ttf "arial.TTF","U13",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<118,0,69>
            }
            text {
                ttf "arial.TTF","U14",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<133,0,69>
            }
            text {
                ttf "arial.TTF","U15",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<153,0,71.5>
            }
            text {
                ttf "arial.TTF","U16",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<164,0,69>
            }
            text {
                ttf "arial.TTF","U17",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<181,0,69>
            }
            text {
                ttf "arial.TTF","U18",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<197,0,69>
            }
            text {
                ttf "arial.TTF","U1",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<17,0,95>
            }
            text {
                ttf "arial.TTF","U2",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<35,0,95>
            }
            text {
                ttf "arial.TTF","U3",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<52.5,0,95>
            }
            text {
                ttf "arial.TTF","U4",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<68,0,95>
            }
            text {
                ttf "arial.TTF","U5",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<86,0,95>
            }
            text {
                ttf "arial.TTF","U6",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<126,0,95.5>
            }
            text {
                ttf "arial.TTF","U7",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<167,0,95>
            }
            text {
                ttf "arial.TTF","U8",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<182.5,0,95>
            }
            text {
                ttf "arial.TTF","RP1",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> translate<196.5,0,95>
            }
            // rotated text
            text {
                ttf "arial.TTF","C12",
                FDD_TextHeight, 0 scale <FDD_TextSize,-FDD_TextSize,-1>
                rotate<-90,0,0> rotate<0,-90,0> translate<49,0,27>
            }

            texture{T_ChipText}
        }

        rotate<-90,0,0>
        translate<0,0,-1>
    }
    texture{T_GreenBoard}
}
