//~~~~~THIS FILE IS DESIGNED TO TEST VARIOUS~~~~~\\
//~~~~~PARTS OF THE ZEPPELIN SCENE~~~~~\\
//~~~~~ALL INFORMATION HEREIN IS COPYRIGHT~~~~~\\
//~~~~~DAVID R. HEYS, 1997-1998~~~~~\\

#declare Gem_Std =
  texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
      ambient 0.45
      diffuse 0.28
      brilliance 3
      reflection .25
      refraction 1
      ior 2.1
      specular .25
      roughness 0.001
      irid {
        0.25
        thickness 1
        turbulence .3
      }
      caustics .6
    }
  }

#declare Clearfire=
  texture {Gem_Std
    pigment {color rgbft <0.25, 0.25, 0.25, 0.35, 0.75> }
  }

#declare Red_Canvas2=
  texture {
    pigment {
      onion
      color_map {
        [0.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.1 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.2 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [0.88 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [1.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
      }
      scale <2, 2.4, 3.7>
      translate <0, -0.25, -0.25>
    }
  }
  texture {
    pigment {
      onion
      color_map {
        [0.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.1 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.2 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [0.88 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [1.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
      }
      scale <2, 2.4, 3.7>
      translate <0, -0.25, -0.25>
    }
    normal {
      quilted
      control1 0
      control0 1
      turbulence 0
      rotate <10, 20, 30>
      scale <0.2, 0.07, 0.2>
    }
  }
  texture {
    pigment {
      onion
      color_map {
        [0.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.1 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
        [0.2 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [0.88 rgbft<0.847, 0.847, 0.749, 0.5, 0.25>]
        [1.0 rgbft<0.847, 0.447, 0.349, 0.5, 0.25>]
      }
      scale <2, 2.4, 3.7>
      translate <0, -0.25, -0.25>
    }
    normal {
      quilted
      control1 0
      control0 1
      turbulence 0
      rotate <-30, -20, -10>
      scale <0.07, 0.02, 0.02>
    }
  }

#declare Old_Steel1=
  texture {
    pigment {color rgb<.13, .13, .13>}
    finish {specular 0.342 roughness 0.05}
  }

#declare White_Metal1=
  texture {
    pigment {color White}
    finish {specular 0.6 roughness 0.03 brilliance 2.13}
  }

#declare Silver_Metal1=
  texture {
    pigment {color rgb<0.65, 0.65, 0.69>}
    finish {specular 0.6 roughness 0.03 brilliance 3.13 reflection 0.25}
  }

#declare Casing1=
  union {
     //~~~~~-Z TOP~~~~~\\
     sphere {<0, 0, 0>, 1
      scale <0.75, 0.75, 2>
      translate <0, 0, -0.25>
      clipped_by {
        sphere {<0, 0, 0>, 1
          translate <0, 0, -0.75>
          inverse
        }
        box {<-4, -4, -4>, <4, 0, 4>
          inverse
        }
      }
    }
    //~~~~~-Z BOTTOM~~~~~\\
    sphere {<0, 0, 0>, 1
      scale <0.75, 0.4, 2>
      translate <0, 0, -0.25>
      clipped_by {
        sphere {<0, 0, 0>, 1
          scale <1, .6, 1>
          translate <0, 0, -0.75>
          inverse
        }
        box {<-4, -4, -4>, <4, 0, 4>}
      }
    }
    //~~~~~+Z TOP~~~~~\\
    sphere {<0, 0, 0>, 1
      translate <0, 0, -0.75>
      clipped_by {
        sphere {<0, 0, 0>, 1
          scale <0.75, 0.75, 2>
          translate <0, 0, -0.25>
          inverse
        }
        box {<-4, -4, -4>, <4, 0, 4>
          inverse
        }
      }
    }
    //~~~~~+Z BOTTOM~~~~~\\
    sphere {<0, 0, 0>, 1
      scale <1, .6, 1>
      translate <0, 0, -0.75>
      clipped_by {
        sphere {<0, 0, 0>, 1
          scale <0.75, 0.4, 2>
          translate <0, 0, -0.25>
          inverse
        }
        box {<-4, -4, -4>, <4, 0, 4>
        }
      }
    }
    clipped_by {
      box {<-4, -4, -4>, <4, 4, -1.25>
        inverse
      }
    }
  }

#declare Casing2=
  union {
    object {Casing1 texture {White_Metal1}}
    object {Casing1 scale <0.9, 0.9, 1> texture {Old_Steel1}}
    torus {0.80625, 0.05625
      rotate <90, 0, 0>
      translate <0, 0, -1.25>
      clipped_by {
        box {<-4, -4, -4>, <4, 0, 4>
          inverse
        }
      }
      texture {White_Metal1}
    }
    torus {0.80625, 0.05625
      rotate <90, 0, 0>
      scale <1, 0.6, 1>
      translate <0, 0, -1.25>
      clipped_by {
        box {<-4, -4, -4>, <4, 0, 4>}
      }
      texture {White_Metal1}
    }
  }

#declare Engine1=
  union {
    union {
      cylinder {<0, 0.13, -1>, <0, 0.68, -1>, 0.1}
      cylinder {<0, 0.13, -1>, <0, -0.42, -1>, 0.1}
      cylinder {<0, 0.13, -1>, <-0.55, 0.13, -1>, 0.1}
      cylinder {<0, 0.13, -1>, <0.55, 0.13, -1>, 0.1}
    }
    union {
      cylinder {<0, 0, -1>, <0, 0.55, -1>, 0.1}
      cylinder {<0, 0, -1>, <0, -0.55, -1>, 0.1}
      cylinder {<0, 0, -1>, <-0.55, 0, -1>, 0.1}
      cylinder {<0, 0, -1>, <0.55, 0, -1>, 0.1}
      rotate <0, 0, 45>
      translate <0, 0.13, 0>
    }
    sphere {<0, 0.13, -1.6>, 0.15}
    cylinder {<0, 0.13, -1>, <0, 0.13, -1.6>, 0.15}
    texture {Old_Steel1}
  }

#declare Propeller1=
  sphere {<0, 0, 0>, 0.2
    texture {Silver_Metal1}
    scale <0.25, 6, 1>
    translate <0, 1.2, 0>
    rotate <0, 45, 0>
  }

#declare Propeller2=
  union {
    object {Propeller1
      rotate <0, 0, 65>
      translate <0, 0.13, -1.5>
    }
    object {Propeller1
      rotate <0, 0, -25>
      translate <0, 0.13, -1.5>
    }
    object {Propeller1
      rotate <0, 0, -115>
      translate <0, 0.13, -1.5>
    }
    object {Propeller1
      rotate <0, 0, 155>
      translate <0, 0.13, -1.5>
    }
  }


#declare Prop_Engine1=
  union {
    object {Propeller2}
    object {Engine1}
    object {Casing2}
  }

#declare Prop_Engine2=
  union {
    object {Propeller2 rotate <0, 0, 45>}
    object {Engine1}
    object {Casing2}
  }

#declare Prop1=
  union {
    object {
      Prop_Engine1
      scale <0.21, 0.21, 0.21>
      translate <-3.75, 0, -0.50>
    }
    //LEFT +Z PROP\\
    cylinder {<-3.6, 0, -0.65>, <-3, -0.1, -0.65>, 0.02 texture {Old_Steel1}}
    cylinder {<-3.6, 0, -0.35>, <-3, -0.1, -0.35>, 0.02 texture {Old_Steel1}}
    cylinder {<-3.65, 0, -0.65>, <-3, 0.75, -0.65>, 0.02 texture {Old_Steel1}}
    cylinder {<-3.65, 0, -0.35>, <-3, 0.75, -0.35>, 0.02 texture {Old_Steel1}}
  }

#declare Prop2=
  union {
    object {
      Prop_Engine1
      scale <0.21, 0.21, 0.21>
      translate <3.75, 0, -0.50>
    }
    //RIGHT +Z PROP\\
    cylinder {<3.6, 0, -0.65>, <3, -0.1, -0.65>, 0.02 texture {Old_Steel1}}
    cylinder {<3.6, 0, -0.35>, <3, -0.1, -0.35>, 0.02 texture {Old_Steel1}}
    cylinder {<3.65, 0, -0.65>, <3, 0.75, -0.65>, 0.02 texture {Old_Steel1}}
    cylinder {<3.65, 0, -0.35>, <3, 0.75, -0.35>, 0.02 texture {Old_Steel1}}
  }

#declare Prop3=
  union {
    object {
      Prop_Engine2
      scale <0.21, 0.21, 0.21>
      translate <-2.75, -1.75, -4>
    }
    //LEFT -Z PROP\\
    cylinder {<-2.6, -1.75, -4.15>, <-2,-1.85, -4.15>, 0.02 texture {Old_Steel1}}
    cylinder {<-2.6, -1.75, -3.85>, <-2, -1.85, -3.85>, 0.02 texture {Old_Steel1}}
    cylinder {<-2.65, -1.75, -4.15>, <-2, -1, -4.15>, 0.02 texture {Old_Steel1}}
    cylinder {<-2.65, -1.75, -3.85>, <-2, -1, -3.85>, 0.02 texture {Old_Steel1}}
  }


#declare Prop4=
  union {
    object {
      Prop_Engine2
      scale <0.21, 0.21, 0.21>
      translate <2.75, -1.75, -4>
    }
    //RIGHT -Z PROP\\
    cylinder {<2.6, -1.75, -4.15>, <2,-1.85, -4.15>, 0.02 texture {Old_Steel1}}
    cylinder {<2.6, -1.75, -3.85>, <2, -1.85, -3.85>, 0.02 texture {Old_Steel1}}
    cylinder {<2.65, -1.75, -4.15>, <2, -1, -4.15>, 0.02 texture {Old_Steel1}}
    cylinder {<2.65, -1.75, -3.85>, <2, -1, -3.85>, 0.02 texture {Old_Steel1}}
  }

#declare Rudder=
  union {
    difference {
      torus {1, 0.075
        rotate <0, 0, -90>
        scale <2, 2.3, 3.8>
      }
      box {<-5, -5, -5>, <5, 0, 5>}
      box {<-5, -1, -5>, <5, 5, 0>}
      box {<0, -1, -1>, <5, 3, 4>
        rotate <0, 2, 0>
        translate <0.1, 0, 0>
      }
      box {<0, -1, -1>, <-5, 3, 4>
        rotate <0, -2, 0>
        translate <-0.1, 0, 0>
      }
    }
    difference {
      sphere {<0, 0, 0>, 1
        scale <3.8, 2.3, 3.8>
      }
      box {<-5, -5, -5>, <5, 0, 5>}
      box {<-5, -1, -5>, <5, 5, 0>}
      box {<0, -1, -1>, <5, 3, 4>
        rotate <0, 2, 0>
        translate <0.1, 0, 0>
      }
      box {<0, -1, -1>, <-5, 3, 4>
        rotate <0, -2, 0>
        translate <-0.1, 0, 0>
      }
    }
    sphere {<0, 0, 0>, 1
      scale <0.2, 0.1, 0.9>
      translate <0.0, 0.35, -0.1>
      texture {Old_Steel1}
    }
    sphere {<0, 0, 0>, 1
      scale <0.2, 0.1, 0.9>
      translate <0.0, 1.15, -0.1>
      texture {Old_Steel1}
    }
    sphere {<0, 0, 0>, 1
      scale <0.2, 0.1, 0.9>
      translate <0.0, 1.95, -0.1>
      texture {Old_Steel1}
    }
    difference {
      box {<-0.1, 0, 0>, <0.1, 2.2, 1.5>}
      box {<0, -1, -1>, <5, 3, 4>
        rotate <0, 8, 0>
      }
      box {<0, -1, -1>, <-5, 3, 4>
        rotate <0, -8, 0>
      }
      translate <0, 0, -1.9>
    }
    difference {
      torus {1, 0.075
        rotate <0, 0, -90>
        scale <2, 2.3, 3.8>
        translate <0, 0, 1.9>
      }
      box {<-0.1, 0, 0>, <0.1, 5, 1.5> inverse}
      box {<0, -1, -1>, <5, 3, 4>
        rotate <0, 8, 0>
      }
      box {<0, -1, -1>, <-5, 3, 4>
        rotate <0, -8, 0>
      }
      translate <0, 0, -1.9>
    }
    texture {
      Red_Canvas2
    }
    scale <1, 1, 0.7>
    translate <0, 0, -3>
  }

#declare Shell=
  merge {
    difference {
      cylinder {<0, -0.7, -1.8>, <0, 0.7, -1.8>, 0.9}
      cylinder {<-2, 0, -1.8>, <2, 0, -1.8>, 0.7
        inverse
      }
    }
    difference {
      cylinder {<0, -0.7, 1.8>, <0, 0.7, 1.8>, 0.9}
      cylinder {<-1, 0, 1.8>, <1, 0, 1.8>, 0.7
        inverse
      }
    }
    box {<-0.9, -0.7, -1.8>, <0.9, 0.7, 1.8>}
  }

#declare WC=
  union {
    box {<-3, -0.2, -1.7>, <3, 0.6, -0.7>
      texture  {Old_Steel1}
    }
    box {<-3, -0.2, -0.5>, <3, 0.6, 0.5>
      texture  {Old_Steel1}
    }
    box {<-3, -0.2, 0.7>, <3, 0.6, 1.7>
      texture  {Old_Steel1}
    }
  }

#declare Shell2=
  difference {
    object {Shell}
    object {WC}
    box{<-0.8, -0.4, -3>, <0.8, 0.5, 3> texture {Old_Steel1}}
    translate <0, -1.25, 0>
  }

#declare Shell3=
  difference {
    object {Shell2}
    merge {
      difference {
        cylinder {<0, -0.65, -1.75>, <0, 0.65, -1.75>, 0.85}
        cylinder {<-2, 0, -1.75>, <2, 0, -1.75>, 0.65
          inverse
        }
      }
      difference {
        cylinder {<0, -0.65, 1.75>, <0, 0.65, 1.75>, 0.85}
        cylinder {<-1, 0, 1.75>, <1, 0, 1.75>, 0.65
          inverse
        }
      }
      box {<-0.85, -0.65, -1.75>, <0.85, 0.65, 1.75>}
      translate <0, -1.25, 0>
    }
    texture {
      pigment {color rgb<0.5, 0.5, 0.5>}
      finish {specular 0.3 roughness 0.03 brilliance 2.41}
    }
  }

#declare GW1=
  union {
    box {<-0.9, -0.2, -1.7>, <-0.8, 0.6, -0.7>}
    box {<-0.9, -0.2, -0.5>, <-0.8, 0.6, 0.5>}
    box {<-0.9, -0.2, 0.7>, <-0.8, 0.6, 1.7>}
    box {<0.9, -0.2, -1.7>, <0.8, 0.6, -0.7>}
    box {<0.9, -0.2, -0.5>, <0.8, 0.6, 0.5>}
    box {<0.9, -0.2, 0.7>, <0.8, 0.6, 1.7>}
    difference {
      box{<-0.8, -0.2, -3>, <0.8, 0.5, 3>}
      merge {
        difference {
          cylinder {<0, -0.7, -1.8>, <0, 0.7, -1.8>, 0.9}
          cylinder {<-2, 0, -1.8>, <2, 0, -1.8>, 0.7 inverse}
        }
        difference {
          cylinder {<0, -0.7, 1.8>, <0, 0.7, 1.8>, 0.9}
          cylinder {<-1, 0, 1.8>, <1, 0, 1.8>, 0.7 inverse}
        }
        box {<-0.9, -0.7, -1.8>, <0.9, 0.7, 1.8>}
        inverse
      }
      merge {
        difference {
          cylinder {<0, -0.65, -1.75>, <0, 0.65, -1.75>, 0.85}
          cylinder {<-2, 0, -1.75>, <2, 0, -1.75>, 0.65 inverse}
        }
        difference {
          cylinder {<0, -0.65, 1.75>, <0, 0.65, 1.75>, 0.85}
          cylinder {<-1, 0, 1.75>, <1, 0, 1.75>, 0.65 inverse}
        }
        box {<-0.85, -0.65, -1.75>, <0.85, 0.65, 1.75>}
      }
    }
    translate <0, -1.25, 0>
    texture {Clearfire}
  }

#declare Gondola=
  union {
    object {Shell3}
    object {GW1}
  }
