//~~~~~THIS FILE IS DESIGNED TO TEST VARIOUS~~~~~\\
//~~~~~PARTS OF THE ZEPPELIN SCENE~~~~~\\
//~~~~~ALL INFORMATION HEREIN IS COPYRIGHT~~~~~\\
//~~~~~DAVID R. HEYS, 1997-1998~~~~~\\

#version 3.0
global_settings { assumed_gamma 2.1 }

#include "colors.inc"
#include "textures.inc"

#declare Wireframe=
  texture {
    pigment {
      gradient z
      color_map {
        [0.0, rgbt<0.3, 0.3, 0.3, 0>]
        [0.05, rgbt<0.3, 0.3, 0.3, 0>]
        [0.06, rgbt<1, 1, 1, 1>]
        [0.5, rgbt<1, 1, 1, 1>]
        [0.94, rgbt<1, 1, 1, 1>]
        [0.95, rgbt<0.3, 0.3, 0.3, 0>]
        [1.0, rgbt<0.3, 0.3, 0.3, 0>]
      }
    }
    rotate <45, 0, 0>
  }
  texture {
    pigment {
      gradient z
      color_map {
        [0.0, rgbt<0.3, 0.3, 0.3, 0>]
        [0.05, rgbt<0.3, 0.3, 0.3, 0>]
        [0.06, rgbt<1, 1, 1, 1>]
        [0.5, rgbt<1, 1, 1, 1>]
        [0.94, rgbt<1, 1, 1, 1>]
        [0.95, rgbt<0.3, 0.3, 0.3, 0>]
        [1.0, rgbt<0.3, 0.3, 0.3, 0>]
      }
    }
    rotate <-45, 0, 0>
  }

#declare Old_Steel1=
  texture {
    pigment {color rgb<.13, .13, .13>}
    finish {specular 0.342 roughness 0.05}
  }

#declare Gem_Std =
  texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
      ambient 0.45
      diffuse 0.28
      brilliance 3
      reflection .25
      refraction 1
      ior 2.1
      specular .25
      roughness 0.001
      irid {
        0.25
        thickness 1
        turbulence .3
      }
      caustics .6
    }
  }

#declare Clearfire=
  texture {Gem_Std
    pigment {color rgbft <0.25, 0.25, 0.25, 0.35, 0.75> }
  }

#declare RD1=
  texture {
    pigment {color rgb<0.37546, 0.37546, 0.37546>}
    normal {bumps -.5 turbulence 0.103}
    finish {specular 0.13 roughness 0.01}
    scale <24, .05, .02>
  }
  texture {
    pigment {
      radial
      frequency 50
      color_map {
        [0.00, rgb<0.3, 0.3, 0.3>]
        [0.05, rgb<0.3, 0.3, 0.3>]
        [0.10, rgbft<0.5, 0.5, 0.5, 0.3, 0.4>]
        [0.90, rgbft<0.5, 0.5, 0.5, 0.3, 0.4>]
        [0.95, rgb<0.3, 0.3, 0.3>]
        [1.00, rgb<0.3, 0.3, 0.3>]
      }
    }
    normal {
      radial
      frequency 50
    }
    finish {
      specular 0.25
      roughness 0.05
      brilliance 2.1
    }
  }

#declare RD2=
  texture {
    pigment {color rgb<0.37546, 0.37546, 0.37546>}
    normal {bumps -.5 turbulence 0.103}
    finish {specular 0.13 roughness 0.01}
    scale <24, .05, .02>
  }
  texture {
    pigment {
      gradient z
      scale 2
      color_map {
        [0.00, rgb<0.3, 0.3, 0.3>]
        [0.05, rgb<0.3, 0.3, 0.3>]
        [0.10, rgbft<0.5, 0.5, 0.5, 0.3, 0.4>]
        [0.90, rgbft<0.5, 0.5, 0.5, 0.3, 0.4>]
        [0.95, rgb<0.3, 0.3, 0.3>]
        [1.00, rgb<0.3, 0.3, 0.3>]
      }
    }
    normal {
      gradient z
      scale 2
    }
    finish {
      specular 0.25
      roughness 0.05
      brilliance 2.1
    }
  }

#declare RD3=
  texture {
    pigment {color rgb<0.2546, 0.2546, 0.2546>}
    normal {bumps -.5 turbulence 0.103}
    finish {specular 0.13 roughness 0.01}
    scale <24, .05, .02>
  }
  texture {
    pigment {
      radial
      frequency 50
      color_map {
        [0.00, rgb<0.13, 0.13, 0.13>]
        [0.05, rgb<0.13, 0.13, 0.13>]
        [0.10, rgbft<0.35, 0.35, 0.35, 0.3, 0.4>]
        [0.90, rgbft<0.35, 0.35, 0.35, 0.3, 0.4>]
        [0.95, rgb<0.13, 0.13, 0.13>]
        [1.00, rgb<0.13, 0.13, 0.13>]
      }
    }
    normal {
      radial
      frequency 50
    }
    finish {
      specular 0.25
      roughness 0.05
      brilliance 2.1
    }
  }



#declare DP1=
  union {
    difference {
      cone {<0, 0, 0>, 9 <0, 9, 0>, 6
        texture {RD1}
      }
      cone {<0, 0, 0>, 8.9 <0, 9, 0>, 5.9 open
        texture {RD3}
      }
      box{<-11, -1, -0.1>, <-0.1, 11, -11> inverse
        pigment {color Gray50}
      }
    }
    difference {
      cone {<0, 0, 0>, 8.9 <0, 9, 0>, 5.9 }
      cone {<0, 0, 0>, 8.6 <0, 9, 0>, 5.6 open}
      box{<-11, -1, -0.2>, <-0.2, 11, -11> inverse}
      texture {Wireframe}
    }
    difference {
      cone {<0, 0, 0>, 8.6 <0, 9, 0>, 5.6
        texture {RD1}
      }
      cone {<0, 0, 0>, 8.5 <0, 9, 0>, 5.5 open
        texture {RD3}
      }
      box{<-11, -1, -0.1>, <-0.1, 11, -11> inverse
        pigment {color Gray50}
      }
    }
  }

#declare DP2=
  union {
    difference {
      sphere {<0, 0, 0>, 1 scale <6, 5, 6> translate <0, 9, 0>
        texture {RD1}
      }
      sphere {<0, 0, 0>, 1 scale <5.9, 4.9, 5.9> translate <0, 9, 0>
        texture {RD3}
      }
      box{<-11, 9, -0.1>, <-0.1, 15, -11> inverse
        pigment {color Gray50}
      }
    }
    difference {
      sphere {<0, 0, 0>, 1 scale <5.9, 4.9, 5.9> translate <0, 9, 0>}
      sphere {<0, 0, 0>, 1 scale <5.6, 4.6, 5.6> translate <0, 9, 0>}
      box{<-11, 9, -0.2>, <-0.2, 15, -11> inverse}
      texture {Wireframe}
    }
    difference {
      sphere {<0, 0, 0>, 1 scale <5.6, 4.6, 5.6> translate <0, 9, 0>
        texture {RD1}
      }
      sphere {<0, 0, 0>, 1 scale <5.5, 4.5, 5.5> translate <0, 9, 0>
        texture {RD3}
      }
      box{<-11, 9, -0.1>, <-0.1, 15, -11> inverse
        pigment {color Gray50}
      }
    }
  }

#declare Left_Door=
  union {
    object {DP1 rotate <0, 30, 0> translate <0, -4, 9>}
    object {DP2 rotate <0, 30, 0> translate <0, -4, 9>}
  }

#declare Right_Door=
  union {
    object {DP1 rotate <0, -120, 0> translate <0, -4, 9>}
    object {DP2 rotate <0, -120, 0> translate <0, -4, 9>}
  }

#declare Back_Door1=
  union {
    object {DP1 rotate <0, 90, 0> translate <0, -4, 33>}
    object {DP2 rotate <0, 90, 0> translate <0, -4, 33>}
  }

#declare Back_Door2=
  union {
    object {DP1 rotate <0, 180, 0> translate <0, -4, 33>}
    object {DP2 rotate <0, 180, 0> translate <0, -4, 33>}
  }

#declare Hangar_Roof=
  union {
    difference {
      cylinder {<0, 0, -1>, <0, 0, 1>, 1
        scale <5.3, 4.3, 12> translate <0, 5, 21>}
      cylinder {<0, 0, -1>, <0, 0, 1>, 1 open
        scale <5.2, 4.2, 12> translate <0, 5, 21>}
      texture {RD2}
    }
    difference {
      cylinder {<0, 0, -1>, <0, 0, 1>, 1
        scale <5.2, 4.2, 11.9> translate <0, 5, 21>}
      cylinder {<0, 0, -1>, <0, 0, 1>, 1 open
        scale <4.9, 3.9, 11.9> translate <0, 5, 21>}
      texture {Wireframe}
    }
    difference {
      cylinder {<0, 0, -1>, <0, 0, 1>, 1
        scale <4.9, 3.9, 12> translate <0, 5, 21>}
      cylinder {<0, 0, -1>, <0, 0, 1>, 1 open
        scale <4.8, 3.8, 12> translate <0, 5, 21>}
      texture {RD3}
    }
    clipped_by {box {<-6, 5, 0>, <6, 10, 50>}}
  }

#declare Window_Cutter=
  union {
    union {
      box {<-10.00, -1.25, 12.50>, <10.00,  0.00, 13.75>}
      box {<-10.00, -1.25, 14.25>, <10.00,  0.00, 15.50>}
      box {<-10.00, -1.25, 16.00>, <10.00,  0.00, 17.25>}
      box {<-10.00, -1.25, 17.75>, <10.00,  0.00, 19.00>}
      box {<-10.00, -1.25, 19.50>, <10.00,  0.00, 20.75>}
      box {<-10.00, -1.25, 21.25>, <10.00,  0.00, 22.50>}
      box {<-10.00, -1.25, 23.00>, <10.00,  0.00, 24.25>}
      box {<-10.00, -1.25, 24.75>, <10.00,  0.00, 26.00>}
      box {<-10.00, -1.25, 26.50>, <10.00,  0.00, 27.75>}
      box {<-10.00, -1.25, 28.25>, <10.00,  0.00, 29.50>}
    }
    union {
      box {<-10.00,  2.00, 12.50>, <10.00,  4.50, 13.75>}
      box {<-10.00,  2.00, 14.25>, <10.00,  4.50, 15.50>}
      box {<-10.00,  2.00, 16.00>, <10.00,  4.50, 17.25>}
      box {<-10.00,  2.00, 17.75>, <10.00,  4.50, 19.00>}
      box {<-10.00,  2.00, 19.50>, <10.00,  4.50, 20.75>}
      box {<-10.00,  2.00, 21.25>, <10.00,  4.50, 22.50>}
      box {<-10.00,  2.00, 23.00>, <10.00,  4.50, 24.25>}
      box {<-10.00,  2.00, 24.75>, <10.00,  4.50, 26.00>}
      box {<-10.00,  2.00, 26.50>, <10.00,  4.50, 27.75>}
      box {<-10.00,  2.00, 28.25>, <10.00,  4.50, 29.50>}
    }
  }

#declare XY1=
  union {
    box {<0.0, -10.5, -12>, <0.095, 1, 12> texture {RD3 scale .75}}
    box {<0.095, -10.5, -11.9>, <0.38, 1, 11.9> texture {Wireframe}}
    box {<0.38, -10.5, -12>, <0.475, 1, 12> texture {RD2 scale .75}}
    rotate <0, 0, 18>
    translate <4.8, 5, 21>
    clipped_by {box {<-6, 5, 0>, <6, 10, 50> inverse}}
  }

#declare XY2=
  union {
    box {<0.0, -10.5, -12>, <-0.095, 1, 12> texture {RD3 scale .75}}
    box {<-0.095, -10.5, -11.9>, <-0.38, 1, 11.9> texture {Wireframe}}
    box {<-0.38, -10.5, -12>, <-0.475, 1, 12> texture {RD2 scale .75}}
    rotate <0, 0, -18>
    translate <-4.8, 5, 21>
    clipped_by {box {<-6, 5, 0>, <6, 10, 50> inverse}}
  }

#declare XY3=
  box {<0.0, -10.5, -12>, <0.475, 1, 12>
    rotate <0, 0, 18>
    translate <4.8, 5, 21>
  }

#declare XY4=
  box {<0.0, -10.5, -12>, <-0.475, 1, 12>
    rotate <0, 0, -18>
    translate <-4.8, 5, 21>
  }

#declare Right_Wall=
  difference {
    object {XY1}
    object {Window_Cutter texture {Old_Steel1}}
  }

#declare Left_Wall=
  difference {
    object {XY2}
    object {Window_Cutter texture {Old_Steel1}}
  }

#declare Right_Glass=
  difference {
    object {Window_Cutter texture {Clearfire}}
    object {XY3 texture {Clearfire} inverse}
  }

#declare Left_Glass=
  difference {
    object {Window_Cutter texture {Clearfire}}
    object {XY4 texture {Clearfire} inverse}
  }

