// Persistence of Vision Ray Tracer Scene Description File
// File: BOTBATBT.pov
// Vers: 1
// Titl: Rainbirds: The Battle Of The Ballista And The Beach Toys
// Desc: Great Engineering Achievements: Ballista
// Date: 23/02/98
// Auth: T.N.
#version 3.02
global_settings
{ assumed_gamma 2.2
  ambient_light 1.5
}
// ----------------------------------------

// INCLUDE FILES
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "ballista.inc"
#include "BT.inc"
// ----------------------------------------

// TEXTURES
#declare Whyte = color red 0.94 green 0.94 blue 0.84
#declare AF = finish {ambient 0.35 diffuse 0.35 reflection 0.2 phong 0.75 phong_size 50}
#declare BF = finish {ambient 0.45 diffuse 0.45 reflection 0.1 phong 0.25}
#declare Ctex1 =
  texture {
    pigment {color red 0.56 green 0.94 blue 0.86 transmit 0.25}
    finish {ambient 0.25 diffuse 0.25 reflection 0.25 refraction 1 ior 1.33 caustics 0.2}
    normal {
      waves 0.15
      frequency 1000.0
      scale 3000.0
    }
  }
#declare Ctex2 =
  texture {
    pigment {color red 0.56 green 0.94 blue 0.86 transmit 0.25}
    finish {ambient 0.25 diffuse 0.25 reflection 0.25 refraction 1 ior 1.33 caustics 0.2}
    normal {
      waves 0.05
      turbulence 0.1
      lambda 2.1
      omega 0.7
      frequency 1000.0
      scale 3000.0
    }
  }
#declare PlyWood =
             texture { pigment { P_WoodGrain4A color_map { M_Wood10A }} rotate x*3}
             texture { pigment { P_WoodGrain4B color_map { M_Wood10B }} rotate x*3}
#declare Dtex =
  texture {
    PlyWood
    finish {ambient 0.55 diffuse 0.55 roughness 0.025 specular 0.05 reflection 0.02}
    scale 2.5 rotate x*90
  }
#declare AIM =
  texture {
    pigment {
      image_map
//      { tga "BTA_map.tga" map_type 5
      { gif "BTA_map.gif" map_type 5
        interpolate 2
        once
      }
    }
    finish {AF}
  }
#declare SEAIM =
  texture {
    pigment {
      image_map
//      { tga "seatex.tga"
      { gif "seatex.gif"
        interpolate 2
      }
    }
    finish { ambient 0.55 diffuse 0.55 reflection 0 }
      translate -0.5*(x+y)
      rotate x*90
      scale <4,1,3>
      scale <4,1,4> // only for gif which is smaller
  }
#declare SOLDIM =
  texture {
    pigment {
      image_map
//      { tga "sold.tga"
      { gif "sold.gif"
        interpolate 2
        once
      }
    }
    finish {AF}
      translate -0.5*(x+y)
      scale <2,2,1>
  }
// ----------------------------------------

// SKY
#declare P_Clouds =
  pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.75
    pigment_map {
        [0.20 rgb <0.44, 0.58, 0.86> ]
        [0.50 White ]
        [1.00 Gray80 ]
    }
    scale <0.5, 0.15, 1>
}

#declare S_Clouds =
  sky_sphere {
    pigment {
      gradient y
      turbulence 0.1
      lambda 3.2
      omega 0.5
      pigment_map {
        [0.00 P_Clouds ]
        [0.10 rgb <0.44, 0.58, 0.86> ]
        [0.20 rgb <0.85, 0.85, 0.85> ]
        [0.30 P_Clouds ]
      }
    }
  }
#declare New_Sky = sky_sphere { S_Clouds }
sky_sphere { New_Sky }
// ----------------------------------------

// OCEAN SURFACE
plane { y, -25.0
  texture {SEAIM scale 10}
}

plane { y, -13.0
  texture {Ctex1}
  clipped_by {plane { z, 0.0
                      translate z*100 rotate y*-38.6598082541}}
}

plane { y, -13.0
  texture {Ctex2}
  clipped_by {plane { x, 0.0  rotate y*90
                      translate z*100 rotate y*-38.6598082541}}
}
// ----------------------------------------
#declare BeachToy =
// BEACH TOYS
union {
  object {BTA1
    texture {AIM}
  }
  object {BTA2
    pigment {Red}
    finish {AF}
  }
  object {BTA3
    texture {AIM}
  }
  object {BTA4
    pigment {Black}
    finish {AF}
  }
  scale 5
  translate y*-12
}
union {
  object {BeachToy rotate y*188 translate <-137,0,224>}
  object {BeachToy rotate y*312 translate <-71,0,221>}
  object {BeachToy rotate y*347 translate <-22,0,189>}
  object {BeachToy rotate y*167 translate <-142,0,189>}
  object {BeachToy rotate y*42 translate <-66,0,173>}
  object {BeachToy rotate y*271 translate <-16,0,152>}
  object {BeachToy rotate y*165 translate <-91,0,140>}
  object {BeachToy rotate y*207 translate <36,0,124>}
  object {BeachToy rotate y*53 translate <-32,0,112>}
  object {BeachToy rotate y*91 translate <-366,0,110>}
  object {BeachToy rotate y*222 translate <16,0,94>}
  object {BeachToy rotate y*27 translate <-314,0,82>}
  object {BeachToy rotate y*29 translate <-25,0,74>}
  object {BeachToy rotate y*161 translate <26,0,61>}
  object {BeachToy rotate y*42 translate <-284,0,52>}
  object {BeachToy rotate y*0 translate <15,0,40>}
  object {BeachToy rotate y*341 translate <-174,0,19>}
  object {BeachToy rotate y*60 translate <37,0,17>}
  object {BeachToy rotate y*24 translate <-37,0,12>}
  object {BeachToy rotate y*82 translate <15,0,0>}
  object {BeachToy rotate y*234 translate <51,0,-15>}
  object {BeachToy rotate y*174 translate <-84,0,-26>}
  object {BeachToy rotate y*302 translate <-28,0,-44>}
}
// ----------------------------------------

// SIGN
union {
  difference {
    box {<-2.5,-100,-2.5><2.5,0,2.5>}
    box {<-5,0,-5><5,5,5> rotate x*45}
    texture {Dtex}
    translate y*10
  }
  union {
    cylinder {<-1.5,-5.5,-3.8><-1.5,-5.5,0>,0.5}
    cylinder {<1.5,-5.5,-3.8><1.5,-5.5,0>,0.5}
    cylinder {<-1.5,4,-3.8><-1.5,4,0>,0.5}
    cylinder {<1.5,4,-3.8><1.5,4,0>,0.5}
    texture { pigment {Gray80}}
  }
  box {<-1,-1,-2.5><1,1,-3.75>
    texture {SOLDIM}
    scale <12,12*350/600,1>
    translate y*-1
  }
  translate y*25
  translate z*100
  translate x*60
  rotate y*-38.6598082541
}
// ----------------------------------------

// CAMERA, BALLISTA & LIGHT
camera {
  location <80, 40, -100>
  up <0.0, 1.0, 0.0>
  right <4/3, 0.0, 0.0>
  look_at <0.0, 0.0, 0.0>
  angle 54.29936339557
  rotate x*10
  rotate z*-10
}
object {Ballista
        translate y*-4.5
        scale 2.0
        rotate x*9.75
        rotate y*-14.5
        rotate z*-25.875
        translate <35,25,-60>
        rotate x*10
        rotate z*-10
}
object {light_source {<200.0, 200.0, -150.0> color White}}
// ----------------------------------------
// ----------------------------------------
/*
EMAIL: ice@teanow4pm.demon.co.uk
NAME: Tom Nowacki
TOPIC: Great Engineering Achievements
COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
TITLE: Rainbirds: The Battle Of The Ballista And The Beach Toys
COUNTRY: UK
WEBPAGE: http://www.teanow4pm.demon.co.uk
RENDERER USED: Povray 3.02 for Windows
TOOLS USED: sPatch, CorelDraw 6
RENDER TIME: 1 hour 50 minutes 35 seconds @ 1024 x 768 +a.1
HARDWARE USED: Pentium-200 MMX

IMAGE DESCRIPTION:

[From 1978 edition of "How It Works" volume 2.]
Originally the word ballista referred to a large
stand-supported crossbow used to fire darts, but
over the years it has come to mean any early
machine for throwing spears or stones. The first
Europeans to experiment with ballistae were the
Greeks, especially those working in the Museum
(a research establishment) at Alexandria in
Egypt in the two centuries before the birth of
Christ.

[From "The Polaroid"]
ONE FINE DAY AT THE BEACH IN PARALION ASTROS...

Father: Honey, you have to hold the camera
straight. Yes, that's better. Now click on the
button to take a picture of Daddy in his swim
trunks.
...Later...
Child: Mommy, Mommy!
Mother: Yes, what is it, dear?
Child: Look!
Mother: Oh no, it looks like it's going to rain.

I can't remember if the small child is a boy or
a girl. Probably it doesn't matter.

At a time when the Middle East is in danger of
a catastrophe of biblical proportions an image
like this may be condemned as a distraction
from the desperately urgent defense of
civilization against modern barbarism.
Rainbirds or BOTBATBT, short for "The Battle Of
The Ballista And The Beach Toys" is not about
evil dictators sporting a mustache, even though
it could be. You know who I mean.

DESCRIPTION OF HOW THIS IMAGE WAS CREATED:

I was annoyed with two of the margins, so
instead of scaling the picture from 1024x768 to
800x600 I cropped it in Photoshop. I changed my
mind. I feel it is more dignified to enter the
unexpurgated artwork. As a distraction I will
post a Sold sign.

The bird neck is a product of sPatch. The rainbow
texture is an image_map. The pawl and the rachet
wheel are prisms. I 'used' a prism to carve out
the jamb pieces of the box that holds the bow
in place. The seabed is also an image_map.

Many thanks to Micheal D. Johnson
for stwist.inc. Without it, no bowstring.
No rope to retract the trigger mechanism either,
come to think of it.

As far as I am currently aware to wrap a length
of rope or twine (or whatever) around an axis
it is necessary to clone a short segment of
'stwist' rope and then rotate and translate
it in a #while statement.

I won't recommend this method to you if you have
limited memory for the simple reason that out of
a total of 18,574 frame level objects in the
BOTBATBT scene, over 10,000 are permutations of
the original segment of rope. One more twist and
my computer would have said in considerable pain,
this message will self-destruct in five seconds.
And I would have said, shut up, computers can't
talk. I would not recommend it.

I have a confession to make.

Confess, you traitor!

I am no lover of trigonometry.

But honestly, gentlemen..., oh, are there some
ladies in the back? How embarrassing... I meant,
I um... What I mean to say is, having CorelDraw
to fall back on on the sly almost, read my lips:
'almost' makes calculating an angle an enjoyable
experience.

Let me show you this globe, man.

The Aegean Sea off the southern coast of the
Peloponnesian peninsula was little more than a
primitive soup with mostly anaerobic organisms
swimming in it in the beginning. It at once
refuted earlier claims by Columbus et al. that
the world is round like an apple and not flat
like a table.

What could be more stereotypical than a horizontal
horizon? I ask you. A body of water that congeals
into a plowed field in the distance, eh?

Boo! Hiss! Boring lecture!

In short, I at length discovered that slicing
the sea into two planes, and defining two surface
normals, one for the foreground and one for the
background and furthermore tilting the camera,
would to some extent vindicate C.C. and his
followers.

They can discover America.

The red Jolly Roger adds a nice little touch.
Don't you agree? It symbolizes poison, death
and international lawlessness.

Sold!

Note:
The image_maps provided are in gif format to
save space (and time).
*/
// ----------------------------------------
// END OF FILE
