//
// stwist.inc version 1.0
// 
// A utility to generate twisted posts.  Or twisted candy canes.
// Or maybe rope.  Or whatever.
// 
// Donated to the public domain
//
// Written by Michael D Johnson
// 		mdjohnson@voyager.net or redbeard@quark.gmi.edu
// 		http://quark.gmi.edu/~redbeard
// 
// Most recent version is available at
// 	http://quark.gmi.edu/~redbeard/raytrace/POVRay-Util.html
//
// The twist extends along the vertical y axis, with the base at the origin.
// It can be composed either of a union of cylinders or a blob.
//
// Use:
// Set the appropriate variables (see below) and call stwist.inc like:
//   object
//   {
//      #include "stwist.inc"
//      texture { My_Texture }
//      rotate Rot
//      translate Move
//   }
// or whatever.
// 
// Variables (default values in []):
// NumRots	[3]	Number of twists over length
// Height	[28]	Height in units (or length if you rotate it :-)
// Rad		[1.5]	Overall radius of twist (I think...)
// NumCords	[4]	Number of 'cords' to twist
// CordRatio	[0.5]	Ratio between cord size and overall radius (i.e.
// 			cord radius = overall radius * CordRatio)
// NumSegs	[70]	Number of segments to comprise each cord
// OffsetFact	[0.125]	A factor used in determining cord segments.  Leave
// 			at 0.125 until youve mastered everything else.  Then
// 			let me know what it does.  Actually, it determines
// 			the spacing of the segments.  The default is good
// 			for blobs with a fairly high CordRatio (>0.2).
// ObjType	[0]	Type of object.  0 = blob, 1 = union of cylinders
// Texture      [specl] Texture for object.  Defaults to light red.
// Threshold	[0.90]	If ObjType is 0 (blob) then this is the threshold
// 			value of the blob
// ThreshLevel	[1.00]	If ObjType is 0 (blob) then this is the strength of
// 			the individual components.
//
// ToDo:
// Add the ability to support generic segment objects.
// Add user defined blob segment scaling.
// Add the ability to make each cord a different texture (or not... not
//   currently possible under POVRay 3.0, at least not nicely)
// Allow the twist to follow a curve (tricky, that one)
// 

#ifndef (NumRots)    #declare NumRots = 3	 #end
#ifndef (Height)     #declare Height = 28	 #end
#ifndef (Rad)	     #declare Rad = 1.5		 #end
#ifndef (NumCords)   #declare NumCords = 4	 #end
#ifndef (CordRatio)  #declare CordRatio = 0.5	 #end
#ifndef (NumSegs)    #declare NumSegs = 70	 #end
#ifndef (OffsetFact) #declare OffsetFact = 0.125 #end
#ifndef (ObjType)    #declare ObjType = 0	 #end

#if (ObjType = 0)
  #ifndef (Threshold)  #declare Threshold = 0.90   #end
  #ifndef (ThreshLevel)#declare ThreshLevel = 1.00 #end
#end

#if (OffsetFact = 1)
  #error "stwist.inc error: OffsetFact must not equal 1.\n"
#end

#if ((ObjType < 0) | (ObjType > 1))
  #warning "stwist.inc warning: ObjType must be either 0 or 1.  Assuming 1.\n"
  #declare ObjType = 1
#end

#ifndef (Texture)
  #declare Texture = texture { pigment { rgb <0.8, 0.5, 0.5> } }
#end

#declare _stwist_Step = 1 / NumSegs
#declare _stwist_StepOff = _stwist_Step * OffsetFact

#if (ObjType = 0) blob #else union #end
{
    #if (ObjType = 0) threshold Threshold #end
    #declare _stwist_I = 0
    #while (_stwist_I < NumCords)
      #declare _stwist_J = 0
      #declare _stwist_LJ = _stwist_J - _stwist_Step + _stwist_StepOff
      #while (_stwist_J < 1)
	#declare _stwist_Pos = <sin(_stwist_J * 2 * pi * NumRots) * Rad / 2,
		        _stwist_J * Height,
	 		cos(_stwist_J * 2 * pi * NumRots) * Rad / 2>
	#declare _stwist_LPos =<sin(_stwist_LJ * 2 * pi * NumRots) * Rad / 2,
			_stwist_LJ * Height,
			cos(_stwist_LJ * 2 * pi * NumRots) * Rad / 2>
	#if (_stwist_J > 0) 
          cylinder
          {
	      _stwist_Pos, _stwist_LPos,
	      Rad * CordRatio #if (ObjType = 0), ThreshLevel #end
	      rotate y * 360 / NumCords * _stwist_I
	  } 
        #end
        #declare _stwist_LJ = _stwist_J + _stwist_StepOff
	#declare _stwist_J = _stwist_J + _stwist_Step
      #end
      #declare _stwist_I = _stwist_I + 1
    #end
    texture { Texture }
}
