// Persistence of Vision Ray Tracer Scene Description File
// File: ballista.inc
// Vers: 3.02
// Desc: BOTBATBT.pov include file
// Date: 23/02/98
// Auth: T.N.
#version 3.02
#include "colors.inc"
#include "textures.inc"
#include "flag.inc"
// note: stwist.inc also needed
// ----------------------------------------

// TEXTURES
#declare Whyte = color red 0.94 green 0.94 blue 0.84
#declare AF = finish {ambient 0.35 diffuse 0.35 reflection 0.2 phong 0.75 phong_size 50}
#declare BF = finish {ambient 0.45 diffuse 0.45 reflection 0.1 phong 0.25}
#declare ACM =
  color_map {
    [0.00 0.02 color Red color Whyte]
    [0.02 0.49 color Whyte color Whyte]
    [0.49 0.51 color Whyte color Black]
    [0.51 0.59 color Black color Black]
    [0.59 0.61 color Black color Red]
    [0.61 1.00 color Red color Red]
  }
#declare BCM =
  color_map {
    [0.00 0.02 color Red color Black]
    [0.02 0.49 color Black color Black]
    [0.49 0.51 color Black color Whyte]
    [0.51 0.59 color Whyte color Whyte]
    [0.59 0.61 color Whyte color Red]
    [0.61 1.00 color Red color Red]
  }
#declare AMT = texture {
  pigment { gradient y
  color_map {ACM}
  }
}
#declare BMT = texture {
  pigment { gradient y
  color_map {BCM}
  }
}
#declare Atex1 = texture {AMT
                         finish {BF}
                         scale 1.25 rotate z*90}
#declare Atex2 = texture {AMT
                         finish {BF}
                         scale 1.25 rotate y*90}
#declare Atex3 = texture {AMT
                         finish {BF}
                         scale 1.25 rotate x*90}
#declare Btex1 = texture {BMT
                         finish {BF}
                         scale 1.25 rotate z*90}
#declare Btex2 = texture {BMT
                         finish {BF}
                         scale 1.25 rotate y*90}
#declare Btex3 = texture {BMT
                         finish {BF}
                         scale 1.25 rotate x*90}
#declare Iron  = texture { pigment { rgb <0.55, 0.55, 0.55> }
                           finish  { reflection 0.1 }}
#declare Line  = texture { pigment { rgb <0.85, 0.85, 0.75> }
                           finish  { ambient 0.3 reflection 0.1 }}
#declare Rope  = texture { pigment { rgb <0.95, 0.85, 0.65> }
                           finish  { ambient 0.3 reflection 0.1 }}
#declare Atip  = texture { pigment { rgb <0.3, 0.8, 0.1> }
                           finish  { BF }}
#declare Camo  = texture { pigment { bozo turbulence 0.5
                             color_map {
                               [0.0, 0.5 color rgb <0.9, 0.7, 0.0>
                                         color rgb <0.3, 0.8, 0.1>]
                               [0.5, 0.6 color rgb <0.6, 0.6, 0.4>
                                         color rgb <0.9, 0.7, 0.0>]
                               [0.6, 1.0 color rgb <0.6, 0.6, 0.4>
                                         color rgb <0.6, 0.6, 0.4>]
                             }
                             scale 0.25
                           }
                           finish  { BF }}
// ----------------------------------------

// DEFINITIONS
#declare R1=seed(1)
#declare R2=seed(2)
#declare R3=seed(3)
#declare R4=seed(4)
#declare R5=seed(5)
#declare R6=seed(6)
#declare R7=seed(7)
#declare R8=seed(8)
#declare R9=seed(9)
#declare ID1 = transform {translate <30*rand(R1),40*rand(R1),50*rand(R1)>}
#declare ID2 = transform {translate <30*rand(R2),40*rand(R2),50*rand(R2)>}
#declare ID3 = transform {translate <30*rand(R3),40*rand(R3),50*rand(R3)>}
#declare ID4 = transform {translate <30*rand(R4),40*rand(R4),50*rand(R4)>}
#declare ID5 = transform {translate <30*rand(R5),40*rand(R5),50*rand(R5)>}
#declare ID6 = transform {translate <30*rand(R6),40*rand(R6),50*rand(R6)>}
#declare ID7 = transform {translate <30*rand(R7),40*rand(R7),50*rand(R7)>}
#declare ID8 = transform {translate <30*rand(R8),40*rand(R8),50*rand(R8)>}
#declare ID9 = transform {translate <30*rand(R9),40*rand(R9),50*rand(R9)>}
#declare ID10 = transform {scale <1,1,0.75> rotate x*-45 translate <0,1.25,-5.25>}
#declare ID11 = transform {rotate x*30 translate <0,7.3,-8.5>}
#declare A= 0.75
#declare B= 0.675
#declare C= 0.35
#declare D= 0.5
#declare N= 0
#declare P= 0.5303300858899
#declare Q= 0.4772970773009
#declare R= 0.2870125742738
#declare S= 0.6929096493722
#declare T= 0.2583113168464
#declare U= 0.623618684436
#declare V= 0.2474873734153
// ----------------------------------------

// DOWELS
#declare DowelX= box {<-0.325,-0.075,-0.075><0.325,0.075,0.075>}
#declare DowelY= box {<-0.075,-0.325,-0.075><0.075,0.325,0.075>}
#declare DowelZ= box {<-0.075,-0.075,-0.325><0.075,0.075,0.325>}
// ----------------------------------------

// UNDERCARRIAGE
// ----------------------------------------
///////// START BALLISTA DECLARE //////////
// ----------------------------------------
#declare Ballista =
union {
  box {<-1.001,0,-6><1.001,0.5,-2> texture {Atex1 transform ID1}}
  box {<-1.001,0,0><1.001,0.5,5.5> texture {Atex1 transform ID2}}
  box {<-5,0,0.001><5,0.5,-2.001> texture {Btex2 transform ID1}}
  box {<-0.65,0,-0.35><-0.5,0.575,-0.5> texture {Atex2 transform ID2}}
  box {<0.5,0,-1.5><0.65,0.575,-1.65> texture {Atex2 transform ID3}}
  union {
    box {<-1,-0.5,0><1,0,5.656854249492>}
    box {<-0.65,-0.5,0.35><-0.5,0.075,0.5>}
    box {<0.5,-0.5,0.35><0.65,0.075,0.5>}
      texture {Btex1 transform ID3} rotate x*-45 translate <0,0.5,-6>
  }
  union {
    box {<-1,-0.5,0><1,0,-6.800735254368>}
    box {<-0.65,-0.5,-0.35><-0.5,0.075,-0.5>}
    box {<0.5,-0.5,-0.35><0.65,0.075,-0.5>}
      texture {Atex1 transform ID4} rotate x*36.02737337 translate <0,0.5,5.5>
    }
  union {
    box {<0,-0.5,0><5.656854249492,0,-2>}
    box {<0.35,-0.5,-0.35><0.5,0.075,-0.5>}
    box {<0.35,-0.5,-1.5><0.5,0.075,-1.65>}
      texture {Atex2 transform ID4} rotate z*45 translate <-5,0.5,0>
  }
  union {
    box {<0,-0.5,0><-5.656854249492,0,-2>}
    box {<-0.35,-0.5,-0.35><-0.5,0.075,-0.5>}
    box {<-0.35,-0.5,-1.5><-0.5,0.075,-1.65>}
      texture {Atex2 transform ID5} rotate z*-45 translate <5,0.5,0>
  }
  difference {
    cylinder {<-0.25,0,0><-0.5,0,0>,0.75 transform ID10}
    box {<-1,-1,0><1,0,5.656854249492> rotate x*-45 translate <0,0.5,-6>}
    texture {Btex2 transform ID6}
  }
  difference {
    cylinder {<0.5,0,0><0.25,0,0>,0.75 transform ID10}
    box {<-1,-1,0><1,0,5.656854249492> rotate x*-45 translate <0,0.5,-6>}
  texture {Btex2 transform ID7}
  }
  cylinder {<-0.85,1.5,-5.5><0.85,1.5,-5.5>,0.125 texture {Atex2 transform ID8}}
  union {
    cylinder {<-0.2,1.5,-5.5><0.2,1.5,-5.5>,0.3}
    cylinder {<-0.2,6,-5.5><0.2,6,-5.5>,0.3}
    box {<-0.2,1.5,-5.2><0.2,6,-5.8>}
      texture {Atex3 transform ID1}
  }
  box {<-1,4,0.001><1,4.5,-2.001> texture {Atex2 transform ID6}}
// ----------------------------------------

// MOUNT
  cylinder {<0,3.875,-1><0,5.125,-1>,0.5 texture {Atex3 transform ID2}}
  box {<-1.6,4.5,0><1.6,5,-2> texture {Atex2 transform ID7}}
  union {
    box {<-2.1,4.5,0><-1.6,6.5,-2>}
    cylinder {<-2.1,6.5,-1><-1.6,6.5,-1>,1}
    object {DowelX translate <-1.85,4.75,-1.575>}
    object {DowelX translate <-1.85,4.75,-1>}
    object {DowelX translate <-1.85,4.75,-0.425>}
      texture {Atex3 transform ID3}
  }
  union {
    box {<1.6,4.5,0><2.1,6.5,-2>}
    cylinder {<1.6,6.5,-1><2.1,6.5,-1>,1}
    object {DowelX translate <1.85,4.75,-1.575>}
    object {DowelX translate <1.85,4.75,-1>}
    object {DowelX translate <1.85,4.75,-0.425>}
      texture {Atex3 transform ID4}
  }
  union {
  box {<-2.125,6.75,-1.25><-1.6,7.25,-0.75>}
  box {<1.6,6.75,-1.25><2.125,7.25,-0.75>}
  cylinder {<-1.6,7,-1><1.6,7,-1>,0.25}
    texture {Atex2 transform ID9}
  }
  difference {
    box {<-1,6,-7.5><1,6.5,3.5>}
    cylinder {<-0.25,6,-5.5><0.25,6,-5.5>,0.35 translate y*-0.05}
      texture {Atex1 transform ID5}
    }
  box {<-0.75,5.94,-7.5><0.75,6,-7> texture {Atex2 transform ID1}}
  difference {
    union {
      box {<-1.5,6,-9.25><-1,8,5>}
      object {DowelX translate <-1.25,7,-6>}
      object {DowelX translate <-1.25,7,-5>}
      object {DowelX translate <-1.25,7,-4>}
      object {DowelX translate <-1.25,7,-3>}
      object {DowelX translate <-1.25,7,1>}
      object {DowelX translate <-1.25,7,2>}
      object {DowelX translate <-1.25,7,3>}
      object {DowelX translate <-1.25,7,4>}
    }
    box {<-1.55,7.5,0><1.55,7.625,-6.5>
    texture {Atex1 transform ID6 finish {ambient 0.4 diffuse 0.4}}}
      texture {Atex1 transform ID6}
  }
  difference {
    union {
      box {<1.5,6,-9.25><1,8,5>}
      object {DowelX translate <1.25,7,-6>}
      object {DowelX translate <1.25,7,-5>}
      object {DowelX translate <1.25,7,-4>}
      object {DowelX translate <1.25,7,-3>}
      object {DowelX translate <1.25,7,1>}
      object {DowelX translate <1.25,7,2>}
      object {DowelX translate <1.25,7,3>}
      object {DowelX translate <1.25,7,4>}
    }
    box {<-1.55,7.5,0><1.55,7.625,-6.5>
    texture {Btex1 transform ID7 finish {ambient 0.4 diffuse 0.4}}}
      texture {Btex1 transform ID7}
  }
  difference {
    box {<-1,6.5,-7><1,7.5,6>}
    cylinder {<0,7.625,-7.5><0,7.625,6.5>,0.25}
      texture {Atex1 transform ID8}
  }
// ----------------------------------------

// ARROW
// ----------------------------------------
/// START ARROW UNION (translate z*-4) ////
// ----------------------------------------
  union {
  union {
    intersection {
      plane {y, 0 rotate x*30  translate y*sqrt(0.5)/2}
      plane {-y, 0 rotate x*-30 translate y*-sqrt(0.5)/2}
      plane {-x, 0 rotate y*30  translate x*-sqrt(0.5)/2}
      plane {x, 0 rotate y*-30 translate x*sqrt(0.5)/2}
      plane {-z, 0}
        translate z*-sqrt(0.5)*sin(radians(60))/2
        rotate z*45
        scale <0.725,0.15625,1/(sqrt(0.5)*sin(radians(60)))*0.9>
        translate z*0.6
    }
    cone {<0,0,0>,0.15625<0,0,1>,0}
      translate <0,7.53125,5>
      texture {Atip}
  }
  union {
    difference {
      box {<-0.375,0,-1><0.375,0.0625,0>}
      box {<-1,-0.1,-1><0,0.1625,0> rotate y*45}
      box {<0,-0.1,-1><1,0.1625,0> rotate y*-45}
        translate <0,7.5,0.9>
    }
    cylinder {<0,7.53125,-0.375><0,7.53125,5.5>,0.078125}
      texture {Camo}
  }
  translate z*-4
  }
// ----------------------------------------
//// END ARROW UNION (translate z*-4) /////
// ----------------------------------------
// ----------------------------------------

// TRIGGER
// ----------------------------------------
// START TRIGGER UNION (translate z*-4) ///
// ----------------------------------------
  union {
  difference {
    union {
      cylinder {<0,7.53125,-2.5><0,7.59375,-2.5>,0.5}
      box {<-1,7.5,-2.5><1,7.625,-1.5>}
      box {<-1.25,7.5,-2><1.25,7.625,-0.5>}
      cylinder {<-0.59375,7.75,-1.125><-0.65625,7.75,-1.125>,0.15625}
      box {<-0.59375,7.5,-1.21965><-0.65625,7.75,-1.03215>}
      cylinder {<0.59375,7.75,-1.125><0.65625,7.75,-1.125>,0.15625}
      box {<0.59375,7.5,-1.21965><0.65625,7.75,-1.03215>}
      cylinder {<-0.71875,7.75,-1.125><0.71875,7.75,-1.125>,0.0625}
    }
    cylinder {<0,7.43125,-2.5><0,7.725,-2.5>,0.325}
      texture {Iron}
  }
  union {
    difference {
      torus {0.1875,0.04375 sturm rotate z*90}
      box {<-1,-1,-1><1,0,1>}
        translate <0,7.75,-1.75>
    }
    torus {0.3,0.04375 sturm rotate x*-8.56 translate <0,7.79375,-2>}
    box {<-1,7.65,-2><1,7.75,-1.5>}
      translate y*-0.0125
      texture {Iron}
  }
  union {
    box {<-0.59375,7.5,-0.375><-0.46875,7.875,-0.25>}
    cylinder {<-0.59375,7.75,-1.125><-0.46875,7.75,-1.125>,0.125}
    box {<-0.59375,7.625,-1.125><-0.46875,7.875,-0.375>}
    box {<-0.59375,7.75,-1.75><-0.46875,7.875,-0.375>}
      texture {Iron}
  }
  union {
    box {<0.59375,7.5,-0.375><0.46875,7.875,-0.25>}
    cylinder {<0.59375,7.75,-1.125><0.46875,7.75,-1.125>,0.125}
    box {<0.59375,7.625,-1.125><0.46875,7.875,-0.375>}
    box {<0.59375,7.75,-1.75><0.46875,7.875,-0.375>}
      texture {Iron}
  }
  translate z*-4
  }
// ----------------------------------------
/// END TRIGGER UNION (translate z*-4) ////
// ----------------------------------------
// ----------------------------------------

// BOW FRAME
// ----------------------------------------
///// START BOW UNION (translate z*1) /////
// ----------------------------------------
  union {
  difference {
    union {
      box {<-6,5.5,0.5><6,6,3.5>}
      object {DowelY translate <-5.75,5.75,0.875>}
      object {DowelY translate <-5.75,5.75,1.625>}
      object {DowelY translate <-5.75,5.75,2.375>}
      object {DowelY translate <-5.75,5.75,3.125>}
      object {DowelY translate <5.75,5.75,0.875>}
      object {DowelY translate <5.75,5.75,1.625>}
      object {DowelY translate <5.75,5.75,2.375>}
      object {DowelY translate <5.75,5.75,3.125>}
      object {DowelY translate <-5.25,5.6875,1>}
      object {DowelY translate <-5.25,5.6875,2>}
      object {DowelY translate <-3.75,5.6875,1>}
      object {DowelY translate <-3.75,5.6875,2>}
      object {DowelY translate <5.25,5.6875,1>}
      object {DowelY translate <5.25,5.6875,2>}
      object {DowelY translate <3.75,5.6875,1>}
      object {DowelY translate <3.75,5.6875,2>}
    }
    cylinder {<-4.5,5,1.5><-4.5,10,1.5>,0.6}
    cylinder {<4.5,5,1.5><4.5,10,1.5>,0.6}
      texture {Atex2 transform ID2}
  }
  union {
    difference {
      union {
        box {<-5.5,5.5,0.75><-3.5,5.375,2.25>}
        cylinder {<-4.5,5.501,1.5><-4.5,5.125,1.5>,0.625}
        box {<-5.25,5.25,1.4375><-3.75,5.125,1.5625>}
      }
      cylinder {<-4.5,5.6,1.5><-4.5,5.025,1.5>,0.5625}
      box {<-4.5625,5.25,0.75><-4.4375,5.126,2.25>}
    }
    box {<-5.25,5.25,1.4375><-3.75,5.126,1.5625>}
      translate y*0.0625
      texture {Iron}
  }
  union {
    difference {
      union {
        box {<-5.5,5.5,0.75><-3.5,5.375,2.25>}
        cylinder {<-4.5,5.501,1.5><-4.5,5.125,1.5>,0.625}
        box {<-5.25,5.25,1.4375><-3.75,5.125,1.5625>}
      }
      cylinder {<-4.5,5.6,1.5><-4.5,5.025,1.5>,0.5625}
      box {<-4.5625,5.25,0.75><-4.4375,5.124,2.25>}
    }
    box {<-5.25,5.25,1.4375><-3.75,5.124,1.5625>}
      translate y*0.0625
      translate x*9
      texture {Iron}
  }
  difference {
    union {
      box {<-6,9,0.5><6,9.5,3.5>}
      object {DowelY translate <-5.75,9.25,0.875>}
      object {DowelY translate <-5.75,9.25,1.625>}
      object {DowelY translate <-5.75,9.25,2.375>}
      object {DowelY translate <-5.75,9.25,3.125>}
      object {DowelY translate <5.75,9.25,0.875>}
      object {DowelY translate <5.75,9.25,1.625>}
      object {DowelY translate <5.75,9.25,2.375>}
      object {DowelY translate <5.75,9.25,3.125>}
      object {DowelY translate <-5.25,9.3125,1>}
      object {DowelY translate <-5.25,9.3125,2>}
      object {DowelY translate <-3.75,9.3125,1>}
      object {DowelY translate <-3.75,9.3125,2>}
      object {DowelY translate <5.25,9.3125,1>}
      object {DowelY translate <5.25,9.3125,2>}
      object {DowelY translate <3.75,9.3125,1>}
      object {DowelY translate <3.75,9.3125,2>}
    }
    cylinder {<-4.5,5,1.5><-4.5,10,1.5>,0.6}
    cylinder {<4.5,5,1.5><4.5,10,1.5>,0.6}
      texture {Atex2 transform ID3}
  }
  union {
    difference {
      union {
        box {<-5.5,9.5,0.75><-3.5,9.625,2.25>}
        cylinder {<-4.5,9.499,1.5><-4.5,9.875,1.5>,0.625}
      }
      cylinder {<-4.5,9.4,1.5><-4.5,9.975,1.5>,0.5625}
      box {<-4.5625,9.75,0.75><-4.4375,9.876,2.25>}
    }
    box {<-5.25,9.75,1.4375><-3.75,9.876,1.5625>}
      translate y*-0.0625
      texture {Iron}
  }
  union {
    difference {
      union {
        box {<-5.5,9.5,0.75><-3.5,9.625,2.25>}
        cylinder {<-4.5,9.499,1.5><-4.5,9.875,1.5>,0.625}
      }
      cylinder {<-4.5,9.4,1.5><-4.5,9.975,1.5>,0.5625}
      box {<-4.5625,9.75,0.75><-4.4375,9.876,2.25>}
    }
    box {<-5.25,9.75,1.4375><-3.75,9.876,1.5625>}
      translate y*-0.0625
      translate x*9
      texture {Iron}
  }
  difference {
    box {<-6,6,0.5><-5.5,9,3.5>}
    prism {
      linear_sweep
      cubic_spline
      -1
      1
      11
      <5,-1.5>,
      <-0.25,0>,<-0.1,2>,<0,1.5>,<0.2,0.85>,<1.2,0.0625>,
      <0.2,-0.85>,<0,-1.5>,<-0.1,-2>,<-0.25,0>,
      <5,1.5>
      sturm
    scale <1,6.5,1>
    rotate y*-90
    rotate z*-90
    translate <0,7.5,0.5>
    }
      texture {Atex3 transform ID5}
  }
  difference {
    box {<5.5,6,0.5><6,9,3.5>}
    prism {
      linear_sweep
      cubic_spline
      -1
      1
      11
      <5,-1.5>,
      <-0.25,0>,<-0.1,2>,<0,1.5>,<0.2,0.85>,<1.2,0.0625>,
      <0.2,-0.85>,<0,-1.5>,<-0.1,-2>,<-0.25,0>,
      <5,1.5>
      sturm
    scale <1,6.5,1>
    rotate y*-90
    rotate z*-90
    translate <0,7.5,0.5>
    }
      texture {Atex3 transform ID6}
  }
// ----------------------------------------

// BOW BARS & STRING
  union {
    box {<-0.23,5.75,-0.23><0.23,9.25,0.23> rotate y*46.525 translate <4.5,0,1.5>}
    box {<-0.23,5.75,-0.23><0.23,9.25,0.23> rotate y*-46.525 translate <-4.5,0,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5625,0.28125,0.5625>
                              translate <4.5,9.5,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5625,0.28125,0.5625>
                              translate <-4.5,9.5,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5625,0.28125,0.5625>
                              translate <4.5,5.525,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5625,0.28125,0.5625>
                              translate <-4.5,5.25,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5,0.25,0.5>
                              translate <4.5,9.25,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5,0.25,0.5>
                              translate <-4.5,9.25,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5,0.25,0.5>
                              translate <4.5,5.75,1.5>}
    superellipsoid { <1, 0.2> rotate x*90 scale <0.5,0.25,0.5>
                              translate <-4.5,5.75,1.5>}
    union {
      difference {
        cylinder {<0,7.5625,0><5.5,7.5625,0>,0.2}
        box {<-0.25,7.5,-0.25><0.25,7.625,0.25> rotate y*-35 translate <5.075,0,-0.2618>}
      }
      cylinder {<5.1215,7.3475,0><5.1215,7.7775,0>,0.1215}
    rotate y*46.525 translate <4.5,0,1.5>
    }
    union {
      difference {
        cylinder {<0,7.5625,0><-5.5,7.5625,0>,0.2}
        box {<-0.25,7.5,-0.25><0.25,7.625,0.25> rotate y*35 translate <-5.075,0,-0.2618>}
      }
      cylinder {<-5.1215,7.3475,0><-5.1215,7.7775,0>,0.1215}
    rotate y*-46.525 translate <-4.5,0,1.5>
    }
      texture {Iron}
  }
  translate z*1
  }
// ----------------------------------------
////// END BOW UNION (translate z*1) //////
// ----------------------------------------
  union {
    object {
      #declare NumRots = 10
      #declare Height = 81.0145
      #declare Rad = 0.5
      #declare NumCords = 4
      #declare CordRatio = 0.5
      #declare NumSegs = 500
      #declare OffsetFact = -0.5
      #declare ObjType = 1
      #declare Texture = texture { Line }
      #include "stwist.inc"
      translate y*-81.0145/2
      scale 0.1
      translate y*8.10145/2
      rotate z*-90
      translate y*7.5625
      rotate y*-23.51953
      translate <0.59375,0,-4.4375>
    }
    sphere {<0.59375,7.5625,-4.4375>,0.05 texture {Line}}
    object {
      #declare NumRots = 1.465
      #declare Height = 11.875
      #declare Rad = 0.5
      #declare NumCords = 4
      #declare CordRatio = 0.5
      #declare NumSegs = 73
      #declare OffsetFact = -0.5
      #declare ObjType = 1
      #declare Texture = texture { Line }
      #include "stwist.inc"
      translate y*-11.875/2
      scale 0.1
      rotate z*90
      translate y*7.5625
      translate <0,0,-4.4375>
    }
    sphere {<-0.59375,7.5625,-4.4375>,0.05 texture { Line }}
    object {
      #declare NumRots = 10
      #declare Height = 81.0145
      #declare Rad = 0.5
      #declare NumCords = 4
      #declare CordRatio = 0.5
      #declare NumSegs = 500
      #declare OffsetFact = -0.5
      #declare ObjType = 1
      #declare Texture = texture { Line }
      #include "stwist.inc"
      translate y*-81.0145/2
      scale 0.1
      translate y*8.10145/2
      rotate z*90
      translate y*7.5625
      rotate y*23.51953
      translate <-0.59375,0,-4.4375>
    }
  }
// ----------------------------------------

// PAWL & RACHET WHEEL
  union {
    box {<-2.025,-0.2,-0.2><-1.6,0.2,0.2>}
    box {<1.6,-0.2,-0.2><2.025,0.2,0.2>}
    cylinder {<-1.6,0,0><1.6,0,0>,0.2}
      texture {Atex2 transform ID4}
      transform ID11
  }
  box {<-0.975,-0.3,-0.05><-0.825,0.3,0.05> rotate x*10
    texture { Atex1 transform ID8}
    rotate x*-30 transform ID11}
  cylinder {<-2,0,0><-1.6,0,0>,0.75
    texture {Btex1 transform ID8}
    transform ID11}
  cylinder {<-1.8,0,-2.0><-1.8,0,2.0>,0.15
    texture {Atex1 transform ID9}
    transform ID11}
  cylinder {<-1.8,0,-2.0><-1.8,0,2.0>,0.15
    rotate x*90
    texture {Atex3 transform ID7}
    transform ID11}
  union {
    cylinder {<2.025,7.7,-7><2.0375,7.7,-7>,0.165}
    cylinder {<1.2,7.7,-7><2.025,7.7,-7>,0.15}
      texture {Atex2 transform ID5}
  }
  prism {
    linear_sweep
    quadratic_spline
    -0.2
    0.2
    34
    <-A,N>,<-B,N>,
    <-S,R>,<-U,T>,
    <-P,P>,<-Q,Q>,
    <-R,S>,<-T,U>,
    <N,A>,<N,B>,
    <R,S>,<T,U>,
    <P,P>,<Q,Q>,
    <S,R>,<U,T>,
    <A,N>,<B,N>,
    <S,-R>,<U,-T>,
    <P,-P>,<Q,-Q>,
    <R,-S>,<T,-U>,
    <N,-A>,<N,-B>,
    <-R,-S>,<-T,-U>,
    <-P,-P>,<-Q,-Q>,
    <-S,-R>,<-U,-T>,
    <-A,N>,<-B,N>
    sturm
    rotate y*30
  rotate z*-90
  rotate x*-90
  translate <1.8,7.3,-8.5>
    texture {Atex1 transform ID1 rotate x*30}
  }
  prism {
    linear_sweep
    cubic_spline
    -0.2
    0.2
    12
    <-V+0.055,-V-0.25>,<-C,N>,
    <-V,V>,<N,C>,<V,V>,<C,N>,<V,-V>,
    <V-0.175,-V-0.25>,<N,-C-0.8>,<-V+0.055,-V-0.25>,
    <-C,N>,<-V,V>
    sturm
    rotate y*99
  rotate z*-90
  rotate x*-90
  translate <1.8,7.7,-7>
    texture {Atex1 transform ID2}
  }
// ----------------------------------------

// ROPE
  #declare TC0 = 0
  #while (TC0 <50)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*TC0
      translate z*-0.22
      rotate x*36*TC0
      translate x*0.018*TC0
      rotate x*88.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC0 = TC0+0.25
  #end
  #declare TC1 = 0
  #while (TC1 <8.75)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*50
      translate z*-0.22
      rotate x*36*50
      translate x*0.018*50
      translate y*0.138230076758*1.2*TC1
      rotate x*88.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC1 = TC1+0.25
  #end
  #declare TC2 = 0
  #while (TC2 <1.25)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*50
      translate z*-0.22
      rotate x*36*50
      translate x*0.018*50
      translate y*0.138230076758*1.2*8.75
      translate y*0.138230076758*1.2*TC2
      rotate x*91.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC2 = TC2+0.25
  #end

  cylinder {<0,0.22,0><0,0.22,1.35>,0.03 rotate x*-1.5 rotate x*-30 transform ID11
    texture { Rope }}

  #declare TC3 = 0
  #while (TC3 <3)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*50
      rotate y*12*TC3
      translate z*0.09
      rotate x*-63*TC3
      translate z*-0.09
      translate z*-0.22
      rotate x*36*50
      translate x*0.018*50
      translate y*0.138230076758*1.2*10
      rotate x*91.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC3 = TC3+0.25
  #end
  #declare TC4 = 0
  #while (TC4 <1.25)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*50
      rotate y*12*3
      translate y*0.138230076758*1.2*TC4
      translate z*0.09
      rotate x*-63*3
      translate z*-0.09
      translate z*-0.22
      rotate x*36*50
      translate x*0.018*50
      translate y*0.138230076758*1.2*10
      rotate x*91.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC4 = TC4+0.25
  #end
  #declare TC5 = 0
  #while (TC5 <3)
    object {
      #declare NumRots = 0.5
      #declare Height = 0.8
      #declare Rad = 0.8
      #declare NumCords = 4
      #declare CordRatio = 0.18
      #declare NumSegs = 10
      #declare OffsetFact = -0.2
      #declare ObjType = 1
      #declare Texture = texture { Rope }
      #include "stwist.inc"
      translate y*-0.4
      scale 0.1
      rotate y*12*50
      rotate y*12*3
      rotate y*12*TC5
      translate z*0.07
      rotate x*-63*TC5
      translate z*-0.07
      translate y*0.138230076758*1.2*1.25
      translate z*0.09
      rotate x*-63*3
      translate z*-0.09
      translate z*-0.22
      rotate x*36*50
      translate x*0.018*50
      translate y*0.138230076758*1.2*10
      rotate x*91.5
      translate x*-0.9
      rotate x*-30 transform ID11
    }
  #declare TC5 = TC5+0.25
  #end
// ----------------------------------------

// NOOSE
  difference {
    cone {<0,0.22,1.15>,0.07<0,0.22,1.45>,0.1 scale <0.9,1,1> rotate x*-1.5}
    cylinder {<0,-0.5,0><0,0.5,0>,0.07 rotate x*-1.5 translate <0,0.22,1.4>}
      rotate x*-30 transform ID11
      texture { Iron }}
// ----------------------------------------

// FLAG
  object {FLAG
    scale <1,2.64/4,1>
    texture {
      pigment {
        image_map
//        { tga "pirate.tga"
        { gif "pirate.gif"
          interpolate 2
          once
        }
        translate -0.5*(x+y)
        scale <4/2,2.64/2,1>
      }
      finish {ambient 0.45 diffuse 0.45}
    }
    translate x*1.05
    rotate y*100
    translate <0,11,3>
  }
  union {
    cylinder {<0,9.5,3><0,11.05+2.64/4,3>,0.05}
    sphere {<0,11.075+2.64/4,3>,0.075}
      pigment {Whyte} finish {BF}
  }
}
// ----------------------------------------
////////// END BALLISTA DECLARE ///////////
// ----------------------------------------
// ----------------------------------------







// ----------------------------------------
/////// CAMERAS FOR TEST RENDERING ////////
// ----------------------------------------
/*
// CAMERA 0
global_settings
{ assumed_gamma 2.2
  ambient_light 1.5
}
background {color red 0.3 green 0.8 blue 0.8}

// CAMERA, BALLISTA & LIGHT
camera {
  location <80, 40, -100>
  up <0.0, 1.0, 0.0>
  right <4/3, 0.0, 0.0>
  look_at <0.0, 0.0, 0.0>
  angle 54.29936339557
  rotate x*10
  rotate z*-10
}
object {Ballista
        translate y*-4.5
        scale 2.0
        rotate x*9.75
        rotate y*-14.5
        rotate z*-25.875
        translate <35,25,-60>
        rotate x*10
        rotate z*-10
}
object {light_source {<200.0, 200.0, -150.0> color White}}
*/
// ----------------------------------------
/*
// CAMERA 1
global_settings
{ assumed_gamma 2.2
}
background {color red 0.3 green 0.8 blue 0.8}

// CAMERA, BALLISTA & LIGHT
camera
{
  location  <-10, 7.5, 3>
  direction 1*z
  right     4/3*x
  look_at   <2, 7.5, 3>
}
object {Ballista}
light_source {0*x color red 1  green 1  blue 1 translate <300, 300, 300>}
light_source {0*x color red 1  green 1  blue 1 translate <-300, 300, -300>}
*/
// ----------------------------------------
/*
// CAMERA 2
global_settings
{ assumed_gamma 2.2
}
background {color red 0.3 green 0.8 blue 0.8}

// CAMERA, BALLISTA & LIGHT
camera
{
  location  <0, 7.5, -10>
  direction 1*z
  right     4/3*x
  look_at   <0, 7.5, 0>
}
object {Ballista}
light_source {0*x color red 1  green 1  blue 1 translate <300, 300, 300>}
light_source {0*x color red 1  green 1  blue 1 translate <-300, 300, -300>}
*/
// ----------------------------------------
/*
// CAMERA 3
global_settings
{ assumed_gamma 2.2
}
background {color red 0.3 green 0.8 blue 0.8}

// CAMERA, BALLISTA & LIGHT
camera
{
  location  <0, 15, -4>
  direction 2*z
  right     4/3*x
  look_at   <0, 7.5, -4>
}
object {Ballista}
light_source {0*x color red 1  green 1  blue 1 translate <300, 300, 300>}
light_source {0*x color red 1  green 1  blue 1 translate <-300, 300, -300>}
*/
// ----------------------------------------
/*
// CAMERA 4
global_settings
{ assumed_gamma 2.2
}
background {color red 0.3 green 0.8 blue 0.8}

// CAMERA, BALLISTA & LIGHT
camera {
  location <50, 40.0, -100>
  direction <0.0, 0.0, 20>
  up <0.0, 1.0, 0.0>
  right <4/3, 0.0, 0.0>
  look_at <0, 7.5, -8.5>
  rotate x*10
  rotate z*-10
}
object {Ballista}
light_source {0*x color red 1  green 1  blue 1 translate <300, 300, 300>}
light_source {0*x color red 1  green 1  blue 1 translate <-300, 300, -300>}
*/
// ----------------------------------------
// END OF FILE
