
// POV file by Andrew Cherry 1998
// Email: UNDEAD1@INFI.NET

// Created for the Internet Ray-Tracing Competition
// January-February 1998 Round
// Great Engineering Achievements

#declare c=clock

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,1)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n\n"

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera
{
perspective
  location  <0 , 4 , 4>
  look_at   <0 , 0 , -20>
}

light_source { <0,100,-100> color (White+Yellow+White)/3 }
light_source { <1,2,3> color .25 }
light_source { <1,2,3> color .95 shadowless }

//-----------------------------------------------------------------------------------------------------------------------------
// EASEL1: WING SKETCH
//-----------------------------------------------------------------------------------------------------------------------------

#declare EASEL1= union {
polygon {5, <0, 1>, <1, 1>, <1, 0>, <0, 0>, <0, 1>
texture
  {
    pigment
    {
      image_map
      {
        gif "wing.gif"
        once
      }
    }
  }
translate <-.5,-.5,0>
scale <1,1.5,1>
}
#declare EASELTEX = texture {pigment {Brown} finish {phong 1 crand .1}}
cylinder { <-.5,.75,0>,<.5,.75,0>, .01 texture {EASELTEX}}
cylinder { <-.5,-.75,0>,<.5,-.75,0>, .01 texture {EASELTEX}}
cylinder { <-.5,-.75,0>,<-.5,.75,0>, .01 texture {EASELTEX}}
cylinder { <.5,-.75,0>,<.5,.75,0>, .01 texture {EASELTEX}}
sphere { <-.5, .75,0> .01 texture {EASELTEX}}
sphere { < .5, .75,0> .01 texture {EASELTEX}}
sphere { < .5,-.75,0> .01 texture {EASELTEX}}
sphere { <-.5,-.75,0> .01 texture {EASELTEX}}
cylinder { <.5,0,0>,<.5,-.75,-.25>, .01 texture {EASELTEX}}
cylinder { <-.5,0,0>,<-.5,-.75,-.25>, .01 texture {EASELTEX}}
sphere { <.5,0,0> .01 texture {EASELTEX}}
sphere { <-.5,0,0> .01 texture {EASELTEX}}
sphere { <.5,-.75,-.25> .01 texture {EASELTEX}}
sphere { <-.5,-.75,-.25> .01 texture {EASELTEX}}
}

#object {EASEL1 translate <0,.75,0> scale 5 rotate <0,-40,0> translate <10,0,-20>}

//-----------------------------------------------------------------------------------------------------------------------------
// SURROUNDINGS
//-----------------------------------------------------------------------------------------------------------------------------

#declare WALLTEX = texture {
                           crackle
                                texture_map {
                                [ 0 pigment {color Gray} finish {specular .1 roughness .75 crand .02} ]
                                [ .25 pigment {color ((Gray+Brown+Yellow)/3)} finish {specular .1 roughness .75 crand .01} ]
                                [ 1 pigment {color Brown} finish {specular .1 roughness .75 crand .01} ]
                                } scale .001}

#declare WALLSEG = union {
difference {
box
{
  <-1, -1, 0>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
texture {WALLTEX}
}
cylinder { <0,.25,-1>,<0,.25,2>,  .4 texture {WALLTEX} }
box { <-.4, .25, -1> < .4, -.5, 2> texture {WALLTEX} }
}
box { <-1, -.5, -.5> < 1, -.4, 1.5> texture {WALLTEX} }
difference {
union {
cylinder { <0,.25,-1>,<0,.25,2>,  .5 texture {WALLTEX} }
box { <-.5, .25, -1> < .5, -.4, 2> texture {WALLTEX} }
}
cylinder { <0,.25,-2>,<0,.25,3>,  .4 texture {WALLTEX} }
box { <-.4, .25, -2> < .4, -.4, 3> texture {WALLTEX} }
}
translate <0,0,-1>
scale <5,10,.5>
translate <0,10,0>
}

#object {WALLSEG translate <-40,0,-40>}
#object {WALLSEG translate <-30,0,-40>}
#object {WALLSEG translate <-20,0,-40>}
#object {WALLSEG translate <-10,0,-40>}
#object {WALLSEG translate <  0,0,-40>}
#object {WALLSEG translate < 10,0,-40>}
#object {WALLSEG translate < 20,0,-40>}
#object {WALLSEG translate < 30,0,-40>}
#object {WALLSEG translate < 40,0,-40>}

#declare FLOOR = plane {z, 0
texture
  {
    pigment
    {
      image_map
      {
        tga "E:\Tiles\carel033.tga"
        interpolate 2
      }
    }
   finish {ambient 0.2 reflection 0.1 crand .1}
  }
rotate <-90,0,0>
scale 2
}

#object {FLOOR}

//-----------------------------------------------------------------------------------------------------------------------------
// THE FLYING MACHINE
//-----------------------------------------------------------------------------------------------------------------------------

#declare FLYINGMACHINE = union {

#declare string = texture {pigment {color ((Tan+White+White)/3)} finish {phong 1 ambient .2 metallic}}
#declare canvas = texture {pigment {color ((Tan+White)/2)} finish {phong .25}}
#declare woodtex = texture {
                    pigment {
                     wood
                     color_map {M_Wood1A}
                     scale .25
                     turbulence .1
                     rotate <89,0,1>
                    }
                    finish {}
                   }

#declare HELI1=union {

lathe { linear_spline 4,
    < 0, -1>
    <.5, -1>
    <.5, 1.25>
    < 0, 1.5>
    texture {woodtex} }

#declare WING=union {
#declare s=.1
#declare hI=0
#while (hI<1.5*2*pi)
#declare h2=hI/(3*pi)
cylinder {<sin(hI)/2, cos(hI)/2,0>, <sin(hI)*3*(1+h2), cos(hI)*3*(1+h2),0>, .01  texture {canvas} rotate <90,0,0> translate <0,1-h2,0>}
cylinder {<sin(hI+s)*3*(1+h2), cos(hI+s)*3*(1+h2)>, <sin(hI+s)/2, cos(hI+s)/2>, .01 texture {canvas} rotate <90,0,0> translate <0,1-h2,0>}
#declare hI=hI+1/750
#end
}

#object {WING}

}

#object {HELI1 scale <1,3,1>}

#declare r=0
#while (r<360)
cylinder { <0,0,0>,<1,0,0>, .01 scale <1,.5,1> texture {woodtex} rotate <0,r,0>}
#declare r=r+22.5
#end
torus {1, 0.1 scale <1,.5,1> texture {woodtex}}

#declare r=0
#while (r<360)
cylinder { <0,0,0>,<30,0,0>, .5 scale .1 translate <0,-3,0> texture {woodtex} rotate <0,r,0>}
#declare r=r+45
#end
torus {3, 0.25 scale <1,.1,1> translate <0,-3,0> texture {woodtex}}

#declare r=0
#while (r<360)
cylinder { <.5,0,0>,<3,-3,0>, .1 texture {woodtex} rotate <0,r,0>}
#declare r=r+90
#end
torus {.5, 0.25 translate <0,-.25,0> texture {woodtex}}

cylinder { <1.75,-1.5,0>,<-1.75,-1.5,0>, .1 texture {woodtex}}
cylinder { <0,-1.5,1.75>,<0,-1.5,-1.75>, .1 texture {woodtex}}
torus {.5, 0.1 translate <0,-1.5,0> texture {woodtex}}


#declare s=.1
#declare hI=0
#while (hI<1.5*2*pi)
#declare h2=hI/(3*pi)
cylinder { <(sin(hI)*3*(1+h2))*.95, (1-h2)*3, (cos(hI)*3*(1+h2))*.95>, <sin(hI)*3,-3,cos(hI)*3>, .01 texture {string} }
#declare hI=hI+1
#end

cylinder { <(sin(0)*3), 3, (cos(0)*3)>, <0,3,0>, .025 texture {woodtex} }
cylinder { <(-sin(0)*6), 0, (-cos(0)*6)>, <0,0,0>, .025 texture {woodtex} }

translate <0,3,0>
}

#object {FLYINGMACHINE scale <-1, 1, 1> rotate <0,50,0> translate <2,.1,-10>}

//-----------------------------------------------------------------------------------------------------------------------------
// EASEL2: SKETCH OF THE FLYING MACHINE
//-----------------------------------------------------------------------------------------------------------------------------

#declare EASEL2= union {
polygon {5, <0, 1>, <1, 1>, <1, 0>, <0, 0>, <0, 1>
texture
  {
    pigment
    {
      image_map
      {
        gif "helipic.gif"
        once
      }
    }
  }
translate <-.5,-.5,0>
scale <1,1.5,1>
}
cylinder { <-.5,.75,0>,<.5,.75,0>, .01 texture {EASELTEX}}
cylinder { <-.5,-.75,0>,<.5,-.75,0>, .01 texture {EASELTEX}}
cylinder { <-.5,-.75,0>,<-.5,.75,0>, .01 texture {EASELTEX}}
cylinder { <.5,-.75,0>,<.5,.75,0>, .01 texture {EASELTEX}}
sphere { <-.5, .75,0> .01 texture {EASELTEX}}
sphere { < .5, .75,0> .01 texture {EASELTEX}}
sphere { < .5,-.75,0> .01 texture {EASELTEX}}
sphere { <-.5,-.75,0> .01 texture {EASELTEX}}
cylinder { <.5,0,0>,<.5,-.75,-.25>, .01 texture {EASELTEX}}
cylinder { <-.5,0,0>,<-.5,-.75,-.25>, .01 texture {EASELTEX}}
sphere { <.5,0,0> .01 texture {EASELTEX}}
sphere { <-.5,0,0> .01 texture {EASELTEX}}
sphere { <.5,-.75,-.25> .01 texture {EASELTEX}}
sphere { <-.5,-.75,-.25> .01 texture {EASELTEX}}
scale <1,(2/3),1>
}

#object {EASEL2 translate <0,.5,0> scale 5 rotate <0,40,0> translate <-7.5,0,-15>}

//-----------------------------------------------------------------------------------------------------------------------------
// BOOKS
//-----------------------------------------------------------------------------------------------------------------------------

#declare BOOK1 = union {
height_field
{
  gif "pagehmap.gif"
  water_level 0
  smooth
  texture
  {
    pigment
    {
      image_map { gif "skull.gif" map_type 0 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
  }
scale <1.5,.101,1>
translate <-1.5,0,-.5>
}
height_field
{
  gif "pagehmap.gif"
  water_level 0
  smooth
  texture
  {
    pigment
    {
      image_map { gif "skelarm.gif" map_type 0 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
  }
scale <1.5,.101,1>
rotate <0,180,0>
translate <1.5,0,.5>
}
box { <-1.55, 0,-.55> < 1.55, .001, .55> pigment {color (Red+Brown)/2}}
}

#declare BOOK2 = union {
height_field
{
  gif "pagehmap.gif"
  water_level 0
  smooth
  texture
  {
    pigment
    {
      image_map { gif "anat.gif" map_type 0 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
  }
scale <1,.101,1.5>
translate <-1,0,-.75>
}
height_field
{
  gif "pagehmap.gif"
  water_level 0
  smooth
  texture
  {
    pigment
    {
      image_map { gif "muscarm.gif" map_type 0 once }
      rotate <90,0,0> // lay X-Y image map down onto X-Z height field plane
    }
  }
scale <1,.101,1.5>
rotate <0,180,0>
translate <1,0,.75>
scale <1,1,-1>
}
box { <-1.05, 0,-.8> < 1.05, .001, .8> pigment {color (Red+Brown)/2}}
}

object {BOOK1 rotate <0,180,0> translate <2,0,-5>}
object {BOOK2 rotate <0,180,0> translate <-3,0,-3> rotate <0,10,0>}

//-----------------------------------------------------------------------------------------------------------------------------
// FAKE SKY
//-----------------------------------------------------------------------------------------------------------------------------

polygon {5, <0, 1>, <1, 1>, <1, 0>, <0, 0>, <0, 1>
texture
  {
    pigment
    {
      image_map
      {
        tga "sky.tga"
        once
      }
    }
  }
translate <-.5,-.5,0>
scale <112,88.6,1>
scale .5
translate <0,0,-45>
no_shadow
}

//-----------------------------------------------------------------------------------------------------------------------------
// HAMMER
//-----------------------------------------------------------------------------------------------------------------------------

#declare stonetex = texture {pigment {Gray} finish {phong .75 crand .25} }

#declare HAMMER= union {
difference {
box {
  <-1.5, -1, -1>
  < 1.5,  1,  1>
texture {stonetex}
}
cylinder { <0,0,-1.5>, <0,0,1.5>, .35 texture {stonetex scale .5} }
cylinder { <-1.5, 1, 1>, < 1.5, 1, 1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5,-1, 1>, < 1.5,-1, 1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5,-1,-1>, < 1.5,-1,-1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5, 1,-1>, < 1.5, 1,-1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5, 1, 1>, <-1.5,-1, 1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5,-1, 1>, <-1.5,-1,-1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5,-1,-1>, <-1.5, 1,-1>, .2 texture {stonetex scale .5} }
cylinder { <-1.5, 1,-1>, <-1.5, 1, 1>, .2 texture {stonetex scale .5} }
cylinder { < 1.5, 1, 1>, < 1.5,-1, 1>, .2 texture {stonetex scale .5} }
cylinder { < 1.5,-1, 1>, < 1.5,-1,-1>, .2 texture {stonetex scale .5} }
cylinder { < 1.5,-1,-1>, < 1.5, 1,-1>, .2 texture {stonetex scale .5} }
cylinder { < 1.5, 1,-1>, < 1.5, 1, 1>, .2 texture {stonetex scale .5} }
sphere { <-1.5,-1, 1>, .2 texture {stonetex scale .5} }
sphere { <-1.5,-1,-1>, .2 texture {stonetex scale .5} }
sphere { <-1.5, 1, 1>, .2 texture {stonetex scale .5} }
sphere { <-1.5, 1,-1>, .2 texture {stonetex scale .5} }
sphere { < 1.5,-1, 1>, .2 texture {stonetex scale .5} }
sphere { < 1.5,-1,-1>, .2 texture {stonetex scale .5} }
sphere { < 1.5, 1, 1>, .2 texture {stonetex scale .5} }
sphere { < 1.5, 1,-1>, .2 texture {stonetex scale .5} }
}
cylinder
{ <0,0,-1.5>, <0,0,5>, (1/3) texture {woodtex scale .5} }
cone
{ <0,0,-2>, 0, <0,0,-1.25>, (1/3) texture {woodtex scale .5} }
translate <0,1,0>
}

#object {HAMMER scale .2 rotate <0,20,0> translate <3,0,-4>}

//-----------------------------------------------------------------------------------------------------------------------------
// EOF
//-----------------------------------------------------------------------------------------------------------------------------
