
// POV file by Andrew Cherry

#declare c=clock

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,1)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n\n"

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera
{
  location  <5.0 , 0.0 , -15.0>
  rotate <0,100,0>
  look_at   <0.0 , 0.0 , 0.0>
}

light_source { <10,10,10> color .8 }
light_source { <-10,10,10> color .8 }
light_source { <10,10,-10> color .8 }
light_source { <-10,10,-10> color .8 }
light_source { <10,-10,10> color .8 }
light_source { <-10,-10,10> color .8 }
light_source { <10,-10,-10> color .8 }
light_source { <-10,-10,-10> color .8 }

light_source { <5.0 , 0.0 , -15.0> color .9 rotate <0,100,0>}

#declare FLYINGMACHINE = union {

#declare string = texture {pigment {color ((Tan+White+White)/3)} finish {phong 1 ambient .2 metallic}}
#declare canvas = texture {pigment {color ((Tan+White)/2)} finish {phong .25}}
#declare woodtex = texture {
                    pigment {
                     wood
                     color_map {M_Wood1A}
                     scale .25
                     turbulence .1
                     rotate <89,0,1>
                    }
                    finish {}
                   }

#declare HELI1=union {

lathe { linear_spline 4,
    < 0, -1>
    <.5, -1>
    <.5, 1.25>
    < 0, 1.5>
    texture {woodtex} }

#declare WING=union {
#declare s=.1
#declare hI=0
#while (hI<1.5*2*pi)
#declare h2=hI/(3*pi)
polygon {4, <sin(hI)/2, cos(hI)/2>, <sin(hI)*3*(1+h2), cos(hI)*3*(1+h2)>, <sin(hI+s)*3*(1+h2), cos(hI+s)*3*(1+h2)>, <sin(hI+s)/2, cos(hI+s)/2> texture {canvas} rotate <90,0,0> translate <0,1-h2,0>}
#declare hI=hI+1/20
#end
}

#object {WING}

}

#object {HELI1 scale <1,3,1>}

#declare r=0
#while (r<360)
cylinder { <0,0,0>,<1,0,0>, .01 scale <1,.5,1> texture {woodtex} rotate <0,r,0>}
#declare r=r+22.5
#end

torus {1, 0.1 scale <1,.5,1> texture {woodtex}}

#declare r=0
#while (r<360)
cylinder { <0,0,0>,<30,0,0>, .5 scale .1 translate <0,-3,0> texture {woodtex} rotate <0,r,0>}
#declare r=r+45
#end
torus {3, 0.25 scale <1,.1,1> translate <0,-3,0> texture {woodtex}}

#declare r=0
#while (r<360)
cylinder { <.5,0,0>,<3,-3,0>, .1 texture {woodtex} rotate <0,r,0>}
#declare r=r+90
#end
torus {.5, 0.25 translate <0,-.25,0> texture {woodtex}}

cylinder { <1.75,-1.5,0>,<-1.75,-1.5,0>, .1 texture {woodtex}}
cylinder { <0,-1.5,1.75>,<0,-1.5,-1.75>, .1 texture {woodtex}}
torus {.5, 0.1 translate <0,-1.5,0> texture {woodtex}}


#declare s=.1
#declare hI=0
#while (hI<1.5*2*pi)
#declare h2=hI/(3*pi)
cylinder { <(sin(hI)*3*(1+h2))*.95, (1-h2)*3, (cos(hI)*3*(1+h2))*.95>, <sin(hI)*3,-3,cos(hI)*3>, .01 texture {string} }
#declare hI=hI+1
#end

cylinder { <(sin(0)*3), 3, (cos(0)*3)>, <0,3,0>, .025 texture {woodtex} }
cylinder { <(-sin(0)*6), 0, (-cos(0)*6)>, <0,0,0>, .025 texture {woodtex} }

}
