

#include "colors.inc"
#include "shapes.inc"
#include "finish.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"



camera {

   location <60.0000001, 750, -750.00>
   look_at <30.0000001, 590, 0.0001>
/*
   location <4800.0000001, 705, 1500.00>
   look_at <28.0000001, 705, 1500.0001>
*/
}

 background {color (White)}

// ------------------------------------------------
// light source
// ------------------------------------------------
 light_source{ <-4000, 4000, -4000> color White(.1)}

// level of river is 12
// bridge is .4 of a mile (2112 ft.)
// bridge deck is 700 ft from river

height_field {   // canyon
	tga "fdivide3.tga"
  	//smooth
  	texture {T_Grnt4}
	water_level .001
	finish {ambient .25}
  	scale <2500, 1100, 2500>
  	translate <-1250,10,-1250>
  }
  
  height_field {   // background terrain
	gif "landscp1.gif"
  	//smooth
  	texture {T_Grnt4}
	water_level .001
	finish {ambient .25}
  	scale <5000, 500, 2500>
  	translate <-2500,550,1500>
  }


  height_field {   // trees
	tga "f_trees.tga"
  	//smooth
	pigment {color (ForestGreen)}
	water_level .001
	finish {ambient .25}
  	scale <2500, 1100, 2500>
  	translate <-1250,9.9,-1250>
  }


box{<-1250,11,-1250>,<1250,12,1250>
	pigment{color (Blue)}
}

#declare road_bed = box{<-7,-3,-1056>,<7,0,1056>}

#declare center_divider = union{
	box{<-10,-3,-1000>,<-8.5,3,1000>}
	box{<8.5,-3,-1000>,<10,3,1000>}
	box{<-10,-3,-1000>,<10,3,-998.5>}
	box{<-10,-3,998.5>,<10,3,1000>}
	box{<-10,-3,1000>,<10,3,1056>}
	box{<-10,-3,-1056>,<10,3,-1000>}

}
#declare upright = -1056
#declare walkway = union{
 	box{<-1.5,-1,-1056>,<1.5,0,1056>}
	box{<-2.5,-1,-1056>,<-1.5,2.5,1056>}
	cylinder{<-2,3,-1056>,<-2,3,1056>,.083
		pigment{color(Green)}
	} // inside railing
	#while (upright <= 1056)
		cylinder{<-2,2.5,upright>,<-2,3,upright>,.08
			pigment{ color(Green)}
		}
		#declare upright = upright + 2
	#end
	
	#declare upright = -1056
	
	box{<1.25,2.8,-1056>,<1.5,3,1056> // outside railing
		pigment {color(Green)}
	}
	#while (upright <= 1056)
		box{<1.25,-1,upright>,<1.5,3,upright+.083>
			pigment{color(Green)}
		}
		#declare upright = upright + .75
	#end
}

#declare i_beam = union{
	box{<-12.5,-1,-.0415>,<12.5,1,.0415>}
	box{<-12.5,1,-.166>,<12.5,1.083,.166>}
	box{<-12.5,-1.083,-.166>,<12.5,-1,.166>}
}

#declare strut_set = union{
	object {i_beam
		translate <0,0,4>
	}
	object {i_beam
		translate <0,0,-4>
	}
	object {i_beam
		rotate y * 45
	}
	object {i_beam
		rotate y * -45
	}
}
#declare span1 = difference{
	torus {352,1.5
		scale<1,.75,.2>
	}
	box{<-352,-4,-100>,<352,4,0>}
}

#declare lower_struts = union{
	object{i_beam
		scale<.85,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,686,0>
	}
	object{i_beam
		scale<1.25,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,686,-11>
	}
	object{i_beam
		scale<1.25,1,1>
		rotate y * 90
		rotate x * -45
		translate <0,686,-30>
	}
		object{i_beam
		scale<.85,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,686,-41>
	}// ------------- 1st
		object{i_beam
		scale<1.25,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,686,-52>
	}
	object{i_beam
		scale<1.3,1,1>
		rotate y * 90
		rotate x * -45
		translate <0,685,-71>
	}
		object{i_beam
		scale<.9,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,686,-82>
	}// ------------- 2nd
	object{i_beam
		scale<1.25,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,686,-93>
	}
	object{i_beam
		scale<1.5,1,1>
		rotate y * 90
		rotate x * -45
		translate <0,684,-116>
	}
		object{i_beam
		scale<.9,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,682,-130>
	}// ------------- 3rd
		object{i_beam
		scale<1.25,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,682,-142>
	}
	object{i_beam
		scale<1.6,1,1>
		rotate y * 90
		rotate x * -45
		translate <0,679,-166>
	}
		object{i_beam
		scale<.9,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,677.5,-180>
	}  // ------------- 4th
		object{i_beam
		scale<1.3,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,677,-192>
	}
	object{i_beam
		scale<1.7,1,1>
		rotate y * 90
		rotate x * -45
		translate <0,673,-218>
	}
		object{i_beam
		scale<1.2,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,673,-233>
	}  // ------------- 5th
		object{i_beam
		scale<1.75,1,1>
		rotate y * 90
		rotate x * 45
		translate <0,673.5,-249.5>
	}
	object{i_beam
		scale<2.35,1,1>
		rotate y * 90
		rotate x * -52
		translate <0,667,-278>
	}
		object{i_beam
		scale<1.9,1,1>
		rotate y * 90
		rotate x * 90
		translate <0,667,-296>
	} // ------------- 6th
		object{i_beam
		scale<2.4,1,1>
		rotate y * 90
		rotate x * 50
		translate <0,667,-316>
	}
	object{i_beam
		scale<3.2,1,1>
		rotate y * 90
		rotate x * -80
		translate <0,652,-342>
	} // ------------- 7th
}
#declare girders = union{
	object {span1
		rotate x * -90
		rotate y * 90
		pigment{color (Green)}
		translate <0,605,0>
	}
	object {lower_struts
		pigment{color(Green)}
		translate<0,0,0>
	}
	object {span1
		rotate x * -90
		rotate y * 90
		pigment {color (Green)}
		translate <0,605,-704>
	}
	object {lower_struts
		pigment{color(Green)}
		rotate y * 180
		translate<0,0,-704>
	}
	object {span1
		rotate x * -90
		rotate y * 90
		pigment {color (Green)}
		translate <0,605,704>
	}
	object {lower_struts
		pigment{color(Green)}
		rotate y * 180
	}
	object {lower_struts
		pigment{color(Green)}
		translate<0,0,704>
	}
	object {lower_struts
		pigment{color(Green)}
		translate<0,0,-704>
	}
	object {lower_struts
		pigment{color(Green)}
		rotate y * 180
		translate<0,0,704>
	}
}

#declare column = difference{
	box{<-25,0,-7.5>,<25,700,7.5>}
	cylinder{<0,0,-10>,<0,0,10>,5
		scale <1.75,60,1>
		translate <-25,350,0>
	}
	cylinder{<0,0,-10>,<0,0,10>,5
		scale <1.75,60,1>
		translate <25,350,0>
	}
}

#declare bridge = union{
	object {road_bed
		texture{T_Grnt1}
		finish {ambient .65}
		translate <17,700,0>
	}
	object {road_bed
		texture{T_Grnt1}
		finish {ambient .75}
		translate <-17,700,0>
	}
	object {center_divider
		texture{T_Grnt1}
		finish {ambient .75}
		translate<0,700,0>
	}
	object {walkway
		texture{T_Grnt1}
		finish {ambient .75}
		translate<26.5,700,0>
	}
	object {walkway
		texture{T_Grnt1}
		finish {ambient .75}
		rotate y * 180
		translate<-26.5,700,0>
	}
	polygon{
		5,
		<10,-1056>,<10,1056>,<10.5,1056>,
		<10.5,-1056><10,-1056>
		pigment{color (Yellow)}
		finish {ambient .75}
		rotate x * 90
		translate<1.25,701,0>
	}
		polygon{
		5,
		<-10.5,-1056>,<-10.5,1056>,<-10,1056>,
		<-10,-1056><-10.5,-1056>
		pigment{color (Yellow)}
		finish {ambient .75}
		rotate x * 90
		translate<-1.25,701,0>
	}
	#declare strut_place = -1000

	#while (strut_place <=1000)
		object{strut_set
			pigment{color(Green)}
			translate <0,696,strut_place>
		}
		#declare strut_place = strut_place + 8
	#end
	
	object {girders
		translate <19,2,0>
	}
	object {girders
		translate <-19,2,0>
	}
	object {column
		texture{T_Grnt1}
		finish{ambient .5}
		scale<.9,.99,1>
		translate <0,0,352>
	}
	object {column
		texture{T_Grnt1}
		finish{ambient .5}
		scale<.9,.99,1>
		translate <0,0,-352>
	}
}



object {bridge
	translate <0,3,50>}


 sky_sphere {
   pigment {
     gradient y
     color_map {
       [ 0.5  color Blue ]
       [ 1.0  color Blue ]

     }
      scale 2
      translate -1
    }

     pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x

  }










