// Persistence Of Vision Raytracer version 3.0 file.

#declare silver = texture {pigment {Gray90}
   finish {
          ambient 0.1
          brilliance 6
          diffuse 0.7
          metallic
          specular 1
          roughness .01
          reflection 0.8
   }
}

#declare foil = texture {pigment {Gray90}
   normal {wrinkles .5 scale .2}
   finish {
          ambient 0.1
          brilliance 6
          diffuse 0.7
          metallic
          specular 1
          roughness .01
          reflection 0.8
   }
}

#declare gold = texture {pigment {color red 1 green .588 blue .195}
         finish {
    ambient 0.30
    diffuse 0.8
    metallic
    specular 0.70
    roughness .02
	}
}

#declare black_paint = texture {pigment {Black}
   finish {specular .8
          roughness .2
          ambient .3
   }
}

#declare gray_paint = texture {pigment {Gray75}
   finish {specular .3
          roughness .07
          ambient 0
          diffuse .4
   }
}

#declare dark_brown = texture {pigment {color rgb <.781, .352, 0>}
         finish {diffuse .25 ambient .5 specular .5 roughness .1}
}

#declare light_brown = texture {pigment {color rgb <1, .586, .195>}
         finish {diffuse .25 ambient .75 specular .5 roughness .1}
}

#declare safe = texture {pigment {color rgb <1, .488, .293>}
         finish {specular .5 roughness .02 ambient 0}
}

#declare rivet = sphere {<0, 0, 0>, .02 scale .5*z}

#declare rivet2 = sphere {<0, 0, 0>, .02 scale .5*y}

#declare plate_rivets = union {
         object {rivet2 translate <-.2, 2.0948, 0>}
         object {rivet2 translate <-.3, 2.0948, 0>}
         object {rivet2 translate <-.4, 2.0948, 0>}
         object {rivet2 translate <-.5, 2.0948, 0>}
         object {rivet2 translate <-.6, 2.0948, 0>}
         object {rivet2 translate <-.7, 2.0948, 0>}
         object {rivet2 translate <-.8, 2.0948, 0>}
         object {rivet2 translate <-.9, 2.0948, 0>}
         object {rivet2 translate <-1, 2.0948, 0>}
         object {rivet2 translate <-1.1, 2.0948, 0>}
         object {rivet2 translate <-1.2, 2.0948, 0>}
         object {rivet2 translate <-1.3, 2.0948, 0>}
         object {rivet2 translate <-1.4, 2.0948, 0>}
         object {rivet2 translate <-1.5, 2.0948, 0>}
         object {rivet2 translate <-1.6, 2.0948, 0>}
         object {rivet2 translate <-1.7, 2.0948, 0>}
         object {rivet2 translate <-1.8, 2.0948, 0>}
}

#declare plate_rivets2 = union {
         object {rivet2 translate <-.2, 2.0948, 0>}
         object {rivet2 translate <-.2, 2.0948, .1>}
         object {rivet2 translate <-.2, 2.0948, .2>}
         object {rivet2 translate <-.2, 2.0948, .3>}
         object {rivet2 translate <-.2, 2.0948, .4>}
         object {rivet2 translate <-.2, 2.0948, -.1>}
         object {rivet2 translate <-.2, 2.0948, -.2>}
         object {rivet2 translate <-.2, 2.0948, -.3>}
         object {rivet2 translate <-.2, 2.0948, -.4>}
}

#declare section = intersection {
         box {<-6.04, -.1, -3>, <-2, .1, 3>}
         cylinder {<-6.3, 0, 0>, <-1.5, 0, 0>, 2.15}
}

#declare section2 = intersection {
         box {<0, -.05, -3>, <1, .05, 3>}
         cylinder {<.1, 0, 0>, <.9, 0, 0>, 2.05}
}

#declare section3 = intersection {
         box {<1, -.05, -3>, <7, .05, 3>}
         cylinder {<0, 0, 0>, <8, 0, 0>, 1.5}
}

#declare plate = union {
         difference {
                    box {<-1.9, 2, -.5644>, <-.1, 2.0948, .5644>}
                    union {
                          box {<-1.0288, 1, -.3644>, <-.6744, 3, -.01>}
                          box {<-1.0288, 1, .01>, <-.6744, 3, .3644>}
                          box {<-.6544, 1, -.3644>, <-.3, 3, -.01>}
                          box {<-.6544, 1, .01>, <-.3, 3, .3644>}
                    }
         }
         object {plate_rivets translate .4644*z}
         object {plate_rivets translate -.4644*z}
         object {plate_rivets2}
         object {plate_rivets2 translate -.9288*x}
         object {plate_rivets2 translate -1.6*x}
}

#declare plate2 = union {
         box {<-1.9, 2, -.5644>, <-.1, 2.0948, .5644>}
         object {plate_rivets}
         object {plate_rivets translate .4644*z}
         object {plate_rivets translate -.4644*z}
         object {plate_rivets2}
         object {plate_rivets2 translate -.8*x}
         object {plate_rivets2 translate -1.6*x}
}

#declare plate3 = box {<-1.8, 2, -.4644>, <-.1, 2.05, .4644>}

#declare rivets = union {
         object {rivet translate <-5.9, 0, 2.15>}
         object {rivet translate <-5.9, 0, -2.15>}
         object {rivet translate <-5.8, 0, 2.15>}
         object {rivet translate <-5.8, 0, -2.15>}
         object {rivet translate <-5.7, 0, 2.15>}
         object {rivet translate <-5.7, 0, -2.15>}
         object {rivet translate <-5.6, 0, 2.15>}
         object {rivet translate <-5.6, 0, -2.15>}
         object {rivet translate <-5.5, 0, 2.15>}
         object {rivet translate <-5.5, 0, -2.15>}
         object {rivet translate <-5.4, 0, 2.15>}
         object {rivet translate <-5.4, 0, -2.15>}
         object {rivet translate <-5.3, 0, 2.15>}
         object {rivet translate <-5.3, 0, -2.15>}
         object {rivet translate <-5.2, 0, 2.15>}
         object {rivet translate <-5.2, 0, -2.15>}
         object {rivet translate <-5.1, 0, 2.15>}
         object {rivet translate <-5.1, 0, -2.15>}
         object {rivet translate <-5.0, 0, 2.15>}
         object {rivet translate <-5.0, 0, -2.15>}
         object {rivet translate <-4.9, 0, 2.15>}
         object {rivet translate <-4.9, 0, -2.15>}
         object {rivet translate <-4.8, 0, 2.15>}
         object {rivet translate <-4.8, 0, -2.15>}
         object {rivet translate <-4.7, 0, 2.15>}
         object {rivet translate <-4.7, 0, -2.15>}
         object {rivet translate <-4.6, 0, 2.15>}
         object {rivet translate <-4.6, 0, -2.15>}
         object {rivet translate <-4.5, 0, 2.15>}
         object {rivet translate <-4.5, 0, -2.15>}
         object {rivet translate <-4.4, 0, 2.15>}
         object {rivet translate <-4.4, 0, -2.15>}
         object {rivet translate <-4.3, 0, 2.15>}
         object {rivet translate <-4.3, 0, -2.15>}
         object {rivet translate <-4.2, 0, 2.15>}
         object {rivet translate <-4.2, 0, -2.15>}
         object {rivet translate <-4.1, 0, 2.15>}
         object {rivet translate <-4.1, 0, -2.15>}
         object {rivet translate <-4.0, 0, 2.15>}
         object {rivet translate <-4.0, 0, -2.15>}
         object {rivet translate <-3.9, 0, 2.15>}
         object {rivet translate <-3.9, 0, -2.15>}
         object {rivet translate <-3.8, 0, 2.15>}
         object {rivet translate <-3.8, 0, -2.15>}
         object {rivet translate <-3.7, 0, 2.15>}
         object {rivet translate <-3.7, 0, -2.15>}
         object {rivet translate <-3.6, 0, 2.15>}
         object {rivet translate <-3.6, 0, -2.15>}
         object {rivet translate <-3.5, 0, 2.15>}
         object {rivet translate <-3.5, 0, -2.15>}
         object {rivet translate <-3.4, 0, 2.15>}
         object {rivet translate <-3.4, 0, -2.15>}
         object {rivet translate <-3.3, 0, 2.15>}
         object {rivet translate <-3.3, 0, -2.15>}
         object {rivet translate <-3.2, 0, 2.15>}
         object {rivet translate <-3.2, 0, -2.15>}
         object {rivet translate <-3.1, 0, 2.15>}
         object {rivet translate <-3.1, 0, -2.15>}
         object {rivet translate <-3.0, 0, 2.15>}
         object {rivet translate <-3.0, 0, -2.15>}
         object {rivet translate <-2.9, 0, 2.15>}
         object {rivet translate <-2.9, 0, -2.15>}
         object {rivet translate <-2.8, 0, 2.15>}
         object {rivet translate <-2.8, 0, -2.15>}
         object {rivet translate <-2.7, 0, 2.15>}
         object {rivet translate <-2.7, 0, -2.15>}
         object {rivet translate <-2.6, 0, 2.15>}
         object {rivet translate <-2.6, 0, -2.15>}
         object {rivet translate <-2.5, 0, 2.15>}
         object {rivet translate <-2.5, 0, -2.15>}
         object {rivet translate <-2.4, 0, 2.15>}
         object {rivet translate <-2.4, 0, -2.15>}
         object {rivet translate <-2.3, 0, 2.15>}
         object {rivet translate <-2.3, 0, -2.15>}
         object {rivet translate <-2.2, 0, 2.15>}
         object {rivet translate <-2.2, 0, -2.15>}
         object {rivet translate <-2.1, 0, 2.15>}
         object {rivet translate <-2.1, 0, -2.15>}
}

#declare rivets2 = union {
         object {rivet translate 2.15*z rotate 4.5*x}
         object {rivet translate 2.15*z rotate 7.5*x}
         object {rivet translate 2.15*z rotate 10.5*x}
         object {rivet translate 2.15*z rotate 13.5*x}
         object {rivet translate 2.15*z rotate 16.5*x}
         object {rivet translate 2.15*z rotate 19.5*x}
         object {rivet translate 2.15*z rotate 22.5*x}
         object {rivet translate 2.15*z rotate 25.5*x}
         object {rivet translate 2.15*z rotate 28.5*x}
         object {rivet translate 2.15*z rotate 31.5*x}
         object {rivet translate 2.15*z rotate 40.5*x}
         object {rivet translate 2.15*z rotate 43.5*x}
         object {rivet translate 2.15*z rotate 46.5*x}
         object {rivet translate 2.15*z rotate 49.5*x}
         object {rivet translate 2.15*z rotate 52.5*x}
         object {rivet translate 2.15*z rotate 55.5*x}
         object {rivet translate 2.15*z rotate 58.5*x}
         object {rivet translate 2.15*z rotate 61.5*x}
         object {rivet translate 2.15*z rotate 64.5*x}
         object {rivet translate 2.15*z rotate 67.5*x}
         object {rivet translate 2.15*z rotate 76.5*x}
         object {rivet translate 2.15*z rotate 79.5*x}
         object {rivet translate 2.15*z rotate 82.5*x}
         object {rivet translate 2.15*z rotate 85.5*x}
         object {rivet translate 2.15*z rotate 88.5*x}
         object {rivet translate 2.15*z rotate 91.5*x}
         object {rivet translate 2.15*z rotate 94.5*x}
         object {rivet translate 2.15*z rotate 97.5*x}
         object {rivet translate 2.15*z rotate 100.5*x}
         object {rivet translate 2.15*z rotate 103.5*x}
         object {rivet translate 2.15*z rotate 112.5*x}
         object {rivet translate 2.15*z rotate 115.5*x}
         object {rivet translate 2.15*z rotate 118.5*x}
         object {rivet translate 2.15*z rotate 121.5*x}
         object {rivet translate 2.15*z rotate 124.5*x}
         object {rivet translate 2.15*z rotate 127.5*x}
         object {rivet translate 2.15*z rotate 130.5*x}
         object {rivet translate 2.15*z rotate 133.5*x}
         object {rivet translate 2.15*z rotate 136.5*x}
         object {rivet translate 2.15*z rotate 139.5*x}
         object {rivet translate 2.15*z rotate 148.5*x}
         object {rivet translate 2.15*z rotate 151.5*x}
         object {rivet translate 2.15*z rotate 154.5*x}
         object {rivet translate 2.15*z rotate 157.5*x}
         object {rivet translate 2.15*z rotate 160.5*x}
         object {rivet translate 2.15*z rotate 163.5*x}
         object {rivet translate 2.15*z rotate 166.5*x}
         object {rivet translate 2.15*z rotate 169.5*x}
         object {rivet translate 2.15*z rotate 172.5*x}
         object {rivet translate 2.15*z rotate 175.5*x}
         object {rivet translate -2.15*z rotate 4.5*x}
         object {rivet translate -2.15*z rotate 7.5*x}
         object {rivet translate -2.15*z rotate 10.5*x}
         object {rivet translate -2.15*z rotate 13.5*x}
         object {rivet translate -2.15*z rotate 16.5*x}
         object {rivet translate -2.15*z rotate 19.5*x}
         object {rivet translate -2.15*z rotate 22.5*x}
         object {rivet translate -2.15*z rotate 25.5*x}
         object {rivet translate -2.15*z rotate 28.5*x}
         object {rivet translate -2.15*z rotate 31.5*x}
         object {rivet translate -2.15*z rotate 40.5*x}
         object {rivet translate -2.15*z rotate 43.5*x}
         object {rivet translate -2.15*z rotate 46.5*x}
         object {rivet translate -2.15*z rotate 49.5*x}
         object {rivet translate -2.15*z rotate 52.5*x}
         object {rivet translate -2.15*z rotate 55.5*x}
         object {rivet translate -2.15*z rotate 58.5*x}
         object {rivet translate -2.15*z rotate 61.5*x}
         object {rivet translate -2.15*z rotate 64.5*x}
         object {rivet translate -2.15*z rotate 67.5*x}
         object {rivet translate -2.15*z rotate 76.5*x}
         object {rivet translate -2.15*z rotate 79.5*x}
         object {rivet translate -2.15*z rotate 82.5*x}
         object {rivet translate -2.15*z rotate 85.5*x}
         object {rivet translate -2.15*z rotate 88.5*x}
         object {rivet translate -2.15*z rotate 91.5*x}
         object {rivet translate -2.15*z rotate 94.5*x}
         object {rivet translate -2.15*z rotate 97.5*x}
         object {rivet translate -2.15*z rotate 100.5*x}
         object {rivet translate -2.15*z rotate 103.5*x}
         object {rivet translate -2.15*z rotate 112.5*x}
         object {rivet translate -2.15*z rotate 115.5*x}
         object {rivet translate -2.15*z rotate 118.5*x}
         object {rivet translate -2.15*z rotate 121.5*x}
         object {rivet translate -2.15*z rotate 124.5*x}
         object {rivet translate -2.15*z rotate 127.5*x}
         object {rivet translate -2.15*z rotate 130.5*x}
         object {rivet translate -2.15*z rotate 133.5*x}
         object {rivet translate -2.15*z rotate 136.5*x}
         object {rivet translate -2.15*z rotate 139.5*x}
         object {rivet translate -2.15*z rotate 148.5*x}
         object {rivet translate -2.15*z rotate 151.5*x}
         object {rivet translate -2.15*z rotate 154.5*x}
         object {rivet translate -2.15*z rotate 157.5*x}
         object {rivet translate -2.15*z rotate 160.5*x}
         object {rivet translate -2.15*z rotate 163.5*x}
         object {rivet translate -2.15*z rotate 166.5*x}
         object {rivet translate -2.15*z rotate 169.5*x}
         object {rivet translate -2.15*z rotate 172.5*x}
         object {rivet translate -2.15*z rotate 175.5*x}
}

#declare ant = union {
         union {
               cone {<0, 0, 2.0>, .1, <0, 0, 2.2>, .03}
               cylinder {<0, 0, 2.2>, <0, 0, 5>, .03}
               cylinder {<-.1, 0, 5>, <.05, 0, 5>, .1}
               texture {gray_paint}
         }
         union {
               difference {
                          intersection {
                                       sphere {<-.55, 0, 5>, .5}
                                       plane {x, .3 rotate 180*y}
                          }
                          sphere {<-.55, 0, 5>, .49}
               }
               cylinder {<-.05, 0, 5>, <-.55, 0, 5>, .02}
               intersection {
                            sphere {<-.55, 0, 5>, .05}
                            plane {x, -.55}
               }
               texture {black_paint}
         }
         rotate 180*z
}

#declare thing = union {
         cylinder {<0, 0, 0>, <0, 0, 1>, .05}
         cylinder {<0, 0, 1>, <0, 0, 1.1>, .25}
         sphere {<.05, 0, 0>, .05 scale 2*x translate 1.1*z}
         sphere {<.05, 0, 0>, .05 scale 2*x rotate 120*z translate 1.1*z}
         sphere {<.05, 0, 0>, .05 scale 2*x rotate -120*z translate 1.1*z}
}

#declare thing2 = union {
         cylinder {<-.4, 2, 0>, <.4, 2, 0>, .05}
         cylinder {<-.4, 2, 0>, <.5, 1.414, .5>, .02}
         cylinder {<.4, 2, 0>, <.5, 1.414, .5>, .02}
         cylinder {<-.4, 2, 0>, <-.5, 1.414, .5>, .02}
         cylinder {<.4, 2, 0>, <-.5, 1.414, .5>, .02}
         cylinder {<-.4, 2, 0>, <.5, 1.414, -.5>, .02}
         cylinder {<.4, 2, 0>, <.5, 1.414, -.5>, .02}
         cylinder {<-.4, 2, 0>, <-.5, 1.414, -.5>, .02}
         cylinder {<.4, 2, 0>, <-.5, 1.414, -.5>, .02}
         texture {silver}
 }

#declare thing3 = union {
         sphere {<0, 1.5, 0>, .2}
         torus {.3, .03 rotate 90*x translate 1.5*y}
         torus {.3, .03 rotate 90*z translate 1.5*y}
         texture {silver}
 }

#declare rail1 = union {
         torus {2.2, .02 rotate 90*z}
         cylinder {<0, -2.2, 0>, <0, 2.2, 0>, .02}
         cylinder {<0, -2.2, 0>, <0, 2.2, 0>, .02 rotate 36*x}
         cylinder {<0, -2.2, 0>, <0, 2.2, 0>, .02 rotate 72*x}
         cylinder {<0, -2.2, 0>, <0, 2.2, 0>, .02 rotate 108*x}
         cylinder {<0, -2.2, 0>, <0, 2.2, 0>, .02 rotate 144*x}
         texture {safe}
}

#declare rail2 = union {
         cylinder {<-.5, .05, 0>, <.5, .05, 0>, .02}
         intersection {
                      torus {.05, .02}
                      box {<0, -1, 0>, <1, 1, 1>}
                      rotate -90*x translate .5*x
         }
         intersection {
                      torus {.05, .02}
                      box {<0, -1, 0>, <1, 1, 1>}
                      rotate <-90, 180, 0> translate -.5*x
         }
         cylinder {<0, 0, 0>, <0, .05, 0>, .02}
         texture {safe}
}

#declare solar = union {
        union {
                cylinder {<0, 0, 0>, <0, 2.25, 0>, .2}
                cylinder {<0, 2.25, 0>, <0, 3.65, 0>, .1}
                cylinder {<0, 6.05, 0>, <0, 6.15, 0>, .2}
                cylinder {<0, 3.65, 0>, <0, 3.75, 0>, .2}
                cylinder {<-6, 3.7, 0>, <6, 3.7, 0>, .05}
                cylinder {<-6, 6.1, 0>, <6, 6.1, 0>, .05}
                cylinder {<-6.2, 3.9, 0>, <-6.2, 5.9, 0>, .05}
                cylinder {<6.2, 3.9, 0>, <6.2, 5.9, 0>, .05}
                intersection {
                        torus {.2, .05}
                        box {<0, -1, 0>, <1, 1, 1>}
                        rotate 90*x
                        translate <6, 3.9, 0>
                }
                intersection {
                        torus {.2, .05}
                        box {<0, -1, 0>, <1, 1, 1>}
                        rotate -90*x
                        translate <6, 5.9, 0>
                }
                intersection {
                        torus {.2, .05}
                        box {<0, -1, 0>, <1, 1, 1>}
                        rotate <90, 180, 0>
                        translate <-6, 3.9, 0>
                }
                intersection {
                        torus {.2, .05}
                        box {<0, -1, 0>, <1, 1, 1>}
                        rotate <-90, 180, 0>
                        translate <-6, 5.9, 0>
                }
        texture {silver}
        }
        union {
                cylinder {<0, 3.75, 0>, <0, 6.05, 0>, .07}
                box {<-6, 3.9, -.001>, <6, 5.9, .001>}
        texture {dark_brown}
        }
        union {
                box {<-6, 4.29, -.002>, <6, 4.31, .002>}
                box {<-6, 4.69, -.002>, <6, 4.71, .002>}
                box {<-6, 5.09, -.002>, <6, 5.11, .002>}
                box {<-6, 5.49, -.002>, <6, 5.51, .002>}
                box {<-4.81, 3.9, -.002>, <-4.79, 5.9, .002>}
                box {<-3.61, 3.9, -.002>, <-3.59, 5.9, .002>}
                box {<-2.41, 3.9, -.002>, <-2.39, 5.9, .002>}
                box {<-1.21, 3.9, -.002>, <-1.19, 5.9, .002>}
                box {<4.79, 3.9, -.002>, <4.81, 5.9, .002>}
                box {<3.59, 3.9, -.002>, <3.61, 5.9, .002>}
                box {<2.39, 3.9, -.002>, <2.41, 5.9, .002>}
                box {<1.19, 3.9, -.002>, <1.21, 5.9, .002>}
        texture {light_brown}
        }
        union {
                box {<-6, 3.9, -.01>, <-5.9, 5.9, .01>}
                box {<5.9, 3.9,-.01>, <6, 5.9, .01>}
                box {<-6.2, 4.15, -.01>, <-6, 4.4, .01>}
                box {<-6.2, 5.4, -.01>, <-6, 5.65, .01>}
                box {<6, 4.15, -.01>, <6.2, 4.4, .01>}
                box {<6, 5.4, -.01>, <6.2, 5.65, .01>}
        texture {gold}
        }
}

#declare hst = union {
         union {
               cylinder {<-6, 0, 0>, <-2, 0, 0>, 2.15}
               object {rivets rotate 1.5*x}
               object {rivets rotate 34.5*x}
               object {rivets rotate 37.5*x}
               object {rivets rotate 70.5*x}
               object {rivets rotate 73.5*x}
               object {rivets rotate 106.5*x}
               object {rivets rotate 109.5*x}
               object {rivets rotate 142.5*x}
               object {rivets rotate 145.5*x}
               object {rivets rotate 178.5*x}
               object {section}
               object {section rotate 36*x}
               object {section rotate 72*x}
               object {section rotate 108*x}
               object {section rotate 144*x}
               cylinder {<-6.1, 0, 1.5>, <-6, 0, 1.5>, .2 rotate 18*x}
               cylinder {<-6.1, 0, 1.5>, <-6, 0, 1.5>, .2 rotate -18*x}
               cylinder {<-6.1, 0, -1.5>, <-6, 0, -1.5>, .2 rotate 18*x}
               cylinder {<-6.1, 0, -1.5>, <-6, 0, -1.5>, .2 rotate -18*x}
               object {rivets2 translate -2.5*x}
               object {rivets2 translate -3*x}
               object {rivets2 translate -3.5*x}
               object {rivets2 translate -4*x}
               object {rivets2 translate -4.5*x}
               object {rivets2 translate -5*x}
               object {rivets2 translate -5.5*x}
               texture {silver}
         }
         difference {
                    intersection {
                            cylinder {<-2.9, 0, 0>, <-2.1, 0, 0>, 2.2}
                            plane {y, 0 rotate -33*x}
                            plane {-y, 0 rotate 33*x}
                    }
                    union {
                          cylinder {<-2.625, 0, 2>, <-2.625, 0, 3>, .125 rotate 20*x}
                          cylinder {<-2.375, 0, 2>, <-2.625, 0, 3>, .125 rotate -20*x}
                          intersection {
                                       cylinder {<-2.75, 0, 0>, <-2.25, 0, 0>, 2.3}
                                       plane {y, 0 rotate -10*x}
                                       plane {-y, 0 rotate 10*x}
                          }
                    }
                    texture {gray_paint}
         }
         intersection {
                 cylinder {<-2.75, 0, 0>, <-2.25, 0, 0>, 2.17}
                 plane {y, 0 rotate -30*x}
                 plane {-y, 0 rotate 30*x}
                 texture {gray_paint}
         }
         union {
               intersection {
                            plane {y, 2.0448}
                            plane {y, 2.0448 rotate 36*x}
                            plane {y, 2.0448 rotate 72*x}
                            plane {y, 2.0448 rotate 108*x}
                            plane {y, 2.0448 rotate 144*x}
                            plane {y, 2.0448 rotate 180*x}
                            plane {y, 2.0448 rotate 216*x}
                            plane {y, 2.0448 rotate 252*x}
                            plane {y, 2.0448 rotate 288*x}
                            plane {y, 2.0448 rotate 324*x}
                            plane {x, 0}
                            plane {x, 2 rotate 180*y}
               }
               object {plate2}
               object {plate2 rotate 36*x}
               object {plate rotate 72*x}
               object {plate rotate 108*x}
               object {plate2 rotate 144*x}
               object {plate2 rotate 180*x}
               object {plate2 rotate 216*x}
               object {plate rotate 252*x}
               object {plate rotate 288*x}
               object {plate2 rotate 324*x}
               texture {silver}
         }
         union {
               object {plate3 rotate 72*x}
               object {plate3 rotate 108*x}
               object {plate3 rotate 252*x}
               object {plate3 rotate 288*x}
               texture {foil}
         }
         union {
               cylinder {<0, 0, 0>, <.1, 0, 0>, 2.15}
               cylinder {<.9, 0, 0>, <1, 0, 0>, 2.05}
               object {section2}
               object {section2 rotate 36*x}
               object {section2 rotate 72*x}
               object {section2 rotate 108*x}
               object {section2 rotate 144*x}
               texture {silver}
         }
         cylinder {<.1, 0, 0>, <.9, 0, 0>, 2.049 texture {foil}}
         union {
               object {ant translate .5*x}
               object {ant rotate 180*y translate .5*x}
               object {thing translate <1.25, 1.25, 0>}
               object {thing translate <1.25, -1.25, 0>}
               object {thing rotate 180*x translate <1.25, 1.25, 0>}
               object {thing rotate 180*x translate <1.25, -1.25, 0>}
               texture {gray_paint}
         }
         cylinder {<1, 0, 0>, <7, 0, 0>, 1.499 texture {foil}}
         union {
               object {section3}
               object {section3 rotate 36*x}
               object {section3 rotate 72*x}
               object {section3 rotate 108*x}
               object {section3 rotate 144*x}
               cylinder {<.875, 0, 0>, <.975, 0, 0>, 1.5}
               cylinder {<1.75, 0, 0>, <1.85, 0, 0>, 1.5}
               cylinder {<2.625, 0, 0>, <2.725, 0, 0>, 1.5}
               cylinder {<3.5, 0, 0>, <3.6, 0, 0>, 1.5}
               cylinder {<4.375, 0, 0>, <4.475, 0, 0>, 1.5}
               cylinder {<5.25, 0, 0>, <5.35, 0, 0>, 1.5}
               cylinder {<6.125, 0, 0>, <6.225, 0, 0>, 1.5}
               cylinder {<7, 0, 0>, <7.1, 0, 0>, 1.5}
               texture {silver}
         }
         union {
               cylinder {<-.05, 0, 1.5>, <.05, 0, 1.5>, 1.5}
               torus {1.5, .05 rotate 90*z translate 1.5*z}
               box {<-.05, -1.5, 0>, <.05, 1.5, 1.5>}
               cylinder {<0, -1.5, 0>, <0, -1.5, 1.5>, .05}
               cylinder {<0, 1.5, 0>, <0, 1.5, 1.5>, .05}
               cylinder {<0, -.25, 0>, <0, .25, 0>, .25}
               box {<-.1, -.5, 0>, <-.05, -.4, 1.5>}
               box {<-.1, .4, 0>, <-.05, .5, 1.5>}
               intersection {
                            union {
                                  box {<-.1, -.5, 1.5>, <-.05, -.4, 3>}
                                  box {<-.1, .4, 1.5>, <-.05, .5, 3>}
                            }
                            cylinder {<-1, 0, 1.5>, <1, 0, 1.5>, 1.5}
               }
         //rotate 59.5*y //A
	     rotate 68*y // B
         translate <7.15, 0, 1.5>
         texture {silver}
         }
         object {thing2 translate 5.8*x} // no color
         object {thing2 rotate 180*x translate 5.8*x}  // no color
         object {thing3 translate 4*x} // no color
         object {thing3 rotate 180*x translate 4*x} // no color
         object {rail1 translate -5.9*x} // no color
         object {rail1 translate -2*x} // no color
         object {rail1 scale .955 translate .95*x} // no color
         object {rail2 translate <-5.25, 2.15, 0> rotate 54*x}
         object {rail2 translate <-5.25, 2.15, 0> rotate 90*x}
         object {rail2 translate <-4, 2.15, 0> rotate 90*x}
         object {rail2 translate <-5.25, 2.15, 0> rotate 126*x}
         object {rail2 translate <-5.25, 2.15, 0> rotate -54*x}
         object {rail2 translate <-5.25, 2.15, 0> rotate -90*x}
         object {rail2 translate <-4, 2.15, 0> rotate -90*x}
         object {rail2 translate <-5.25, 2.15, 0> rotate -126*x}
         object {rail2 translate <4, 1.5, 0> rotate 54*x}
         object {rail2 translate <4, 1.5, 0> rotate 90*x}
         object {rail2 translate <2.75, 1.5, 0> rotate 90*x}
         object {rail2 translate <4, 1.5, 0> rotate 126*x}
             union {
                       object {solar}
                       object {solar rotate 180*x}
                       //rotate 30*y // A
		       rotate -45*y // B
             }
         cylinder {<0, -1, 0>, <0, 2, 0> 1 hollow texture {
                  pigment {
                          image_map {gif "nasa.gif"
                                    map_type 2
                                    interpolate 2
                                    once
                                    filter 255, 1
                          }
                  }
                  finish {ambient 0}
         }
         scale <1.501, .94277, 1.501>
         rotate <0, 90, -90>
         translate <5.2, 0, 0>
         }
}

