// File: karefine.inc
// Author: Kirk A. Austin
// Date: 2/28/98
// 
// These are most of the objects I used to create the image. Actual
// unit plots were not included
//

#declare LightCyan = color blue 1.0 green 1.0 red 0.6
#declare LanternCyan = color blue 1.0 green 0.6 red 0.6

////////////////////////////////////////
///////// Light Object /////////////////
////////////////////////////////////////
#declare Lantern = union {
         cylinder { <0,0,0>
                    <0,0.8,0>
                    0.5
                    pigment {LanternCyan}
                    finish {ambient 1.0}
                   }
         sphere { <0,0,0>
                  0.5
                  pigment {LanternCyan}
                  finish {ambient 1.0}
                }
         sphere { <0,0,0>
                  0.5
                  pigment {LanternCyan}
                  translate <0,0.8,0>
                  finish {ambient 1.0}
                }
         }

//////////////////////////////////////////////////////
////////////////// Furnace Steam /////////////////////
//////////////////////////////////////////////////////

#declare Steam = cone { 0, 0, y*5, 2
	hollow
	texture {
		pigment { Clear }
		halo {
		  linear
		  //attenuating
		  emitting
		  cylindrical_mapping
		  color_map
		  {
		    [0.0 color rgbt <0, 0, 0, 1.0>]
		    [0.5 color rgbt <1, 1, 1, 0.25>]
		    [1.0 color rgbt <1, 1, 1, 0.1>]
		  }
		  turbulence 1.7
		  samples 5
		  scale 0.65
		}
	}

}
//////////////////////////////////////////////////////
/////////////// Pipe Rack ////////////////////////////
//////////////////////////////////////////////////////

#declare PipeRack = union {
         difference {
                  box { <0,0,0>       // Main concrete support
                        <10,10,10>
                        texture{T_Grnt9}
                      }
                  box { <1,-1,-1>     // Cut holes
                        <9,9,11>
                        texture{T_Grnt9}
                      }
                  box { <-1,-1,1>
                        <11,9,9>
                        texture{T_Grnt9}
                      }
          }
          box { <0,10,0>              // Top Rim-type edges
                <0.5,10.5,10>
                texture{T_Grnt9}
              }
          box { <9.5,10,0>
                <10,10.5,10>
                texture{T_Grnt9}
              }
          // Time for pipes
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5   // Radius
                     pigment {Tan}
                     translate <1,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Blue}
                     translate <2,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.3
                     pigment {Red}
                     translate <3,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.4
                     pigment {Blue}
                     translate <4,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Tan}
                     translate <5,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Green}
                     translate <6,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Orange}
                     translate <7,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Yellow}
                     translate <8,10.5,0>
                   }
          cylinder { <0,0,0>
                     <0,0,10>
                     0.5
                     pigment {Tan}
                     translate <9,10.5,0>
                   }
}





////////////////////////////////////////////////////////
//////////// Heat Exchanger ////////////////////////////
////////////////////////////////////////////////////////


#declare HX = union {
         cylinder { <0,0,0>
                    <0,10,0>
                    2.5
                    pigment {Silver}
                  }
         sphere { <0,0,0> 2.5
                  translate <0,10,0>
                  pigment {Silver}
                }
         cylinder { <0,0,0>
                    <0,0.3,0>
                    2.8
                    translate<0,10,0>
                    pigment{Silver}
                  }
         cylinder { <0,0,0>
                    <0,3,0>
                    1.7
                    rotate<-90,0,0>
                    translate<0,3,3>
                    pigment{Silver}
                  }
}

// End of Heat Exchanger

///////////////////////////////////////////////////
//////// Heat Exchanger Rack //////////////////////
///////////////////////////////////////////////////

#declare HXRack = union {
   object {HX
           rotate <0,0,90>
           translate <20,5,10>
          }
   object {HX
           rotate <0,0,90>
           translate <20,10,20>
          }
   object {HX
           rotate <0,0,90>
           translate <20,5,30>
          }
   object {HX
           rotate <0,0,90>
           translate <20,10,40>
          }
   object {HX
           rotate <0,0,90>
           translate <20,5,50>
          }
   object {HX
           rotate <0,0,90>
           translate <20,10,60>
          }
   // Simple HX Racks
   box { <0,0,0>
         <1,1,60>
         pigment {Gray}
          translate <10,7,5>
       }
   box { <0,0,0>
         <1,1,60>
         pigment {Gray}
         translate <20,7,5>
       }
   box { <0,0,0>
         <1,1,60>
         pigment {Gray}
         translate <10,13,5>
       }
   box { <0,0,0>
         <1,1,60>
         pigment {Gray}
         translate <20,13,5>
       }
   box { <0,0,0>
         <1,13,1>
         pigment {Gray}
         translate <20,0,5>
       }
   box { <0,0,0>
         <1,13,1>
         pigment {Gray}
         translate <10,0,5>
       }
   box { <0,0,0>
         <1,13,1>
         pigment {Gray}
         translate <20,0,65>
       }
   box { <0,0,0>
         <1,13,1>
         pigment {Gray}
         translate <10,0,65>
       }
   box { <0,0,0>
         <10,1,1>
         pigment {Gray}
         translate <10,7,5>
       }
   box { <0,0,0>
         <10,1,1>
         pigment {Gray}
         translate <10,13,5>
       }
   box { <0,0,0>
         <10,1,1>
         pigment {Gray}
         translate <10,7,65>
       }
   box { <0,0,0>
         <10,1,1>
         pigment {Gray}
         translate <10,13,65>
       }
}


//////////////////////////////////
/// Small Furnace ////////////////
//////////////////////////////////

#declare SmallFurnace = union{    
  box {<0,0,0 >
       <30 ,25, 17.5  >
       texture {Rust}
      }
  box {<0,0,0>
       <30,15,5>
       texture {Rust}
       translate<0,25,0>
      }
  cone {<0,0,0>, 5
        <0,20,0>,3
        texture {Rust}
        translate<12,25,5>
       }
  cylinder{<0,0,0>
           <0,50,0>
           3
           hollow
           texture {Rust}
           translate<12,45,5>
          }
  box { <0,0,0>
        <1,19,1>
        pigment {Gray}
        translate <-1,0,0>
      }
  box { <0,0,0>
        <1,19,1>
        pigment {Gray}
        translate <31,0,0>
      }
  box { <0,0,0>
        <1,19,1>
        pigment {Gray}
        translate <-1,0,18>
      }
  box { <0,0,0>
        <1,19,1>
        pigment {Gray}
        translate <30,0,18>
      }

  box { <0,0,0>
        <1,1,18>
        pigment {Gray}
        translate <30,18,0>
      }
  box { <0,0,0>
        <1,1,18>
        pigment {Gray}
        translate <-1,18,0>
      }
  box { <0,0,0>
        <31,1,1>
        pigment {Gray}
        translate <0,18,-1>
      }
  box { <0,0,0>
        <31,1,1>
        pigment {Gray}
        translate <0,18,17>
      }
  box { <0,0,0>
        <1,1,18>
        pigment {Gray}
        translate <30,0,0>
      }
  box { <0,0,0>
        <1,1,18>
        pigment {Gray}
        translate <-1,0,0>
      }
  box { <0,0,0>
        <31,1,1>
        pigment {Gray}
        translate <0,0,-1>
      }
  box { <0,0,0>
        <31,1,1>
        pigment {Gray}
        translate <0,0,17>
      }


}


#declare Ladder = union{
  cylinder{
    <-0.75,0,2.55>
    <-0.75,15,2.55>,
    0.1
    pigment {Silver}
  }
  cylinder{
    <0.75,0,2.55>
    <0.75,15,2.55>,
    0.1
    pigment{Silver}
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,1,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,2,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,3,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,4,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,5,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,6,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,7,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,8,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,9,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,10,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,11,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,12,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,13,0>
  }
  cylinder{
    <-0.75,0,2.25>
    <0.75,0,2.25>,
    0.07
    pigment{Silver}
    translate <0,14,0>
  }

}

#declare Platform = union{
cylinder // Platform and railings
{
  <0,15,0> <0,15.1,0>, 4.5  // Platform
  pigment {Grey}
}
difference{
  cylinder
    { <0,18,0> <0,18.1,0>, 4.5 //Outside edge of railing
      pigment {Grey}
    }
  cylinder
    { <0,17.9,0> <0,18.2,0>, 4.3 // Inside edge of railing
      pigment {Grey}
    }
}


// Support Posts
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,22.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,45,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,67.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,90,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,112.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,135,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,157.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,180,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,202.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,225,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,247.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,270,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,292.5,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,315,0>
   pigment {Grey}
}
cylinder{
   <4.4,15,0> <4.4,18,0>, 0.05
   rotate<0,337.5,0>
   pigment {Grey}
}
} // End of platform union

#declare TowerTop = union {

difference{
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     1.875,
     0.625
   }
   box
   {
     <0,-5,-5>
     <-5,5,5>
   }
   box
   {
     <0,-5,0>
     <5,5,-5>
   }
   rotate <270,180,0>
   translate <1.875,93.75,0>
   pigment {Blue}
}
difference{
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     1.875,
     0.625
   }
   box
   {
     <0,-5,-5>
     <-5,5,5>
   }
   box
   {
     <0,-5,0>
     <5,5,-5>
   }
   rotate <270,180,0>
   translate<6.875,90,0>
   pigment {Blue}
}
difference{
   torus  // for bend 2
   {
     1.875,
     0.625
   }
   box{
     <0,-5,-5>
     <-5,5,5>
   }
   rotate<90,0,0>
   translate<6.875 ,93.75,0>
   pigment {Blue}
}
cylinder{
   <0,0,0>
   <5,0,0>,
   0.625
   translate<1.875,95.625,0>
   pigment {Blue}
}
cylinder {
         <0,0,0>
         <0,3.75,0>
         0.625
         translate <0,90,0>
         pigment {Blue}
}
} // End of TowerTop

#declare DeProp = union {
union{
  cylinder 
  {
    <0,0,0> <0,90,0>, 2.5  
    pigment {Silver}
  }
  sphere 
  {
    <0, 0, 0> 
    2.5       
    pigment {Silver}
    translate <0,90,0>
  }
}
cylinder 
{
  <5,0,0> <5,90,0>, 0.625  
  pigment {Blue}
}

object{ Platform   }
object{ Platform  translate<0,15,0>}
object{ Platform  translate<0,30,0>}
object{ Platform  translate<0,45,0>}
object{ Platform  translate<0,60,0>}
object{ Platform  translate<0,77.5,0> scale<0.5555,0,0.5555>}
// Add a lantern object
light_source {
             <4.4,55,0>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1

             }
light_source {
             <0,80,-3.4>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }

light_source {
             <0,70,4.4>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }


object {TowerTop}

object {Ladder}
object {Ladder
        translate<0,15,0>
        rotate<0,45,0>
       }
object {Ladder
        translate<0,30,0>
        rotate<0,-45,0>
       }
object {Ladder
        translate<0,45,0>
        rotate<0,0,0>
       }
object {Ladder
        translate<0,60,0>
        rotate<0,45,0>
       }
object {Ladder
        translate<0,75,0>
        rotate<0,-45,0>
       }
} // End of DeProp tower
///////////////////////////////////////////////////////
//////////////  General Tower /////////////////////////
///////////////////////////////////////////////////////
#declare GenTowerTop = union {
difference{
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     1.875,
     0.625
   }
   box
   {
     <0,-5,-5>
     <-5,5,5>
   }
   box
   {
     <0,-5,0>
     <5,5,-5>
   }
   rotate <270,180,0>
   translate <1.875,93.75,0>
   pigment {Tan}
}
difference{
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     1.875,
     0.625
   }
   box
   {
     <0,-5,-5>
     <-5,5,5>
   }
   box
   {
     <0,-5,0>
     <5,5,-5>
   }
   rotate <270,0,0>
   translate<3.135,93.75,0>
   pigment {Tan}
}
cylinder{
   <0,0,0>
   <1.26,0,0>,
   0.625
   translate<1.875,95.625,0>
   pigment {Tan}
}
cylinder {
         <0,0,0>
         <0,3.75,0>
         0.625
         translate <0,90,0>
         pigment {Tan}
}

} // End of GenTowerTop


#declare GenTower = union {
union{
  cylinder 
  {
    <0,0,0> <0,90,0>, 2.5  
    pigment {Silver}
  }
  sphere
  {
    <0, 0, 0> 
    2.5       
    pigment {Silver}
    translate <0,90,0>
  }
}
cylinder 
{
  <5,0,0> <5,93.97,0>, 0.625  
  pigment {Tan}
}

object{ Platform   }
object{ Platform  translate<0,15,0>}
object{ Platform  translate<0,30,0>}
object{ Platform  translate<0,45,0>}
object{ Platform  translate<0,60,0>}
object{ Platform  translate<0,77.5,0> scale<0.5555,0,0.5555>}
// 'Lantern' objects
light_source {
             <-4.4,55,0>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }
// 'Lantern'
light_source {
             <0,70,-4.4>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }


object {GenTowerTop}

object {Ladder}
object {Ladder
        translate<0,15,0>
        rotate<0,45,0>
       }
object {Ladder
        translate<0,30,0>
        rotate<0,-45,0>
       }
object {Ladder
        translate<0,45,0>
        rotate<0,0,0>
       }
object {Ladder
        translate<0,60,0>
        rotate<0,45,0>
       }
object {Ladder
        translate<0,75,0>
        rotate<0,-45,0>
       }
} // End of GenTower tower

///////////////////////////////////////////////////////
////////// CAT CRACKER ////////////////////////////////
///////////////////////////////////////////////////////
#declare Cat = union{
  cylinder{
           <0,0,0>
           <0,90,0>
           10
           pigment {Brown  }
           normal {dents 1}
          }
  cylinder{
           <0,0,0>
           <0,40,0>
           15
           pigment{Brown  }
           normal {dents 1}
          }
  sphere{
          <0,0,0>
          10
          pigment {Brown  }
          normal {dents 1}
          scale<1,0.5,1>
          translate<0,90,0>
         }
  sphere{
          <0,0,0>
          15
          pigment{Brown  }
          normal {dents 1}
          scale<1,0.4,1>
          translate<0,40,0>
        }
   union{
     cylinder{
            <0,0,0>
            <0,55.5,0>
            1.5
            pigment{Grey}
            translate<20,0,0>
           }
     cylinder{
            <0,0,0>
            <0,15.5,0>
            1.5
            pigment{Grey}
            rotate<0,0,-90>
            translate<0,60,0>
           }
     difference{
         torus  // for bend 2
         {
           4.5,
           1.5
         }
         box{
           <0,-8,-8>
           <-8,8,8>
         }
         box{
            <-1,8,0>
            <8,-8,-8>
            }
         rotate<-90,0,0>
         translate<15.5 ,55.5,0>
         pigment {Grey}
     }
   }
}
// END OF CAT
/////////////////////////////////////////////////
////////// FLARE ////////////////////////////////
/////////////////////////////////////////////////

#declare Flare = union{
   cylinder{
            <0,0,0>
            <0,20,0>
            5
            pigment{Grey}
           }
   cone{
        <0,0,0>,5
        <0,100,0>,2
        pigment{Grey}
        translate<0,20,0>
       }
}
// END OF FLARE
///////////////////////////////////////////////
//////////// CAT2 /////////////////////////////
///////////////////////////////////////////////
#declare Cat2 = union {
   cylinder {
             <0,0,0>
             <0,40,0>
             9
            pigment{Tan}
            normal {dents 1}
            }
   cone {
         <0,0,0>,9
         <0,35,0>,5
         pigment{Tan}
         normal {dents 1}
         translate<0,40,0>
        }
   cylinder {
             <0,0,0>
             <0,47,0>
             5
             pigment{Tan}
             normal {dents 1}
             translate<0,75,0>
            }
   sphere {
           <0,0,0>
           5
           scale<0,0.3,0>
           translate<0,123,0>
           pigment{Tan}
           normal {dents 1}
          }
   cylinder {                   
             <0,0,0>
             <0,40,0>
             1.5
             pigment {Gray}
             translate <0,0,-12>
            }
   cylinder {
             <0,0,0>
             <0,50,0>
             1.5
             pigment{Gray}
             rotate<15,0,0>
             translate<0,39,-12>
            }
   cylinder{ <0,0,0> <0,100,0> 0.5  
             pigment {Gray}
             translate <-5,40,5>
           }
   object { Platform
            translate <0,-15,0>
            scale <3.111,1,3.111>
            translate <0, 20, 0>
          }
   object { Platform
            translate <0,-15,0>
            scale <3.111,1,3.111>
            translate <0, 40, 0>
          }
   object { Platform
            translate <0,-15,0>
            scale <2,1,2>
            translate <0, 90, 0>
          }

}


// END OF CAT2
/////////////////////////////////////////////////////////////
////////// COKER SUPPORTS AND FURNACE ///////////////////////
/////////////////////////////////////////////////////////////

#declare CokerSupports = union{
  // Supports
  box {<-30,0,-17.5>
       <-28,10,-15.5>
    texture {White_Marble}  }
  box {<-23,0,-17.5>
       <-21,10,-15.5>
       texture {White_Marble}  }
  box {<-16,0,-17.5>
       <-14,10,-15.5>
       texture {White_Marble} }
  box {<-9,0,-17.5>
       <-7,10,-15.5>
       texture {White_Marble}  }
  box {<-2,0,-17.5>
       < 3,10,-15.5>
       texture {White_Marble}  }
  box {< 8,0,-17.5>
       <10,10,-15.5>
       texture {White_Marble}  }
  box {<15,0,-17.5>
       <17,10,-15.5>
       texture {White_Marble} }
  box {<19,0,-17.5>
       <21,10,-15.5>
       texture {White_Marble}  }
  box {<28,0,-17.5>
       <30,10,-15.5>
       texture {White_Marble} }
  // back row
  box {<-30,0,17.5>
       <-28,10,15.5>
       texture {White_Marble}  }
  box {<-23,0,17.5>
       <-21,10,15.5>
       texture {White_Marble} }
  box {<-16,0,17.5>
       <-14,10,15.5>
       texture {White_Marble} }
  box {<-9,0,17.5>
       <-7,10,15.5>
       texture {White_Marble}  }
  box {<-2,0,17.5>
       < 3,10,15.5>
       texture {White_Marble} }
  box {< 8,0,17.5>
       <10,10,15.5>
       texture {White_Marble}  }
  box {<15,0,17.5>
       <17,10,15.5>
       texture {White_Marble}  }
  box {<19,0,17.5>
       <21,10,15.5>
       texture {White_Marble}  }
  box {<28,0,17.5>
       <30,10,15.5>
       texture {White_Marble}  }
  // End 1
  box {<28,0,10.5>
       <30,10, 8.5>
       texture {White_Marble}  }
  box {<28,0, 4.5>
       <30,10,2.5>
       texture {White_Marble}  }
  box {<28,0,-1.5>
       <30,10,-3.5>
       texture {White_Marble} }
  box {<28,0,-7.5>
       <30,10,-9.5>
      texture {White_Marble} }
  // End 2
  box {<-28,0,10.5>
       <-30,10, 8.5>
       texture {White_Marble}  }
  box {<-28,0, 4.5>
       <-30,10,2.5>
       texture {White_Marble}  }
  box {<-28,0, -1.5>
       <-30,10,-3.5>
      texture {White_Marble} }
  box {<-28,0,-7.5>
       <-30,10,-9.5>
       texture {White_Marble}
    }
}
// END OF SUPPORTS

#declare CokerFurnace = union{      
  box {<-30,0 , -17.5 >
       <30 ,25, 17.5  >
       texture {Rust}
      }
  box {<-30,0,-5>
       <30,15,5>
       texture {Rust}
       translate<0,25,0>
      }
  cone {<0,0,0>, 10
        <0,50,0>,6
        texture {Rust}
        translate<12,25,5>
       }
  cone {<0,0,0>, 10
        <0,50,0>,6
        texture {Rust}
        translate<-12,25,5>
       }
  cylinder{<0,0,0>
           <0,80,0>
           6
           hollow
           texture {Rust}
           translate<12,75,5>
          }

  cylinder{<0,0,0>
           <0,80,0>
           6
           hollow
           texture {Rust}
           translate<-12,75,5>
          }


}
////////////////////////////////////////////////////////////
/////////////////// Coking Drum ////////////////////////////
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
/////////////////// Coking Drum ////////////////////////////
////////////////////////////////////////////////////////////

#declare Angles = union{
         box { <0,0,0>               //Angle
               <1,24,1>
               pigment{Silver}
               rotate<0,0,33>
               translate<13,0,-13>
         }
         box { <0,0,0>               //Angle
               <1,24,1>
               pigment{Silver}
               rotate<0,0,-33>
               translate<-13,0,-13>
         }
}

#declare Level = union {
         box { <0,0,0>               // Cross
               <26,1,1>
               pigment{Silver}
               translate<-13,20,-13>
         }
         box { <0,0,0>               // Cross
               <26,1,1>
               pigment{Silver}
               translate<-13,20,-13>
               rotate<0,90,0>
         }
         box { <0,0,0>               // Cross
               <26,1,1>
               pigment{Silver}
               translate<-13,20,-13>
               rotate<0,180,0>
         }
         box { <0,0,0>               // Cross
               <26,1,1>
               pigment{Silver}
               translate<-13,20,-13>
               rotate<0,270,0>
         }
         object{Angles}
         object{Angles
                rotate<0,90,0>
         }
         object{Angles
                rotate<0,180,0>
         }
         object{Angles
                rotate<0,270,0>
         }

}

#declare CokerPlatformSupport = union {
      box {<-0.2,0,-0.2> // Support
             <0.2,4,0.2>
             pigment{Silver}
             translate<-13,115,-13>
           }
      box {<-0.2,0,-0.2> // Support
             <0.2,4,0.2>
             pigment{Silver}
             translate<-6.5,115,-13>
           }
      box {<-0.2,0,-0.2> // Support
             <0.2,4,0.2>
             pigment{Silver}
             translate<0,115,-13>
           }
      box {<-0.2,0,-0.2> // Support
             <0.2,4,0.2>
             pigment{Silver}
             translate<6.5,115,-13>
           }
      box {<-0.2,0,-0.2> // Support
             <0.2,4,0.2>
             pigment{Silver}
             translate<13,115,-13>
           }

}
#declare CokingDrum = union {

cylinder { <0,0,0>
           <0,100,0>
           12.5
           texture {T_Silver_1A}

         }
sphere { <0,0,0> 12.5
         texture {T_Silver_1A}
         translate <0,100,0>
       }
// Scaffolding
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<-13,0,-13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<13,0,13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<-13,0,13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<13,0,-13>
    }
object{Level}
object{Level
       translate<0,20,0>
      }
object{Level
       translate<0,40,0>
      }
object{Level
       translate<0,60,0>
      }
object{Level
       translate<0,80,0>
      }
box {<-13,0,-13>         // Top platform
     <13,0.4,13>
     pigment{Silver}
     translate<0,115,0>
    }
difference{              // Railing
           box {<-13,0,-13>
             <13,0.4,13>
             pigment{Silver}
             translate<0,119,0>
           }
           box {<-12.8,-.1,-12.8>
             <12.8,0.5,12.8>
             pigment{Silver}
             translate<0,119,0>
           }
// Lanterns
light_source {
             <-12,122,-10>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }

}
object {CokerPlatformSupport}
object {CokerPlatformSupport
                   rotate<0,90,0>
                  }
object {CokerPlatformSupport
                   rotate<0,180,0>
                  }
object {CokerPlatformSupport
                   rotate<0,270,0>
                  }



}

// End of coking drum

////////////////////////////////////////////////////////////
/////////////// Desulfur Reactor (same as Coker) ///////////
////////////////////////////////////////////////////////////

#declare DeSulfurReactor = union {

cylinder { <0,0,0>
           <0,100,0>
           12.5
           texture {T_Silver_1A}

         }
sphere { <0,0,0> 12.5
         texture {T_Silver_1A}
         translate <0,100,0>
       }
// Scaffolding
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<-13,0,-13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<13,0,13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<-13,0,13>
    }
box { <0,0,0>               //Corner support
      <1,115,1>
      pigment{Silver}
      translate<13,0,-13>
    }
object{Level}
object{Level
       translate<0,20,0>
      }
object{Level
       translate<0,40,0>
      }
object{Level
       translate<0,60,0>
      }
object{Level
       translate<0,80,0>
      }
box {<-13,0,-13>         // Top platform
     <13,0.4,13>
     pigment{Silver}
     translate<0,115,0>
    }
difference{              // Railing
           box {<-13,0,-13>
             <13,0.4,13>
             pigment{Silver}
             translate<0,119,0>
           }
           box {<-12.8,-.1,-12.8>
             <12.8,0.5,12.8>
             pigment{Silver}
             translate<0,119,0>
           }

}
object {CokerPlatformSupport}
object {CokerPlatformSupport
                   rotate<0,90,0>
                  }
object {CokerPlatformSupport
                   rotate<0,180,0>
                  }
object {CokerPlatformSupport
                   rotate<0,270,0>
                  }



}

// End of coking drum

////////////////////////////////////////////////////////////
/////////////// Atmospheric Tower and Platform Tower ///////
////////////////////////////////////////////////////////////

#declare AtmPlatformLevels = union {

box { <0,0,0>                // Platform Structure
      <15,1,15>
      pigment {Silver}
      translate <0,15,0>
    }
box { <0,0,0>               // Supports
      <1,15,1>
      pigment {Silver}
    }
box { <0,0,0>
      <1,15,1>
      pigment {Silver}
      translate <14,0,0>
    }
box { <0,0,0>
      <1,15,1>
      pigment {Silver}
      translate <0,0,14>
    }
box { <0,0,0>
      <1,15,1>
      pigment {Silver}
      translate <14,0,14>
    }

         box { <0,0,0>               //Angle    FRONT (Sides not done)
               <1,16,1>
               pigment{Silver}
               rotate<0,0,-18>
               translate<7.5,0,0>
         }
         box { <0,0,0>               //Angle
               <1,16,1>
               pigment{Silver}
               rotate<0,0,18>
               translate<7.5,0,0>
         }
         box { <0,0,0>               //Angle   BACK
               <1,16,1>
               pigment{Silver}
               rotate<0,0,-18>
               translate<7.5,0,15>
         }
         box { <0,0,0>               //Angle
               <1,16,1>
               pigment{Silver}
               rotate<0,0,18>
               translate<7.5,0,15>
         }



}

#declare AtmTower = union {

  cylinder { <0,0,0>
           <0,120,0>
           10


          texture {
             gradient y
             texture_map {
                 [ 0.3 T_Chrome_5A normal {dents 0.5}]
                 [ 1 Rust]
             }
             turbulence 1.5
           }

//          texture {
//                  crackle
//                  texture_map {
//                  [0 T_Chrome_5A normal { dents 0.5 } ]
//                  [0.8 T_Chrome_5A normal { dents 0.5 } ]
//                  [1 Rust]
//                  }
//          }
  }
  sphere { <0,0,0> 10
         translate <0,120,0>
         texture {
             gradient y
             texture_map {
                 [ 0.2 T_Chrome_5A normal {dents 0.5}]
                 [ 1 Rust]
             }
             turbulence 1.5
           }
         }
  object {Platform
        translate <0,-15,0>
        scale <3,1,3>
        translate <0,20,0>
         }
  object {Platform
        translate <0,-15,0>
        scale <3,1,3>
        translate <0,40,0>
         }
  object {Platform
        translate <0,-15,0>
        scale <3,1,3>
        translate <0,60,0>
         }
  object {Platform
        translate <0,-15,0>
        scale <3,1,3>
        translate <0,80,0>
         }
  light_source {
             <-12,78,-12>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
  }

  object {Platform
        translate <0,-15,0>
        scale <3,1,3>
        translate <0,100,0>
         }

  object {AtmPlatformLevels}
  object {AtmPlatformLevels
        translate <13,15,-7.5>
         }
  object {AtmPlatformLevels
        translate <13,30,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,45,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,60,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,75,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,90,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,105,-7.50>
         }
  object {AtmPlatformLevels
        translate <13,120,-7.50>
         }
  box {<0,0,0>
     <23,1,15>
     pigment {Silver}
     translate <-10,135,-7.5>
      }
  box { <0,0,0>             // Railing
      <38,0.5,0.5>
      pigment {Silver}
      translate <-10,140,-7.5>
      }
  box { <0,0,0>             // Railing
      <38,0.5,0.5>
      pigment {Silver}
      translate <-10,140,7.5>
      }
  box { <0,0,0>             // Railing
      <0.5,0.5,15>
      pigment {Silver}
      translate <-10,140,-7.5>
      }
  box { <0,0,0>             // Railing
      <0.5,0.5,15>
      pigment {Silver}
      translate <28,140,-7.5>
      }
  box { <0,0,0>
      <0.5,5,0.5>
      pigment {Silver}
      translate <-10,135,-7.5>
      }
  box { <0,0,0>
      <0.5,5,0.5>
      pigment {Silver}
      translate <-10,135,7.5>
      }
  box { <0,0,0>
      <0.5,5,0.5>
      pigment {Silver}
      translate <28,135,-7.5>
      }
  box { <0,0,0>
      <0.5,5,0.5>
      pigment {Silver}
      translate <28,135,7.5>
      }
//Lantern
light_source {
             <28,142,-7.5>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }



  cylinder { <0,0,0>            // Overhead draw
           <0,15,0>
           2
           pigment {Tan}
           translate <0,130,0>
           }
 difference {
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     3,
     2
   }
   box
   {
     <0,-10,-10>
     <-10,10,10>
   }
   box
   {
     <0,-10,0>
     <10,10,-10>
   }
   rotate <270,180,0>
   translate <3,145,0>
   pigment {Silver}
}
cylinder {<0,0,0>
          <9,0,0>
          2
          pigment{Silver}
          translate <3,148,0>
         }

difference{
   torus  // For bends 1 and 3. Leaves the first quadrant - x  |z
   {      //                                              - -  --x
     3,
     2
   }
   box
   {
     <0,-10,-10>
     <-10,10,10>
   }
   box
   {
     <0,-10,0>
     <10,10,-10>
   }
   rotate <270,0,0>
   translate<12,145,0>
   pigment {Silver}
}

cylinder { <0,0,0>
           <0,145,0>
           2
           pigment {Silver}
           translate <15,0,0>
         }


}
// End of Atm Tower


/////////////////////////////////////////////////////
////////////// Platformer Tower /////////////////////
/////////////////////////////////////////////////////

#declare PlatformerTower = union {

cylinder { <0,0,0>
           <0,31,0>
           1.5
           pigment {Gray}
         }
sphere { <0,0,0> 1.5
         translate <0,31,0>
         pigment {Gray}
       }
object { Platform
         translate <0,-15,0>
         translate <0,17,0>
       }

object { Platform
         translate <0,-15,0>
         translate <0,30,0>
       }
object { Ladder
         scale <1,1.3,0.78>
         rotate <0,180,0>
       }
object {
         Ladder
         scale <1,1.4,0.78>
         rotate<0,90,0>
         translate <0,17,0>
       }
//Lantern
light_source {
             <-4.4,35,-1>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }


}



// End of platformer tower

////////////////////////////////////////////////////////
/////////////// Platformer Tower  2 ////////////////////
////////////////////////////////////////////////////////

#declare PlatformerTower2 = union {

cylinder { <0,0,0>
           <0,38,0>
           1
           pigment {Gray}
         }
sphere { <0,0,0> 1
         translate <0,38,0>
         pigment {Gray}
       }
object { Platform             // Bottom Platform
         translate <0,-15,0>
         translate <0,15,0>
         scale <0.7,1,0.7>
         }
difference {    // Half Platform
  object { Platform             // Mid Platform
           translate <0,-15,0>
           translate <0,25,0>
           scale <0.7,1,0.7>
         }
  box { <-10,23,0>
        < 10,30,10>
      }
}
difference {   // Quarter Platform
  object { Platform             // Top Platform
           translate <0,-15,0>
           translate <0,35,0>
           scale <0.7,1,0.7>
         }
  box { <-10,33,0>
        < 10,40,10>
      }
  box { <-10,33,0>
        <  0,40,-10>
      }
}
light_source {
             <-4.4,29,1>
             color rgb <0.4,0.4,0.6>
             looks_like { Lantern}
             fade_distance 20
             fade_power 1
             }


object { Ladder
         scale <1,1.3,0.5>
         rotate <0,270,0>
       }
object {
         Ladder
         scale <1,1.5,0.5>
         rotate<0,90,0>
         translate <0,15,0>
       }

}
// End of Platformer Tower



// End of Platformer Tower


///////////////////////////////////////////////
/////// Platformer Reactor And Furnace ////////
///////////////////////////////////////////////

#declare PlatformerReactor = union {
         box { <0,0,0>            // Furnace bottom
               <5,12,10>
               pigment {Red}
               translate <0,0,7>
             }
         box { <0,0,0>            // Furnace Top
               <5,8,4>
               pigment {Red}
               translate <0,12,10>
             }
         difference {
           box { <0,0,0>            // Reactor Support
                 <5,6,5>
                 pigment {Grey}
               }
           box { <1,1,-1>           // Holes in the support
                 <4,5,6>
               }
           box { <-1,1,1>           // Holes in the support
                 <6,5,4>
               }
         }
         cylinder { <0,0,0>                 // Reactor
                    <0,12,0>
                    2
                    pigment {Silver}
                    translate <2.5,6,2.5>
                  }
         sphere { <0,0,0>
                  2
                  pigment {Silver}
                  translate <2.5,18,2.5>
                }
         box { <0,0,0>                      // Scaffolding
               <0.5,15,0.5>
               pigment {Silver}
               translate <0,6,0>
             }
         box { <0,0,0>
               <0.5,15,0.5>
               pigment {Silver}
               translate <4.5,6,0>
             }
         box { <0,0,0>
               <0.5,15,0.5>
               pigment {Silver}
               translate <0,6,4.5>
             }
         box { <0,0,0>
               <0.5,15,0.5>
               pigment {Silver}
               translate <4.5,6,4.5>
             }
         box { <0,0,0>                      // Top platform
               <5,1,5>
               pigment {Silver}
               translate <0,21,0>
}
}

