// Buildings between Lake Street and Washington Street (NS)
//       and between Chicago River and Michigan Ave. (EW)

// Randolph-Wacker Bldg
box
{
    < -20,   0, -60>*FEET
    <  20, 350,  60>*FEET
    texture   { BlackGlassBox }
    translate < -632, 0, -757 >*METERS
}

// La Salle Plaza
box
{
    < -50,   0, -80>*FEET
    <  50, 425,  80>*FEET
    texture   { BlackWaffleBox }
    translate < -286, 0, -731 >*METERS
}

// State of Illinois Center
cone
{
    < 0,   0, 0 >*FEET 275*FEET
    < 0, 200, 0 >*FEET 210*FEET
    clipped_by
    {
        box { < 0, -10, 0 >*FEET < 280, 205, -280 >*FEET }
    }
    texture   { SilverGlassBox }
    translate < -216, 0, -698 >*METERS
}

cylinder
{
    < 0, 0,  0 >*FEET
    < 0, 80, 0 >*FEET, 75*FEET
    clipped_by
    {
        plane
        {
            y 0
            rotate -30*x
            rotate -45*y
            translate 35*FEET*y
        }
    }
    texture   { SilverGlassBox }
    translate 200*FEET*y
    translate < -186, 0, -728 >*METERS
}

// One Park Place
box
{
    < -15,   0, -20 >*FEET
    <  15, 550,  20 >*FEET
    clipped_by
    {
        plane
        {
            y 0
            rotate -45*x
            rotate -45*y
            translate 460*FEET*y
        }
    }
    texture   { BandedGlassBox }
    translate < 356, 0, -755 >*METERS
}

// Headquarters Bldg
box
{
    < -60,   0, -75 >*FEET
    <  60, 225,  75 >*FEET
    texture   { BandedGlassBox }
    translate < -552, 0, -881 >*METERS
}

// Illinois Bell Telephone Bldg.
box
{
    < -100,   0, -75 >*FEET
    <  100, 300,  75 >*FEET
    texture   { BlackWaffleBox }
    translate < -430, 0, -887 >*METERS
}

// Cook County Courthouse
box
{
    < -125,   0, -180 >*FEET
    <  125, 125,  180 >*FEET
    texture   { WhiteMasonryTower }
    translate < -192, 0, -880 >*METERS
}

// Daley Center
box
{
    < -110,   0, -60 >*FEET
    <  110, 675,  60 >*FEET
    translate < -61, 0, -757 >*METERS
    texture   { InteriorLights }
}

// Marshall Fields
box
{
    < -150,   0, -60 >*FEET
    <  150, 125,  60 >*FEET
    texture   { WhiteMasonryTower }
    translate < 199, 0, -880 >*METERS
}
