// Buildings between Washington Street and Monroe Street (NS)
//       and between Chicago River and Michigan Ave.     (EW)

// Kemper Insurance
box
{
    < -25,   0, -90 >*FEET
    <  25, 525,  90 >*FEET
    texture   { WhiteMasonryTower }
    translate < -642, 0, -1011 >*METERS
}

// Madison Plaza
prism
{
    linear_sweep linear_spline
    0*FEET, 525*FEET,
    7,
    <-100, -60>*FEET, <-100,  60>*FEET, < 0,  60>*FEET,
    < 100,  25>*FEET, < 100, -25>*FEET, < 0, -60>*FEET, <-100, -60>*FEET
    texture   { BlackGlassBox }
    translate < -428, 0, -1039 >*METERS
}

// 30 N. La Salle
box
{
    < -75,   0, -60 >*FEET
    <  75, 525,  60 >*FEET
    texture   { BlackWaffleBox }
    translate < -192, 0, -879 >*METERS
}

// Three First National Plaza
prism
{
    linear_sweep linear_spline
    0*FEET, 775*FEET,
    7,
    <-90, -75>*FEET, <-90,  75>*FEET, < 0,  75>*FEET,
    < 90,  40>*FEET, < 90, -40>*FEET, < 0, -75>*FEET, <-90, -75>*FEET
    texture   { BronzeGlassBox }
    translate < -174, 0, -1151 >*METERS
}

// Brunswick Bldg
box
{
    < -75,   0, -40 >*FEET
    <  75, 475,  40 >*FEET
    texture   { SilverGlassBox }
    translate < -44, 0, -1009 >*METERS
}

// Chicago Mercantile Exchange
cylinder
{
    < 0, 0, 0 > < 0, 1, 0 > 1
    scale < 125, 525, 225 >*FEET
    texture { WhiteWaffleBox }
    translate <-678, 0, -1188 >*METERS
}

cylinder
{
    < 0, 0, 0 > < 0, 1, 0 > 1
    scale < 125, 525, 225 >*FEET
    texture { WhiteWaffleBox }
    translate <-678, 0, -1118 >*METERS
}

// 1 S. Wacker Drive
box
{
    < -60,   0, -75 >*FEET
    <  60, 550,  75 >*FEET
    texture { BlackGlassBox }
    translate <-556, 0, -1131 >*METERS
}

// One First National Plaza
box
{
    <-125,   0, -40>*FEET
    < 125, 825,  40>*FEET
    texture { WhiteWaffleBox translate 10*FEET }
    translate < -54, 0, -1151 >*METERS
}

box
{
    <-127, -20, -41>*FEET
    < 127,  20,  41>*FEET
    texture { MarqueeLights }
    translate < -54, 0, -1151 >*METERS
    translate 770*FEET*y
}
