// Buildings between Chicago River and Oak Street   (NS)
//       and between Michigan Ave and Lake Michigan (EW)

// Equitable Bldg
box
{
   < -50,   0, -75 >*FEET
   <  50, 450,  75 >*FEET
   translate < 533, 0, -259>*METERS
   texture { BlackGlassBox }
}

cylinder { <-50, 440, -60>*FEET <-50, 440, 60>*FEET 10*FEET
           texture { MercuryLamp }
           translate < 533, 0, -259>*METERS }


// Mandel Bldg
prism
{
    linear_sweep linear_spline
    0*FEET, 160*FEET
    5
    < -75,  200 >*FEET <  75,  200 >*FEET
    <  75, -200 >*FEET < -75, -150 >*FEET < -75,  200 >*FEET
    rotate -20*y
    translate < 583, 0, -259>*METERS
    texture  { WhiteMasonryTower }
}

// Tribune Tower
box
{
   < -150,   0, -100 >*FEET
   <  150, 125, -100 >*FEET
   translate < 523, 0, -149>*METERS
   texture { WhiteMasonryTower }
}

cylinder
{
   < -110,   0, 60 >*FEET
   < -110, 425, 60 >*FEET 40*FEET
   translate < 523, 0, -149>*METERS
   texture { WhiteMasonryTower }
}

sphere { < -110, 425, 60 >*FEET 30*FEET
            translate < 523, 0, -149>*METERS
            texture { YellowLamp }
        }


// Radisson Hotel
box
{
   < -50,   0, -100 >*FEET
   <  50, 125,  100 >*FEET
   translate < 523, 0, -29>*METERS
   texture { WhiteMasonryTower }
}

cylinder
{
   <  0,   0, 60 >*FEET
   <  0, 500, 60 >*FEET 40*FEET
   translate < 523, 0, -29>*METERS
   texture { WhiteMasonryTower }
}

sphere { < 0, 500, 60 >*FEET 30*FEET
   translate < 523, 0, -29>*METERS
   texture { YellowLamp }
}

// 535 N Michigan Ave
box
{
   < -75,   0, -50 >*FEET
   <  75, 300,  50 >*FEET
   translate < 513, 0, 5>*METERS
   texture { WhiteWaffleBox }
}

// 625 N Michigan Ave
box
{
   < -50,   0, -40 >*FEET
   <  50, 325,  40 >*FEET
   translate < 494, 0, 144>*METERS
   texture { GrayGlassBox }
}

// St Clair Bldg
box
{
   < -50,   0, -90 >*FEET
   <  50, 300,  90 >*FEET
   translate < 539, 0, 204>*METERS
   texture { WhiteWaffleBox }
}

// Sheraton Plaza
box
{
   < -50,   0, -25 >*FEET
   <  50, 425,  25 >*FEET
   translate < 549, 0, 372>*METERS
   texture { BlackWaffleBox }
}

// Olympia Center
box
{
   < -75,   0, -40 >*FEET
   <  75, 550,  40 >*FEET
   translate < 535, 0, 518>*METERS
   texture { BrownMasonryTower }
}

// Water Tower Place
box
{
   < -200,   0, -90 >*FEET
   <  200, 150,  90 >*FEET
   translate < 553, 0, 694>*METERS
   texture { BandedGlassBox }
}

// Ritz Carlton
box
{
   <   0, 150, -90 >*FEET
   < 200, 825, -15 >*FEET
   translate < 553, 0, 694>*METERS
   texture { WhiteWaffleBox }
}

// Hancock tower
difference
{
    box
    {
        <-20, 0,  -12>*METERS
        < 20, 344, 12>*METERS
    }
    plane { x 0 rotate -1.66*z translate -20*METERS }
    plane {-x 0 rotate  1.66*z translate  20*METERS }
    plane { z 0 rotate -0.99*x translate -12*METERS }
    plane {-z 0 rotate  0.99*x translate  12*METERS }

    translate <545, 0, 769>*METERS
    texture { InteriorLights }
    texture { GlassBoxMask rotate 45*x rotate 45*z }
}

box { < -12, 324, -9 >*METERS
      <  12, 344,  9 >*METERS
      translate <545, 0, 769>*METERS
      texture { MercuryLamp }
    }


cylinder // W radio antenna
{
    < -10, 344, 0>*METERS
    < -10, 450, 0>*METERS 1*METERS
    translate <545, 0, 769>*METERS
    texture { RadioAntenna }
}

cylinder // E radio antenna
{
    < 10, 344, 0>*METERS
    < 10, 450, 0>*METERS 1*METERS
    translate <545, 0, 769>*METERS
    texture { RadioAntenna }
}

// Navy Pier
box
{
   <    0,  0, -110 >*FEET
   < 2500, 30,  -35 >*FEET
   translate < 1613, 0, -41>*METERS
   texture { BrownMasonryTower }
}

box
{
   <    0,  0,  110 >*FEET
   < 2500, 30,   35 >*FEET
   translate < 1613, 0, -41>*METERS
   texture { BrownMasonryTower }
}

box
{
   <   0,  0, -110 >*FEET
   < 150, 30,  110 >*FEET
   translate < 1613, 0, -41>*METERS
   texture { BrownMasonryTower }
}

box
{
   < 2350   0, -110 >*FEET
   < 2500, 30,  110 >*FEET
   translate < 1613, 0, -41>*METERS
   texture { BrownMasonryTower }
}

// Time-Life Bldg
box
{
   < -40,   0, -100 >*FEET
   <  40, 425,  100 >*FEET
   translate < 813, 0, 42>*METERS
   texture { BlackWaffleBox }
}

// Lake Point Tower
union
{
    cylinder
    {
        < 0, 0,   0>*METERS
        < 0, 197, 0>*METERS 10*METERS
    }
    cylinder
    {
        < 10, 0,   0>*METERS
        < 10, 197, 0>*METERS 5*METERS
    }
    cylinder
    {
        < 10, 0,   0>*METERS
        < 10, 197, 0>*METERS 5*METERS
        rotate 120*y
    }
    cylinder
    {
        < 10, 0,   0>*METERS
        < 10, 197, 0>*METERS 5*METERS
        rotate -120*y
    }
    translate <1434, 0, -33>*METERS
    texture { BlackGlassBox }
}
