// -------------------
// urban light sources
// -------------------
#declare Darkness    = texture { pigment { color Black } }

#declare MercuryLamp = texture { pigment { color (White *0.9 + Green*0.1) }
                                 finish  { ambient 1 } }

#declare SodiumLamp  = texture { pigment { color (Orange*0.8 + White*0.2) }
                                 finish  { ambient 1 } }

#declare YellowLamp  = texture { pigment { color (Yellow*0.6 + White*0.4) }
                                 finish  { ambient 1 } }

#declare RedLamp     = texture { pigment { color Red  }
                                 finish  { ambient 1 } }

#declare WhiteLamp   = texture { pigment { color (White*0.8 + Yellow*0.2) }
                                 finish  { ambient 1 } }

#declare BlueLamp    = texture { pigment { color Blue }
                                 finish  { ambient 1 } }

// ----------------
// natural textures
// ----------------

#declare SkySunsetAdjacent = pigment
{
    gradient z
    color_map
    {
        [ 0.003 White   ]
        [ 0.003 (Orange*0.52 +   Blue*0.23) ]
        [ 0.600 (  Blue*0.37 + Violet*0.37) ]
    }
}

#declare SkySunsetOpposite = pigment
{
    gradient z
    color_map
    {
        [ 0.0  (Blue*0.37 + Violet*0.37) ]
        [ 0.6 Violet*0.75 ]
    }
}

#declare ChicagoClouds = pigment
{
    bozo
    color_map
    {
        [ 0.75 Clear ] [ 0.87 Pink ] [ 1.00 (Orange*0.37+Red*0.18) ]
    }
    turbulence 0.66
    scale < 0.5, 0.05, 0.5 >
}

// ----------------------
// urban roadway textures
// ----------------------

#declare Interstate = texture
{
    bozo
    texture_map
    {
        [ 0.05 RedLamp    ]
        [ 0.10 WhiteLamp  ]
        [ 0.15 SodiumLamp ]
        [ 0.65 SodiumLamp ]
        [ 0.80 Darkness   ]
    }
    scale 10*METERS
}

#declare MajorHighway = texture
{
    bozo
    texture_map
    {
        [ 0.05 Darkness    ]
        [ 0.25 MercuryLamp ]
        [ 0.75 SodiumLamp  ]
        [ 0.90 SodiumLamp  ]
        [ 0.95 RedLamp     ]
    }
    scale 10*METERS
}

#declare MinorHighway = texture
{
    bozo
    texture_map
    {
        [ 0.15 Darkness    ]
        [ 0.25 MercuryLamp ]
        [ 0.45 SodiumLamp  ]
        [ 0.90 SodiumLamp  ]
        [ 0.95 RedLamp     ]
    }
    scale 10*METERS
}

#declare Street = texture
{
    bozo
    texture_map
    {
        [ 0.10 Darkness    ]
        [ 0.15 MercuryLamp ]
        [ 0.35 SodiumLamp  ]
        [ 0.90 SodiumLamp  ]
        [ 0.95 RedLamp     ]
    }
    scale 10*METERS
}


// -----------------
// Building textures
// -----------------

#declare InteriorLights = texture
{
    pigment
    {
        bozo
        color_map
        {
            [ 0.33 ( White*0.2) ]
            [ 0.66 ( White*0.9 + Green*0.1) ]
            [ 1.00 (Yellow*0.6 + White*0.4) ]
        }
    }
    finish
    {
        reflection 0.3
        ambient    0.7
    }
    normal
    {
        bumps 0.1 scale <3, 3, 3>*METERS
    }
    scale < 60, 3, 60 >*METERS
}

#declare Black10Map = color_map
{
    [ 0.00 Black ]
    [ 0.05 Black ]
    [ 0.05 Clear ]
    [ 0.95 Clear ]
    [ 0.95 Black ]
    [ 1.00 Black ]
}

#declare Black20Map = color_map
{
    [ 0.00 Black ]
    [ 0.10 Black ]
    [ 0.10 Clear ]
    [ 0.80 Clear ]
    [ 0.80 Black ]
    [ 1.00 Black ]
}

#declare Black30Map = color_map
{
    [ 0.00 Black ]
    [ 0.15 Black ]
    [ 0.15 Clear ]
    [ 0.85 Clear ]
    [ 0.85 Black ]
    [ 1.00 Black ]
}

#declare GlassBoxMask = texture
{
    pigment { gradient x color_map { Black10Map } }
    pigment { gradient y color_map { Black10Map } }
    pigment { gradient z color_map { Black10Map } }
    scale <10, 5, 10>*FEET
}

#declare WaffleBoxMask = texture
{
    pigment { gradient x color_map { Black20Map } }
    pigment { gradient y color_map { Black20Map } }
    pigment { gradient z color_map { Black20Map } }
    scale <10, 5, 10>*FEET
}

#declare MasonryBoxMask = texture
{
    pigment { gradient x color_map { Black30Map } }
    pigment { gradient y color_map { Black10Map } }
    pigment { gradient z color_map { Black30Map } }
    scale <17, 5, 17>*FEET
}

#declare BandedBoxMask = texture
{
    pigment { gradient y color_map { Black10Map } }
    scale <10, 5, 10>*FEET
}

#declare PillaredBoxMask = texture
{
    pigment { gradient x color_map { Black30Map } }
    pigment { gradient z color_map { Black30Map } }
    scale <10, 5, 10>*FEET
}

#declare BlackGlassBox =
texture { InteriorLights }
texture { GlassBoxMask   }

#declare BronzeGlassBox =
texture { InteriorLights }
texture { GlassBoxMask   }

#declare GrayGlassBox =
texture { InteriorLights }
texture { GlassBoxMask   }

#declare SilverGlassBox =
texture { InteriorLights }
texture { GlassBoxMask   }

#declare WhiteMasonryTower =
texture { InteriorLights }
texture { MasonryBoxMask }

#declare BrownMasonryTower =
texture { InteriorLights }
texture { MasonryBoxMask }

#declare BandedPillaredBox =
texture { InteriorLights  }
texture { PillaredBoxMask }
texture { BandedBoxMask   }

#declare PillaredGlassBox =
texture { InteriorLights }
texture { PillaredBoxMask }

#declare BlackWaffleBox =
texture { InteriorLights }
texture { WaffleBoxMask  }

#declare WhiteWaffleBox =
texture { InteriorLights }
texture { WaffleBoxMask  }

#declare RedWaffleBox   =
texture { InteriorLights }
texture { WaffleBoxMask  }

#declare BrownWaffleBox =
texture { InteriorLights }
texture { WaffleBoxMask  }

#declare BandedGlassBox =
texture { InteriorLights }
texture { BandedBoxMask  }

#declare RadioAntenna = texture
{
    gradient y
    texture_map
    {
        [ 0.0 pigment { color White } finish { ambient 0.8 } ]
        [ 0.8 pigment { color White } finish { ambient 0.8 } ]
        [ 0.8 RedLamp ]
        [ 1.0 RedLamp ]
    }
    scale 30*METERS
}

#declare MarqueeLights = texture
{
    pigment { leopard color_map { [ 0.2 Black ] [ 0.2 (Yellow/2+White/2) ] } }
    finish  { ambient 1 }
    scale   <5, 10, 5>*FEET
}
