#include "colors.inc"

#declare METERS = 3.3

camera
{
    orthographic
    location < 0,-2, 0 >
    right    <-1, 0, 0 >
    up       < 0, 0,-1 >
    look_at  < 0, 0, 0 >
}

#declare Interstate   = texture { pigment { color Black } }
#declare MajorHighway = texture { pigment { color Black } }
#declare MinorHighway = texture { pigment { color Black } }
#declare Street       = texture { pigment { color Black } }

// mask out streets
// ----------------
object
{
    #include "road03.pov"
    translate 3000*METERS*z
    scale 1/(10000*METERS)
    translate -1*y
}
object
{
    #include "road04.pov"
    translate 3000*METERS*z
    scale 1/(10000*METERS)
    translate -1*y
}
object
{
    #include "road11.pov"
    translate 3000*METERS*z
    scale 1/(10000*METERS)
    translate -1*y
}
object
{
    #include "road12.pov"
    translate 3000*METERS*z
    scale 1/(10000*METERS)
    translate -1*y
}

#declare BuildingHeightMap = pigment
{
    gradient y
    color_map
    {
        [ 0.0 Black ]
        [ 1.0 White ]
    }
    scale -50
}

// -------------------------
// dispense random buildings
//--------------------------

#declare RND = seed(447777)

#declare RANGE=5000

#declare iz = -RANGE
#while  (iz <  RANGE)
  #declare ix = -RANGE
  #while  (ix <  RANGE)
    #declare nb = 4*rand(RND)
    #while (nb > 0)

      #if (rand(RND) > (ix*ix)/(RANGE*RANGE))
      #if (rand(RND) > (iz*iz)/(RANGE*RANGE))
        #declare x_jitter =  40*(rand(RND)-0.5)
        #declare z_jitter =  40*(rand(RND)-0.5)
        #declare bwidth   = 5 + 20*(rand(RND)+rand(RND)+rand(RND))
        #declare bbreadth = 5 + 20*(rand(RND)+rand(RND)+rand(RND))
        #declare bheight  = 5 + 10*(rand(RND)+rand(RND))
        box
        {    < -bwidth,  0,       -bbreadth >
             <  bwidth, -bheight,  bbreadth >
             pigment { BuildingHeightMap }
             finish  { ambient 1 }
             #if (rand(RND) > 0.8)
                 rotate 45*y
             #end
             translate < (ix + x_jitter), 0, (iz + z_jitter) >
             scale (1/10000)
       }
      #end
      #end

      #declare nb = nb - 1
    #end
    #declare ix = ix + 100
  #end
  #declare iz = iz + 100
#end
