
#declare BaseTerrain = union
{
    // Land bounded by:
    // W bank of Chicago River from 10 km N to 15 km N of site,
    // and line 15 km W of site from 15 km to 10 km N of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        38,
        <-6319.21, 10000.00>*METERS, <-6320.37, 10006.95>*METERS,
        <-6350.00, 10124.01>*METERS, <-6359.72, 10185.04>*METERS,
        <-6364.72, 10195.24>*METERS, <-6371.99, 10243.55>*METERS,
        <-6391.79, 10314.82>*METERS, <-6394.11, 10345.31>*METERS,
        <-6401.53, 10373.31>*METERS, <-6411.36, 10419.10>*METERS,
        <-6558.77, 11105.99>*METERS, <-6561.16, 11126.33>*METERS,
        <-6568.73, 11134.00>*METERS, <-6573.46, 11182.30>*METERS,
        <-6598.01, 11299.32>*METERS, <-6619.89, 11434.10>*METERS,
        <-6639.21, 11571.41>*METERS, <-6642.71, 11789.88>*METERS,
        <-6640.95, 12031.17>*METERS, <-6640.46, 12032.00>*METERS,
        <-6621.93, 12481.46>*METERS, <-6602.95, 12994.41>*METERS,
        <-6595.18, 13362.67>*METERS, <-6579.24, 13807.06>*METERS,
        <-6577.03, 14109.31>*METERS, <-6566.09, 14215.92>*METERS,
        <-6560.64, 14614.67>*METERS, <-6547.59, 14662.83>*METERS,
        <-6537.04, 14716.10>*METERS, <-6544.46, 14744.09>*METERS,
        <-6556.99, 14767.05>*METERS, <-6569.39, 14807.78>*METERS,
        <-6566.46, 14861.10>*METERS, <-6558.73, 14876.28>*METERS,
        <-6554.49, 15000.00>*METERS, <-15000.00, 15000.00>*METERS,
        <-15000.00, 10000.00>*METERS, <-6319.21, 10000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }
    }

    // Land bounded by:
    // Lake Michigan from 15 km N to 10 km N of site, and
    // E bank of Chicago River from 10 km N to 15 km N of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        150,
        <-3053.23, 15000.00>*METERS,
        <-3017.64, 14982.53>*METERS, <-2977.27, 14944.14>*METERS,
        <-2957.42, 14880.49>*METERS, <-2947.37, 14865.18>*METERS,
        <-2934.99, 14821.91>*METERS, <-2927.42, 14814.23>*METERS,
        <-2905.04, 14748.02>*METERS, <-2902.63, 14730.23>*METERS,
        <-2880.05, 14691.96>*METERS, <-2880.11, 14684.34>*METERS,
        <-2872.56, 14674.13>*METERS, <-2850.15, 14613.00>*METERS,
        <-2837.56, 14597.67>*METERS, <-2838.19, 14511.31>*METERS,
        <-2805.67, 14442.49>*METERS, <-2795.92, 14386.54>*METERS,
        <-2763.03, 14368.52>*METERS, <-2750.48, 14348.10>*METERS,
        <-2730.68, 14276.84>*METERS, <-2733.59, 14226.06>*METERS,
        <-2746.46, 14203.29>*METERS, <-2739.13, 14162.60>*METERS,
        <-2731.64, 14144.76>*METERS, <-2729.25, 14124.42>*METERS,
        <-2734.39, 14116.84>*METERS, <-2739.67, 14088.94>*METERS,
        <-2709.45, 14053.16>*METERS, <-2699.44, 14032.76>*METERS,
        <-2687.17, 13974.25>*METERS, <-2677.21, 13946.24>*METERS,
        <-2677.66, 13885.28>*METERS, <-2667.76, 13849.65>*METERS,
        <-2655.15, 13836.85>*METERS, <-2647.66, 13819.02>*METERS,
        <-2645.77, 13730.10>*METERS, <-2618.62, 13620.68>*METERS,
        <-2598.47, 13597.67>*METERS, <-2581.01, 13554.37>*METERS,
        <-2578.63, 13531.49>*METERS, <-2568.62, 13511.09>*METERS,
        <-2566.21, 13493.30>*METERS, <-2601.90, 13475.78>*METERS,
        <-2599.66, 13435.12>*METERS, <-2564.19, 13422.16>*METERS,
        <-2531.56, 13368.58>*METERS, <-2531.66, 13355.88>*METERS,
        <-2506.65, 13302.36>*METERS, <-2494.06, 13287.02>*METERS,
        <-2436.45, 13174.84>*METERS, <-2421.34, 13156.95>*METERS,
        <-2388.79, 13093.21>*METERS, <-2376.29, 13065.18>*METERS,
        <-2366.32, 13039.70>*METERS, <-2358.85, 13019.33>*METERS,
        <-2333.84, 12965.80>*METERS, <-2303.65, 12924.94>*METERS,
        <-2251.00, 12830.58>*METERS, <-2249.48, 12690.86>*METERS,
        <-2257.30, 12662.98>*METERS, <-2250.22, 12589.26>*METERS,
        <-2208.21, 12428.93>*METERS, <-2203.19, 12421.27>*METERS,
        <-2195.88, 12378.04>*METERS, <-2185.98, 12342.41>*METERS,
        <-2181.26, 12294.11>*METERS, <-2199.15, 12279.00>*METERS,
        <-2199.41, 12243.44>*METERS, <-2191.90, 12228.15>*METERS,
        <-2156.41, 12217.73>*METERS, <-2143.81, 12204.94>*METERS,
        <-2141.43, 12182.06>*METERS, <-2121.33, 12151.43>*METERS,
        <-2121.89, 12075.23>*METERS, <-2094.55, 11993.75>*METERS,
        <-2095.04, 11993.09>*METERS, <-2090.24, 11954.95>*METERS,
        <-2065.25, 11898.89>*METERS, <-2060.37, 11870.91>*METERS,
        <-2045.29, 11847.94>*METERS, <-2043.07, 11804.74>*METERS,
        <-2017.83, 11781.70>*METERS, <-2023.49, 11703.00>*METERS,
        <-1998.25, 11679.95>*METERS, <-1990.85, 11649.42>*METERS,
        <-2014.29, 11570.85>*METERS, <-2015.39, 11418.45>*METERS,
        <-1997.74, 11400.54>*METERS, <-1995.41, 11372.59>*METERS,
        <-2008.36, 11337.12>*METERS, <-2014.13, 11243.18>*METERS,
        <-1999.15, 11207.51>*METERS, <-1984.00, 11194.70>*METERS,
        <-1984.13, 11176.92>*METERS, <-2012.51, 11116.16>*METERS,
        <-2017.75, 11093.34>*METERS, <-2000.60, 11006.85>*METERS,
        <-2001.14, 10933.19>*METERS, <-2034.30, 10913.12>*METERS,
        <-2037.10, 10877.57>*METERS, <-2024.53, 10859.70>*METERS,
        <-2019.69, 10826.65>*METERS, <-2017.95, 10717.41>*METERS,
        <-2008.15, 10666.54>*METERS, <-1993.23, 10623.25>*METERS,
        <-1968.12, 10582.42>*METERS, <-1912.67, 10523.60>*METERS,
        <-1768.69, 10413.33>*METERS, <-1662.53, 10341.44>*METERS,
        <-1675.65, 10283.11>*METERS, <-1688.59, 10250.19>*METERS,
        <-1691.48, 10201.94>*METERS, <-1701.99, 10153.76>*METERS,
        <-1704.82, 10000.00>*METERS, <-6317.21, 10000.00>*METERS,
        <-6318.37, 10006.95>*METERS, <-6348.00, 10124.01>*METERS,
        <-6357.72, 10185.04>*METERS, <-6362.72, 10195.24>*METERS,
        <-6369.99, 10243.55>*METERS, <-6389.79, 10314.82>*METERS,
        <-6392.11, 10345.31>*METERS, <-6399.53, 10373.31>*METERS,
        <-6409.36, 10419.10>*METERS, <-6556.77, 11105.99>*METERS,
        <-6559.16, 11126.33>*METERS, <-6566.73, 11134.00>*METERS,
        <-6571.46, 11182.30>*METERS, <-6596.01, 11299.32>*METERS,
        <-6617.89, 11434.10>*METERS, <-6637.21, 11571.41>*METERS,
        <-6640.71, 11789.88>*METERS, <-6638.95, 12031.17>*METERS
        <-6638.46, 12032.00>*METERS, <-6619.93, 12481.46>*METERS,
        <-6600.95, 12994.41>*METERS, <-6593.18, 13362.67>*METERS,
        <-6577.24, 13807.06>*METERS, <-6575.03, 14109.31>*METERS,
        <-6564.09, 14215.92>*METERS, <-6558.64, 14614.67>*METERS,
        <-6545.59, 14662.83>*METERS, <-6535.04, 14716.10>*METERS,
        <-6542.46, 14744.09>*METERS, <-6554.99, 14767.05>*METERS,
        <-6567.39, 14807.78>*METERS, <-6564.46, 14861.10>*METERS,
        <-6556.73, 14876.28>*METERS, <-6552.49, 15000.00>*METERS,
        <-3053.23, 15000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // Land bounded by:
    // W bank of Chicago River from 5 km N to 10 km N of site,
    // and line 15 km W of site from 5 km N to 10 km N of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        76,
        <-6319.21, 10000.00>*METERS,
        <-6310.63, 9948.46>*METERS, <-6204.77, 9485.39>*METERS,
        <-6200.01, 9442.18>*METERS, <-6187.64, 9396.37>*METERS,
        <-6168.08, 9292.08>*METERS, <-6160.68, 9261.55>*METERS,
        <-6155.78, 9236.11>*METERS, <-6150.74, 9230.99>*METERS,
        <-6145.97, 9187.78>*METERS, <-6136.07, 9152.14>*METERS,
        <-6133.79, 9116.57>*METERS, <-6131.66, 9060.67>*METERS,
        <-6121.53, 9055.52>*METERS, <-6121.64, 9040.28>*METERS,
        <-6111.74, 9004.64>*METERS, <-6101.92, 8958.85>*METERS,
        <-6089.47, 8923.20>*METERS, <-6074.42, 8897.69>*METERS,
        <-6074.51, 8884.99>*METERS, <-5997.01, 8714.24>*METERS,
        <-5986.94, 8701.47>*METERS, <-5981.97, 8686.19>*METERS,
        <-5969.36, 8673.40>*METERS, <-5964.45, 8650.50>*METERS,
        <-5946.80, 8632.60>*METERS, <-5944.35, 8619.88>*METERS,
        <-5848.78, 8489.64>*METERS, <-5738.07, 8344.05>*METERS,
        <-5712.95, 8305.77>*METERS, <-5632.39, 8206.12>*METERS,
        <-5604.73, 8167.82>*METERS, <-5577.05, 8132.06>*METERS,
        <-5448.78, 7955.86>*METERS, <-5441.37, 7927.86>*METERS,
        <-5428.81, 7907.45>*METERS, <-5421.38, 7882.00>*METERS,
        <-5408.83, 7861.59>*METERS, <-5386.56, 7780.14>*METERS,
        <-5371.48, 7757.17>*METERS, <-5359.89, 7604.68>*METERS,
        <-5352.70, 7546.21>*METERS, <-5341.21, 7378.48>*METERS,
        <-5333.80, 7350.49>*METERS, <-5330.69, 7078.68>*METERS,
        <-5341.99, 6921.27>*METERS, <-5543.04, 6518.86>*METERS,
        <-5548.58, 6455.40>*METERS, <-5531.43, 6368.91>*METERS,
        <-5526.52, 6346.02>*METERS, <-5524.37, 6292.66>*METERS,
        <-5511.92, 6257.01>*METERS, <-5509.94, 6180.79>*METERS,
        <-5500.04, 6145.16>*METERS, <-5495.27, 6101.94>*METERS,
        <-5504.45, 6099.48>*METERS, <-5519.76, 6089.43>*METERS,
        <-5510.16, 6013.16>*METERS, <-5500.31, 5969.90>*METERS,
        <-5473.68, 5789.37>*METERS, <-5458.75, 5746.08>*METERS,
        <-5454.19, 5674.92>*METERS, <-5444.38, 5626.59>*METERS,
        <-5411.53, 5603.49>*METERS, <-5376.34, 5552.43>*METERS,
        <-5356.17, 5531.96>*METERS, <-5326.15, 5468.24>*METERS,
        <-5318.90, 5417.39>*METERS, <-5283.82, 5351.09>*METERS,
        <-5193.06, 5256.45>*METERS, <-5147.82, 5190.08>*METERS,
        <-5055.17, 5006.52>*METERS, <-5048.25, 5000.00>*METERS,
        <-15000.00, 5000.00>*METERS, <-15000.00, 10000.00>*METERS,
        <-6319.21, 10000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // Land bounded by:
    // Lake Michigan shoreline from 10 km N to 5 km N of site, and
    // E bank of Chicago River from 5 km N to 10 km N of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        259,
        <-1704.82, 10000.00>*METERS,
        <-1706.19, 9925.18>*METERS, <-1694.01, 9853.97>*METERS,
        <-1688.97, 9848.86>*METERS, <-1689.06, 9836.16>*METERS,
        <-1684.05, 9825.96>*METERS, <-1684.13, 9815.80>*METERS,
        <-1674.13, 9792.87>*METERS, <-1669.40, 9744.57>*METERS,
        <-1677.22, 9716.69>*METERS, <-1667.53, 9653.12>*METERS,
        <-1649.95, 9625.05>*METERS, <-1640.09, 9584.33>*METERS,
        <-1622.51, 9556.27>*METERS, <-1604.80, 9545.98>*METERS,
        <-1513.37, 9545.31>*METERS, <-1401.74, 9526.72>*METERS,
        <-1346.21, 9478.06>*METERS, <-1345.77, 9188.48>*METERS,
        <-1333.85, 9081.72>*METERS, <-1331.60, 9041.06>*METERS,
        <-1304.35, 8946.88>*METERS, <-1294.30, 8931.56>*METERS,
        <-1294.37, 8921.40>*METERS, <-1271.88, 8870.44>*METERS,
        <-1211.75, 8755.70>*METERS, <-1199.14, 8742.91>*METERS,
        <-1144.00, 8640.90>*METERS, <-1086.14, 8564.28>*METERS,
        <-985.39, 8446.71>*METERS, <-892.04, 8359.67>*METERS,
        <-818.73, 8310.87>*METERS, <-649.22, 8218.20>*METERS,
        <-502.42, 8146.01>*METERS, <-335.23, 8083.83>*METERS,
        <-249.16, 8042.57>*METERS, <-231.39, 8042.44>*METERS,
        <-185.41, 8077.66>*METERS, <-147.16, 8097.71>*METERS,
        <-137.13, 8079.85>*METERS, <-134.96, 8029.04>*METERS,
        <-115.36, 7929.83>*METERS, <-113.12, 7889.17>*METERS,
        <-120.88, 7868.91>*METERS, <-159.20, 7838.71>*METERS,
        <-248.43, 7793.63>*METERS, <-330.04, 7748.51>*METERS,
        <-419.61, 7657.71>*METERS, <-460.56, 7614.83>*METERS,
        <-478.54, 7587.02>*METERS, <-532.19, 7544.23>*METERS,
        <-606.07, 7514.28>*METERS, <-710.30, 7502.34>*METERS,
        <-837.10, 7531.20>*METERS, <-872.51, 7551.78>*METERS,
        <-895.16, 7579.89>*METERS, <-894.85, 7623.06>*METERS,
        <-856.59, 7645.65>*METERS, <-810.81, 7652.94>*METERS,
        <-729.79, 7616.79>*METERS, <-651.00, 7623.83>*METERS,
        <-597.53, 7641.23>*METERS, <-508.17, 7704.08>*METERS,
        <-459.41, 7772.31>*METERS, <-461.64, 7815.50>*METERS,
        <-481.68, 7853.75>*METERS, <-501.97, 7858.98>*METERS,
        <-562.91, 7861.96>*METERS, <-936.68, 7808.79>*METERS,
        <-974.95, 7786.21>*METERS, <-1000.75, 7730.52>*METERS,
        <-1001.12, 7679.72>*METERS, <-991.18, 7649.17>*METERS,
        <-948.43, 7590.43>*METERS, <-962.83, 7356.85>*METERS,
        <-953.11, 7295.82>*METERS, <-946.06, 7217.03>*METERS,
        <-936.49, 7135.67>*METERS, <-931.63, 7105.16>*METERS,
        <-921.82, 7056.82>*METERS, <-914.28, 7046.61>*METERS,
        <-907.08, 6988.14>*METERS, <-867.51, 6840.52>*METERS,
        <-862.47, 6835.41>*METERS, <-845.06, 6784.48>*METERS,
        <-842.65, 6766.68>*METERS, <-837.64, 6756.48>*METERS,
        <-810.37, 6664.84>*METERS, <-802.80, 6657.17>*METERS,
        <-802.88, 6647.01>*METERS, <-797.85, 6639.35>*METERS,
        <-792.99, 6608.84>*METERS, <-785.49, 6593.54>*METERS,
        <-773.19, 6537.57>*METERS, <-768.15, 6532.45>*METERS,
        <-765.68, 6522.28>*METERS, <-760.68, 6512.08>*METERS,
        <-760.77, 6499.38>*METERS, <-730.84, 6422.96>*METERS,
        <-728.45, 6402.62>*METERS, <-720.90, 6392.41>*METERS,
        <-716.03, 6364.43>*METERS, <-703.44, 6349.10>*METERS,
        <-701.08, 6323.68>*METERS, <-693.50, 6318.55>*METERS,
        <-693.59, 6305.85>*METERS, <-688.55, 6300.73>*METERS,
        <-688.66, 6285.49>*METERS, <-616.05, 6140.18>*METERS,
        <-593.49, 6099.37>*METERS, <-558.47, 6025.46>*METERS,
        <-513.30, 5948.93>*METERS, <-452.97, 5862.13>*METERS,
        <-334.62, 5719.02>*METERS, <-332.16, 5708.84>*METERS,
        <-301.92, 5675.60>*METERS, <-304.53, 5665.46>*METERS,
        <-294.43, 5657.77>*METERS, <-292.02, 5639.97>*METERS,
        <-284.43, 5634.83>*METERS, <-284.58, 5614.52>*METERS,
        <-294.83, 5601.89>*METERS, <-325.35, 5597.03>*METERS,
        <-352.83, 5660.73>*METERS, <-378.14, 5673.62>*METERS,
        <-408.58, 5678.92>*METERS, <-477.27, 5664.18>*METERS,
        <-497.51, 5674.48>*METERS, <-517.65, 5700.03>*METERS,
        <-520.06, 5717.83>*METERS, <-530.16, 5725.52>*METERS,
        <-530.02, 5745.84>*METERS, <-550.02, 5789.17>*METERS,
        <-557.40, 5822.24>*METERS, <-567.51, 5829.94>*METERS,
        <-577.32, 5878.27>*METERS, <-597.39, 5911.44>*METERS,
        <-647.66, 5985.46>*METERS, <-708.45, 6008.77>*METERS,
        <-746.35, 6036.98>*METERS, <-812.31, 6047.62>*METERS,
        <-837.64, 6057.96>*METERS, <-877.96, 6101.44>*METERS,
        <-898.02, 6137.15>*METERS, <-928.23, 6175.47>*METERS,
        <-986.48, 6198.75>*METERS, <-984.12, 6173.33>*METERS,
        <-843.14, 5999.58>*METERS, <-846.09, 5943.72>*METERS,
        <-848.77, 5923.42>*METERS, <-849.20, 5865.00>*METERS,
        <-841.73, 5844.63>*METERS, <-834.27, 5821.71>*METERS,
        <-819.18, 5801.28>*METERS, <-814.34, 5768.23>*METERS,
        <-796.67, 5752.86>*METERS, <-771.37, 5739.97>*METERS,
        <-741.20, 5696.57>*METERS, <-718.88, 5622.75>*METERS,
        <-706.86, 5528.68>*METERS, <-631.31, 5439.23>*METERS,
        <-581.21, 5342.34>*METERS, <-558.51, 5319.32>*METERS,
        <-543.31, 5314.13>*METERS, <-482.37, 5311.14>*METERS,
        <-444.20, 5321.03>*METERS, <-428.83, 5338.70>*METERS,
        <-387.01, 5500.96>*METERS, <-353.95, 5505.80>*METERS,
        <-336.29, 5490.43>*METERS, <-319.56, 5345.52>*METERS,
        <-304.63, 5302.23>*METERS, <-294.90, 5243.74>*METERS,
        <-287.35, 5233.52>*METERS, <-277.52, 5187.73>*METERS,
        <-224.92, 5085.75>*METERS, <-214.95, 5060.27>*METERS,
        <-207.35, 5057.68>*METERS, <-204.97, 5034.80>*METERS,
        <-199.95, 5027.14>*METERS, <-196.66, 5000.00>*METERS,
        <-4849.90, 5000.00>*METERS, <-4929.57, 5025.94>*METERS,
        <-4977.66, 5049.15>*METERS, <-5005.38, 5079.83>*METERS,
        <-5015.30, 5112.92>*METERS, <-5052.88, 5184.32>*METERS,
        <-5055.31, 5199.58>*METERS, <-5072.94, 5220.03>*METERS,
        <-5082.88, 5250.58>*METERS, <-5267.06, 5422.10>*METERS,
        <-5329.38, 5585.12>*METERS, <-5347.03, 5603.03>*METERS,
        <-5369.52, 5653.99>*METERS, <-5381.91, 5697.26>*METERS,
        <-5398.84, 5814.23>*METERS, <-5406.42, 5819.36>*METERS,
        <-5423.11, 5969.35>*METERS, <-5435.57, 6002.46>*METERS,
        <-5432.92, 6017.68>*METERS, <-5440.50, 6022.82>*METERS,
        <-5437.87, 6035.50>*METERS, <-5455.43, 6066.11>*METERS,
        <-5493.27, 6101.94>*METERS, <-5498.04, 6145.16>*METERS,
        <-5507.94, 6180.79>*METERS, <-5509.92, 6257.01>*METERS,
        <-5522.37, 6292.66>*METERS, <-5524.52, 6346.02>*METERS,
        <-5529.43, 6368.91>*METERS, <-5546.58, 6455.40>*METERS,
        <-5541.04, 6518.86>*METERS, <-5339.99, 6921.27>*METERS,
        <-5328.69, 7078.68>*METERS, <-5331.80, 7350.49>*METERS,
        <-5339.21, 7378.48>*METERS, <-5350.70, 7546.21>*METERS,
        <-5357.89, 7604.68>*METERS, <-5369.48, 7757.17>*METERS,
        <-5384.56, 7780.14>*METERS, <-5406.83, 7861.59>*METERS,
        <-5419.38, 7882.00>*METERS, <-5426.81, 7907.45>*METERS,
        <-5439.37, 7927.86>*METERS, <-5446.78, 7955.86>*METERS,
        <-5575.05, 8132.06>*METERS, <-5602.73, 8167.82>*METERS,
        <-5630.39, 8206.12>*METERS, <-5710.95, 8305.77>*METERS,
        <-5736.07, 8344.05>*METERS, <-5846.78, 8489.64>*METERS,
        <-5942.35, 8619.88>*METERS, <-5944.80, 8632.60>*METERS,
        <-5962.45, 8650.50>*METERS, <-5967.36, 8673.40>*METERS,
        <-5979.97, 8686.19>*METERS, <-5984.94, 8701.47>*METERS,
        <-5995.01, 8714.24>*METERS, <-6072.51, 8884.99>*METERS,
        <-6072.42, 8897.69>*METERS, <-6087.47, 8923.20>*METERS,
        <-6099.92, 8958.85>*METERS, <-6109.74, 9004.64>*METERS,
        <-6119.64, 9040.28>*METERS, <-6119.53, 9055.52>*METERS,
        <-6129.66, 9060.67>*METERS, <-6131.79, 9116.57>*METERS,
        <-6134.07, 9152.14>*METERS, <-6143.97, 9187.78>*METERS,
        <-6148.74, 9230.99>*METERS, <-6153.78, 9236.11>*METERS,
        <-6158.68, 9261.55>*METERS, <-6166.08, 9292.08>*METERS,
        <-6185.64, 9396.37>*METERS, <-6198.01, 9442.18>*METERS,
        <-6202.77, 9485.39>*METERS, <-6308.63, 9948.46>*METERS,
        <-6317.21, 10000.00>*METERS, <-1704.82, 10000.00>*METERS
    }

    // Land bounded by:
    // W bank of Chicago River from 5 km N to 1 km N of site,
    // and line 15 km W of site from 1 km N to 5 km N of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        84,
        <-15000.00, 5000.00>*METERS, <-5047.25, 5000.00>*METERS,
        <-5018.85, 4973.25>*METERS, <-4991.04, 4955.26>*METERS,
        <-4907.43, 4926.71>*METERS, <-4828.91, 4895.66>*METERS,
        <-4791.02, 4867.45>*METERS, <-4778.48, 4844.50>*METERS,
        <-4753.36, 4806.21>*METERS, <-4745.91, 4783.30>*METERS,
        <-4730.74, 4773.03>*METERS, <-4730.81, 4762.87>*METERS,
        <-4675.40, 4698.96>*METERS, <-4629.97, 4657.99>*METERS,
        <-4510.86, 4621.57>*METERS, <-4465.41, 4583.13>*METERS,
        <-4433.11, 4483.84>*METERS, <-4408.03, 4440.47>*METERS,
        <-4375.30, 4399.59>*METERS, <-4274.33, 4312.50>*METERS,
        <-4231.78, 4225.83>*METERS, <-4221.88, 4190.19>*METERS,
        <-4179.31, 4106.06>*METERS, <-4136.50, 4054.95>*METERS,
        <-4098.57, 4031.81>*METERS, <-4004.81, 4000.65>*METERS,
        <-3938.98, 3972.23>*METERS, <-3852.95, 3925.89>*METERS,
        <-3802.52, 3874.72>*METERS, <-3752.24, 3803.23>*METERS,
        <-3752.31, 3793.07>*METERS, <-3744.80, 3777.78>*METERS,
        <-3740.63, 3653.28>*METERS, <-3723.11, 3617.59>*METERS,
        <-3703.01, 3586.97>*METERS, <-3634.96, 3512.81>*METERS,
        <-3609.66, 3499.93>*METERS, <-3511.28, 3405.23>*METERS,
        <-3453.08, 3374.33>*METERS, <-3336.28, 3368.40>*METERS,
        <-3293.16, 3360.46>*METERS, <-3217.18, 3329.43>*METERS,
        <-3179.44, 3280.90>*METERS, <-3151.94, 3219.73>*METERS,
        <-2991.14, 2977.26>*METERS, <-2920.72, 2880.23>*METERS,
        <-2863.94, 2653.75>*METERS, <-2846.29, 2635.84>*METERS,
        <-2810.90, 2612.72>*METERS, <-2719.44, 2614.60>*METERS,
        <-2645.56, 2644.54>*METERS, <-2602.33, 2651.85>*METERS,
        <-2577.00, 2641.50>*METERS, <-2486.08, 2569.72>*METERS,
        <-2392.82, 2469.98>*METERS, <-2357.98, 2370.66>*METERS,
        <-2288.80, 2103.45>*METERS, <-2286.52, 2067.88>*METERS,
        <-2383.15, 2053.34>*METERS, <-2393.49, 2028.01>*METERS,
        <-2398.89, 1984.87>*METERS, <-2376.27, 1951.68>*METERS,
        <-2361.23, 1923.63>*METERS, <-2343.60, 1903.19>*METERS,
        <-2346.62, 1837.17>*METERS, <-2362.69, 1722.98>*METERS,
        <-2370.71, 1667.16>*METERS, <-2373.64, 1613.84>*METERS,
        <-2386.86, 1542.81>*METERS, <-2385.30, 1408.17>*METERS,
        <-2380.44, 1377.66>*METERS, <-2372.91, 1364.90>*METERS,
        <-2365.47, 1339.45>*METERS, <-2345.34, 1313.90>*METERS,
        <-2335.31, 1296.05>*METERS, <-2287.53, 1229.66>*METERS,
        <-2282.56, 1214.38>*METERS, <-2239.82, 1153.11>*METERS,
        <-2230.00, 1107.32>*METERS, <-2225.12, 1079.34>*METERS,
        <-2217.76, 1043.73>*METERS, <-2173.68, 1000.00>*METERS,
        <-15000.00, 1000.00>*METERS, <-15000.00, 5000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // Land bounded by:
    // Lake Michigan shoreline, from 5 km N to 1 km N of site,
    // and E bank of Chicago River from 1 km N to 5 km N of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        242,
        <-196.66, 5000.00>*METERS,
        <-190.08, 4986.43>*METERS, <-185.37, 4935.60>*METERS,
        <-163.18, 4843.99>*METERS, <-73.03, 4665.53>*METERS,
        <-65.48, 4655.32>*METERS, <-65.54, 4647.70>*METERS,
        <-60.51, 4640.04>*METERS, <-55.79, 4591.74>*METERS,
        <-137.47, 4536.46>*METERS, <-228.96, 4529.50>*METERS,
        <-246.59, 4549.95>*METERS, <-274.52, 4552.69>*METERS,
        <-325.28, 4558.14>*METERS, <-365.97, 4550.82>*METERS,
        <-409.35, 4523.19>*METERS, <-442.85, 4457.39>*METERS,
        <-440.94, 4371.02>*METERS, <-411.12, 4279.36>*METERS,
        <-408.62, 4274.26>*METERS, <-388.80, 4205.53>*METERS,
        <-381.42, 4172.46>*METERS, <-371.32, 4164.76>*METERS,
        <-361.47, 4121.51>*METERS, <-356.59, 4093.54>*METERS,
        <-351.53, 4090.96>*METERS, <-351.62, 4078.26>*METERS,
        <-346.58, 4073.14>*METERS, <-329.19, 4019.67>*METERS,
        <-324.44, 3973.92>*METERS, <-309.51, 3930.63>*METERS,
        <-271.78, 3879.55>*METERS, <-254.23, 3848.94>*METERS,
        <-234.42, 3777.68>*METERS, <-182.67, 3558.86>*METERS,
        <-177.63, 3553.74>*METERS, <-167.84, 3502.87>*METERS,
        <-162.81, 3495.21>*METERS, <-157.90, 3472.31>*METERS,
        <-150.32, 3467.18>*METERS, <-152.91, 3459.58>*METERS,
        <-142.83, 3449.34>*METERS, <-142.94, 3434.10>*METERS,
        <-133.00, 3403.55>*METERS, <-125.62, 3370.48>*METERS,
        <-123.13, 3362.84>*METERS, <-120.74, 3342.50>*METERS,
        <-110.90, 3299.25>*METERS, <-106.04, 3268.73>*METERS,
        <-73.81, 3159.27>*METERS, <-71.42, 3138.94>*METERS,
        <-63.87, 3128.72>*METERS, <-61.52, 3103.30>*METERS,
        <-56.47, 3098.19>*METERS, <-54.04, 3082.93>*METERS,
        <-51.58, 3072.75>*METERS, <-26.94, 2968.43>*METERS,
        <5.33, 2864.05>*METERS, <24.93, 2764.85>*METERS,
        <37.52, 2749.51>*METERS, <55.22, 2739.23>*METERS,
        <67.94, 2741.67>*METERS, <70.78, 2782.29>*METERS,
        <50.77, 2825.62>*METERS, <35.92, 2879.07>*METERS,
        <28.70, 2935.00>*METERS, <11.18, 2970.69>*METERS,
        <3.88, 3013.93>*METERS, <-1.17, 3019.04>*METERS,
        <-22.92, 3171.61>*METERS, <-30.41, 3189.44>*METERS,
        <-32.69, 3225.02>*METERS, <-49.86, 3308.96>*METERS,
        <-69.74, 3370.07>*METERS, <-92.29, 3413.42>*METERS,
        <-129.48, 3538.15>*METERS, <-136.88, 3568.68>*METERS,
        <-144.42, 3578.90>*METERS, <-161.61, 3660.31>*METERS,
        <-171.61, 3683.24>*METERS, <-181.45, 3726.49>*METERS,
        <-205.78, 3873.99>*METERS, <-212.59, 3985.81>*METERS,
        <-222.12, 4072.24>*METERS, <-238.70, 4237.46>*METERS,
        <-237.54, 4397.48>*METERS, <-234.54, 4460.96>*METERS,
        <-214.07, 4481.13>*METERS, <-148.00, 4485.73>*METERS,
        <-117.54, 4482.97>*METERS, <-97.38, 4459.96>*METERS,
        <-94.94, 4447.24>*METERS, <-100.94, 4320.28>*METERS,
        <-104.55, 4172.99>*METERS, <-92.31, 4109.40>*METERS,
        <-32.27, 3981.96>*METERS, <-4.67, 3936.03>*METERS,
        <10.13, 3874.97>*METERS, <12.21, 3811.45>*METERS,
        <-21.29, 3745.65>*METERS, <-29.13, 3715.23>*METERS,
        <-36.84, 3702.58>*METERS, <-22.60, 3565.31>*METERS,
        <10.05, 3514.28>*METERS, <27.77, 3506.53>*METERS,
        <73.11, 3452.86>*METERS, <72.96, 3432.54>*METERS,
        <39.57, 3381.98>*METERS, <49.21, 3310.79>*METERS,
        <69.29, 3277.62>*METERS, <84.22, 3234.33>*METERS,
        <73.91, 3214.08>*METERS, <68.52, 3170.94>*METERS,
        <78.59, 3158.17>*METERS, <81.07, 3150.53>*METERS,
        <121.10, 3066.42>*METERS, <118.38, 3041.04>*METERS,
        <105.57, 3025.89>*METERS, <105.36, 2997.95>*METERS,
        <115.37, 2977.56>*METERS, <132.90, 2941.87>*METERS,
        <150.53, 2921.42>*METERS, <168.05, 2885.73>*METERS,
        <160.28, 2865.47>*METERS, <154.98, 2835.02>*METERS,
        <175.06, 2801.86>*METERS, <215.39, 2758.38>*METERS,
        <232.94, 2727.77>*METERS, <237.71, 2684.56>*METERS,
        <272.94, 2638.58>*METERS, <315.82, 2597.63>*METERS,
        <391.58, 2536.12>*METERS, <497.70, 2459.14>*METERS,
        <538.14, 2430.91>*METERS, <619.19, 2399.84>*METERS,
        <657.25, 2394.48>*METERS, <700.56, 2411.95>*METERS,
        <748.99, 2434.46>*METERS, <779.73, 2469.80>*METERS,
        <800.08, 2474.73>*METERS, <802.31, 2431.53>*METERS,
        <779.13, 2388.52>*METERS, <748.36, 2348.10>*METERS,
        <725.43, 2338.11>*METERS, <651.66, 2323.40>*METERS,
        <564.99, 2280.85>*METERS, <508.74, 2230.46>*METERS,
        <452.42, 2169.90>*METERS, <431.71, 2116.71>*METERS,
        <421.05, 2048.21>*METERS, <403.00, 2010.24>*METERS,
        <387.65, 1995.11>*METERS, <371.74, 1903.78>*METERS,
        <386.82, 1880.81>*METERS, <401.59, 1817.20>*METERS,
        <406.34, 1771.45>*METERS, <418.49, 1695.16>*METERS,
        <430.47, 1596.01>*METERS, <457.23, 1433.25>*METERS,
        <469.26, 1341.72>*METERS, <519.67, 1288.01>*METERS,
        <574.93, 1201.25>*METERS, <584.83, 1165.61>*METERS,
        <589.52, 1112.24>*METERS, <800.15, 1085.31>*METERS,
        <833.08, 1072.37>*METERS, <886.14, 1033.88>*METERS,
        <993.53, 1000.00>*METERS, <-1399.66, 1000.00>*METERS,
        <-1613.93, 1295.89>*METERS, <-1621.16, 1349.28>*METERS,
        <-1688.95, 1459.00>*METERS, <-1739.45, 1500.01>*METERS,
        <-1739.36, 1512.71>*METERS, <-2083.44, 2051.16>*METERS,
        <-2215.33, 2077.52>*METERS, <-2222.88, 2087.73>*METERS,
        <-2222.71, 2110.59>*METERS, <-2227.73, 2118.25>*METERS,
        <-2237.54, 2166.58>*METERS, <-2245.09, 2176.80>*METERS,
        <-2252.43, 2214.95>*METERS, <-2304.46, 2395.68>*METERS,
        <-2316.96, 2423.71>*METERS, <-2316.88, 2433.87>*METERS,
        <-2367.04, 2523.13>*METERS, <-2546.15, 2692.08>*METERS,
        <-2589.17, 2715.25>*METERS, <-2642.64, 2697.86>*METERS,
        <-2729.33, 2652.77>*METERS, <-2772.49, 2655.62>*METERS,
        <-2792.71, 2668.47>*METERS, <-2817.91, 2696.59>*METERS,
        <-2830.42, 2722.09>*METERS, <-2857.44, 2849.29>*METERS,
        <-2887.40, 2920.62>*METERS, <-2907.54, 2946.17>*METERS,
        <-2962.90, 3017.70>*METERS, <-2990.45, 3071.24>*METERS,
        <-3003.01, 3091.65>*METERS, <-3030.54, 3147.73>*METERS,
        <-3103.51, 3242.24>*METERS, <-3161.12, 3354.43>*METERS,
        <-3176.19, 3377.40>*METERS, <-3234.37, 3410.84>*METERS,
        <-3330.72, 3434.40>*METERS, <-3467.83, 3443.02>*METERS,
        <-3508.28, 3468.71>*METERS, <-3682.00, 3680.80>*METERS,
        <-3694.30, 3736.77>*METERS, <-3699.07, 3779.98>*METERS,
        <-3711.40, 3830.88>*METERS, <-3716.40, 3841.07>*METERS,
        <-3721.24, 3874.13>*METERS, <-3738.86, 3897.12>*METERS,
        <-3794.35, 3950.86>*METERS, <-3908.07, 4030.43>*METERS,
        <-4128.49, 4108.23>*METERS, <-4148.59, 4138.86>*METERS,
        <-4158.44, 4182.11>*METERS, <-4163.48, 4187.23>*METERS,
        <-4170.77, 4233.00>*METERS, <-4185.62, 4286.45>*METERS,
        <-4187.98, 4311.87>*METERS, <-4207.93, 4362.82>*METERS,
        <-4207.74, 4388.22>*METERS, <-4220.16, 4426.41>*METERS,
        <-4232.70, 4449.36>*METERS, <-4341.64, 4488.25>*METERS,
        <-4351.69, 4503.57>*METERS, <-4356.60, 4526.46>*METERS,
        <-4409.26, 4620.83>*METERS, <-4439.40, 4666.77>*METERS,
        <-4566.25, 4688.01>*METERS, <-4632.00, 4729.13>*METERS,
        <-4672.30, 4775.14>*METERS, <-4760.21, 4912.94>*METERS,
        <-4767.64, 4938.40>*METERS, <-4805.44, 4979.32>*METERS,
        <-4840.87, 4997.35>*METERS, <-4849.90, 5000.00>*METERS,
        <-196.66, 5000.00>*METERS
    }

    // Land bounded by:
    // W bank of Chicago River from 1 km S to 1 km N of site,
    // and line 15 km W of site from 1 km N to 5 km N of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        31,
        <-15000.00, 1000.00>*METERS, <-2173.68, 1000.00>*METERS,
        <-2104.27, 931.14>*METERS, <-1853.26, 868.35>*METERS,
        <-1666.56, 694.27>*METERS, <-1316.60, 615.53>*METERS,
        <-1268.55, 587.24>*METERS, <-1253.47, 564.27>*METERS,
        <-1252.96, 284.86>*METERS, <-1230.34, 251.67>*METERS,
        <-1202.64, 218.45>*METERS, <-1200.18, 208.27>*METERS,
        <-1031.50, 1.30>*METERS, <-981.47, -105.75>*METERS,
        <-971.39, -115.98>*METERS, <-948.86, -161.86>*METERS,
        <-838.41, -343.01>*METERS, <-826.32, -426.92>*METERS,
        <-819.09, -480.32>*METERS, <-814.06, -487.97>*METERS,
        <-796.69, -543.98>*METERS, <-786.59, -551.67>*METERS,
        <-784.14, -564.39>*METERS, <-764.00, -589.94>*METERS,
        <-756.59, -617.93>*METERS, <-746.57, -638.33>*METERS,
        <-729.20, -694.33>*METERS, <-727.42, -798.49>*METERS,
        <-746.77, -1000.00>*METERS, <-15000.00, -1000.00>*METERS,
        <-15000.00, 1000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // island in Chicago River
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        44,
        <-1364.29, 694.62>*METERS, <-1567.32, 718.95>*METERS,
        <-1595.17, 731.86>*METERS, <-1751.54, 885.40>*METERS,
        <-1865.45, 939.57>*METERS, <-1938.94, 962.96>*METERS,
        <-2098.71, 997.14>*METERS, <-2124.00, 1012.57>*METERS,
        <-2146.68, 1038.13>*METERS, <-2176.84, 1081.53>*METERS,
        <-2206.47, 1198.59>*METERS, <-2226.46, 1244.46>*METERS,
        <-2291.74, 1349.07>*METERS, <-2321.82, 1405.17>*METERS,
        <-2321.74, 1415.33>*METERS, <-2331.79, 1430.65>*METERS,
        <-2331.05, 1532.24>*METERS, <-2316.10, 1842.02>*METERS,
        <-2297.97, 1890.15>*METERS, <-2282.60, 1907.82>*METERS,
        <-2175.85, 1917.21>*METERS, <-2170.37, 1973.05>*METERS,
        <-2160.04, 1995.84>*METERS, <-2129.41, 2015.93>*METERS,
        <-2109.09, 2015.79>*METERS, <-2066.40, 1949.43>*METERS,
        <-2053.94, 1916.32>*METERS, <-2023.75, 1875.46>*METERS,
        <-2006.19, 1844.85>*METERS, <-2003.82, 1821.98>*METERS,
        <-1973.65, 1778.58>*METERS, <-1677.50, 1286.19>*METERS,
        <-1614.65, 1196.83>*METERS, <-1523.91, 1099.65>*METERS,
        <-1518.96, 1081.83>*METERS, <-1428.24, 982.11>*METERS,
        <-1428.32, 971.95>*METERS, <-1415.73, 956.62>*METERS,
        <-1415.80, 946.46>*METERS, <-1375.83, 854.73>*METERS,
        <-1355.84, 808.86>*METERS, <-1336.20, 714.73>*METERS,
        <-1349.05, 694.51>*METERS, <-1364.29, 694.62>*METERS
    }

    // Land bounded by:
    // Lake Michigan shore, from 1 km N of site to mouth of Chicago River,
    // and E bank of Chicago River from lake to 1 km N of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        97
        <993.53, 1000.00>*METERS,
        <933.95, 972.57>*METERS, <938.85, 947.14>*METERS,
        <1038.99, 745.74>*METERS, <1041.40, 727.94>*METERS,
        <1066.50, 687.12>*METERS, <1096.49, 618.32>*METERS,
        <1139.06, 534.19>*METERS, <1186.56, 429.70>*METERS,
        <1284.12, 223.25>*METERS, <1296.67, 202.84>*METERS,
        <1301.64, 187.56>*METERS, <1326.67, 136.58>*METERS,
        <1354.54, 126.21>*METERS, <1407.90, 128.37>*METERS,
        <1446.14, 148.41>*METERS, <1484.67, 206.55>*METERS,
        <1484.83, 229.41>*METERS, <1582.68, 411.58>*METERS,
        <1600.83, 462.25>*METERS, <1618.70, 474.82>*METERS,
        <1697.45, 476.79>*METERS, <1771.06, 468.64>*METERS,
        <2076.02, 489.28>*METERS, <2261.38, 480.32>*METERS,
        <2258.83, 129.80>*METERS, <2251.17, 124.78>*METERS,
        <1798.99, 117.90>*METERS, <1669.40, 111.23>*METERS,
        <1666.32, 37.59>*METERS, <1671.26, 17.23>*METERS,
        <1744.90, 14.15>*METERS, <2316.46, 20.16>*METERS,
        <2585.69, 18.21>*METERS, <2584.99, -78.31>*METERS,
        <2369.04, -84.36>*METERS, <2363.83, -102.10>*METERS,
        <1698.16, -125.21>*METERS, <1675.23, -135.20>*METERS,
        <1671.54, -292.66>*METERS, <1514.05, -294.06>*METERS,
        <1508.99, -291.48>*METERS, <1492.21, -154.19>*METERS,
        <1403.29, -156.09>*METERS, <1403.29, -156.09>*METERS,
        <1022.30, -153.32>*METERS, <989.35, -142.92>*METERS,
        <958.91, -137.62>*METERS, <793.54, -174.52>*METERS,
        <783.25, -192.23>*METERS, <917.81, -200.82>*METERS,
        <1161.72, -192.44>*METERS, <1375.07, -193.99>*METERS,
        <1405.52, -199.29>*METERS, <1412.45, -293.32>*METERS,
        <1407.11, -328.84>*METERS, <1310.41, -353.54>*METERS,
        <1254.55, -350.59>*METERS, <1211.52, -329.96>*METERS,
        <1064.04, -351.75>*METERS, <957.34, -353.52>*METERS,
        <794.88, -339.63>*METERS, <528.52, -291.98>*METERS,
        <467.45, -306.78>*METERS, <370.95, -303.53>*METERS,
        <327.75, -305.76>*METERS, <284.39, -330.85>*METERS,
        <205.13, -401.39>*METERS, <136.22, -446.61>*METERS,
        <105.67, -456.55>*METERS, <-21.38, -463.25>*METERS,
        <-155.94, -454.65>*METERS, <-521.69, -451.99>*METERS,
        <-572.60, -466.87>*METERS, <-659.44, -532.28>*METERS,
        <-700.08, -531.98>*METERS, <-720.31, -519.13>*METERS,
        <-742.80, -468.17>*METERS, <-780.27, -381.53>*METERS,
        <-802.58, -305.17>*METERS, <-802.34, -272.15>*METERS,
        <-987.89, 59.41>*METERS, <-1171.93, 251.25>*METERS,
        <-1188.54, 411.39>*METERS, <-1194.74, 607.02>*METERS,
        <-1204.75, 627.42>*METERS, <-1234.88, 675.90>*METERS,
        <-1249.85, 714.11>*METERS, <-1287.56, 767.72>*METERS,
        <-1327.66, 841.68>*METERS, <-1335.02, 877.29>*METERS,
        <-1342.59, 884.97>*METERS, <-1342.48, 900.21>*METERS,
        <-1355.05, 918.08>*METERS, <-1362.45, 948.61>*METERS,
        <-1399.66, 1000.00>*METERS, <993.53, 1000.00>*METERS
    }

    // Land bounded by:
    // Lake Michigan shore, from mouth of Chicago River to 1 km S of site,
    // and E bank of Chicago River from 1 km S of site to Lake Michigan shore
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        35,
        <1317.26, -460.27>*METERS,
        <1329.86, -473.06>*METERS, <1329.50, -523.86>*METERS,
        <1338.90, -628.07>*METERS, <1337.77, -783.01>*METERS,
        <1329.91, -815.97>*METERS, <1317.01, -843.82>*METERS,
        <1263.38, -884.07>*METERS, <1252.79, -942.42>*METERS,
        <1107.94, -951.53>*METERS, <1105.16, -1000.00>*METERS,
        <-694.85, -1000.00>*METERS, <-687.65, -918.16>*METERS,
        <-671.82, -837.00>*METERS, <-671.32, -768.42>*METERS,
        <-658.17, -707.55>*METERS, <-652.76, -661.87>*METERS,
        <-642.44, -639.08>*METERS, <-616.89, -618.95>*METERS,
        <-616.89, -618.95>*METERS, <-540.18, -548.38>*METERS,
        <-517.22, -535.85>*METERS, <-433.33, -526.30>*METERS,
        <148.37, -522.90>*METERS, <191.71, -500.36>*METERS,
        <268.47, -424.71>*METERS, <299.09, -404.62>*METERS,
        <355.17, -377.08>*METERS, <370.40, -379.73>*METERS,
        <548.30, -365.78>*METERS, <888.30, -416.52>*METERS,
        <1109.30, -415.58>*METERS, <1228.60, -426.61>*METERS,
        <1302.13, -444.92>*METERS, <1317.26, -460.27>*METERS
    }

    // Land bounded by:
    // W bank of Chicago River from 1 km S to 4 km S of site,
    // and line 15 km W of site from 4 km S to 1 km S of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        34,
        <-15000.00, -1000.00>*METERS,
        <-746.77, -1000.00>*METERS, <-757.64, -1113.24>*METERS,
        <-760.89, -1209.74>*METERS, <-739.61, -1428.34>*METERS,
        <-727.34, -1486.85>*METERS, <-724.98, -1512.27>*METERS,
        <-714.90, -1522.50>*METERS, <-705.70, -1654.65>*METERS,
        <-698.32, -1687.73>*METERS, <-648.42, -1812.55>*METERS,
        <-588.07, -1896.81>*METERS, <-583.10, -1912.09>*METERS,
        <-565.67, -1960.48>*METERS, <-541.25, -2095.28>*METERS,
        <-507.37, -2326.67>*METERS, <-495.00, -2372.48>*METERS,
        <-488.03, -2461.44>*METERS, <-478.35, -2527.55>*METERS,
        <-473.84, -2606.32>*METERS, <-459.21, -2690.25>*METERS,
        <-454.64, -3109.40>*METERS, <-462.46, -3137.28>*METERS,
        <-470.63, -3213.42>*METERS, <-473.69, -3635.05>*METERS,
        <-478.90, -3652.80>*METERS, <-491.82, -3683.18>*METERS,
        <-536.07, -3830.19>*METERS, <-582.40, -3913.67>*METERS,
        <-597.81, -3936.42>*METERS, <-651.53, -3989.37>*METERS,
        <-665.92, -4000.00>*METERS, <-15000.00, -4000.00>*METERS,
        <-15000.00, -1000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }


    // Lake Chicago shore from 1 km S to 5 km S of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        124,
        <1105.16, -1000.00>*METERS,
        <1096.31, -1154.65>*METERS, <1101.29, -1167.38>*METERS,
        <1139.30, -1180.36>*METERS, <1141.25, -1261.66>*METERS,
        <1092.90, -1274.01>*METERS, <1087.75, -1284.13>*METERS,
        <1094.41, -1416.26>*METERS, <1083.69, -1492.39>*METERS,
        <1094.81, -1710.91>*METERS, <1083.21, -1908.95>*METERS,
        <1113.73, -2602.62>*METERS, <1164.18, -2651.24>*METERS,
        <1230.09, -2669.50>*METERS, <1275.88, -2659.67>*METERS,
        <1324.18, -2654.95>*METERS, <1374.72, -2690.87>*METERS,
        <1369.08, -2767.03>*METERS, <1343.30, -2820.19>*METERS,
        <1767.54, -2813.11>*METERS, <1851.67, -2770.54>*METERS,
        <1917.58, -2788.80>*METERS, <1978.32, -2819.72>*METERS,
        <1980.43, -2878.16>*METERS, <1936.70, -2954.04>*METERS,
        <1926.04, -3022.55>*METERS, <1867.66, -3017.04>*METERS,
        <1819.22, -3042.09>*METERS, <1803.63, -3090.24>*METERS,
        <1815.76, -3169.07>*METERS, <1848.00, -3275.99>*METERS,
        <1920.90, -3380.66>*METERS, <1929.73, -3563.61>*METERS,
        <1835.63, -3580.71>*METERS, <1876.11, -4302.38>*METERS,
        <1680.47, -4308.58>*METERS, <1622.28, -4277.68>*METERS,
        <1622.54, -4242.12>*METERS, <1668.09, -3914.78>*METERS,
        <1615.42, -3822.95>*METERS, <1616.08, -3731.52>*METERS,
        <1573.61, -3634.68>*METERS, <1584.14, -3583.96>*METERS,
        <1551.54, -3525.30>*METERS, <1579.77, -3484.87>*METERS,
        <1582.85, -3411.23>*METERS, <1621.87, -3284.51>*METERS,
        <1635.84, -3109.34>*METERS, <1578.48, -2964.14>*METERS,
        <1568.67, -2915.81>*METERS, <1388.35, -2911.96>*METERS,
        <1369.72, -3028.67>*METERS, <1338.51, -3130.04>*METERS,
        <1337.90, -3213.86>*METERS, <1402.55, -3404.84>*METERS,
        <1410.61, -3694.46>*METERS, <1356.83, -3755.03>*METERS,
        <1348.54, -3846.42>*METERS, <1385.46, -4009.25>*METERS,
        <1498.82, -4139.62>*METERS, <1518.18, -4271.84>*METERS,
        <1570.59, -4399.22>*METERS, <1655.73, -4567.49>*METERS,
        <1660.04, -4674.20>*METERS, <1636.13, -4818.81>*METERS,
        <1659.87, -5000.00>*METERS, <-2467.03, -5000.00>*METERS,
        <-2431.59, -4964.53>*METERS, <-2326.99, -4901.79>*METERS,
        <-2263.40, -4889.55>*METERS, <-2156.72, -4890.32>*METERS,
        <-2034.95, -4911.53>*METERS, <-1948.48, -4896.92>*METERS,
        <-1790.77, -4865.04>*METERS, <-1684.01, -4855.66>*METERS,
        <-1612.73, -4833.31>*METERS, <-1470.05, -4773.39>*METERS,
        <-1414.08, -4761.09>*METERS, <-1172.58, -4734.91>*METERS,
        <-1134.36, -4717.41>*METERS, <-1078.11, -4667.01>*METERS,
        <-1044.76, -4621.53>*METERS, <-815.55, -4188.85>*METERS,
        <-759.35, -4146.07>*METERS, <-695.58, -4108.44>*METERS,
        <-639.37, -4063.12>*METERS, <-598.36, -4012.62>*METERS,
        <-501.07, -3906.64>*METERS, <-479.81, -3777.25>*METERS,
        <-425.84, -3691.28>*METERS, <-407.91, -3671.09>*METERS,
        <-400.58, -3361.26>*METERS, <-414.05, -2766.78>*METERS,
        <-423.87, -2720.99>*METERS, <-425.86, -2644.77>*METERS,
        <-433.09, -2591.38>*METERS, <-429.56, -2454.24>*METERS,
        <-444.67, -2436.35>*METERS, <-464.21, -2329.53>*METERS,
        <-471.20, -2243.11>*METERS, <-490.80, -2143.91>*METERS,
        <-490.45, -2095.65>*METERS, <-500.50, -2080.33>*METERS,
        <-500.23, -2042.24>*METERS, <-524.81, -1930.29>*METERS,
        <-529.87, -1927.72>*METERS, <-527.11, -1897.26>*METERS,
        <-567.25, -1828.38>*METERS, <-574.84, -1823.25>*METERS,
        <-584.81, -1797.77>*METERS, <-644.98, -1688.11>*METERS,
        <-662.35, -1632.11>*METERS, <-666.97, -1568.57>*METERS,
        <-674.52, -1558.36>*METERS, <-674.15, -1507.56>*METERS,
        <-684.21, -1494.78>*METERS, <-683.88, -1449.06>*METERS,
        <-693.93, -1433.75>*METERS, <-693.64, -1393.11>*METERS,
        <-703.44, -1344.78>*METERS, <-715.44, -1248.17>*METERS,
        <-701.49, -1075.55>*METERS, <-694.85, -1000.00>*METERS,
        <1105.16, -1000.00>*METERS
    }

    // Land bounded by:
    // W bank of Chicago River from 4 km S to 8 km S of site,
    // and line 15 km W of site from 8 km S to 4 km S of site.
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        122,
        <-15000.00, -4000.00>*METERS, <-665.92, -4000.00>*METERS,
        <-845.62, -4132.75>*METERS, <-889.37, -4211.17>*METERS,
        <-930.47, -4274.37>*METERS, <-1036.08, -4476.81>*METERS,
        <-1102.93, -4588.09>*METERS, <-1161.74, -4641.00>*METERS,
        <-1210.20, -4668.59>*METERS, <-1276.39, -4688.43>*METERS,
        <-1400.94, -4700.23>*METERS, <-1561.34, -4752.41>*METERS,
        <-1683.54, -4789.62>*METERS, <-1780.18, -4806.70>*METERS,
        <-1841.14, -4806.25>*METERS, <-1866.41, -4788.29>*METERS,
        <-1883.82, -4737.36>*METERS, <-1883.34, -4671.32>*METERS,
        <-1890.80, -4648.41>*METERS, <-1913.43, -4617.76>*METERS,
        <-1915.84, -4599.97>*METERS, <-1931.01, -4589.70>*METERS,
        <-1948.79, -4589.57>*METERS, <-1949.23, -4650.52>*METERS,
        <-1929.82, -4775.13>*METERS, <-1930.28, -4838.63>*METERS,
        <-2090.33, -4842.55>*METERS, <-2156.28, -4829.37>*METERS,
        <-2189.15, -4808.81>*METERS, <-2285.57, -4795.41>*METERS,
        <-2303.19, -4772.42>*METERS, <-2320.99, -4774.83>*METERS,
        <-2336.58, -4822.98>*METERS, <-2446.33, -4895.84>*METERS,
        <-2466.76, -4910.93>*METERS, <-2499.87, -4923.39>*METERS,
        <-2509.94, -4910.62>*METERS, <-2519.99, -4895.31>*METERS,
        <-2518.51, -4692.11>*METERS, <-2526.00, -4674.28>*METERS,
        <-2551.36, -4669.01>*METERS, <-2559.04, -4676.58>*METERS,
        <-2563.90, -4996.59>*METERS, <-2604.89, -5044.55>*METERS,
        <-2691.80, -5120.12>*METERS, <-2719.84, -5132.62>*METERS,
        <-2719.99, -4454.42>*METERS, <-2735.16, -4444.15>*METERS,
        <-2750.36, -4438.96>*METERS, <-2775.89, -4456.55>*METERS,
        <-2780.96, -5155.04>*METERS, <-2814.22, -5187.82>*METERS,
        <-2882.89, -5200.02>*METERS, <-2905.66, -5187.15>*METERS,
        <-2913.09, -5161.70>*METERS, <-2922.86, -4757.76>*METERS,
        <-2935.47, -4744.96>*METERS, <-2968.49, -4744.72>*METERS,
        <-2976.16, -4752.29>*METERS, <-2974.95, -4935.18>*METERS,
        <-2970.00, -4953.00>*METERS, <-2965.31, -5006.37>*METERS,
        <-2960.39, -5029.27>*METERS, <-2953.62, -5146.16>*METERS,
        <-2964.04, -5181.65>*METERS, <-2981.87, -5189.14>*METERS,
        <-3106.28, -5180.62>*METERS, <-3167.23, -5180.17>*METERS,
        <-3312.36, -5227.38>*METERS, <-3633.56, -5385.07>*METERS,
        <-3730.46, -5437.71>*METERS, <-3755.92, -5445.14>*METERS,
        <-3765.93, -5424.75>*METERS, <-3768.22, -5041.18>*METERS,
        <-3813.92, -5038.31>*METERS, <-3815.88, -5307.54>*METERS,
        <-3809.44, -5470.16>*METERS, <-3824.81, -5487.82>*METERS,
        <-3886.06, -5528.02>*METERS, <-3926.74, -5532.81>*METERS,
        <-3956.99, -5502.10>*METERS, <-3982.43, -5507.00>*METERS,
        <-4022.92, -5486.39>*METERS, <-4050.79, -5476.02>*METERS,
        <-4068.57, -5475.89>*METERS, <-4073.94, -5516.50>*METERS,
        <-4054.14, -5587.76>*METERS, <-4054.53, -5641.10>*METERS,
        <-4064.89, -5668.97>*METERS, <-4077.76, -5691.73>*METERS,
        <-4467.57, -5854.01>*METERS, <-5224.34, -6181.26>*METERS,
        <-5965.61, -6470.52>*METERS, <-6021.60, -6485.36>*METERS,
        <-6029.14, -6475.14>*METERS, <-6026.13, -6061.13>*METERS,
        <-6087.07, -6058.15>*METERS, <-6093.03, -6528.02>*METERS,
        <-6709.67, -6795.33>*METERS, <-7275.19, -7019.83>*METERS,
        <-7619.12, -7159.57>*METERS, <-7669.97, -7166.82>*METERS,
        <-7702.90, -7153.88>*METERS, <-7738.18, -7115.53>*METERS,
        <-7771.15, -7107.67>*METERS, <-7794.01, -7107.50>*METERS,
        <-7801.75, -7125.22>*METERS, <-7784.23, -7160.91>*METERS,
        <-7766.58, -7178.82>*METERS, <-7764.19, -7199.16>*METERS,
        <-7774.46, -7214.32>*METERS, <-7815.17, -7224.19>*METERS,
        <-7825.26, -7213.96>*METERS, <-7825.15, -7198.72>*METERS,
        <-7852.85, -7165.49>*METERS, <-7868.12, -7170.46>*METERS,
        <-7876.24, -7238.99>*METERS, <-7889.07, -7256.67>*METERS,
        <-8872.51, -7666.10>*METERS, <-9677.35, -8000.00>*METERS,
        <-15000.00, -8000.00>*METERS, <-15000.00, -4000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // Land bounded by:
    // Lake Michigan shore, from 5 km S to 10 km S of site, and
    // S bank of Chicago River from 10 km S to 5 km S of site
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        141,
        <1659.87, -5000.00>*METERS,
        <1660.89, -5255.88>*METERS, <1667.61, -5380.40>*METERS,
        <1722.60, -5502.72>*METERS, <1742.18, -5604.47>*METERS,
        <1794.51, -5744.55>*METERS, <1886.92, -5961.13>*METERS,
        <1898.71, -6085.68>*METERS, <1925.84, -6197.64>*METERS,
        <1995.92, -6340.39>*METERS, <1977.35, -6449.48>*METERS,
        <2037.50, -6561.68>*METERS, <2141.47, -6585.29>*METERS,
        <2169.15, -6621.06>*METERS, <2168.10, -6765.83>*METERS,
        <2230.64, -6898.37>*METERS, <2309.78, -7193.59>*METERS,
        <2413.36, -7270.55>*METERS, <2506.66, -7365.21>*METERS,
        <2525.79, -7527.91>*METERS, <2608.69, -7655.52>*METERS,
        <2826.56, -8083.83>*METERS, <3000.82, -8222.26>*METERS,
        <3017.94, -8313.83>*METERS, <3195.47, -8701.21>*METERS,
        <3273.58, -8788.14>*METERS, <3331.28, -8887.62>*METERS,
        <3364.17, -8905.64>*METERS, <3422.46, -8923.84>*METERS,
        <3459.80, -9028.26>*METERS, <3479.53, -9109.68>*METERS,
        <3559.70, -9262.67>*METERS, <3594.39, -9382.31>*METERS,
        <3647.03, -9479.21>*METERS, <3901.65, -9745.23>*METERS,
        <4028.07, -9824.89>*METERS, <4010.11, -10000.00>*METERS,
        <-14374.68, -10000.00>*METERS, <-14238.93, -9941.31>*METERS,
        <-13175.44, -9522.85>*METERS, <-12308.24, -9173.51>*METERS,
        <-10538.00, -8447.25>*METERS, <-10208.73, -8290.57>*METERS,
        <-10068.46, -8236.11>*METERS, <-8998.15, -7827.75>*METERS,
        <-7841.46, -7345.92>*METERS, <-7288.67, -7126.41>*METERS,
        <-5349.71, -6304.81>*METERS, <-4740.70, -6039.99>*METERS,
        <-4050.20, -5745.27>*METERS, <-3945.44, -5659.67>*METERS,
        <-3884.22, -5624.56>*METERS, <-3833.41, -5622.39>*METERS,
        <-3813.12, -5627.61>*METERS, <-3780.32, -5658.33>*METERS,
        <-3754.91, -5655.98>*METERS, <-3693.19, -5552.28>*METERS,
        <-3659.67, -5483.94>*METERS, <-3634.07, -5456.19>*METERS,
        <-3590.78, -5441.26>*METERS, <-3560.34, -5446.56>*METERS,
        <-3556.98, -5682.82>*METERS, <-3531.60, -5685.54>*METERS,
        <-3490.81, -5665.52>*METERS, <-3486.15, -5373.44>*METERS,
        <-3320.50, -5298.44>*METERS, <-3139.76, -5243.87>*METERS,
        <-3038.16, -5244.61>*METERS, <-3030.63, -5257.37>*METERS,
        <-3021.50, -5399.68>*METERS, <-2965.94, -5443.26>*METERS,
        <-2973.80, -5476.23>*METERS, <-2999.55, -5524.30>*METERS,
        <-3020.22, -5572.41>*METERS, <-3015.31, -5595.31>*METERS,
        <-2982.86, -5674.29>*METERS, <-2975.44, -5702.28>*METERS,
        <-2966.28, -5839.51>*METERS, <-2898.62, -5967.01>*METERS,
        <-2846.30, -6107.09>*METERS, <-2813.67, -6160.67>*METERS,
        <-2786.13, -6216.75>*METERS, <-2725.76, -6298.47>*METERS,
        <-2599.78, -6439.09>*METERS, <-2534.33, -6520.85>*METERS,
        <-2388.59, -6737.81>*METERS, <-2388.79, -6765.75>*METERS,
        <-2378.70, -6775.99>*METERS, <-2384.71, -6902.95>*METERS,
        <-2392.55, -6933.37>*METERS, <-2393.14, -7014.65>*METERS,
        <-2401.13, -7065.39>*METERS, <-2393.78, -7103.55>*METERS,
        <-2391.89, -7192.46>*METERS, <-2384.56, -7233.16>*METERS,
        <-2390.03, -7286.46>*METERS, <-2438.46, -7308.97>*METERS,
        <-2451.29, -7326.65>*METERS, <-2448.97, -7357.15>*METERS,
        <-2431.28, -7369.98>*METERS, <-2375.42, -7372.93>*METERS,
        <-2368.35, -7449.18>*METERS, <-2355.76, -7464.51>*METERS,
        <-2337.93, -7457.02>*METERS, <-2329.41, -7332.62>*METERS,
        <-2339.16, -7276.67>*METERS, <-2349.87, -7002.26>*METERS,
        <-2347.18, -6981.96>*METERS, <-2344.18, -6918.48>*METERS,
        <-2333.67, -6870.30>*METERS, <-2335.27, -6740.74>*METERS,
        <-2372.87, -6671.88>*METERS, <-2490.97, -6495.76>*METERS,
        <-2500.96, -6472.83>*METERS, <-2521.01, -6434.58>*METERS,
        <-2609.13, -6327.26>*METERS, <-2626.87, -6322.05>*METERS,
        <-2662.40, -6316.71>*METERS, <-2682.55, -6293.70>*METERS,
        <-2692.54, -6270.77>*METERS, <-2765.43, -6163.56>*METERS,
        <-2798.06, -6109.98>*METERS, <-2825.61, -6056.44>*METERS,
        <-2830.32, -6005.60>*METERS, <-2845.30, -5969.93>*METERS,
        <-2867.87, -5929.13>*METERS, <-2870.30, -5913.87>*METERS,
        <-2887.87, -5885.80>*METERS, <-2907.90, -5845.02>*METERS,
        <-2910.31, -5827.22>*METERS, <-2917.87, -5819.54>*METERS,
        <-2922.79, -5796.65>*METERS, <-2922.08, -5700.13>*METERS,
        <-2951.86, -5603.39>*METERS, <-2951.57, -5562.75>*METERS,
        <-2874.15, -5395.67>*METERS, <-2845.57, -5306.97>*METERS,
        <-2814.87, -5276.71>*METERS, <-2597.90, -5130.97>*METERS,
        <-2467.03, -5000.00>*METERS, <1659.87, -5000.00>*METERS
    }

    // Land bounded by:
    // Line 15 km W of site from N bank of Chicago River to 8 km S of site,
    // and N bank of Chicago River,
    // and line 8 km S of site from 15 km W of site to N bank of Chicago River
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        15,
        <-15000.00, -10359.54>*METERS, <-14987.35, -10350.28>*METERS,
        <-14920.69, -10290.00>*METERS, <-14869.61, -10262.58>*METERS,
        <-14795.59, -10227.77>*METERS, <-14468.55, -10040.58>*METERS,
        <-14238.93, -9941.31>*METERS, <-13175.44, -9522.85>*METERS,
        <-12308.24, -9173.51>*METERS, <-10538.00, -8447.25>*METERS,
        <-10208.73, -8290.57>*METERS, <-10068.46, -8236.11>*METERS,
        <-9677.35, -8000.00>*METERS, <-15000.00, -8000.00>*METERS,
        <-15000.00, -10359.54>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }

    // Land bounded by:
    // Lake Michigan shore, from 10 km S to 15 km S of site, and
    // line 15 km S of site from 15 km W of site to S bank of Chicago River,
    // and S bank of Chicago River from 15 km S of site to 10 km S of site,
    // and line 10 km S of site from S bank of Chicago River to
    //   Lake Michigan shore
    prism
    {
        linear_spline linear_sweep
        -4*METERS, -0.1*METERS,
        116,
        <4010.11, -10000.00>*METERS,
        <3989.80, -10198.00>*METERS, <4081.62, -10495.86>*METERS,
        <4243.47, -10593.56>*METERS, <4410.98, -10612.55>*METERS,
        <4448.69, -10666.17>*METERS, <4420.33, -10724.38>*METERS,
        <4374.20, -10779.93>*METERS, <4155.23, -10852.00>*METERS,
        <4134.60, -10895.03>*METERS, <4134.60, -10895.03>*METERS,
        <4098.45, -10976.05>*METERS, <4074.62, -11110.50>*METERS,
        <4230.01, -11398.66>*METERS, <4295.31, -11500.74>*METERS,
        <4140.09, -11537.71>*METERS, <4068.88, -11549.89>*METERS,
        <4012.49, -11620.61>*METERS, <3941.06, -11663.27>*METERS,
        <3860.24, -11599.18>*METERS, <3833.33, -11456.74>*METERS,
        <3907.14, -11436.96>*METERS, <3937.91, -11396.54>*METERS,
        <3907.78, -11348.06>*METERS, <3803.46, -11372.70>*METERS,
        <3696.80, -11369.39>*METERS, <3663.10, -11463.12>*METERS,
        <3723.88, -11488.97>*METERS, <3774.40, -11527.43>*METERS,
        <3771.40, -11590.91>*METERS, <3725.71, -11585.50>*METERS,
        <3677.46, -11585.15>*METERS, <3671.42, -11717.19>*METERS,
        <3704.84, -12012.08>*METERS, <3728.30, -12278.96>*METERS,
        <3758.59, -12304.58>*METERS, <3972.46, -12235.01>*METERS,
        <4003.22, -12197.14>*METERS, <4023.98, -12136.32>*METERS,
        <4031.73, -12118.60>*METERS, <4084.98, -12131.69>*METERS,
        <4133.55, -12088.86>*METERS, <4110.99, -12048.05>*METERS,
        <4057.92, -12009.57>*METERS, <3988.89, -11722.04>*METERS,
        <4022.06, -11701.96>*METERS, <4080.68, -11674.44>*METERS,
        <4131.59, -11659.57>*METERS, <4167.66, -11588.71>*METERS,
        <4274.38, -11584.41>*METERS, <4305.07, -11904.68>*METERS,
        <4372.64, -12044.87>*METERS, <4460.89, -12134.42>*METERS,
        <4632.77, -12249.97>*METERS, <4891.40, -12312.81>*METERS,
        <4605.95, -12445.36>*METERS, <4593.00, -12480.83>*METERS,
        <4485.71, -12563.87>*METERS, <4418.73, -12692.93>*METERS,
        <4457.95, -12888.80>*METERS, <4394.40, -12895.96>*METERS,
        <4319.25, -12750.63>*METERS, <4281.96, -12638.59>*METERS,
        <4346.55, -12489.20>*METERS, <4339.11, -12463.74>*METERS,
        <4301.27, -12427.91>*METERS, <4104.90, -12535.70>*METERS,
        <4137.09, -12650.24>*METERS, <4154.12, -12754.51>*METERS,
        <4186.75, -12808.09>*METERS, <4201.53, -12871.70>*METERS,
        <4264.78, -12905.18>*METERS, <4386.42, -12944.16>*METERS,
        <4477.94, -12934.67>*METERS, <4699.13, -12905.79>*METERS,
        <4684.89, -12768.52>*METERS, <4636.65, -12765.63>*METERS,
        <4601.77, -12671.40>*METERS, <4597.45, -12567.22>*METERS,
        <4645.76, -12559.95>*METERS, <4948.53, -12841.56>*METERS,
        <5121.75, -13122.23>*METERS, <5179.73, -13183.61>*METERS,
        <5177.06, -13201.37>*METERS, <5293.23, -13293.66>*METERS,
        <5358.81, -13357.64>*METERS, <5414.71, -13355.50>*METERS,
        <5408.63, -13492.62>*METERS, <5470.89, -13663.26>*METERS,
        <5696.37, -13743.64>*METERS, <5717.04, -13695.53>*METERS,
        <5715.27, -13939.36>*METERS, <5633.39, -14022.59>*METERS,
        <5625.38, -14075.87>*METERS, <5720.90, -14213.73>*METERS,
        <5983.12, -14482.34>*METERS, <6041.31, -14513.25>*METERS,
        <6172.36, -14656.44>*METERS, <6349.01, -14815.21>*METERS,
        <6605.10, -14878.03>*METERS, <6892.33, -14849.64>*METERS,
        <7073.33, -14759.51>*METERS, <7131.29, -14823.43>*METERS,
        <7118.50, -14836.04>*METERS, <7214.08, -14966.28>*METERS,
        <7247.17, -14956.36>*METERS, <7271.98, -15000.00>*METERS,
        <-15000.00, -15000.00>*METERS, <-15000.00, -10359.54>*METERS,
        <-14987.35, -10350.28>*METERS, <-14920.69, -10290.00>*METERS,
        <-14869.61, -10262.58>*METERS, <-14795.59, -10227.77>*METERS,
        <-14468.55, -10040.58>*METERS, <-14374.68, -10000.00>*METERS,
        <4010.11, -10000.00>*METERS

        clipped_by
        { cylinder { < 0, -5, 0 >*METERS < 0, 0, 0 >*METERS 15000*METERS } }

    }
    
}
