#if (d_Wheel > 1)
#declare T_Wheel_Black =
texture {
	pigment { color rgb <0.03,0.02,0.04> }
	finish {
    phong 0.9
    phong_size 60
  }
	normal {dents 0.5 }
	scale 0.3
}
#else
#declare T_Wheel_Black =
texture { pigment { Black }  }
#end

#declare Spoke_Gusset =
difference {
	box { <0,0,-2><3,3,2> }
	cylinder { <3,2.95,-5><3,2.95,5> 3 }
}

#declare Spoke =
union {
	box { <-1.0,0,-2><1.0,26,2> }
	object { Spoke_Gusset translate <1,8,0> }
	object { Spoke_Gusset rotate 180*y translate <-1,8,0> }
	object { Spoke_Gusset rotate <180,0,0> scale <1.5,1.1,1> translate <1,24.5,0> }
	object { Spoke_Gusset rotate <180,180,0> scale <1.5,1.1,1> translate <-1,24.5,0> }
	scale <1.3,1,1>
}

#declare Wheel_Plate =
union {
	cylinder { <0,0,-1><0,0,1> 27.5
	clipped_by { plane {-x,0} }
	clipped_by { plane {x,0} rotate -90*z }
	}
	union {
		cylinder { <0,0,-1.3><0,0,1.3> 1.5
		 	texture {
				pigment { Black }
			}
		}
		cylinder { <0,0,-1.7><0,0,1.7> 0.8
	  	texture {
				pigment { Gray10 }
				finish { Dull }
			}
		}
		translate <15,15,0>
	}
	texture {
		pigment { Gray15 }
		finish {
			ambient .2
      diffuse .6
			phong .25
      phong_size 25
		}
		normal { bumps 0.5 scale 0.1 }
	}
}

#declare Wheel =
union {
	difference {
		union {
			// outer rim - 1
			cylinder { <0,0,-3.9><0,0,-1.4> 28
			 	texture { T_Copper_2A
					normal { dents .5 }
				}
			}
			// outer rim - 2
			cylinder { <0,0,1.4><0,0,3.9> 28
				texture { T_Copper_2A
					normal {dents .4 } }
			}
			// worn area on outer rim
			cylinder { <0,0,-1.6><0,0,1.6> 28
				texture { T_Silver_3A
					normal { dents 7 }
				 	scale 0.6
				}
			}
			// flange
			cylinder { <0,0,3.9><0,0,3> 30.5
				texture { T_Copper_2A
					normal { dents .35 }
				}
			}
			// inner part of outer rim
			cylinder { <0,0,-4><0,0,4> 27 }
		}
		// subtract this
		cylinder { <0,0,-4.5><0,0,4.5> 24.5 }
	}
	// inner rim
	cylinder { <0,0,-2><0,0,2> 8.2 }
	// axle
	cylinder { <0,0,-14><0,0,30> 2.0
		texture {
			pigment { color rgb <0.07,0.07,0.09> }
			finish {
    		phong 0.9
    		phong_size 60
  		}
		}
	}
	#if (d_Wheel > 1)
	// spokes
	#declare ang = 0
	#while (ang < 360)
		object { Spoke rotate ang*z }
		#declare ang = ang + (360/12)
	#end
	#end
	texture { T_Wheel_Black }
	scale <1,1,1>
}

