// Persistence of Vision Ray Tracer Scene Description File
// File: mjm_jb.pov
// Vers: 3
// Desc: John Bull Steam Locomotive
// Date: 01/10/98
// Auth: Mark J. Murphy
//       mj_murf@mindspring.com
//

#version 3

// detail levels -  0 -> ommit  1 -> low detail  2 -> high detail

#declare d_Wheel       = 2
#declare d_Frame       = 2
#declare d_Boiler      = 2
#declare d_Attachments = 2
#declare d_Far_Side    = 2
#declare d_Ground      = 2
#declare d_Cow_Catcher = 2
#declare d_Controls    = 2
#declare d_Sky  			 = 2

#include "colors.inc"
#include "Textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "finish.inc"
#include "Glass.inc"
#include "Stones.inc"
#include "Skies.inc"

#include "Wheel.inc"
#include "Attachments.inc"
#include "Frame.inc"
#include "Boiler.inc"
#include "Ground.inc"
#include "CowCatcher.inc"
#include "Controls.inc"

global_settings
{
  assumed_gamma 1.0
}

#if (d_Sky > 1)
	sky_sphere { Sky }
#else
	background { Blue }
#end

camera
{
  location  <0.0, 73.0, -80.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 73.0,  0.0>
}

// lights /////


light_source
{
  0*x
  color rgb <1,1,1> * 0.05
  area_light
  <150, 0, 0> <0, 0, 150>
  2, 2
  adaptive 1
  jitter
  translate <0, 200, 250>
}

light_source
{
  0*x
  color rgb <1,1,1> * 1.0
	// old
	//translate <-30, 100, -130>
	translate <-90,95,-130>
}

light_source
{
  0*x
  color rgb <1,1,1> * 1.0
	// old
  //translate <5, 80, -100>
	translate <70,80,-130>
}
///////////////

#declare Locomotive =
union {
	#if (d_Frame > 0)
  object { Frame translate -35*z }
	#end
	#if (d_Boiler > 0)
	object { Boiler translate <50,11,0> }
	#end
	#if (d_Attachments > 0)
	object { Attachments }
	#end
	#if (d_Cow_Catcher > 0)
 	object { Cow_Catcher translate <53,-14.9,-29> }
	#end
	#if (d_Controls > 0)
	object { Controls }
	#end
}

union {
	object { Locomotive translate <-67,52.1,-0.2> }
	#if (d_Ground > 0)
	object { Ground translate <0,0,0> }
	#end
	translate <0,0, 300>
}
