
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 1
// Desc:
// Date:
// Auth:


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions


#default { texture { TempTexture } }


#declare Explorer_BodyTexture = texture {
   //pigment { color rgb <1, 0.5, 0.2> }
   pigment {
      gradient y
      pigment_map {
         [ 0.00 color rgb <1.0, 0.9, 0.7> ]
         [ 0.49 color rgb <1.0, 0.9, 0.7> ]
         [ 0.49 color rgb <0.0, 0.0, 0.0> ]
         [ 0.51 color rgb <0.0, 0.0, 0.0> ]
         [ 0.51 color rgb <1.0, 0.3, 0.1> ]
         [ 1.00 color rgb <1.0, 0.3, 0.1> ]
      }
   }
	finish {
	   ambient 0.2
           diffuse 0.16 // 0.2
           specular 0.25 //0.2
       roughness 0.01
       crand 0.05
	   //reflection 0.05
	}
    //normal { crackle -1.0 scale 0.05 }
}

//#default { texture { Explorer_BodyTexture } }

//*================================= Explorer Control Panel =================================*

   #declare Explorer_LightSwitch = on

   #declare Explorer_Light1_InnerRadius = 1.50 //1 //2
   #declare Explorer_Light1_OuterRadius = 3.50 //3 //6

   #declare Explorer_Light2_InnerRadius = 09
   #declare Explorer_Light2_OuterRadius = 10

   #declare Explorer_Light3_InnerRadius = 06 //08 //24
   #declare Explorer_Light3_OuterRadius = 12 //15 //25

   #declare Explorer_Light4_InnerRadius = 7.5
   #declare Explorer_Light4_OuterRadius = 10

   #declare Explorer_Light1_Dimmer = 0.85
   #declare Explorer_Light2_Dimmer = 1
   #declare Explorer_Light3_Dimmer = 1
   #declare Explorer_Light4_Dimmer = 1

//*==========================================================================================*


#declare Explorer_MainShell = object {
   merge {
      difference {
         cylinder { -3*x, 0*x, 1 }
         cylinder {
            -10*x, 10*x, 0.95
            texture {
               pigment { color rgb <1, 1, 1> }
               finish { ambient 0.35  diffuse 0.35 specular 0.2  roughness 0.1 }
               //normal { crackle -1.0 scale 0.05 }
            }
         }
         cylinder { -10*z, 10*z, 0.14 translate <-0.3, 0.4, 0> }
         cylinder { -10*z, 10*z, 0.14 translate <-1.0, 0.4, 0> }
         //cylinder { -10*z, 10*z, 0.14 translate <-1.7, 0.4, 0> }
      }
      difference {
         sphere { 0*x, 1.00 }
         sphere { 0*x, 0.90 }
         plane { x, 0 }
         box { <0.05, 0.05, -0.05> <10, 10, -10> }
         box { <0.05, 0.05,  0.05> <10, 10,  10> }
         box { <0.05, -0.05, -0.05> <10, -10, -10> }
         box { <0.05, -0.05,  0.05> <10, -10,  10> }
         scale <1.5, 1, 1>
         texture {
            pigment { color rgb <1, 1, 1> }
            finish { ambient 0.35  diffuse 0.35 specular 0.2  roughness 0.1 }
            //normal { crackle -1.0 scale 0.05 }
         }
      }
      merge {
         cylinder { -3*x, 0*x, 0.9 hollow }
         sphere { 0*x, 0.9  scale <1.5, 1, 1> hollow }
         texture {
            pigment { color rgbt 1 }
            finish  { ambient 0 diffuse 0 }
            halo {
               emitting
               cylindrical_mapping
               constant
               color_map {
                  [ 0.00 color rgbft <1, 1, 1, 0.3, -1> ]
                  [ 1.00 color rgbft <1, 1, 1, 0.3, -1> ]
               }
            }
         }
      }
      difference {
         sphere { 0*x, 0.99 }
         sphere { 0*x, 0.95 }
         plane { x, 0 }
         scale <1.5, 1, 1>
         texture {
            pigment { color rgbf 0.95 }
            finish {
               ambient 0.2 diffuse 0.2 specular 0.75 roughness 0.001
               refraction on ior 1.15 reflection 0.175
            }
         }
      }
      difference {
         union {
            cylinder { -10*z, 10*z, 0.14 translate <-0.3, 0.4, 0> }
            cylinder { -10*z, 10*z, 0.14 translate <-1.0, 0.4, 0> }
            cylinder { -10*z, 10*z, 0.14 translate <-1.7, 0.4, 0> }
         }
         cylinder { -3*x, 0*x, 1 inverse }
         cylinder { -10*x, 10*x, 0.95 }
         texture {
            pigment { color rgbf <0.9, 0.9, 0.95, 0.95> }
            finish {
               ambient 0.2 diffuse 0.2 specular 0.75 roughness 0.001
               refraction on ior 1.15 reflection 0.07
            }
         }
      }
      sphere { 0*x, 1 scale <0.5, 1, 1> translate -3*x }
   }
   scale <1, 0.75, 1>
   texture { Explorer_BodyTexture }
}


#declare Explorer_TailFin = object {
   union {
      difference {
         sphere { 0*x, 0.75 }
         plane { x, 0 }
         plane { y, 0 }
         scale <1.5, 1.4, 0.1>
      }
      difference {
         sphere { 0*x, 0.75 }
         plane { -x, 0 }
         plane {  y, 0 }
         scale <0.75, 1.4, 0.1>
         rotate -y*0
      }
      difference {
         sphere { 0*x, 0.75 }
         plane { x, 0 }
         plane {-y, 0 }
         scale <1.5, 1, 0.1>
      }
      difference {
         sphere { 0*x, 0.75 }
         plane { -x, 0 }
         plane { -y, 0 }
         scale <0.75, 1, 0.1>
         rotate -y*0
      }
      sphere { 0*x, 0.75 scale <0.05, 1.05, 0.115> }
   }
   texture {
      pigment { color rgb <1.0, 0.3, 0.1> }
      finish { ambient 0.2 diffuse 0.15 specular 0.25 roughness 0.005 }
   }
}


#declare Explorer_TailAssembly = object {
   union {
      box { <-0.5, -0.075, -0.55> <0.1, 0.075, 0.55> translate x*0.65 }
      object { Explorer_TailFin translate <0, 0, -0.55> }
      object { Explorer_TailFin translate <0, 0,  0.55> }
   }
   texture { Explorer_BodyTexture }
}

#declare Explorer_Wing = object {
   union {
      difference {
         union {
            cylinder { -2.3*z, 2.3*z, 0.20 }
            sphere { -2.3*z, 0.20 }
            sphere {  2.3*z, 0.20 }
         }
         plane { x, 0 }
         plane { y, 0 }
         cylinder { -10*x, 10*x, 1 scale <1, 0.75, 1> }
         scale <2, 0.7, 1>
      }
      difference {
         union {
            cylinder { -2.3*z, 2.3*z, 0.20 }
            sphere { -2.3*z, 0.20 }
            sphere {  2.3*z, 0.20 }
         }
         plane {-x, 0 }
         plane { y, 0 }
         cylinder { -10*x, 10*x, 1 scale <1, 0.75, 1> }
         scale <4, 0.7, 1>
      }
      difference {
         union {
            cylinder { -2.3*z, 2.3*z, 0.20 }
            sphere { -2.3*z, 0.20 }
            sphere {  2.3*z, 0.20 }
         }
         plane { x, 0 }
         plane {-y, 0 }
         cylinder { -10*x, 10*x, 1 scale <1, 0.75, 1> }
         scale <2, 0.45, 1>
      }
      difference {
         union {
            cylinder { -2.3*z, 2.3*z, 0.20 }
            sphere { -2.3*z, 0.20 }
            sphere {  2.3*z, 0.20 }
         }
         plane {-x, 0 }
         plane {-y, 0 }
         cylinder { -10*x, 10*x, 1 scale <1, 0.75, 1> }
         scale <4, 0.45, 1>
      }
   }
   texture {
      pigment { color rgb <1.0, 0.3, 0.1> }
      finish {
         ambient 0.35
         diffuse 0.35
         specular 0.2
         roughness 0.1
	   //reflection 0.05
	  }
      //normal { crackle -1.0 scale 0.05 }
   }
}


#declare Explorer_LandingStrut = object {
   union {
      cylinder { -0.9*z, 0.9*z, 0.05 }
      difference {
         torus { 0.2, 0.05 rotate z*90 }
         plane { y, 0 }
         plane {-z, 0 }
         translate <0, -0.2, -0.9>
      }
      cylinder { 0.2*y, 0*y, 0.05 translate <0, -0.4, -1.1> }
      difference {
         torus { 0.2, 0.05 rotate z*90 }
         plane { y, 0 }
         plane { z, 0 }
         translate <0, -0.2, 0.9>
      }
      cylinder { 0.2*y, 0*y, 0.05 translate <0, -0.4,  1.1> }
   }
   //texture { RedT }
}

#declare Explorer_LandingGear = object {
   union {
      object { Explorer_LandingStrut }
      object { Explorer_LandingStrut translate -x*1.5 }
      cylinder { 0.55*x, -2.1*x, 0.05 scale <1, 0.75, 1.3> translate <0, -0.4, -1.1> }
      cylinder { 0.55*x, -2.1*x, 0.05 scale <1, 0.75, 1.3> translate <0, -0.4,  1.1> }
   }
}


#declare Explorer_Turbine = object {
   union {
      cylinder { -0.2*x, 0.2*x, 0.3 open }
      torus { 0.3, 0.025 rotate z*90 translate  0.2*x }
      torus { 0.3, 0.025 rotate z*90 translate -0.2*x }
      sphere { 0*x, 0.075 scale <2, 1, 1> }
   }
}

#declare Explorer_PropellerBlade = object {
   difference {
      cylinder { -0.01*x, 0.01*x, 0.3 }
      plane { y, 0 rotate  x*75 }
      plane { y, 0 rotate -x*75 }
   }
   rotate y*20
   //texture { RedT }
}

#declare Explorer_Propeller = object {
   union {
      object { Explorer_Turbine }
      difference {
         sphere { 0*x, 0.1 }
         plane { z, 0 }
         translate z*0.3
      }
      cylinder { 0*z, 0.3*z, 0.04 translate z*0.3 }
      object { Explorer_PropellerBlade rotate -x*000 }
      object { Explorer_PropellerBlade rotate -x*072 }
      object { Explorer_PropellerBlade rotate -x*144 }
      object { Explorer_PropellerBlade rotate -x*216 }
      object { Explorer_PropellerBlade rotate -x*288 }
   }
}


#declare Explorer_LightSupport = object {
   union {
      union {
         difference {
            torus { 0.1, 0.03 rotate z*90 }
            plane { y, 0 rotate x*15 }
            plane { -z, 0 }
         }
         cylinder { -0.4*y, 0*y, 0.03 translate -z*0.1 rotate x*15 }
         translate -z*0.6
      }
      union {
         difference {
            torus { 0.1, 0.03 rotate z*90 }
            plane { y, 0 rotate -x*15 }
            plane { z, 0 }
         }
         cylinder { -0.4*y, 0*y, 0.03 translate z*0.1 rotate -x*15 }
         translate z*0.6
      }
      cylinder { -z*0.6, z*0.6, 0.03 translate y*0.1 }
   }
}


#declare Explorer_LightGlow = object {
   sphere {
      0*x, 1
      hollow no_shadow
      texture {
         pigment { color rgbt 1 }
         finish  { ambient 0 diffuse 0 specular 0 }
         halo {
            emitting
            spherical_mapping
            //constant max_value 0
            //cubic
            linear
            color_map {
               [ 0.00 color rgbft <1.0, 1.0, 1.0, 0,  0> ]
               [ 0.80 color rgbft <1.0, 1.0, 1.0, 0, -1> ]
               [ 1.00 color rgbft <1.0, 1.0, 1.0, 0, -1> ]
            }
            turbulence 0.1
            samples 10
            scale 1
         }
      }
   }
   scale <0.20, 0.25, 0.25>
}



#declare Explorer_Light1_Source = object {
   union {
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light1_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light1_InnerRadius
         falloff  Explorer_Light1_OuterRadius
         tightness 100
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         //fade_distance 4.5 fade_power 2
         fade_distance 2.5 fade_power 1
      }
      light_source {
         -0.05*x, color rgb <0.9, 0.9, 1.00> //0.85
         spotlight point_at x*100
         radius   Explorer_Light1_InnerRadius/2
         falloff  Explorer_Light1_InnerRadius
         tightness 10 //100 //65
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         //fade_distance 4.5 fade_power 2
         fade_distance 2.5 fade_power 1
      }
      //cylinder { 0*x, 100*x, 0.1 texture { RedT } no_shadow }
   }
}


#declare Explorer_Light1 = object {
   union {
      cylinder { -0.1*x, 0.1*x, 0.1 open }
      cylinder { -0.11*x, -0.1*x, 0.115 }
      torus { 0.1, 0.02 rotate z*90 translate x*0.1 }
      cylinder {
         0.1*x, 0.09*x, 0.1
         texture {
            //pigment { color rgbf 0.95 }
            //finish { ambient 0.2 diffuse 0.15 specular 0.6 roughness 0.05 }
            pigment { color rgb 1.0 }  finish { ambient 1.0 diffuse 0.5 }
         }
         no_shadow
      }
      #if (Explorer_LightSwitch=on)
         object { Explorer_Light1_Source translate -0.05*x }
         object { Explorer_LightGlow translate 0.25*x }
      #end
      //cylinder { 0*x, 1000*x, 0.1 texture { RedT } no_shadow }
   }
}



#declare Explorer_Light2_Source = object {
   union {
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light2_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light2_InnerRadius
         falloff  Explorer_Light2_OuterRadius
         tightness 100
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         //fade_distance 25.5 fade_power 1
      }
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light2_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light2_InnerRadius/2
         falloff  Explorer_Light2_InnerRadius
         tightness 10 //100 //65
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         //fade_distance 25.5 fade_power 1
      }
      //cylinder { 0*x, 100*x, 0.1 texture { RedT } no_shadow }
   }
}


#declare Explorer_Light2 = object {
   union {
      cylinder { -0.1*x, 0.1*x, 0.05 open }
      cylinder { -0.11*x, -0.1*x, 0.055 }
      torus { 0.05, 0.01 rotate z*90 translate x*0.1 }
      cylinder {
         0.1*x, 0.09*x, 0.05
         texture {
            //pigment { color rgbf 0.95 }
            //finish { ambient 0.2 diffuse 0.15 specular 0.6 roughness 0.05 }
            pigment { color rgb 1.0 }  finish { ambient 1.0 diffuse 0.5 }
         }
         no_shadow
      }
      #if (Explorer_LightSwitch=on) object { Explorer_Light2_Source translate 0.08*x } #end
   }
   //texture { RedT }
}




#declare Explorer_Light3_Source = object {
   union {
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light3_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light3_InnerRadius
         falloff  Explorer_Light3_OuterRadius
         tightness 100
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         fade_distance 1 fade_power 1
      }
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light3_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light3_InnerRadius/2
         falloff  Explorer_Light3_InnerRadius
         tightness 10 //100 //65
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         fade_distance 1 fade_power 1
      }
      //cylinder { 0*x, 100*x, 0.1 texture { RedT } no_shadow }
   }
}


#declare Explorer_Light3 = object {
   union {
      cylinder { -0.1*x, 0.1*x, 0.05 open }
      cylinder { -0.11*x, -0.1*x, 0.055 }
      torus { 0.05, 0.01 rotate z*90 translate x*0.1 }
      cylinder {
         0.1*x, 0.09*x, 0.05
         texture {
            //pigment { color rgbf 0.95 }
            //finish { ambient 0.2 diffuse 0.15 specular 0.6 roughness 0.05 }
            pigment { color rgb 1.0 }  finish { ambient 1.0 diffuse 0.5 }
         }
         no_shadow
      }
      #if (Explorer_LightSwitch=on)
         object { Explorer_Light3_Source translate 0.08*x }
         object { Explorer_LightGlow translate 0.25*x }
      #end
   }
   //texture { RedT }
}



#declare Explorer_Light4_Source = object {
   union {
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light4_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light4_InnerRadius
         falloff  Explorer_Light4_OuterRadius
         tightness 100
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         fade_distance 1 fade_power 1
      }
      light_source {
         -0.05*x, color rgb <0.8, 0.8, 1.00>*Explorer_Light4_Dimmer
         spotlight point_at x*100
         radius   Explorer_Light1_InnerRadius/2
         falloff  Explorer_Light1_InnerRadius
         tightness 10 //100 //65
         //area_light 0.1*z, 0.1*y, 2, 2 jitter adaptive 1
         atmosphere on atmospheric_attenuation on
         fade_distance 1 fade_power 1
      }
      //cylinder { 0*x, 100*x, 0.1 texture { RedT } no_shadow }
   }
}


#declare Explorer_Light4 = object {
   union {
      cylinder { -0.1*x, 0.1*x, 0.1 open }
      cylinder { -0.11*x, -0.1*x, 0.115 }
      torus { 0.1, 0.02 rotate z*90 translate x*0.1 }
      cylinder {
         0.1*x, 0.09*x, 0.1
         texture {
            //pigment { color rgbf 0.95 }
            //finish { ambient 0.2 diffuse 0.15 specular 0.6 roughness 0.05 }
            pigment { color rgb 1.0 }  finish { ambient 1.0 diffuse 0.5 }
         }
         no_shadow
      }
      #if (Explorer_LightSwitch=on)
         object { Explorer_Light4_Source translate -0.05*x }
         object { Explorer_LightGlow translate 0.25*x }
      #end
      //cylinder { 0*x, 1000*x, 0.1 texture { RedT } no_shadow }
   }
}



#declare Explorer = object {
   union {
      object { Explorer_MainShell }
      object { Explorer_TailAssembly translate <-4.1, 0, 0> }
      object { Explorer_Wing translate <-0.7, -0.15, 0> }
      object { Explorer_LandingGear translate <-0.4, -0.6, 0> }
      object { Explorer_Propeller translate <-2.5, 0.1, -1.4> }
      object { Explorer_Propeller rotate x*180 translate <-2.5, 0.1,  1.4> }
      object { Explorer_LightSupport translate <-1.8, 0.8, 0> }
      /*
      object { Explorer_Light1 translate <-1.7, 1.15, 0> }
      object { Explorer_Light1 rotate -y*10 translate <-1.7, 1.15,  0.6> }
      object { Explorer_Light1 rotate  y*10 translate <-1.7, 1.15, -0.6> }
      */

      object { Explorer_Light1 translate <-1.8, 1, 0> }
      object { Explorer_Light1 rotate -y*10 translate <-1.8, 1,  0.6> }
      object { Explorer_Light1 rotate  y*10 translate <-1.8, 1, -0.6> }

      /*
      object { Explorer_Light2 rotate -z*1 rotate y*144 translate <-0.9, 0.05, 2.4> }
      object { Explorer_Light2 rotate -z*1 rotate y*155 translate <-0.9, 0.05, 1.5> }
      object { Explorer_Light2 rotate -z*1 rotate -y*144 translate <-0.9, 0.05,-2.4> }
      object { Explorer_Light2 rotate -z*1 rotate -y*155 translate <-0.9, 0.05,-1.5> }
      */

      object { Explorer_Light3 rotate -z*90 rotate x*03 translate <-0.7, -0.1, 2.55> }
      object { Explorer_Light3 rotate -z*90 rotate -x*03 translate <-0.7, -0.1, -2.55> }

      object { Explorer_Light4 rotate -z*15 rotate -y*4 translate <-0.3, -0.35,  1.5> }
      object { Explorer_Light4 rotate -z*12 rotate  y*4 translate <-0.3, -0.35, -1.5> }
   }
}
