
// Persistence of Vision Ray Tracer Scene Description File
// File: ship.inc
// Vers: 1
// Desc:
// Date:
// Auth:

#declare EditMode = off


#if ( EditMode = on )
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"



// ------------- Some housekeeping def's.

global_settings { max_trace_level 10 assumed_gamma 1.35 /*1.5 1.15 1.9*/ }

background { color rgb 0.6 }

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
           ambient 0.35
           diffuse 0.35
	   specular 0.3
       roughness 0.01
	   //reflection 0.05
	}
    //normal { crackle -1.0 scale 0.05 }
}


#declare RedT = texture { pigment { color rgb <1,0,0> } finish { ambient 0.6 } }

#declare BlackT = texture { pigment { color rgb <0,0,0> } finish { ambient 0.6 } }


camera {
  //location  <-5.0 , 1 , -50.0>  look_at   <0 , 0.5 , 0.0>
  //location <-3, 0.2, -50> look_at <1.0, 0.15, 0>
  //location <-3.5, -0.7, -50> look_at <0.85, 0.15, 0> angle 7.2  //<----- STD CAM 1b
  //location <-3.5, -1.0, -50> look_at <1.35, 0.15, 0> angle 8.2  //<----- STD CAM 1
  //location <-50, 0.2, -70> look_at <-1.35, 0.15, -4> angle 8    //<----- STD CAM 2 - oblique
  //location <0, 50, 0>  look_at <0, 0, 0> rotate y*90 angle 18   //<----- ABOVE
  location <0, 0, -50>  look_at <0, 0, 0> angle 10   //<----- FRONT
  //angle 18 //10
}


#declare Dimmer = 0.95 //0.75
light_source { 0*x  color rgb 0.65*Dimmer translate <-30, 60, -30> }
light_source { 0*x  color rgb 0.99*Dimmer translate < 20, 70, -50> }
light_source { 0*x  color rgb 0.65*Dimmer translate <-50,-40, -20> }
light_source { 0*x  color rgb 0.65*Dimmer translate <  0,  0, -40> }
light_source { 0*x  color rgb 0.20*Dimmer translate <  0, 20,  30> }


//---Put reference lines on origin for placement purposes.
//cylinder { -100*x, 100*x, 0.01 texture { RedT } }
//cylinder { -100*x, 100*x, 0.01 translate -z*3.5 texture { RedT } }


#declare Rust =
texture {
    pigment {
        granite
        color_map {
            [0.0, 0.4 color rgb <0.89, 0.51, 0.28>
                      color rgb <0.70, 0.13, 0.00>]
            [0.4, 0.5 color rgb <0.70, 0.13, 0.00>
                      color rgb <0.69, 0.41, 0.08>]
            [0.5, 0.6 color rgb <0.69, 0.41, 0.08>
                      color rgb <0.49, 0.31, 0.28>]
            [0.6, 1.0 color rgb <0.49, 0.31, 0.28>
                      color rgb <0.89, 0.51, 0.28>]
        }
    }
    finish { ambient 0.25 diffuse 0.5 }
}

#declare Ship_RustyIron =
texture {
    pigment {
        granite
        color_map {
            [0.0, 0.5 color rgb <0.21, 0.10, 0.10> * 3
                      color rgb <0.25, 0.25, 0.01> * 3 ]
            [0.5, 0.6 color rgb <0.25, 0.25, 0.01> * 4
                      color rgb <0.30, 0.10, 0.10> * 4 ]
            [0.6, 1.0 color rgb <0.15, 0.10, 0.10> * 2
                      color rgb <0.15, 0.10, 0.10> * 2 ]
        }
        turbulence 0.15
        scale 0.15
    }
    //finish { ambient 0.15 diffuse 0.55 crand 0.1 specular 0.1 roughness 0.01 }
    finish { ambient 0.05 diffuse 0.35 crand 0.1 specular 0.05 roughness 0.01 }
    normal { average normal_map { [ 1.00 wrinkles 1 ] [ 1.00 crackle 0.75 ] } scale 0.1 }
}

#declare Ship_RustedMetal = //texture {
   texture { Rust }
   texture { Ship_RustyIron }


//==================================== Scene Controls ======================================

//   * These controls make it easier to debug the scene. They enable quick switching from
//     high to low quality renders, and also make it easy to change environments. You can
//     also toggle on/off the scene elements which take up a lot of memory.

   #declare FogSwitch = off
   #declare FogType   = 2          // 1=Fog,  2=Atmosphere

   #declare Ship_Switch = on         //-------- Switch on/off scene elements
   #declare Explorer_Switch = on
   #declare Rock_Switch = on
   #declare Ground_Switch = on
   #declare Mountain_Switch = on
   #declare Debris_Switch = off

   #declare AreaLights = off         //-------- Rendering controls
   #declare FillerLights = off
   #declare FocalBlur = off

//==========================================================================================

#end

//#default { texture  { TempTexture } }
#default { texture  { Ship_RustyIron } }

#include "RUST1.INC"
#include "RUST2.INC"
#include "RUST3.INC"
#include "RUST4.INC"


#declare Ship_MainHull = object {
   union {
      //----- Right Half
      difference {
         difference {
            union {
               cylinder { -45*x, 0*x, 2 scale <1, 1.3, 1> }
               sphere { 0*x, 2 scale <2.25, 1.3, 1> }
            }
            plane { -y, 0 }
         }
         plane { -z, 0.5 }
         box { <-100, -0.25, -10> <-3, 10, 10> }
         translate z*0.5
      }
      //----- Left Half
      difference {
         difference {
            union {
               cylinder { -45*x, 0*x, 2 scale <1, 1.3, 1> }
               sphere { 0*x, 2 scale <2.25, 1.3, 1> }
            }
            plane { -y, 0 }
         }
         plane { z, 0.5 }
         box { <-100, -0.25, -10> <-3, 10, 10> }
         translate -z*0.5
      }
      scale <1, 1, 1.5>
      //texture { Ship_RustedMetal }
   }
}

#declare Ship_RightRail = object {
   difference {
      union {
         cylinder { -3*x, 0*x, 0.005 translate -z*1.975 }
         cylinder { -45*x, -3*x, 0.005 translate <0, -0.25, -1.975> }
         difference {
            torus { 1.975, 0.005 }
            plane {  x, 0 }
            plane { -z, 0 }
            scale <1.7, 1, 1>
         }
      }
      plane { -z, 0.5 }
      translate z*0.5
      scale <1, 1, 1.5>
      //texture { TempTexture }
   }
}

#declare Ship_LeftRail = object {
   difference {
      union {
         cylinder { -3*x, 0*x, 0.005 translate z*1.975 }
         cylinder { -45*x, -3*x, 0.005 translate <0, -0.25, 1.975> }
         difference {
            torus { 1.975, 0.005 }
            plane { x, 0 }
            plane { z, 0 }
            scale <1.7, 1, 1>
         }
      }
      plane { z, 0.5 }
      translate -z*0.5
      scale <1, 1, 1.5>
      //texture { TempTexture }
   }
}

#declare Ship_RailSupport = object {
   cylinder { 0*y, 0.15*y, 0.01 }
   //texture { TempTexture }
}

#declare Ship_RailSupportRow = object {
   union {
      object { Ship_RailSupport translate <  0.0, 0, 0> }
      object { Ship_RailSupport translate < -0.5, 0, 0> }
      object { Ship_RailSupport translate < -1.0, 0, 0> }
      object { Ship_RailSupport translate < -1.5, 0, 0> }
      object { Ship_RailSupport translate < -2.0, 0, 0> }
      object { Ship_RailSupport translate < -2.5, 0, 0> }
      object { Ship_RailSupport translate < -3.0, 0, 0> }
      object { Ship_RailSupport translate < -3.5, 0, 0> }
      object { Ship_RailSupport translate < -4.0, 0, 0> }
      object { Ship_RailSupport translate < -4.5, 0, 0> }
      object { Ship_RailSupport translate < -5.0, 0, 0> }
      object { Ship_RailSupport translate < -5.5, 0, 0> }
      object { Ship_RailSupport translate < -6.0, 0, 0> }
      object { Ship_RailSupport translate < -6.5, 0, 0> }
      object { Ship_RailSupport translate < -7.0, 0, 0> }
      object { Ship_RailSupport translate < -7.5, 0, 0> }
      object { Ship_RailSupport translate < -8.0, 0, 0> }
      object { Ship_RailSupport translate < -8.5, 0, 0> }
      object { Ship_RailSupport translate < -9.0, 0, 0> }
      object { Ship_RailSupport translate < -9.5, 0, 0> }
   }
}

#declare Ship_Rails = object {
   union {
      object { Ship_RightRail translate y*0.05 }
      object { Ship_LeftRail  translate y*0.05 }
      object { Ship_RightRail translate y*0.10 }
      object { Ship_LeftRail  translate y*0.10 }
      object { Ship_RightRail translate y*0.15 }
      object { Ship_LeftRail  translate y*0.15 }

      object { Ship_RailSupport translate < 3.225, 0, 0> }

      //---- Right Side Supports
      object { Ship_RailSupport translate < 3.125, 0, -0.300> }
      object { Ship_RailSupport translate < 2.975, 0, -0.600> }
      object { Ship_RailSupport translate < 2.800, 0, -0.900> }
      object { Ship_RailSupport translate < 2.525, 0, -1.200> }
      object { Ship_RailSupport translate < 2.235, 0, -1.440> }
      object { Ship_RailSupport translate < 1.900, 0, -1.680> }
      object { Ship_RailSupport translate < 1.565, 0, -1.850> }
      object { Ship_RailSupport translate < 1.170, 0, -2.000> }
      object { Ship_RailSupport translate < 0.725, 0, -2.125> }
      object { Ship_RailSupport translate < 0.200, 0, -2.190> }

      object { Ship_RailSupport translate < -0.300, 0, -2.200> }
      object { Ship_RailSupport translate < -0.800, 0, -2.200> }
      object { Ship_RailSupport translate < -1.300, 0, -2.200> }
      object { Ship_RailSupport translate < -1.800, 0, -2.200> }
      object { Ship_RailSupport translate < -2.300, 0, -2.200> }
      object { Ship_RailSupport translate < -2.800, 0, -2.200> }

      object { Ship_RailSupportRow translate <-3.3, -0.25, -2.2> }
      object { Ship_RailSupportRow translate <-13.3, -0.25, -2.2> }



      //---- Left Side Supports
      object { Ship_RailSupport translate < 3.125, 0, 0.300> }
      object { Ship_RailSupport translate < 2.975, 0, 0.600> }
      object { Ship_RailSupport translate < 2.800, 0, 0.900> }
      object { Ship_RailSupport translate < 2.525, 0, 1.200> }
      object { Ship_RailSupport translate < 2.235, 0, 1.440> }
      object { Ship_RailSupport translate < 1.900, 0, 1.680> }
      object { Ship_RailSupport translate < 1.565, 0, 1.850> }
      object { Ship_RailSupport translate < 1.170, 0, 2.000> }
      object { Ship_RailSupport translate < 0.725, 0, 2.125> }
      object { Ship_RailSupport translate < 0.200, 0, 2.190> }

      object { Ship_RailSupport translate < -0.300, 0, 2.200> }
      object { Ship_RailSupport translate < -0.800, 0, 2.200> }
      object { Ship_RailSupport translate < -1.300, 0, 2.200> }
      object { Ship_RailSupport translate < -1.800, 0, 2.200> }
      object { Ship_RailSupport translate < -2.300, 0, 2.200> }
      object { Ship_RailSupport translate < -2.800, 0, 2.200> }

      object { Ship_RailSupportRow translate <-3.3, -0.25, 2.2> }
      object { Ship_RailSupportRow translate <-13.3, -0.25, 2.2> }
   }
   scale <1.275, 1, 0.975>
}


#declare Ship_FrontThing1 = object {
   union {
      cylinder { 0*y, 0.065*y, 0.035 }
      cylinder { 0.065*y, 0.085*y, 0.04 }
      torus { 0.04, 0.01 translate y*0.075 }
      cylinder { 0*y, 0.065*y, 0.005 translate  x*0.035 }
      cylinder { 0*y, 0.065*y, 0.003 translate  z*0.035 }
      cylinder { 0*y, 0.065*y, 0.003 translate -z*0.035 }
      union {
         cylinder { -0.005*x, 0.005*x, 0.05 scale <1, 1, 0.6> translate -z*0.015 }
         box { <-0.005, 0, -0.1> <0.005, 0.0035, 0> }
         difference {
            box { <-0.0035, 0, -0.1> <0.0035, 0.02, -0.075> }
            cylinder { -10*x, 10*x, 0.01 scale <1, 1, 0.8> translate <0, 0.01, -0.075> }
            cylinder { -10*x, 10*x, 0.02 scale <1, 1, 1.5> translate -z*0.075 inverse }
            scale <1, 1.3, 1>
         }
         scale <1.2, 1.5, 1>
         rotate y*20
      }
      union {
         cylinder { -0.005*x, 0.005*x, 0.05 scale <1, 1, 0.6> translate z*0.015 }
         box { <-0.005, 0, 0.1> <0.005, 0.0035, 0> }
         difference {
            box { <-0.0035, 0, 0.1> <0.0035, 0.02, 0.075> }
            cylinder { -10*x, 10*x, 0.01 scale <1, 1, 0.8> translate <0, 0.01, 0.075> }
            cylinder { -10*x, 10*x, 0.02 scale <1, 1, 1.5> translate z*0.075 inverse }
            scale <1, 1.3, 1>
         }
         scale <1.2, 1.5, 1>
         rotate -y*20
      }
   }
   scale <1, 1.1, 1>
   //texture { TempTexture }
}


#declare Ship_GroundFloor = object {
   union {
      difference {
         union {
            box { <-20, 0, -1.55> <0, 0.4, 1.55> }
            box { <0, 0, -1.3> <0.5, 0.4, 1.3> }
         }
         //--- Hollow out inside
         box { <-100, 0, -1.50> <-0.1, 10, 1.50> texture { BlackT } }
         box { <-100, 0, -1.25> <0.49, 0.39, 1.25> texture { BlackT } }
         //--- Add windows
         box { <-10, 0.15, -0.05> <10, 0.35, -0.28> texture { BlackT } }
         box { <-10, 0.15, -0.38> <10, 0.35, -0.61> texture { BlackT } }
         box { <-10, 0.15, -0.71> <10, 0.35, -0.93> texture { BlackT } }
         box { <-10, 0.15, -1.03> <10, 0.35, -1.25> texture { BlackT } }
         box { <-10, 0.15,  0.05> <10, 0.35,  0.28> texture { BlackT } }
         box { <-10, 0.15,  0.38> <10, 0.35,  0.61> texture { BlackT } }
         box { <-10, 0.15,  0.71> <10, 0.35,  0.93> texture { BlackT } }
         box { <-10, 0.15,  1.03> <10, 0.35,  1.25> texture { BlackT } }

         box { <-10, 0.15, -1.5> <10, 0.35, -1.35> texture { BlackT } }
         box { <-10, 0.15,  1.5> <10, 0.35,  1.35> texture { BlackT } }
      }
      cylinder { 0*y, 0.4*y, 0.02 translate < 0.45, 0, -1.7> }
      cylinder { 0*y, 0.4*y, 0.02 translate < 0.45, 0,  1.7> }
   }
   //texture { TempTexture }
}


#declare Ship_FirstFloor = object {
   union {
      difference {
         union {
            box { <-40, 0, -1.4> <-0.5, 0.4, 1.4> }
            box { <-0.5, 0, -0.95> <0.625, 0.4, 0.95> }
         }
         //--- Hollow out inside
         box { <-100, 0.01, -1.35> <-0.55, 0.39, 1.35> texture { BlackT } }
         box { <-100, 0.01, -0.90> < 0.60, 0.39, 0.90> texture { BlackT } }
         //--- Add windows
         box { <-10, 0.18, -0.90> <10, 0.33, -0.70> texture { BlackT } }
         box { <-10, 0.18, -0.65> <10, 0.33, -0.45> texture { BlackT } }
         box { <-10, 0.18, -0.40> <10, 0.33, -0.20> texture { BlackT } }
         box { <-10, 0.18, -0.15> <10, 0.33,  0.15> texture { BlackT } }
         box { <-10, 0.18,  0.40> <10, 0.33,  0.20> texture { BlackT } }
         box { <-10, 0.18,  0.65> <10, 0.33,  0.45> texture { BlackT } }
         box { <-10, 0.18,  0.90> <10, 0.33,  0.70> texture { BlackT } }

         box { <-10, 0.18, -1.35> <10, 0.33, -1.05> texture { BlackT } }
         box { <-10, 0.18,  1.35> <10, 0.33,  1.05> texture { BlackT } }
      }
      difference {
         cylinder { 0*y, 0.15*y, 0.75 }
         cylinder { 0.1*y, 10*y, 0.70 }
         plane { x, 0 }
         scale <1, 1.1, 2.4>
      }
      difference {
         box { <-40, 0, -1.8> <0, 0.15, 1.8> }
         box { <-50, 0.05, -1.75> <50, 10, 1.75> }
      }
      cylinder { 0*y, 0.4*y, 0.015 translate < 0.25, 0, -1.68> }
      cylinder { 0*y, 0.4*y, 0.015 translate < 0.25, 0,  1.68> }
   }
   //texture { TempTexture }
}

#declare Ship_SecondFloor = object {
   union {
      difference {
         union {
            box { <-40, 0, -1.8> <-0.5, 0.4, 1.8> }
            box { <-0.5, 0, -1.1> <0.5, 0.4, 1.1> }
         }
         //--- Hollow out inside
         box { <-100, 0.01, -1.75> <-0.55,  0.39,  1.75> texture { BlackT } }
         box { <-100, 0.01, -1.05> <  0.45, 0.39, 1.05> texture { BlackT } }
         //--- Add windows
         box { <-100, 0.21, -0.02> <  100, 0.34, -0.25> texture { BlackT } }
         box { <-100, 0.21, -0.28> <  100, 0.34, -0.51> texture { BlackT } }
         box { <-100, 0.21, -0.54> <  100, 0.34, -0.77> texture { BlackT } }
         box { <-100, 0.21, -0.80> <  100, 0.34, -1.05> texture { BlackT } }
         box { <-100, 0.21,  0.02> <  100, 0.34,  0.25> texture { BlackT } }
         box { <-100, 0.21,  0.28> <  100, 0.34,  0.51> texture { BlackT } }
         box { <-100, 0.21,  0.54> <  100, 0.34,  0.77> texture { BlackT } }
         box { <-100, 0.21,  0.80> <  100, 0.34,  1.05> texture { BlackT } }

         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265, -1.60> texture { BlackT } }
         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265, -1.40> texture { BlackT } }
         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265, -1.20> texture { BlackT } }
         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265,  1.60> texture { BlackT } }
         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265,  1.40> texture { BlackT } }
         cylinder { -100*x, 100*x, 0.05 translate <0, 0.265,  1.20> texture { BlackT } }
      }
      difference {
         cylinder { 0*y, 0.15*y, 0.75 }
         cylinder { 0.1*y, 10*y, 0.70 }
         plane { x, 0 }
         scale <1, 1.1, 2.4>
      }
      difference {
         box { <-0.5, 0, -1.8> <0, 0.15, 1.8> }
         box { <-10, 0.05, -1.75> <10, 10, 1.75> }
      }
      cylinder { 0*y, 0.4*y, 0.02 translate < 0, 0, -1.75> }
      cylinder { 0*y, 0.4*y, 0.02 translate < 0, 0,  1.75> }
   }
   //texture { TempTexture }
}

#declare Ship_TopFloor = object {
   union {
      difference {
         union {
            box { <-40, 0, -0.8> <-1.5, 0.4, 0.8> }
            box { <-40, 0.38, -0.8> <-0.5, 0.4, 0.8> }
            box { <-0.5, 0, -0.4> <0.5, 0.40, 0.4> }
         }
         //--- Hollow out inside
         box { <-100, 0.01, -0.75> <-1.55, 0.39, 0.75> texture { BlackT } }
         box { <-100, 0.01, -0.35> < 0.45, 0.39, 0.35> texture { BlackT } }
         //--- Add windows
         box { <-100, 0.15, -0.03> < 100, 0.35,  0.03> texture { BlackT } }
         box { <-100, 0.15, -0.13> < 100, 0.35, -0.19> texture { BlackT } }
         box { <-100, 0.15, -0.29> < 100, 0.35, -0.35> texture { BlackT } }
         box { <-100, 0.15,  0.13> < 100, 0.35,  0.19> texture { BlackT } }
         box { <-100, 0.15,  0.29> < 100, 0.35,  0.35> texture { BlackT } }

         box { <-100, 0.23, -0.75> < 100, 0.33, -0.62> texture { BlackT } }
         box { <-100, 0.23, -0.58> < 100, 0.33, -0.45> texture { BlackT } }
         box { <-100, 0.23,  0.75> < 100, 0.33,  0.62> texture { BlackT } }
         box { <-100, 0.23,  0.58> < 100, 0.33,  0.45> texture { BlackT } }
      }
      cylinder { 0*y, 0.4*y, 0.02 translate < -0.5, 0, -0.8> }
      cylinder { 0*y, 0.4*y, 0.02 translate < -0.5, 0,  0.8> }
      difference {
         cylinder { 0*y, 0.20*y, 0.75 }
         cylinder { 0.1*y, 10*y, 0.70 }
         plane { x, 0 }
         scale <0.85, 1.1, 2.4>
      }
      difference {
         cylinder { 0*y, 0.20*y, 0.35 }
         cylinder { 0.1*y, 10*y, 0.30 }
         plane { x, 0 }
         scale <2.5, 1.1, 2.4>
      }
      difference {
         box { <-0.5, 0, -1.8> <0, 0.20, 1.8> }
         box { <-100, 0.05, -1.75> <-0.05, 10, 1.75> }
      }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.06, -1.8> }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.13, -1.8> }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.20, -1.8> }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.06,  1.8> }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.13,  1.8> }
      cylinder { -0.5*x, -50*x, 0.01 translate <0, 0.20,  1.8> }
      union {
         object { Ship_RailSupportRow translate <-0.5, 0.4, -0.8> }
         object { Ship_RailSupportRow translate <-0.5, 0.4,  0.8> }
         cylinder { -0.8*z, 0.8*z, 0.01 translate <-0.5, 0.45, 0> }
         cylinder { -0.8*z, 0.8*z, 0.01 translate <-0.5, 0.50, 0> }
         cylinder { -0.8*z, 0.8*z, 0.01 translate <-0.5, 0.55, 0> }
         object { Ship_RailSupport  translate <-0.5, 0.4, -0.6>  }
         object { Ship_RailSupport  translate <-0.5, 0.4, -0.4>  }
         object { Ship_RailSupport  translate <-0.5, 0.4, -0.2>  }
         object { Ship_RailSupport  translate <-0.5, 0.4,  0.0>  }
         object { Ship_RailSupport  translate <-0.5, 0.4,  0.2>  }
         object { Ship_RailSupport  translate <-0.5, 0.4,  0.4>  }
         object { Ship_RailSupport  translate <-0.5, 0.4,  0.6>  }
      }
   }
   //texture { TempTexture }
}


#declare Ship_SmokeStack = object {
   union {
      cylinder { 0*y, 3.25*y, 0.50 scale <1, 1, 0.7> }
      cylinder { 0*y, 3.25*y, 0.02 translate x*0.50 }
   }
   rotate z*10
   //texture { TempTexture }
}

#declare Ship_FallenPole = object {
   union {
      cone { -0.5*y, 0.06, 5.0*y, 0.04 }
      object { Rustacle1 scale 0.16 rotate x*24 rotate y*90 translate <-0.05, 0.7, 0> }
      object { Rustacle2 scale 0.17 rotate x*25 rotate y*90 translate <-0.05, 1.4, 0> }
      object { Rustacle1 scale 0.15 rotate x*24 rotate y*90 translate <-0.05, 1.9, 0> }
      object { Rustacle4 scale 0.14 rotate x*23 rotate y*90 translate <-0.05, 2.4, 0> }
      object { Rustacle3 scale 0.16 rotate x*23 rotate y*90 translate <-0.05, 3.0, 0> }
      object { Rustacle2 scale 0.14 rotate x*25 rotate y*90 translate <-0.05, 3.9, 0> }
      object { Rustacle4 scale 0.23 rotate x*24 rotate y*90 translate <-0.05, 4.5, 0> }
      object { Rustacle3 scale 0.17 rotate x*24 rotate y*90 translate <-0.05, 4.7, 0> }
   }
}

#declare Ship_FrontBox = object {
   union {
      box { <-0.4, 0, -0.4> <0.4, 0.2, 0.4> }
      box { <-0.4, 0.2, -0.4> <-0.38, 0.4, -0.38> }
      box { <-0.4, 0.2,  0.4> <-0.38, 0.5,  0.38> }
      box { < 0.4, 0.2, -0.4> < 0.38, 0.6, -0.38> }
      box { < 0.4, 0.2,  0.4> < 0.38, 0.4,  0.38> }
   }
   //texture { RedT }
}

#declare Ship_FrontBox2 = object {
   union {
      box { <-0.15, 0, -0.15> <0.15, 0.1, 0.15> }
      sphere { 0*x, 0.12 scale <1, 0.5, 1> translate 0.1*y }
   }
   //texture { RedT }
}

#declare Ship_FrontCrane = object {
   union {
      cone { -0.5*y, 0.07, 0.5*y, 0.04 }
      cone { -0.2*y, 0.05, 0.6*y, 0.02 rotate -z*35 }
      union {
         cylinder { 0*x, 0.40*x, 0.01 }
         object { Rustacle1 scale 0.044 translate <0.15, 0.03, 0> rotate -z*15 }
         object { Rustacle4 scale 0.060 translate <0.37, 0.01, 0> rotate -z*15 }
         rotate z*15
         translate <0, 0.4, -0.04>
      }
      union {
         cylinder { 0*x, 0.40*x, 0.01 }
         object { Rustacle2 scale 0.045 translate <0.10, 0.02, 0> rotate -z*15 }
         object { Rustacle4 scale 0.035 translate <0.25, 0.01, 0> rotate -z*15 }
         object { Rustacle1 scale 0.055 translate <0.35, 0.03, 0> rotate -z*15 }
         rotate z*15
         translate <0, 0.4,  0.04>
      }
   }
   //texture { RedT }
}

#declare Ship_RopeTie = object {
   union {
      box { <-0.065, 0, -0.025> <0.065, 0.005, 0.025> }
      union {
         cylinder { 0*y, 0.065*y, 0.02 }
         sphere { 0*x, 0.02 scale <1, 0.5, 1> translate y*0.065 }
         cylinder { 0*y, 0.0075*y, 0.025 translate y*0.055 }
         torus { 0.02, 0.005 translate y*0.055 }
         torus { 0.02, 0.0015 translate y*0.025 }
         translate -x*0.035
      }
      union {
         cylinder { 0*y, 0.065*y, 0.02 }
         sphere { 0*x, 0.02 scale <1, 0.5, 1> translate y*0.065 }
         cylinder { 0*y, 0.0075*y, 0.025 translate y*0.055 }
         torus { 0.02, 0.005 translate y*0.055 }
         torus { 0.02, 0.0015 translate y*0.025 }
         translate x*0.035
      }
   }
   scale 1.25
   //texture { RedT }
}

#declare Ship_Anchor = object {
   union {
      torus { 0.15, 0.0125 rotate -x*90 }
      cylinder {
         0*z, -0.125*z, 0.2 open scale <1, 0.9, 1>
         clipped_by {
            plane { -y, 0 }
            plane { -z, 0 rotate -x*25 translate -0.06*z }
         }
      }
      union {
         torus { 0.04, 0.035 rotate -x*90 }
         //cylinder { -y*0.03, -y*0.4, 0.025 scale <1, 1, 0.6> }
         cone { -y*0.03, 0.02, -y*0.4, 0.037 scale <1, 1, 0.6> }
         cylinder { -y*0.38, -y*0.5, 0.040 scale <1, 1, 0.6> }
         sphere { 0*x, 0.040 scale <1, 1.7, 0.6> translate -y*0.5 }
         difference {
            torus { 0.20, 0.01 rotate -x*90 }
            plane { -y, 0 }
            scale <1.5, 1, 3>
            translate -y*0.275
         }
         difference {
            sphere { 0*x, 0.1 scale <0.2, 1, 1> }
            plane { y, 0 }
            translate <0.3, -0.275, 0>
         }
         difference {
            sphere { 0*x, 0.1 scale <0.2, 1, 1> }
            plane { y, 0 }
            translate <-0.3, -0.275, 0>
         }
         rotate x*2
      }
   }
   texture { Ship_RustyIron finish { ambient 0.10 diffuse 0.35 } }
}

#declare Ship_FrontThing2 = object {
   union {
      cylinder { 0*y, 0.065*y, 0.02 }
      sphere { 0*x, 0.02 scale <1, 0.5, 1> translate y*0.065 }
      cylinder { 0*y, 0.0075*y, 0.025 translate y*0.055 }
      torus { 0.02, 0.005 translate y*0.055 }
      torus { 0.02, 0.0015 translate y*0.025 }
   }
   scale 2.5
   //texture { RedT }
}


#declare R5 = seed ( 01010 )
#declare RustCount = 0
#declare RustBits1 = object {
   difference {
      union {
         #while (RustCount < 90)
            #declare RandomNumber = rand ( R5 )
            #declare RustBits1_Transform = transform {
                  scale 0.05
                  rotate -y*0
                  translate z*1.975
                  translate -y*0.05*RandomNumber
                  rotate y*RustCount
            }

            #if ( RandomNumber < 0.25 )
               object { Rustacle1 transform RustBits1_Transform }
            #else
            #if ( RandomNumber < 0.50 )
               object { Rustacle2 transform RustBits1_Transform }
            #else
            #if ( RandomNumber < 0.75 )
               object { Rustacle3 transform RustBits1_Transform }
            #else
            #if ( RandomNumber < 1.00 )
               object { Rustacle4 transform RustBits1_Transform }
            #end
            #end
            #end
            #end

            #declare RustCount = RustCount + RandomNumber*5
         #end
      }
      plane { z, 0.5 }
      translate -z*0.5
      scale <2.155, 1, 1.455>
   }
}

#declare RustCount = 0
#declare RustBits2 = object {
   difference {
      union {
         #while (RustCount < 90)
            #declare RandomNumber = rand ( R5 )
            #declare RustBits2_Transform = transform {
                  scale 0.05
                  rotate -y*0
                  translate -z*1.975
                  translate -y*0.05*RandomNumber
                  rotate -y*RustCount
            }

            #if ( RandomNumber < 0.25 )
               object { Rustacle1 transform RustBits2_Transform }
            #else
            #if ( RandomNumber < 0.50 )
               object { Rustacle2 transform RustBits2_Transform }
            #else
            #if ( RandomNumber < 0.75 )
               object { Rustacle3 transform RustBits2_Transform }
            #else
            #if ( RandomNumber < 1.00 )
               object { Rustacle4 transform RustBits2_Transform }
            #end
            #end
            #end
            #end

            #declare RustCount = RustCount + RandomNumber*5
         #end
      }
      plane { -z, 0.5 }
      translate z*0.5
      scale <2.155, 1, 1.455>
   }
}


#declare RustCount = 0
#declare RustBits3 = object {
   difference {
      union {
         #while (RustCount < 90)
            #declare RandomNumber = rand ( R5 )
            #declare RustBits3_Transform = transform {
                  scale <0.25, 0.17, 0.25>*RandomNumber
                  rotate x*5
                  translate z*2
                  translate -y*0.05*RandomNumber
                  rotate y*RustCount
            }

            #if ( RandomNumber < 0.25 )
               object { Rustacle1 transform RustBits3_Transform }
            #else
            #if ( RandomNumber < 0.50 )
               object { Rustacle2 transform RustBits3_Transform }
            #else
            #if ( RandomNumber < 0.75 )
               object { Rustacle3 transform RustBits3_Transform }
            #else
            #if ( RandomNumber < 1.00 )
               object { Rustacle4 transform RustBits3_Transform }
            #end
            #end
            #end
            #end

            #declare RustCount = RustCount + RandomNumber*5
         #end
      }
      plane { z, 0.5 }
      translate -z*0.5
      scale <2.25, 1.3, 1>
      scale <1, 1, 1.5>
   }
}

#declare RustCount = 0
#declare RustBits4 = object {
   difference {
      union {
         #while (RustCount < 90)
            #declare RandomNumber = rand ( R5 )
            #declare RustBits4_Transform = transform {
                  scale <0.25, 0.17, 0.25>*RandomNumber
                  rotate -x*5
                  translate -z*2
                  translate -y*0.05*RandomNumber
                  rotate -y*RustCount
            }

            #if ( RandomNumber < 0.25 )
               object { Rustacle1 transform RustBits4_Transform }
            #else
            #if ( RandomNumber < 0.50 )
               object { Rustacle2 transform RustBits4_Transform }
            #else
            #if ( RandomNumber < 0.75 )
               object { Rustacle3 transform RustBits4_Transform }
            #else
            #if ( RandomNumber < 1.00 )
               object { Rustacle4 transform RustBits4_Transform }
            #end
            #end
            #end
            #end

            #declare RustCount = RustCount + RandomNumber*5
         #end
      }
      plane { -z, 0.5 }
      translate z*0.5
      scale <2.25, 1.3, 1>
      scale <1, 1, 1.5>
   }
}


// ----------------------------------------------------------------------------------------
//                                     Ship: Main Object
// ----------------------------------------------------------------------------------------

#declare Ship = object {
   union {
      object { Ship_MainHull }
      object { Ship_Rails }
      object { Ship_FrontThing1 translate < 4.275, 0, 0> }
      object { Ship_GroundFloor translate < -8, -0.25, 0> }
      object { Ship_FirstFloor translate < -8,  0.15, 0> }
      object { Ship_SecondFloor translate < -8,  0.55, 0> }
      object { Ship_TopFloor translate < -8,  0.95, 0> }
      object { Ship_SmokeStack translate  <-20, 1.35, 0> }
      object { Ship_SmokeStack translate  <-40, 1.35, 0> }
      //object { Ship_SmokeStack translate  <-36, 1.35, 0> }

      object { Ship_FallenPole rotate z*76 rotate y*8 translate <-2.8, 0, 0> }
      object { Ship_FrontBox translate <-1, 0, 0> }
      object { Ship_FrontBox2 translate <0.5, 0,  1> }
      object { Ship_FrontBox2 translate <0.5, 0, -1> }
      object { Ship_FrontCrane rotate y*20 translate <3.2, 0, 0> }

      object { Ship_RopeTie translate < 0.0, 0, 2> }
      object { Ship_RopeTie translate <-1.2, 0, 2> }
      object { Ship_RopeTie translate <-2.4, 0, 2> }
      object { Ship_RopeTie rotate y*15 translate < 1.8, 0, 1.75> }
      object { Ship_RopeTie rotate y*38 translate < 3.2, 0, 1.00> }
      object { Ship_RopeTie translate < 0.0, 0, -2> }
      object { Ship_RopeTie translate <-1.2, 0, -2> }
      object { Ship_RopeTie translate <-2.4, 0, -2> }
      object { Ship_RopeTie rotate -y*15 translate < 1.8, 0, -1.75> }
      object { Ship_RopeTie rotate -y*38 translate < 3.2, 0, -1.00> }
      object { Ship_Anchor scale 0.6 rotate x*8 rotate y*221 translate <3.23, -0.35, 1.3> }
      object { Ship_Anchor scale 0.6 rotate x*8 rotate y*319 translate <3.23, -0.35, -1.3> }

      object { Ship_FrontThing2 translate <1.3, 0, -0.3> }
      object { Ship_FrontThing2 translate <1.3, 0,  0.3> }
      object { Ship_FrontThing2 translate <2.4, 0, -0.3> }
      object { Ship_FrontThing2 translate <2.4, 0,  0.3> }

      object { RustBits1 translate <0, 0.15, 0> }
      object { RustBits2 translate <0, 0.15, 0> }
      object { RustBits3 translate <0, -0.05, 0> }
      object { RustBits4 translate <0, -0.05, 0> }
      object { Rustacle1 scale 0.3 rotate x*8 rotate y*221 translate <3.30, -0.4, 1.25> }

   }
}


#if ( EditMode = on )

#if ( Ship_Switch = on )

//object { Ship rotate y*89 rotate z*5.5 }


object {
   Ship //_Anchor scale 5
   //rotate -x*20
   rotate y*90
   rotate -x*75
   //rotate x*90
   //rotate -y*180
   //translate -y*0.5
   //translate -z*3
}


#end

/*
cylinder { -x*100, x*100, 0.02 translate <0, -0.6, 1.3> texture { RedT } }
cylinder { -x*100, x*100, 0.02 translate <0, -0.6, -1.3> texture { RedT } }
cylinder { -z*100, z*100, 0.02 translate <3.25, -0.6, 0> texture { RedT } }
cylinder { -z*100, z*100, 0.02 rotate -y*55 translate <3.3, -0.6, 1.3> texture { RedT } }
*/

#end
