/*
 -=-------------------------------------------=-

     T H E  V E R Y  L A R G E   A R R A Y

                       A T

     ###   ##    ###   ##   ###   ###    ##
    #     #  #  #     #  #  #  #  #  #  #  #
     ##   #  #  #     #  #  ###   ###   #  #
       #  #  #  #     #  #  # #   # #   #  #
    ###    ##    ###   ##   #  #  #  #   ##

                      -  N E W   M E X I C O

 -=-------------------------------------------=-

 The world's largest and modern aperture-
 synthesis radio-telescope.

 Modelled by Robert Fremin, d96rfr@csd.uu.se
 For the IRTC raytrace competition, Jan-Feb 1998

 -=-------------------------------------------=-
*/



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "chars.inc"   // FIXME-add comments describing each of these
#include "consts.inc"

//===========================================================================
// SCALE: 1.0 = 1 meter

// (on the dish)
#declare use_corrugation	= 1
#declare use_framework		= 1
#declare use_platforms		= 1
#declare final				= 1

#declare UP_ANGLE			= 65
#declare SIDE_ANGLE			= 40 			//60 //40

//===========================================================================

#include "tex.inc"
#include "mount.inc"
#include "the_stand.inc"
#include "dish.inc"

//===========================================================================

camera
{
//	location  <10, 2, 4.9> look_at <0, 2, 4.9>			// back pod
//	location  <0, 15, -50> look_at <0, 2, 0>			// front
//	location  <0, 15+15, -50> look_at <0, 2+15, 0>		// front high
//	location  <0, 10, -25> look_at <0, 2, 0>			// front close
//	location  <0, 4+10, -30> look_at <0, 8, 0>			// front overview
//	location  <0+5, 18-5, -12-5> look_at <0, 12-3, 0>	// working platforms
//	location  <45, 3, -70> look_at <0, 11, 45>			// front side overview (final old)
	location  <25, 3, -51> look_at <-10, 22, 45>		// front side overview (FINAL!)
//	location <0,0,-20> look_at <0,3,0>					// working bottom parts
//	location <0,15,-30> look_at <0,17,0>				// working disc
//	location  <25, 200, -351> look_at <-10, 22, 45>		// birds-eye
	ultra_wide_angle
}

//===========================================================================

#declare SunLight = color <1,1,.85>
#declare SunFill = color Gray50
#declare SunPos = <20000, 1300, -50>
//#declare SunPos = <20000, 13000, 50>

light_source { SunPos color White #if (final) area_light x*5 z*5 5 4 jitter #end fade_distance 21000 fade_power 2 }
light_source { <-1000,200,-1000> color Gray50 #if (!final) area_light x*20 z*20 3 3 jitter #end fade_distance 1300 fade_power 2 shadowless }
//light_source { <400,200,-200> color White fade_distance 400 fade_power 2 shadowless }

/*
#declare MoonLight = 1
#include "..\moon.inc"
object { TheMoon scale .05 }
*/

//===========================================================================

sky_sphere
{
//	pigment { SkyBlue }
	#if (final)
		pigment
		{
			gradient y
			pigment_map
			{
//				[0 color <.4,.15,.11>][.3 color <.03,0,.04>]
//				[0 color <.5,.13,.11>][.3 color <.03,0,.04>]
//				[0 color <.4,.15,.06>][.3 color <.03,0,.04>]	// red night sky
//				[0 color <.1,.15,.2>][.3 color <.03,0,.04>]		// blue night
				[0 color <.15,.12,.2>][.3 color <.03,0,.04>]	// deep blue night
			}
		}
	#else
//		pigment { color <.4,.15,.11> }
		pigment { color <.15,.12,.2> }
	#end
}

#declare stars =
union
{
	#declare c = 0
	#declare R = seed(7871)
	#while (c < 200)
		sphere
		{
			#declare ry = rand(R)
			<(rand(R)-.5)*2000,200+ry*500,1000> .5*(rand(R)+ry)
		}
		#declare c = c + 1
	#end

	no_shadow
}

#declare Ground =
height_field
{
	png "ground1.png"
	#if (final)
		smooth
	#end
	rotate x*-2
//	pigment { granite pigment_map { [0 rgb <.9,.8,.7>][.2 rgb <.9,.7,.4>][1 color rgb <.5,.6,.7>] } scale 2 }
//	pigment { granite pigment_map { [0 rgb <.5,.3,.2>][.8 rgb <.7,.5,.2>][1 color rgb <.5,.4,.3>] } scale 2 }
//	pigment { granite pigment_map { [0 color rgb <.6,.4,.2>][.2 rgb <.7,.5,.3>][.4 rgb <.8,.6,.4>][1 rgb <.9,.7,.5>] } scale 1 }
	pigment { granite pigment_map { [0 color <1,.8,.7>][.5 color <1,.6,.3>][1 color <.8,.7,.6>] } scale 4 }
//	pigment { Green }
//	pigment { color <1,.7,.5> }
	finish { ambient .1 diffuse .8 specular .1 crand .02 }
	normal { granite scale .2 turbulence .1 }
	scale <300,2,600>
	translate <-120,-.5,-50>
}


//===========================================================================

#declare complete_antenna =
union
{
	object { the_stand }
	union
	{
		object { mount translate y*8 }
		object { the_dish translate z*-8 rotate x*UP_ANGLE translate y*13 }
		rotate y*SIDE_ANGLE
	}

	texture { WhitePaint }
}

#declare antennas =
union
{
	#declare dist = 75

	object { complete_antenna translate z*dist*0 }
	object { complete_antenna translate z*dist*1 }
	object { complete_antenna translate z*dist*2 }
	object { complete_antenna translate z*dist*3 }
	object { complete_antenna translate z*dist*4 }
	object { complete_antenna translate z*dist*5 }
	object { complete_antenna translate z*dist*6 }
	object { complete_antenna translate z*dist*7 }

	union {
		object { pods translate z*dist*0 }
		object { pods translate z*dist*1 }
		object { pods translate z*dist*2 }
		object { pods translate z*dist*3 }
		object { pods translate z*dist*4 }
		object { pods translate z*dist*5 }
		object { pods translate z*dist*6 }
		object { pods translate z*dist*7 }

		object { pods translate z*(dist/2+dist*0) }
		object { pods translate z*(dist/2+dist*1) }
		object { pods translate z*(dist/2+dist*2) }
		object { pods translate z*(dist/2+dist*3) }
		object { pods translate z*(dist/2+dist*4) }
		object { pods translate z*(dist/2+dist*5) }

		pigment { Gray50 }
		#if (final)
			normal { bumps scale <2,2.5,2> }
		#end
	}

	texture { WhitePaint }
}

#declare mountains =
height_field
{
	gif "plasma2.gif"
	#if (final)
//		smooth
	#end
//	pigment { granite pigment_map { [0 rgb <.2,.2,.2>][.1 rgb <.2,.2,.2>][1 color rgb <.5,.5,.5>] } }
//	pigment { granite pigment_map { [0 color rgb <.15,.25,.35>][.1 rgb <.4,.3,.2>][1 rgb <.5,.3,.2>] } }
//	pigment { granite pigment_map { [0 color rgb <.7,.5,.3>][.1 rgb <.8,.6,.4>][.6 rgb <.9,.7,.5>][1 rgb <1,.8,.6>] } }
	pigment { granite pigment_map { [0 color <.3,.2,.1>][1 color <.6,.4,.2>] } }
//	pigment { color <.6,.5,.4> }
//	finish { ambient .0 }

	rotate x*-40
	scale <850,50,100>
	translate <-600,-40,700>
}

//===========================================================================

object { Ground }
object { mountains }
object { stars translate x*-100 pigment { White } finish { Luminous } }
object { stars scale .8 translate <-140,-150,100> pigment { Gray40 } finish { Luminous } }
//object { complete_antenna }
object { antennas }
