// The dish
//
//	objects:
//		the_dish

#include "metals.inc"
#include "tex.inc"


// definitions for the frame structure
#declare PartsPer360 = 10
#declare PartsPerFrame = 5
#declare AnglePerPart = 360 / (PartsPer360 * PartsPerFrame)

#declare DishRadius = 19.8 //18
#declare DishCompensation = 15 //12.5



#declare FramePart =
union
{
	#declare r1 = x*13.1 + z*.2
	#declare r2 = x*10.8 + z*2.8
	#declare r3 = x*9.5 + z*3.8
	#declare r4 = x*8.0  + z*4.8
	#declare r5 = x*6    + z*5.4

	// angles of fixpoints
	#declare v1 = 44.5+5.1
	#declare v2 = 49.5+5.1
	#declare v3 = 54.5+5.1
	#declare v4 = 59.5+5.1

	// tube diameters
	#declare d1 = .075
	#declare d2 = .05

	// outer frames
	/*
		11****12****13****14****15****16
        *   *  *    **    **    * *
        * *     *  *  *  *  *  *    *
        21      *  *  *  *  *  *      22
        * ***    **    **    **   ***
        *    *** 31****32****33***
        * ***      **  *   **     ***
        41*************42*************43
        *        ****** ******
        *  ******             ******
        51****************************52
	*/

	#declare f11 = vrotate(r1, 0*z*AnglePerPart)
	#declare f12 = vrotate(r1, 1*z*AnglePerPart)
	#declare f13 = vrotate(r1, 2*z*AnglePerPart)
	#declare f14 = vrotate(r1, 3*z*AnglePerPart)
	#declare f15 = vrotate(r1, 4*z*AnglePerPart)
	#declare f16 = vrotate(r1, 5*z*AnglePerPart)
	#declare f21 = vrotate(r2, 0*z*AnglePerPart)
	#declare f22 = vrotate(r2, 5*z*AnglePerPart)
	#declare f31 = vrotate(r3, 1.5*z*AnglePerPart)
	#declare f32 = vrotate(r3, 2.5*z*AnglePerPart)
	#declare f33 = vrotate(r3, 3.5*z*AnglePerPart)
	#declare f41 = vrotate(r4, 0.0*z*AnglePerPart)
	#declare f42 = vrotate(r4, 2.5*z*AnglePerPart)
	#declare f43 = vrotate(r4, 5.0*z*AnglePerPart)
	#declare f51 = vrotate(r5, 0*z*AnglePerPart)
	#declare f52 = vrotate(r5, 5*z*AnglePerPart)

	cylinder { f11 f12 d1 }
	cylinder { f12 f13 d1 }
	cylinder { f13 f14 d1 }
	cylinder { f14 f15 d1 }
	cylinder { f15 f16 d1 }

	cylinder { f11 f21 d2 }
	cylinder { f12 f21 d2 }
	cylinder { f15 f22 d2 }

	cylinder { f21 f31 d1 }
	cylinder { f12 f31 d2 }
	cylinder { f13 f31 d2 }
	cylinder { f31 f32 d1 }
	cylinder { f13 f32 d2 }
	cylinder { f14 f32 d2 }
	cylinder { f32 f33 d1 }
	cylinder { f14 f33 d2 }
	cylinder { f15 f33 d2 }
	cylinder { f22 f33 d1 }

	cylinder { f21 f41 d1 }
	cylinder { f31 f41 d1 }
	cylinder { f41 f42 d1 }
	cylinder { f31 f42 d1 }
	cylinder { f32 f42 d1 }
	cylinder { f33 f42 d1 }
	cylinder { f42 f43 d1 }
	cylinder { f33 f43 d1 }

	cylinder { f41 f51 d1 }
	cylinder { f42 f51 d1 }
	cylinder { f42 f52 d1 }
	cylinder { f51 f52 d1 }

	// inner fixpoints
	#declare p11 = vrotate(x*DishRadius, -y*v1+0*z*AnglePerPart) - z*DishCompensation
	#declare p12 = vrotate(x*DishRadius, -y*v1+1*z*AnglePerPart) - z*DishCompensation
	#declare p13 = vrotate(x*DishRadius, -y*v1+2*z*AnglePerPart) - z*DishCompensation
	#declare p14 = vrotate(x*DishRadius, -y*v1+3*z*AnglePerPart) - z*DishCompensation
	#declare p15 = vrotate(x*DishRadius, -y*v1+4*z*AnglePerPart) - z*DishCompensation
	#declare p21 = vrotate(x*DishRadius, -y*v2+0*z*AnglePerPart) - z*DishCompensation
	#declare p22 = vrotate(x*DishRadius, -y*v2+1*z*AnglePerPart) - z*DishCompensation
	#declare p23 = vrotate(x*DishRadius, -y*v2+2*z*AnglePerPart) - z*DishCompensation
	#declare p24 = vrotate(x*DishRadius, -y*v2+3*z*AnglePerPart) - z*DishCompensation
	#declare p25 = vrotate(x*DishRadius, -y*v2+4*z*AnglePerPart) - z*DishCompensation
	#declare p31 = vrotate(x*DishRadius, -y*v3+0*z*AnglePerPart) - z*DishCompensation
	#declare p32 = vrotate(x*DishRadius, -y*v3+1*z*AnglePerPart) - z*DishCompensation
	#declare p33 = vrotate(x*DishRadius, -y*v3+2*z*AnglePerPart) - z*DishCompensation
	#declare p34 = vrotate(x*DishRadius, -y*v3+3*z*AnglePerPart) - z*DishCompensation
	#declare p35 = vrotate(x*DishRadius, -y*v3+4*z*AnglePerPart) - z*DishCompensation
	#declare p41 = vrotate(x*DishRadius, -y*v4+0*z*AnglePerPart) - z*DishCompensation
	#declare p42 = vrotate(x*DishRadius, -y*v4+1*z*AnglePerPart) - z*DishCompensation
	#declare p43 = vrotate(x*DishRadius, -y*v4+2*z*AnglePerPart) - z*DishCompensation
	#declare p44 = vrotate(x*DishRadius, -y*v4+3*z*AnglePerPart) - z*DishCompensation
	#declare p45 = vrotate(x*DishRadius, -y*v4+4*z*AnglePerPart) - z*DishCompensation

	// from outer to inner parts
	cylinder { f11 p11 d2 }
	cylinder { f12 p12 d2 }
	cylinder { f13 p13 d2 }
	cylinder { f14 p14 d2 }
	cylinder { f15 p15 d2 }

	cylinder { f21 p21 d2 }
	cylinder { f21 p31 d2 }
	cylinder { f21 p22 d2 }
	cylinder { f21 p32 d2 }

	cylinder { f31 p22 d2 }
	cylinder { f31 p32 d2 }
	cylinder { f31 p23 d2 }
	cylinder { f31 p33 d2 }
	cylinder { f32 p23 d2 }
	cylinder { f32 p33 d2 }
	cylinder { f32 p24 d2 }
	cylinder { f32 p34 d2 }
	cylinder { f33 p24 d2 }
	cylinder { f33 p34 d2 }
	cylinder { f33 p25 d2 }
	cylinder { f33 p35 d2 }

	cylinder { f22 p25 d2 }
	cylinder { f22 p35 d2 }

	cylinder { f41 p31 d2 }
	cylinder { f41 p41 d2 }
	cylinder { f43 p45 d2 }
	cylinder { f41 p42 d2 }

	cylinder { f51 p41 d2 }
}

// The one of four that holds the LNB in place.
#declare boom =
intersection
{
	box { <0,.2,.4> <13,-.2,-.2> rotate y*-50 translate <1.1,0,-5.5> }
	sphere { z*-DishCompensation DishRadius }
}

#declare corrugation =
cylinder { x*-.15 x*.15 DishRadius+.1 translate z*-DishCompensation }

#declare corrugations =
union
{
	#declare c = 0
	#while (c < 180)
		object { corrugation rotate z*c }
		#declare c = c + 3
	#end
}

#declare yboom =
union
{
	cylinder { 0 y*.1 .3 }
	cylinder { y*.1 y*1 .15 }
	cylinder { y*1 y*1.2 .2 }
	cylinder { y*1.2 y*3 .14 }

		// bolts
	#if (final)
		#declare c = 0
		#while (c < 10)
			cylinder { <.225,.1,0> <.225,.15,0> .05 rotate y*c*36 }
			#declare c = c + 1
		#end
	#end
}

#declare angle_part =
union
{
	intersection
	{
		union
		{
			difference
			{
				cylinder { x*-.2 x*.2 3.5 }
				cylinder { x*-1 x*1 2.9 }
			}
			difference
			{
				cylinder { x*-.3 x*.3 3.5 }
				cylinder { x*-1 x*1 3.4 }
			}
		}
		plane { y,0 rotate x*20 }
		plane { y,0 rotate x*-20 }
	}
	object { yboom rotate x*10 translate z*-3.2 rotate x*-20 }
	object { yboom rotate x*-10 translate z*3.2 rotate x*20 }
	cylinder { <-3.5,0,0> y*-3 .15 rotate x*40 }
	cylinder { <-3.5,0,0> y*-3 .15 rotate x*-40 }
	cylinder { <3.5,0,0> y*-3 .15 rotate x*40 }
	cylinder { <3.5,0,0> y*-3 .15 rotate x*-40 }
	cylinder { x*-3.8 x*3.8 .2 }
}

#declare the_dish =
union
{
	// framework
	#if (use_framework)
		#declare c = 0
		#while (c < PartsPer360)
			object { FramePart rotate z*c*360/PartsPer360 }
			#declare c = c + 1
		#end
	#end

	// parabol
	intersection
	{
		difference
		{
			merge
			{
				sphere { z*-DishCompensation DishRadius }
				#if (use_corrugation)
					torus { p11.x .07 rotate x*90 translate 1.01*p11.y }
					torus { p21.x .05 rotate x*90 translate 1.01*p21.y }
					torus { p31.x .05 rotate x*90 translate 1.01*p31.y }
					torus { p41.x .05 rotate x*90 translate 1.01*p41.y }
					object { corrugations rotate z*0 }
				#end
			}
			sphere { z*-DishCompensation DishRadius-.05 }
		}
		box { <-1000,-1000,0> <1000,1000,1000> }
	}

	difference
	{
		union
		{
			box { <-3.75, -4, 3.5> <3.75, 4, 6.6> }
			box { <-3.90, -2, 3.5> <3.90, 2, 7>   }

			#declare a1 = < 3.5,-4, 6.6>
			#declare a2 = < 3.5, 0, 8>
			#declare a3 = < 3.5, 4, 6.6>
			#declare b1 = <-3.5,-4, 6.6>
			#declare b2 = <-3.5, 0, 8>
			#declare b3 = <-3.5, 4, 6.6>
			#declare c1 = <-3.5, 4, 3.5>
			#declare c2 = <    0, 6, 3.5>
			#declare c3 = < 3.5, 4, 3.5>
			#declare c4 = <    0, 6, 5.25>

			triangle { a1 a2 a3 }
			triangle { b1 b2 b3 }
			triangle { a1 a2 b1 }
			triangle { b1 b2 a2 }
			triangle { a2 a3 b3 }
			triangle { b2 b3 a2 }

			triangle { c1 c2 c3 }
			triangle { a3 c2 c3 }
			triangle { a3 c4 c2 }
			triangle { b3 c4 c2 }
			triangle { b3 c1 c2 }
			triangle { a3 b3 c4 }

			union
			{
				triangle { c1 c2 c3 }
				triangle { a3 c2 c3 }
				triangle { a3 c4 c2 }
				triangle { b3 c4 c2 }
				triangle { b3 c1 c2 }
				triangle { a3 b3 c4 }
				scale <1,-1,1>
			}
		}

		sphere { z*-DishCompensation DishRadius }
	}

	// antenna parts
	cylinder { z*-6.6 z*-5.8 .6 }
	cylinder { z*-5.8 z*-4.8 1.2 }
	#if (final)
	#declare c = 0
		#while (c < 16)
			cylinder { z*-5.8 z*-4.8 .05 translate x*1.2 rotate z*c*22.5 }
			#declare c = c + 1
		#end
	#end

	// LNB
	union
	{
		cylinder { z*0 z*-.5 1 }
		sphere { 0 1.5 scale <1,1,.4> clipped_by { plane { -z,0 } } }
		disc { 0 z 1.5 }
		translate z*-4.6
	}

	object { boom }
	object { boom rotate z*90 }
	object { boom rotate z*180 }
	object { boom rotate z*270 }

	#if (final)
		// wires
		cylinder { <.2,-8,3> <1.5,-.1,-4.8> .03 }
		cylinder { <.2,-8,3> <1.5,-.1,-4.8> .03 scale <1,-1,1> }
		cylinder { <.2,-8,3> <1.5,-.1,-4.8> .03 scale <-1,1,1> }
		cylinder { <.2,-8,3> <1.5,-.1,-4.8> .03 scale <-1,-1,1> }

		// small antenna
		cylinder { <-.8,.7,-5.8> <-.8,.7,-8> .03 }
	#end

	object { angle_part rotate x*-90 translate z*7.5 }

	object { ladder1 rotate x*-90 rotate y*-70 translate <6,0,5.7> }
}
