
// create a smooth blobby shape
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components

#declare finger =
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  cylinder { <-1.675, 0.65,0>, <0,0,0> 1.0, 1.0 }
}
#declare finger2 =
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  cylinder { <-1.675, 0.65,0>, <-1.8,.65,1> 0.8, 1.0 }
}

#declare finger3 =
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  cylinder { <-1.8, 0.65,1>, <-1.8,.65,1.5> 0.7, 1.0 }
}

#declare palm =
blob {
   threshold 0.6
   sphere { <0,-.4,0> 1.5, 1 }
   scale <2,2,1>
}

#declare hand =
union {
   object { palm }
   object { finger }
   object { finger rotate <0,0,20>
      translate <0,-.2,0>
   }
   object { finger rotate <0,0,40>
      translate <0,-.4,0>
   }
   object { finger rotate <0,0,60>
      translate <0,-.6,0>
   }
   object { finger2 }
   object { finger2 rotate <0,0,20>
      translate <0,-.2,0>
   }
   object { finger2 rotate <0,0,40>
      translate <0,-.4,0>
   }
   object { finger2 rotate <0,0,60>
      translate <0,-.6,0>
   }
   object { finger3 }
   object { finger3 rotate <0,0,20>
      translate <0,-.2,0>
   }
   object { finger3 rotate <0,0,40>
      translate <0,-.4,0>
   }
   object { finger3 rotate <0,0,60>
      translate <0,-.6,0>
   }
   // This is the thumb
   union {
      object { finger }
      object { finger2 }
      rotate <90,0,0>
      rotate <0,45,0>
   }
   texture { T02 }
}

object { hand
   scale <.3,.2,.3>
   rotate <0,-45,0>
   rotate <0,0,-15>
   translate <4,13.6,15.4>
}
object { hand
    scale <-.3,.2,.3>
    rotate <0,90,0>
    rotate <0,0,90>
    rotate <0,45,0>
    translate <-3.5,11.2,15.1>    
}
    
