// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Bridge inc file for "First Kiss"
// Date: March 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#include "t_bridge.inc"

#declare Part_arch_1 =
difference {
	union {
		difference {
			cylinder {<0,-58.8333,0><0,-58.8333,1>,90.8333}
			cylinder {<0,-58.8333,-10><0,-58.8333,10>,90.0833}
		}
		difference {
			cylinder {<0,-35.0769,0><0,-35.0769,1>,61.8269}
			cylinder {<0,-35.0769,-10><0,-35.0769,10>,61.0769}
		}
		box {<-0.2500,26.5500,0><0.2500,31.4500,1>}
	}
	box {<-50,50,50><-100,-50,-50>}
	box {<50,50,50><100,-50,-50>}
	box {<200,0,200><-200,-200,-200>}
}

#declare Part_arch_2 =
union {
	box {<-50.0000,1.2902,0><-49.5000,16.6705,1>}
	box {<-45.2500,7.0286,0><-44.7500,19.4359,1>}
	box {<-40.7500,11.3733,0><-40.2500,21.8564,1>}
	box {<-36.2500,14.9418,0><-35.7500,23.9621,1>}
	box {<-31.7500,17.8913,0><-31.2500,25.7765,1>}
	box {<-27.2500,20.3205,0><-26.7500,27.3182,1>}
	box {<-22.7500,22.2958,0><-22.2500,28.6014,1>}
	box {<-18.2500,23.8627,0><-17.7500,29.6375,1>}
	box {<-13.7500,25.0532,0><-13.2500,30.4350,1>}
	box {<-9.2500,25.8893,0><-8.7500,31.0003,1>}
	box {<-4.7500,26.3855,0><-4.2500,31.3378,1>}

	cylinder {<-49.5000,16.4312,0.5><-45.2500,7.0539,0.5>,.4}
	cylinder {<-44.7500,19.3488,0.5><-40.7500,11.4205,0.5>,.4}
	cylinder {<-40.2500,21.7579,0.5><-36.2500,15.0081,0.5>,.4}
	cylinder {<-35.7500,23.8525,0.5><-31.7500,17.9750,0.5>,.4}
	cylinder {<-31.2500,25.6560,0.5><-27.2500,20.4209,0.5>,.4}
	cylinder {<-26.7500,27.1867,0.5><-22.7500,22.4123,0.5>,.4}
	cylinder {<-22.2500,28.4590,0.5><-18.2500,23.9951,0.5>,.4}
	cylinder {<-17.7500,29.4840,0.5><-13.7500,25.2016,0.5>,.4}
	cylinder {<-13.2500,30.2702,0.5><-9.2500,26.0541,0.5>,.4}
	cylinder {<-8.7500,30.8240,0.5><-4.7500,26.5673,0.5>,.4}
	cylinder {<-4.2500,31.1497,0.5><-0.2500,26.7495,0.5>,.4}

}

#declare Lamp_bulb_2 = sphere {<0,0,0>,.15 pigment{rgb <.8,.8,.6>} finish{ambient 1}}

#declare Bridge_lamp =
union {
	cylinder {<0,0,0><0,2,0>.15 no_shadow}
	cylinder {<0,1.9,-1.6><0,1.9,1.6>,.1  no_shadow}

	light_source {<0,1.9,1.6> color <.7,.7,.3>
	looks_like {Lamp_bulb_2}
	fade_distance 1
	fade_power 2
	}

	light_source {<0,1.9,-1.6> color <.7,.7,.3>
	looks_like {Lamp_bulb_2}
	fade_distance 2
	fade_power 2
	}
}

#declare Part_arch_3 =
union {
	object {Bridge_lamp translate <-31.5,14.75,.5>}
		cylinder {<-31.5,14.75,.5><-31.5,17.3,.5>,.1 no_shadow}
	object {Bridge_lamp translate <-27,14.75,.5>}
		cylinder {<-27,14.75,.5><-27,18.75,.5>,.1 no_shadow}
		cylinder {<-27,18.75,.5><-27,19.8,.5>,.15 no_shadow}
	object {Bridge_lamp translate <-22.5,14.75,.5>}
		cylinder {<-22.5,14.75,.5><-22.5,20.6,.5>,.1 no_shadow}
		cylinder {<-22.5,20.6,.5><-22.5,21.8,.5>,.15 no_shadow}
	object {Bridge_lamp translate <-18,14.75,.5>}
		cylinder {<-18,14.75,.5><-18,22,.5>,.1 no_shadow}
		cylinder {<-18,22,.5><-18,23.3,.5>,.15 no_shadow}
	object {Bridge_lamp translate <-13.5,14.75,.5>}
		cylinder {<-13.5,14.75,.5><-13.5,23,.5>,.1 no_shadow}
		cylinder {<-13.5,23,.5><-13.5,24.5,.5>,.15 no_shadow}
	object {Bridge_lamp translate <-9,14.75,.5>}
		cylinder {<-9,14.75,.5><-9,23.8,.5>,.1 no_shadow}
		cylinder {<-9,23.8,.5><-9,25.4,.5>,.15 no_shadow}
	object {Bridge_lamp translate <-4.5,14.75,.5>}
		cylinder {<-4.5,14.75,.5><-4.5,24.1,.5>,.1 no_shadow}
		cylinder {<-4.5,24.1,.5><-4.5,25.9,.5>,.15 no_shadow}
}

#declare Full_arch =
union {
	object {Part_arch_1}
	object {Part_arch_2}
	object {Part_arch_2 scale <-1,1,1>}

	#if (Bridge_lights = on)
		object {Part_arch_3}
		object {Part_arch_3 scale <-1,1,1>}

		object {Bridge_lamp translate <0,14.75,.5>}
		cylinder {<0,14.75,.5><0,18.75,.5>,.1 no_shadow}
		cylinder {<0,18.75,.5><0,26,.5>,.15 no_shadow}

		object {Bridge_lamp translate <36,14.75,.5>}
		object {Bridge_lamp translate <40.5,14.75,.5>}
		object {Bridge_lamp translate <45,14.75,.5>}
		object {Bridge_lamp translate <49.5,14.75,.5>}
		object {Bridge_lamp translate <54,14.75,.5>}
		object {Bridge_lamp translate <58.5,14.75,.5>}
		object {Bridge_lamp translate <63,14.75,.5>}
		object {Bridge_lamp translate <67.5,14.75,.5>}
		object {Bridge_lamp translate <72,14.75,.5>}
		object {Bridge_lamp translate <76.5,14.75,.5>}
		object {Bridge_lamp translate <81,14.75,.5>}
		object {Bridge_lamp translate <85.5,14.75,.5>}
	#end
}

#include "road.inc"

#include "tower.inc"

#include "ground1.inc"

#declare Harbour_bridge =
union {
	object {Full_arch texture{T_Bridge1}}
	object {Full_arch translate <0,0,10> texture{T_Bridge1}}
	object {Bridge_road texture{T_Bridge1}}
	object {Bridge_tower translate <-58,0,1> texture{T_Bridge1}}
	object {Bridge_tower translate <58,0,1> texture{T_Bridge1}}
	object {Bridge_tower rotate <0,180,0> translate <-58,0,10> texture{T_Bridge1}}
	object {Bridge_tower rotate <0,180,0> translate <58,0,10> texture{T_Bridge1}}
	object {Ground1 translate <63,0,0> texture{T_Tower1}}

	light_source
	{
  	<58,1,-15>
  	color rgb <1,1,.9>
  	spotlight
  	point_at <35, 15, 0>
  	radius 180
  	tightness 50
  	falloff 50
	}

	light_source
	{
  	<58,1,-15>
  	color rgb <1,1,.9>
  	spotlight
  	point_at <15, 15, 0>
  	radius 180
  	tightness 50
  	falloff 50
	}

	light_source
	{
  	<-58,1,-15>
  	color rgb <1,1,.9>
  	spotlight
  	point_at <-35, 15, 0>
  	radius 180
  	tightness 50
  	falloff 50
	}

	light_source
	{
  	<-58,1,-15>
  	color rgb <1,1,.9>
  	spotlight
  	point_at <-15, 15, 0>
  	radius 180
  	tightness 50
  	falloff 50
	}

	light_source
	{
  	<65,1,-15>
  	color rgb <1,1,.9>
  	spotlight
  	point_at <70, 12, 0>
  	radius 180
  	tightness 50
  	falloff 50
	}


}

