// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Boat inc file for "First Kiss"
// Date: March 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#include "t_boat.inc"

#declare Boat_base_1 =
difference {
	intersection {
		sphere {<3.25,0,-1>,5.1539}
		sphere {<-3.25,0,-1>,5.1539}
	}
	box {<10,0,10><-10,10,-10>}
	box {<20,20,-3><-20,-20,-20>}
}

#declare Boat_base_2 =
difference {
	object {Boat_base_1 scale <1,.3,1>}
	object {Boat_base_1 scale <.98,.29,.98> translate <0,.1,0> }
}

#declare Boat_base_3 =
difference {
	object {Boat_base_1 scale <1,.3,1>}
	object {Boat_base_1 scale <.93,.29,.93> translate <0,.1,0> }
}

#declare Boat_internal =
intersection {
	cylinder {<3.25,-10,-1><3.25,10,-1>,5.14}
	cylinder {<-3.25,-10,-1><-3.25,10,-1>,5.14}
}

#declare Boat_top =
intersection {
	box {<-2,-.05,0><2,-.1,3>}
	object {Boat_internal}
}

#declare Boat_seat1 =
intersection {
	box {<-2,-.05,-2.4><2,-.1,-2.9>}
	object {Boat_internal}
}

#declare Boat_seat2 =
intersection {
	box {<-2,-.05,-1.5><2,-.1,-0.9>}
	object {Boat_internal}
}

#declare Boat_name =
text {ttf "timrom.ttf","SYDNEY 13", 1, 0 }

#declare Boat_oar_ring =
union {
	cylinder {<0,0,0><0,.1,0>,.05}
	intersection {
		cylinder {<0,0,0><0,-0.5,0>,.1}
		object {Boat_base_1 scale <.98,.29,.98> translate <-1.75,0,1.5>}
	}
}

#declare Boat_ring =
difference {
	cylinder {<0,.2,0.05><0,.2,-0.05>,.15}
	cylinder {<0,.2,10><0,.2,-10>,.12}
	box {<5,.25,5><-5,5,-5>}
}


#declare Boat_oar_oar =
union {
	cylinder {<0,0,-0.15><0,0,5>,.06}
	cylinder {<0,0,-0.15><0,0,-0.17>,.12 pigment{White}}
	cylinder {<0,0,-0.17><0,0,-.2>,.06}
	cone {<0,0,-.2>,.06<0,0,-.3>,.04}
	cylinder {<0,0,-.3><0,0,-1.1>,.04}
	sphere {<0,0,-1.1>,.04}
}

#declare Boat_oar1 =
union {
	object {Boat_oar_ring texture{T_Boat3}}
	object {Boat_ring rotate <0,45,0> texture{T_Boat3}}
	object {Boat_oar_oar texture {T_Wood2 scale <.2,1,.2>} rotate <30,0,0> translate <0,.2,0> rotate <0,45,0>}
}

#declare Boat_oar2 =
union {
	object {Boat_oar_ring texture{T_Boat3}}
	object {Boat_ring rotate <0,-60,0> texture{T_Boat3}}
	object {Boat_oar_oar texture {T_Wood2 scale <.2,1,.2>} rotate <30,0,0> translate <0,.2,0> rotate <0,-60,0>}
}


#declare The_boat =
union {
	object {Boat_base_2 texture{T_Boat1}}

	difference {
		object {Boat_base_3 scale 1.01 pigment{White} finish {phong 1} translate <0,.025,0>}
		box {<200,0,200><-200,-200,-200> pigment{White} finish {phong 1}}
	}

	object {Boat_top texture{T_Wood2}}
	object {Boat_seat1 texture{T_Wood2}}
	object {Boat_seat2 texture{T_Wood2}}
	object {Boat_name scale <.4,.3,.4> translate <-1,-.35,-3.02> pigment{White}finish{phong 1}}

	object {Boat_oar1 translate <1.75,0,-1.5>}
	object {Boat_oar2 translate <-1.75,0,-1.5>}

	#if (Lovers_switch = on)
		#include "lovers2.inc"
		object {Lovers scale <-1,1,1> rotate <0,0,-15> scale 5 translate <0,-.9,-1.75>}
	#end

	light_source {<-1,2,-4> color <.9,.9,.9>
	fade_distance 3
	fade_power 2
	}

}
