
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Sydney Opera House for "First Kiss"
// Date: March 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13


#include "t_opera.inc"

/*

#include "colors.inc"
background {rgb <1,1,1>}

#declare Elevation = off

#if (Elevation = on)
camera {
	location <3,12,0>
	look_at  <3,0,0>
}

light_source {<5,20,0> color White}
#else
camera {
	location <2,1.5,-10>
	look_at  <2,1.5,0>
}

light_source {<10,3,-10> color White}
#end

*/

#declare Opera_light1 =
light_source
{
  <0,.5,7>              // light's position (translated below)
  color rgb <1,1,.9>       // light's color
  spotlight               // this kind of light source
  point_at <0, 2, 0>      // direction of spotlight
  radius 60                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 20               // intensity falloff radius (outer, in degrees)
}

#declare Opera_light2 =
light_source
{
  <0,.5,10>              // light's position (translated below)
  color rgb <1,1,.9>       // light's color
  spotlight               // this kind of light source
  point_at <0, 4.5, 0>      // direction of spotlight
  radius 80                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 20               // intensity falloff radius (outer, in degrees)
}

#declare Sail1 =
difference {
	sphere {<0,0,3>,6.1752}
    sphere {<0,0,3>,5.9752}
	box {<30,30,30><-30,-30,0>}
	box {<30,0,30><-30,-30,-30>}
	box {<0,30,30><-30,-30,-30> rotate <0,0,16> translate <2.4400,1.0537,0>}
}

#declare Sail2 =
difference {
	sphere {<0,0,1.5>,3.8411}
    sphere {<0,0,1.5>,3.6411}
	box {<30,30,30><-30,-30,0>}
	box {<30,0,30><-30,-30,-30>}
	box {<0,30,30><30,-30,-30> rotate <0,0,-25.5> translate <-0.5327,0.5443,0>}
}

#declare Sail3 =
difference {
	sphere {<0,0,2>,4.4949}
    sphere {<0,0,2>,4.2949}
	box {<30,30,30><-30,-30,0>}
	box {<30,0,30><-30,-30,-30>}
	box {<0,30,30><-30,-30,-30> rotate <0,0,17> translate <1.0129,0.8845,0>}
}

#declare Sail4 =
difference {
	sphere {<0,0,2>,3.8540}
    sphere {<0,0,2>,3.6540}
	box {<30,30,30><-30,-30,0>}
	box {<30,0,30><-30,-30,-30>}
	box {<0,30,30><-30,-30,-30> rotate <0,0,33> translate <0.5931,1.2528,0>}
}

#declare Centre_sail1 =
difference {
    cylinder {<1,0,0><2.5,0,0>,3.5 scale <1,1,.7>}
	cylinder {<1,0,0><2.5,0,0>,3  scale <1,1,.7>}
	box {<50,50,0><-50,-50,50>}
    box {<30,0,30><-30,-30,-30>}
	box {<0,50,50><-50,-50,-50> rotate <0,0,-17> translate <1.6468,3.3894,0>}
	box {<0,50,50><50,-50,-50> rotate <0,0,14.5> translate <1.6468,3.3894,0>}
}

#declare Centre_sail2 =
difference {
    cylinder {<1,0,0><-1,0,0>,3 scale <1,1,.6>  rotate <0,5,0>}
	cylinder {<1,0,0><-1,0,0>,2.5 scale <1,1,.6>  rotate <0,5,0>}
	box {<50,50,0><-50,-50,50>}
    box {<30,0,30><-30,-30,-30>}
	box {<-.7,50,50><-50,-50,-50>}
	box {<0,50,50><-50,-50,-50> rotate <0,0,-24.66> translate <0,3,0>}
	box {<0,50,50><50,-50,-50> rotate <0,0,16.7> translate <0,3,0>}
}

#declare Centre_sail3 =
difference {
	union {
		cylinder {<-3,0,0><0,0,0>2.6 scale <1,1.05,.8> rotate <0,-15,0> translate <4.4,0,0>}
		cylinder {<3,0,0><0,0,0>2.6 scale <1,1.05,.8> rotate <0,15,0> translate <4.4,0,0>}
	}
	cylinder {<-3,0,0><0,0,0>2.1 scale <1,1.05,.8> rotate <0,-15,0> translate <4.4,0,0>}
	cylinder {<3,0,0><0,0,0>2.1 scale <1,1.05,.8> rotate <0,15,0> translate <4.4,0,0>}
	box {<0,50,50><-50,-50,-50> rotate <0,0,-46.6> translate <4.3841,2.6390,0>}
	box {<0,50,50><50,-50,-50> rotate <0,0,41> translate <4.3841,2.6390,0>}
	box {<50,.9,50><-50,-50,-50>}
	box {<50,50,0><-50,-50,50>}
}

#declare Sails =
union {
	difference {
		union {
			object {Sail1 texture{T_Op1 translate <2.5780,1.0157,0>}}
			object {Sail2 translate <6.3242,0,0> texture{T_Op1 translate <6.0221,1.2298,0>}}
			object {Centre_sail3 texture{T_Op2}}
		}
		difference {
			box {<2.8355,1,-30><4.2845,1.5743,0> texture{T_Op2}}
			box {<0,50,50><-50,-50,-50> rotate <0,0,-46.6> translate <2.8355,1.0444,0> texture{T_Op2}}
			box {<50,0,50><-50,50,-50> rotate <0,0,-16.36> translate <4.2845,1.3311,0> texture{T_Op2}}
		}
		difference {
			box {<4.4341,1,-30><5.7916,1.5231,0> texture{T_Op2}}
			box {<0,50,50><50,-50,-50> rotate <0,0,41> translate <5.7916,1.1566,0> texture{T_Op2}}
			box {<50,0,50><-50,50,-50> rotate <0,0,11.1> translate <4.4341,1.3289,0> texture{T_Op2}}
		}
	}
	difference {
		union {
			object {Sail3 translate <-0.1048,0,0> texture{T_Op1 translate <0.8827,1.2119,0>}}
			object {Centre_sail1 texture{T_Op2}}
		}
		difference {
			box {<1.05,1,-30><2.1602,1.5711,-1> texture{T_Op2}}
			box {<0,50,50><-50,-50,-50> rotate <0,0,-17> translate <1.05,1,0> texture{T_Op2}}
			box {<0,50,50><50,-50,-50> rotate <0,0,14.5> translate <2.1602,1,0> texture{T_Op2}}
			box {<50,0,50><-50,50,-50> rotate <0,0,-8.7> translate <2.1595,1.4031,0> texture{T_Op2}}
		}
	}
	difference {
		union {
			object {Sail4 translate <-1.0900,0,0> texture{T_Op1 translate <-0.5627,1.5686,0>}}
			object {Centre_sail2 texture{T_Op2}}
		}
		difference {
			box {<-0.4219,1,-30><0.5728,1.7449,-1> texture{T_Op2}}
			box {<0,50,50><-50,-50,-50> rotate <0,0,-24.66> translate <-0.4219,1.4610,0> texture{T_Op2}}
			box {<0,50,50><50,-50,-50> rotate <0,0,16.7> translate <0.5,1,0> texture{T_Op2}}
			box {<50,0,50><-50,50,-50> rotate <0,0,-13.4> translate <0.5728,1.5633 ,0> texture{T_Op2}}
		}
	}
}

#declare Lamp_bulb = sphere {<0,0,0>,.04 pigment{rgb <1,1,.8>} finish{ambient 1}}

#declare Lamp_post =
union {
	cylinder {<0,0,0><0,.4,0>,.02 pigment{White} no_shadow}
	sphere {<0,.4,0>,.075 pigment{rgbf <1,1,.8,.8>} finish{phong 1 reflection .2} no_shadow}
	light_source {<0,.4,0> color <.7,.7,.3>
	looks_like {Lamp_bulb}
	fade_distance 0.75
	fade_power 2
	}
}

#declare Win_frame =
union {
	cylinder {<0,1.8,-.6><0,2.8,-.6>,.02 pigment{Black} finish{phong 1 reflection .2} no_shadow}
	cylinder {<0,1.8,-.6><0,1.4,-1.2>,.02 pigment{Black} finish{phong 1 reflection .2} no_shadow}
	cylinder {<0,1.4,-1.2><0,1.2,-1.2>,.02 pigment{Black} finish{phong 1 reflection .2} no_shadow}
}

#declare Opera_base1 =
union {
	difference {
		box {<-4.5,-2,-3.5><15,.2,3.5>}
		box {<30,30,0><-30,-30,-30> rotate <0,45,0> translate <-.43 0,-4>}
		box {<30,30,0><-30,-30,30> rotate <0,-45,0> translate <-.43 0,4>}
	}
	difference {
		box {<-4.5,-2,2><-2,.2,-2>}
		box {<30,30,0><-30,-30,-30> rotate <0,45,0> translate <-4.5 0,-1.25>}
		box {<30,30,0><-30,-30,30> rotate <0,-45,0> translate <-4.5 0,1.25>}
	}
}

#declare Opera_base2 =
union {
	difference {
		object {Opera_base1 texture{T_Op5}}
		object {Opera_base1 scale .9 translate <0,1,0> texture{T_Op5}}
	}
	object {Opera_base1 scale .9 translate <0,-.25,0> texture{T_Op5}}
	box {<2.2,0,2.8><10,1,-2.8> texture{T_Op5}}
	box {<2.4,.5,2.85><4,.75,-2.85> texture{T_Op3}}
	box {<5,.5,2.85><5.2,.75,-2.85> texture{T_Op3}}
	box {<4.2,.5,2.85><4.8,.65,-2.85> texture{T_Op3}}
	difference {
		box {<2.2,0,2.6><.75,1.23,-2.6> texture{T_Op5}}
		box {<30,0,30><-30,30,-30> rotate <0,0,-15> translate <2.2,1,0> texture{T_Op5}}
	}
	box {<1,.5,2.65><1.5,.75,-2.65> texture{T_Op3}}
	difference {
		box {<-.9,0,2.2><.75,1.44,-2.2> texture{T_Op5}}
		box {<30,0,30><-30,30,-30> rotate <0,0,-15> translate <.75,1.23,0> texture{T_Op5}}
		box {<30,0,30><-30,30,-30> rotate <0,0,45> translate <-.9,1.23,0> texture{T_Op5}}
		box {<30,30,0><-30,-30,-30> rotate <0,45,0> translate <-.43 0,-2> texture{T_Op5}}
		box {<30,30,0><-30,-30,30> rotate <0,-45,0> translate <-.43 0,2> texture{T_Op5}}
	}
	merge {
		cylinder {<-.6,0,0><-.6,2.8,0>,.6 texture{T_Op6}}
		cone {<-.6,1.8,0>,.6,<-.6,1.4,0>,1.2 texture{T_Op6}}
		cylinder {<-.6,1.4,0><-.6,1.2,0>,1.2 texture{T_Op6}}
		cylinder {<-.6,1.2,0><-.6,-1,0>,1 texture{T_Op6}}

		box {<1,0,1.1><10,2,-1.1> texture{T_Op6}}
	}
	cylinder {<-.6,1,0><-.6,-1,0>,1.4  texture{T_Op5}}
	box {<0,-1,.5><-4,.5,-.5>  texture{T_Op5}}

	#declare Count = 0
	#while (Count < 13)
		object {Win_frame rotate <0,(Count * 15),0> translate <-.6,0,0>}
		#declare Count = (Count + 1)
	#end
}

#declare In_light =
light_source {<0,1.5,0> color <.6,.6,.3>
	fade_distance 3
	fade_power 1
}

#declare House1 =
union {
	object {Sails pigment{White}}
	object {Sails scale <1,1,-1> pigment{White}}
	object {Opera_base2}
	object {In_light}

	object {Lamp_post translate <-4.5,0,0>}
	object {Lamp_post translate <-1.5,0,2>}
	object {Lamp_post translate <-3,0,2>}

}

#declare House2 =
union {
	object {House1}

	object {Opera_light1}
	object {Opera_light1 translate <2,0,0>}
	object {Opera_light1 translate <4,0,0>}
	object {Opera_light1 translate <6,0,0>}

	object {Opera_light2}
	object {Opera_light2 translate <2,0,0>}
	object {Opera_light2 translate <4,0,0>}
	object {Opera_light2 translate <6,0,0>}

	object {In_light translate <2,0,0>}
	object {In_light translate <3.5,0,0>}

	object {Lamp_post translate <0,0,3.4>}
	object {Lamp_post translate <1.5,0,3.4>}
	object {Lamp_post translate <3,0,3.4>}

}


#declare Opera_house =
union {
	object {House1 rotate <0,-10,0>}
	object {House2 scale .8 translate <1,.2,5>}
}

