
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: INC file for "First Kiss"
// Date: Apr 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13

#declare T_Light =
texture {
	pigment {
		granite
		color_map {
			[0.0 rgb <0,0,0>]
			[0.1 rgb <0,0,0>]
			[0.1 rgb <.8,.8,.7>]
			[0.15 rgb <.8,.8,.7>]
			[0.15 rgb <0,0,0>]
			[0.6 rgb <0,0,0>]
			[0.6 rgb <.6,.6,.4>]
			[0.7 rgb <.6,.6,.4>]
			[0.7 rgb <0,0,0>]
			[1.0 rgb <0,0,0>]
		}
	}
	finish {ambient 1}
}

#declare Ground2 =
union {
#declare Apple = seed(13)
#declare Count = 0
#while (Count < 300)
	box {<0,0,0><((rand(Apple) * 4) + 3),((rand(Apple) * 7) + 5),((rand(Apple) * 4) + 3)>
		rotate <0,(rand(Apple) * 360),0>
		#declare Sign1 = rand(Apple)
			#if (Sign1 < 0.5)
				#declare Sign1 = -1
			#else
				#declare Sign1 = 1
			#end
		#declare Sign2 = rand(Apple)
			#if (Sign2 < 0.5)
				#declare Sign2 = -1
			#else
				#declare Sign2 = 1
			#end
		translate <((rand(Apple) * 150) * Sign1),0,((rand(Apple) * 10) * Sign2)>
		texture {T_Light scale 12}
	}
	#declare Count = (Count + 1)
#end
cylinder {<200,0,0><-200,0,0>,6 scale <1,1,2> pigment{Black}}
}
