/*
    Grass.c -- used to generate a simple blade of grass primitive from
		smooth triangles for POVray
    Copyright (C) 1998 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <math.h>

#define NUM_ROWS	10
#define NUM_PER_ROW	5

float curve(float x)
{
   float y;

   y = -pow(x, 2);
   y += 9;

   return y;
}

void normalize(float *normal)
{
   float length;

   length = pow(normal[0], 2) + pow(normal[1], 2) + pow(normal[2], 2);

   normal[0] /= length;
   normal[1] /= length;
   normal[2] /= length;

}

void main()
{
   int i, j, k;
   char first_row = 1;
   float xmax, ymax, zmax;
   float x, y, z;
   FILE *output;
   float this_row[NUM_PER_ROW+1][3];
   float last_row[NUM_PER_ROW+1][3];
   float normals[3], old_normals[3];
   float slope, tangent;

   if(!(output = fopen("grass.inc", "w")))
	{
	fprintf(stderr, "Cannot write to file.\n\r");
	exit(1);
	}
   fprintf(output, "#include \"blade.inc\"\n#declare Grass = mesh {\n");
   for(zmax = 1, y = 0, x = -3; zmax >= 0; zmax -= 1.0/NUM_ROWS, x += 0.3)
	{
	for(z = -zmax, i = 0; z <= zmax + 0.01*zmax; z += 2*zmax/NUM_PER_ROW, i++)
	   {
	   this_row[i][0] = x + 3;
	   this_row[i][1] = curve(x);
	   this_row[i][2] = z;
	   }

	slope = -2*x;  /* first derivative */
	tangent = -1/slope;
	normals[0] = 1;
	normals[1] = tangent;
	normals[2] = 0;
	normalize(normals);

	if(first_row == 1)
	   {
	   first_row = 0;
	   for(i = 0; i < NUM_PER_ROW+1; i++)
		for(j = 0; j < 3; j++)
			last_row[i][j] = this_row[i][j];
	   old_normals[0] = normals[0];
	   old_normals[1] = normals[1];
	   old_normals[2] = normals[2];
	   continue;
	   }

	for(i = 0; i < 5; i++)
	   {
	   fprintf(output, "smooth_triangle {\n\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>,\n",
		last_row[i][0], last_row[i][1], last_row[i][2],
			old_normals[0], old_normals[1], old_normals[2]);
	   fprintf(output, "\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>,\n",
		last_row[i+1][0], last_row[i+1][1], last_row[i+1][2],
			old_normals[0], old_normals[1], old_normals[2]);
	   fprintf(output, "\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>\n\ttexture {G1}\n}\n",
		this_row[i][0], this_row[i][1], this_row[i][2],
			normals[0], normals[1], normals[2]);
	   fprintf(output, "smooth_triangle {\n\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>,\n",
		this_row[i][0], this_row[i][1], this_row[i][2],
			normals[0], normals[1], normals[2]);
	   fprintf(output, "\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>,\n",
		last_row[i+1][0], last_row[i+1][1], last_row[i+1][2],
			old_normals[0], old_normals[1], old_normals[2]);
	   fprintf(output, "\t<%1.4f, %1.4f, %1.4f>, <%1.4f, %1.4f, %1.4f>\n\ttexture {G1}\n}\n",
		this_row[i+1][0], this_row[i+1][1], this_row[i+1][2],
			normals[0], normals[1], normals[2]);
	   }

	for(i = 0; i < NUM_PER_ROW+1; i++)
	   for(j = 0; j < 3; j++)
		last_row[i][j] = this_row[i][j];
	old_normals[0] = normals[0];
	old_normals[1] = normals[1];
	old_normals[2] = normals[2];
	}
	fprintf(output, "} //end mesh\n");
	fclose(output);
}
