/*
    Readppm.c -- program to read PPM files and write out object declarations
	at certain elevations of a height field.  Used as a POV utility.
    Copyright (C) 1998 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>

#define THRESHOLD 30000
#define BOTTOM	100

void main()
{
   FILE *input;
   FILE *output;
   int height, width, max_colors, mag;
   int i, j;
   unsigned char r, g, b;

   if(!(input = fopen("night.ppm", "r")))
	{
	fprintf(stderr, "Cannot open input file.\n\r");
	exit(1);
	}
   if(!(output = fopen("hfgrass.inc", "w")))
	{
	fprintf(stderr, "Cannot open output file.\n\r");
	exit(1);
	}

   fscanf(input, "P6 %d %d\n", &height, &width);
   printf("Resolution: %d %d\n", height, width);
   fscanf(input, "%d ", &max_colors);
   printf("Max val: %d\n", max_colors);

   for(i = 0; i < height && i < BOTTOM; i++)
	for(j = 0; j < width; j++)
		{
/* These ranges reflect the color map used by terrain maker */
		fscanf(input, "%c%c%c", &r, &g, &b);
		if(r == 0 && g == 0 && b == 0)
			mag = 0;
		else if(b > 0 && r == 0)  /* lower 25% */
			{
			mag = (b/255.0) * 0.25 * 65536;
			}
		else if(b > 0 && r > 0 && g == 0) /* 25-50% */
			{
			mag = (r/255.0) * 0.25 * 65536 + 0.25*65536;
			}
		else if(r > 0 && g > 0 && b == 0) /* 50-75% */
			{
			mag = (g/255.0) * 0.25 * 65536 + 0.5*65536;
			}
		else if(r > 0 && g > 0 && b > 0) /* 75-100% */
			{
			mag = (r/255.0) * 0.25 * 65536 + 0.75*65536;
			}
		else printf("Unaccounted for case: %d %d %d\n", r, g, b);
/*
		mag = r;
		mag <<= 8;
		mag += g;
*/

		if(mag > THRESHOLD && !(i%2) && !(j%2))
			{
			printf(".");
fprintf(output,
	"object { Grass scale <1/500, 1/50, 1/500> scale <1,(rand(S1)+0.5),1> rotate y*(rand(S2) - 0.5)*60\n");
fprintf(output, "\t translate <%d/512, %d/65536, %d/512> texture {G1}}\n",
	j, mag, 512-i);
			}
		}

   fclose(input);
   fclose(output);
}
