/*
    solar.inc -- used to generate eclipse in POVray
    Copyright (C) 1998 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#declare Eclipse = union {
sphere { 0, 1
	texture {
		pigment { Clear }
		halo {
			emitting
			spherical_mapping
			linear
			turbulence 0.4
			color_map {
				[0 color rgbt <0, 0, 1, 1>]
				[0.7 color rgbt <1, 1, 1, -1>]
				[1 color rgbt <1, 1, 1, -1>]
				}
			samples 10
			}
		scale 0.75
		}
		hollow
		scale 4/3
}

sphere { <0, 0, -1.331>, 0.33
	texture {
		pigment { color White*0.85 }
		finish { ambient 0 }
		normal { dents }
		}
}

light_source { <0.5, 0.5, -1> color White*3
		area_light y*2, x*2, 6, 6 }

light_source { <0.33, 0.33, -1.45> color White*1 }

}

#declare EclipseProto = sphere { 0, 1 pigment { color Yellow } finish {ambient 1}}
