/*
    Tree.c -- used to output a set of triangles as a POVray mesh to create
	something resembling a tree
    Copyright (C) 1998 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <math.h>

void xrotate(float *coords, float theta)
{
/* 1   0     0      A
   0   cos -sin     B
   0   sin  cos     C
*/

   float temp[3];

   /* temp[0] = coords[0]; */
   temp[1] = coords[1]*cos(theta) - coords[2]*sin(theta);
   temp[2] = coords[1]*sin(theta) + coords[2]*cos(theta);

   /* coords[0] = temp[0]; */
   coords[1] = temp[1];
   coords[2] = temp[2];
}

void yrotate(float *coords, float theta)
{
/* cos   0     sin     A
   0     1     0       B
   -sin   0    cos     C
*/

   float temp[3];

   temp[0] = coords[0]*cos(theta) + coords[2]*sin(theta);
   /* temp[1] = ; */
   temp[2] = coords[0]*-sin(theta) + coords[2]*cos(theta);

   coords[0] = temp[0];
   /* coords[1] = temp[1]; */
   coords[2] = temp[2];
}


void zrotate(float *coords, float theta)
{
/* cos -sin 0    A
   sin  cos 0    B
   0    0   1    C
*/

   float temp[3];

   temp[0] = coords[0]*cos(theta) - coords[1]*sin(theta);
   temp[1] = coords[0]*sin(theta) + coords[1]*cos(theta);
   /* temp[2] = coords[2]; */

   coords[0] = temp[0];
   coords[1] = temp[1];
   /* coords[2] = temp[2]; */
}

void scale(float *coords, float factor)
{
   coords[0] *= factor;
   coords[1] *= factor;
   coords[2] *= factor;
}

void translate(float *coords, float *vector)
{
   coords[0] += vector[0];
   coords[1] += vector[1];
   coords[2] += vector[2];
}


void main()
{
   FILE *output;
   int j, k, l;
   float i;
   float v1[3], v2[3], v3[3], v4[3];

   float prototype[4][3] =
	{
		{ 0, 25, 0 },
		{ 1, 0, 0},
		{ -0.707, 0, 0.707 },
		{ -0.707, 0, -0.707 }
	};

/* legal connections are 0-1-2, 0-2-3, 0-3-1 */

  if(!(output = fopen("pinetree.inc", "w")))
	{
	fprintf(stderr, "Error, cannot write to file.\n\r");
	exit(1);
	}

  fprintf(output, "#declare Frond = mesh {\n");
  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		prototype[0][0], prototype[0][1], prototype[0][2],
		prototype[1][0], prototype[1][1], prototype[1][2],
		prototype[2][0], prototype[2][1], prototype[2][2]);
  fprintf(output, "texture{T2}}\n");
  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		prototype[0][0], prototype[0][1], prototype[0][2], 
		prototype[2][0], prototype[2][1], prototype[2][2], 
		prototype[3][0], prototype[3][1], prototype[3][2]);
  fprintf(output, "texture{T2}}\n");
  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		prototype[0][0], prototype[0][1], prototype[0][2], 
		prototype[3][0], prototype[3][1], prototype[3][2], 
		prototype[1][0], prototype[1][1], prototype[1][2]);
  fprintf(output, "texture{T2}}\n");
  for(i = 2; i < 25; i+= 0.5) /* had been i = 0 */
	{
	for(j = 0; j < 12; j++)
		{
		v1[0] = 8*(25-i)/25.0;
		v1[1] = i+0.5;
		v1[2] = 0;

		v2[0] = 0;
		v2[1] = i;
		v2[2] = -0.25*(26-i)/25;

		v3[0] = 0;
		v3[1] = i;
		v3[2] = 0.25*(26-i)/25;

		v4[0] = 0;
		v4[1] = i-0.15;
		v4[2] = 0;

		yrotate(v1, j*(M_PI*2/12.0 + M_PI/180*i));
		yrotate(v2, j*(M_PI*2/12.0 + M_PI/180*i));
		yrotate(v3, j*(M_PI*2/12.0 + M_PI/180*i));
		yrotate(v4, j*(M_PI*2/12.0 + M_PI/180*i));
		
  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		v1[0], v1[1], v1[2], v2[0], v2[1], v2[2], v3[0], v3[1], v3[2]);
  fprintf(output, "texture{T1}}\n");

  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		v1[0], v1[1], v1[2], v4[0], v4[1], v4[2], v3[0], v3[1], v3[2]);
  fprintf(output, "texture{T1}}\n");

  fprintf(output, " triangle{<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>,<%1.4f,%1.4f,%1.4f>",
		v1[0], v1[1], v1[2], v2[0], v2[1], v2[2], v4[0], v4[1], v4[2]);
  fprintf(output, "texture{T1}}\n");
		}
	}
  fprintf(output, "texture {T1}}\n");
  fclose(output);
}
