//------------------------------------------------------------------------
//
//  C O M M A N D .INC
//
//  Author:  Robert J Becraft
//  Created: March, 1998
//------------------------------------------------------------------------
// Command Pod/ Communications Pod

#declare Command_Poda=union{
      difference{
          union{
              sphere{<0,0,0>,9 texture{silver}}
              cylinder{<-8.5,0,0><8.5,0,0>,3.8 texture{Blue_Strip}}
              cylinder{<0,-8.5,0><0,8.5,0>,3.8 texture{Blue_Strip}}
              cylinder{<0,0,-8.5><0,0,8.5>,3.8 texture{Blue_Strip}}

              cylinder{<0,0,-6.5><0,0,6.5>,6.6 texture{Blue_Strip}}
          }

         sphere{<0,0,0>,8.8}                // hollow center
         cylinder{<0,4,0><0,6,0>,9}    // windows
 //         box{<-9,5.9,-9><9,8,0>}         // create upper front windows
     }

     object{Pod_Ports}

      cylinder{<0,3.8,0><0,4,0>,8.5 texture{Steel_beam}}
      cylinder{<0,6,0><0,6.2,0>,7 texture{Steel_beam}}
      cylinder{<0,8,0><0,8.2,0>,4.5 texture{Steel_beam}}
     }

#declare Command_Podb=difference{
    union{
        object{Command_Poda texture{silver}}
        object{Pod_Glaze texture{Window_Glaze}}
        #declare Count=12.25
        #while (Count<359)
           cylinder{<-.2,0,0><.2,0,0>,9.3  rotate<0,Count,0> texture{silver}}
           #declare Count=Count+22.5
        #end
      object{Pod_Ladder}   // add ladders...
      }
      sphere{<0,0,0>,8.8}  // hollow center
}
#declare Seat=union{
     cylinder{<0,1.15,-.15><0,1.15,.15>,.15 texture{pigment{color Wheat}}}   // headrest
     box{<-.2,0,-.25><0,1,.25> texture{pigment{color Wheat}}}                // seat back
     box{<-.2,-.2,-.25><.7,0,.25> texture{pigment{color Wheat}}}             // seat
     cylinder{<.2,-.7,0><.2,0,0>,.1 texture{Steel_beam}}                     // bottom pole
     cylinder{<0,.2,-.3><.7,.2,-.3>,.05 texture{Red_Strip}}
     box{<.3,0,-.28><.35,.2,-.3> texture{Steel_beam}}
     cylinder{<0,.2,.3><.7,.2,.3>,.05 texture{Red_Strip}}
     box{<.3,0,.28><.35,.2,.3> texture{Steel_beam}}
}

#declare Command_Pod=union{
     object{Command_Podb}
     object{TLite_White translate<0,6,-6>}
     object{Crane_Lite_Green translate<-3,6,4>}
     object{Crane_Lite_Red translate<4,6,3>}
     object{Crane_Lite_Blue translate<0,6,-7>}
     cylinder{<0,3.5,0><0,3.51,0>,8.5 texture{pigment {checker Blue,White} scale .5}}
//     object{Seat translate<2,4.2,2>}
//     object{Seat translate<-2,4.2,2>}

     object{Seat rotate<0,90,0> translate<-2.2,4.2,-5>}
     object{Seat rotate<0,90,0> translate<-1.1,4.2,-5>}
     object{Seat rotate<0,90,0> translate<0,4.2,-5>}
     object{Seat rotate<0,90,0> translate<1.1,4.2,-5>}
     object{Seat rotate<0,90,0> translate<2.2,4.2,-5>}

     box{<3,3.5,-4><6,6,-2> texture{silver}}
     box{<-6,3.5,-4><-4,5,-2> texture{Steel_beam}}
     box{<-6.1,5,-4.1><-3.9,5.2,-1.9> texture{silver}}

     box{<-3,4.9,-7><3,5,-6> texture{Steel_beam}}
     box{<-3,5.2,-7><3,5.5,-6.8> texture{Steel_beam}}
     box{<-2.5,5,-6.9><-2.4,5.2,-6.8> texture{Steel_beam}}
     box{<2.4,5,-6.9><2.5,5.2,-6.8> texture{Steel_beam}}
     box{<-.25,3.5,-5.75><.25,4.9,-5.5> texture{Red_Strip}}

     object{Seat rotate<0,90,0> translate<0,5.1,0>}
     cylinder{<0,0,0><0,4.4,0>,1.5 texture{Steel_beam}}
     cylinder{<0,0,0><0,4.2,0>,1.7 texture{Blue_Strip}}
     cylinder{<0,0,0><0,4,0>,1.9 texture{Steel_beam}}
}

//========================================
#declare Disha=difference{
      sphere{<0,0,0>,3 texture{silver}}
      sphere{<.2,0,0>,3.1}
}
#declare Dish=union{
      object{Disha texture{silver}}
      cone{<-2.9,0,0>,.3 <1,0,0>,.1 texture{silver}}
      cone{<.5,0,0>,.1 <.85,0,0>,.4 texture{silver}}
}

//=========================================
#declare Spot_Light=difference{
      sphere{<0,0,0>,.5 texture{goldfoil}}
      sphere{<0,0,0>,.4 texture{silver}}
      box{<-.5,-.5,-.5><-.1,.5,.5>}
}
#declare Spot_Light_Supporta=difference{
      cylinder{<-.08,0,0><.08,0,0>,.7 texture{Steel_beam}}
      cylinder{<-.11,0,0><.11,0,0>,.6 texture{Steel_beam}}
      box{<-.11,.1,-.71><.11,.71,.71>}     // top part of loop
}
#declare Spot_Light_Support=union{
      object{Spot_Light_Supporta}
      cylinder{<0,0,-.70><0,0,-.68>,.1 texture{Steel_beam}}
      cylinder{<0,0,.68><0,0,.70>,.1 texture{Steel_beam}}
      cylinder{<0,-1,0><0,-.71,0>,.1 texture{Steel_beam}}
      cylinder{<0,0,-.8><0,0,.8>,.06 texture{silver}}
      object{Spot_Light rotate<0,0,-65> translate<-.2,0,0>}
}
#declare Light_Array_Base=union{
       cylinder{<0,0,-2><0,0,2>,.17 texture{Steel_beam}}
       cylinder{<0,0,-1.5><1.3,0,-1.8>,.14 texture{Steel_beam}}
       cylinder{<0,0,1.5><1.3,0,1.8>,.14 texture{Steel_beam}}
}
#declare Light_Array_Framea=union{
        cylinder{<0,0,0><0,.5,0>,.1 texture{Steel_beam}}
        cylinder{<0,0,-.1><0,0,.1>,.22 texture{silver}}
        box{<-.1,.5,-2><.1,.6,2> texture{goldfoil}}
}
#declare LA_West_Frame=union{
        object{Light_Array_Framea}
        object{Spot_Light_Support rotate<0,65,0> translate<0,1.7,0>}             // white light bottom
//         #declare PAX=-20
//         #declare PAY=10
//         #declare PAZ=-20
//        #include "light.inc"
        object{Lite_White translate<-.2,1.7,0>}
        object{Spot_Light_Support rotate<0,75,0> translate<0,1.7,-1.6>}        // Green light left side
//         #declare PAX=-47
//         #declare PAY=20
//         #declare PAZ=0
//        #include "light.inc"
        object{Lite_Green translate<-.2,1.7,-1.6>}
        object{Spot_Light_Support rotate<0,0,0> translate<0,1.7,1.6>}           // off

}
#declare LA_South_Frame=union{
        object{Light_Array_Framea}
        object{Spot_Light_Support  rotate<0,0,0> translate<0,1.7,0>}
        object{Lite_White translate<-.2,1.7,0>}
        object{Spot_Light_Support rotate<0,0,0> translate<0,1.7,-1.6>}        // off
//        object{Lite_Green translate<-.2,1.7,-1.6>}
        object{Spot_Light_Support rotate<0,65,0> translate<0,1.7,1.6>}       // off
//        object{Lite_White translate<-.2,1.7,1.6>}
}
#declare LA_East_Frame=union{
        object{Light_Array_Framea}
        object{Spot_Light_Support rotate<0,0,0>  translate<0,1.7,0>}          // white light right side
//         #declare PAX=20
//         #declare PAY=10
//         #declare PAZ=20
//        #include "light.inc"
        object{Lite_White translate<-.2,1.7,0>}
        object{Spot_Light_Support rotate<0,0,0>  translate<0,1.7,-1.6>}     // Tan light right side
//         #declare PAX=47
//         #declare PAY=-20
//         #declare PAZ=0
//        #include "light.inc"
        object{Lite_Tan translate<-.2,1.7,-1.6>}
        object{Spot_Light_Support rotate<0,0,0> translate<0,1.7,1.6>}          // off
}
#declare LA_North_Frame=union{
        object{Light_Array_Framea}
        object{Spot_Light_Support translate<0,1.7,0>}                         // tan light center pointing back
//         #declare PAX=0
//         #declare PAY=33
//         #declare PAZ=40
//        #include "light.inc"
        object{Lite_Wheat translate<-.2,1.7,0>}
        object{Spot_Light_Support translate<0,1.7,-1.6>}                  // off
        object{Spot_Light_Support translate<0,1.7,1.6>}                   // off
}
#declare LA_West=union{
       object{LA_West_Frame rotate<0,0,80>}
       object{Light_Array_Base}
}
#declare LA_South=union{
       object{LA_South_Frame rotate<0,0,-10>}
       object{Light_Array_Base}
}
#declare LA_East=union{
       object{LA_East_Frame rotate<0,0,90> rotate<90,0,0>}
       object{Light_Array_Base}
}
#declare LA_North=union{
       object{LA_North_Frame rotate<0,0,90>}
       object{Light_Array_Base}
}
#declare Comm_Marker=union{
     cylinder{<0,0,0><0,.5,0>,.12 texture{Steel_beam}}
     sphere{<0,.6,0>,.1 texture{Glow_Red}}
}
#declare Comm_Pod=union{
     sphere{<0,0,0>,2 texture{silver}}
     cylinder{<0,-.5,0><0,.5,0>,5.5 texture{Steel_beam}}

     //Light arrays on 4 sides...
     object{LA_West translate<-6.3,0,0>}
     object{LA_East rotate<0,180,0> translate<6.3,0,0>}
     object{LA_South rotate<0,-90,0> translate<0,0,-6.3>}
     object{LA_North rotate<0,90,0> translate<0,0,6.3>}

     //railing
     torus{5.5, .07 translate<0,1.25,0> texture{Steel_beam}}
     torus{5.5, .1 translate<0,2,0> texture{Steel_beam}}
     #declare Count=0
     #while (Count<360)
        cylinder{<5.5,0,0><5.5,2,0>,.1 rotate<0,Count,0> texture{Steel_beam}}
        #declare Count=Count+30
     #end
     #declare Count=0
     #while (Count<360)
        object{Comm_Marker translate<5.5,2,0> rotate<0,Count,0>}
        #declare Count=Count+90
     #end

     cylinder{<0,-.2,0><0,.2,0>,5.7 texture{silver}}
     cylinder{<0,-6,0><0,0,0>,1 texture{Steel_beam}}       // connector tube

     cylinder{<-2,0,-2><-2,.9,-2>,.4 texture{Steel_beam}}
     cone{<-2,0,-2>,.2 <-2,12,-2>,.08 texture{silver}}
     cone{<-2,0,-2>,.25 <-2,3,-2>,.23 texture{Steel_beam}}
     sphere{<-2,12,-2>,.1 texture{Steel_beam}}

     cylinder{<0,0,-3><0,.9,-3>,.42 texture{Steel_beam}}
     cone{<0,0,-3>,.24 <0,14,-3>,.08 texture{silver}}
     cone{<0,0,-3>,.29 <0,5,-3>,.25 texture{Steel_beam}}
     sphere{<0,14,-3>,.1 texture{Steel_beam}}
     sphere{<0,14,-3.1>,.1 texture{Glow_Red}}          // light

     cylinder{<-3,0,-3><-3,.9,-3>,.42 texture{Steel_beam}}
     cone{<-3,0,-3>,.24 <-3,18,-3>,.08 texture{silver}}
     cone{<-3,0,-3>,.29 <-3,5,-3>,.25 texture{Steel_beam}}
     sphere{<-3,18,-3>,.1 texture{Steel_beam}}
     sphere{<-3,18,-3.1>,.1 texture{Glow_Red}}        // lights
     sphere{<-3,17,-3.1>,.1 texture{Glow_Red}}

      cone{<3,0,0>,.4 <3,4.8,0>,.2 texture{silver}}
      sphere{<3,4.8,0>,.35 texture{Steel_beam}}
      object{Dish rotate<0,30,0> rotate<0,0,30> translate<4.5,7,-2> texture{silver}}

      cone{<-3,0,0>,1 <-3,2,0>,.5 texture{silver}}
      cone{<3,0,3>,1 <3,3,3>,.5 texture{silver}}
      cone{<0,0,3>,1 <0,6,3>,.5 texture{foil}}
}

//======================================= DOCKING FACILITIES....
#declare Docking_rail=union{
      torus{3,.1 rotate<0,0,90> texture{Steel_beam}}
      #declare Count=0
      #while (Count<=180)
        cylinder{<0,-3,0><0,3,0>,.1 texture{Steel_beam} rotate<Count,0,0>}
         #declare Count=Count+30
      #end
}
#declare Docking_Pod=union{
      cylinder{<-11,0,0><11,0,0>,1. texture{Steel_beam}}

      object{Hatch translate<0,11,0> rotate<0,0,90>}
      object{Hatch translate<0,11,0> rotate<0,0,-90>}

      cylinder{<-9,0,0><9,0,0>,2 texture{silver}}
      cylinder{<-3,0,0><3,0,0>,2.2 texture{Steel_beam}}
      cylinder{<-2.5,0,0><-2,0,0>,2.21 texture{silver}}
      cylinder{<2,0,0><2.5,0,0>,2.21 texture{silver}}
      cylinder{<-8,0,0>,<-6,0,0>,2.6 texture{goldfoil}}
      cylinder{<6,0,0>,<8,0,0>,2.6 texture{goldfoil}}

      object{Docking_rail translate<-8,0,0> }
      torus{3,.1 rotate<0,0,90> translate<-8.05,0,0> texture{Red_Strip}}
      object{Docking_rail translate<-6,0,0> }
      object{Docking_rail translate<8,0,0> }
      torus{3,.1 rotate<0,0,90> translate<8.05,0,0> texture{Red_Strip}}
      object{Docking_rail translate<6,0,0> }

      #declare Count=0
      #while (Count<=360)
        cylinder{<-6,-2.25,0><6,-2.25,0>,.2 texture{Steel_beam} rotate<Count,0,0>}
         #declare Count=Count+45
      #end

}
