//------------------------------------------------------------------------
//
//  S C O O T E R.INC
//
//  Author:  Robert J Becraft
//  Created: March, 1998
//------------------------------------------------------------------------
//   Small worker ships

#declare Scooter_Poda=difference{
  union{
      sphere{<0,0,0>,2.5 texture{Yellow_Strip}}
      cylinder{<0,-.2,0><0,.2,0>,2.6 texture{Yellow_Strip}}
      cone{<0,0,0>,2.5 <8.5,0,0>,1.2 texture{Yellow_Strip}}
     }
     sphere{<0,0,0>,1.9 texture{Yellow_Strip}}  // hollow center
     cylinder{<1,0,0>,<1,3.1,0>,2 texture{Yellow_Strip}} // hole in top
     cylinder{<-4,-4,0><8.6,-4,0>,4.3}
}
#declare Scooter_Exhaust=difference{
      union{
         sphere{<5,-.6,0>,1.5 texture{silver}}                        // fuel
         cylinder{<4.5,-.5,0><4.7,-.5,0>,1.6 texture{Yellow_Strip}}
         cylinder{<5.3,-.5,0><5.5,-.5,0>,1.6 texture{Yellow_Strip}}
         cylinder{<5,-.25,0><9,-.2,0>,.3 texture{silver}}        // pipe
         cone{<9,-.25,0>,.3 <13,-.25,0>,1. texture{goldfoil}}    // exhaust
      }
      cone{<9,-.25,0>,.28 <13.1,-.25,0>, .98 texture{silver}}  // hole
}
#declare Scooter_Canopy=difference{
         union{
             sphere{<0,0,0>,2 texture{T_Green_Glass}}
             cylinder{<0,-.25,0><0,.2,0>,2.1 texture{Yellow_Strip}}
          }
          sphere{<0,0,0>,1.998 texture{T_Green_Glass}}
          box{<-2.1,-2.1,-2.1><2.1,-.3,2.1>}
          box{<-2.1,1.5,-2.1><2.1,2.1,2.1>}
}
#declare Scooter_Alt=union{
          box{<-.4,-.3,-.3><.4,.3,.3> texture{goldfoil}}
          difference{
              cone{<0,-.3,0>, .07 <0,-.6,0>,.09  texture{silver}}
              cone{<0,-.3,0>,.06 <0,-.61,0>,.08 texture{silver}}
          }
          difference{
             cone{<0,.3,0>,.07 <0,.6,0>,.09 texture{silver}}
             cone{<0,.3,0>,.06 <0,.61,0>,.08 texture{silver}}
          }
          difference{
             cone{<-.4,0,0>,.07 <-.7,0,0>,.09 texture{silver}}
             cone{<-.4,0,0>,.06 <-.71,0,0>,.08 texture{silver}}
          }
          difference{
             cone{<.4,0,0>,.07 <.7,0,0>,.09 texture{silver}}
             cone{<.4,0,0>,.06 <.71,0,0>,.08 texture{silver}}
          }
}
#declare Scooter_Arm_Claw=difference{
       cylinder{<0,0,-.1><0,0,.1>,.5 texture{Steel_beam}}
       box{<-.51,-.2,-.11><0,.2,11> texture{Steel_beam}}
       cylinder{<0,0,-.11><0,0,.11>,.4 texture{Steel_beam}}
}
#declare Scooter_R_Arm=union{
       cylinder{<0,0,0><-2,-2,1>,.15 texture{silver}}
       sphere{<0,0,0>,.35 texture{Steel_beam}}
       sphere{<-2,-2,1>,.2 texture{Steel_beam}}
       cylinder{<-2,-2,1> <-4,-1,.5>,.15 texture{silver}}
       sphere{<-4,-1,.5>,.2 texture{Steel_beam}}
       object{Scooter_Arm_Claw translate<-4.5,-1,.5>}
}
#declare Scooter_L_Arm=union{
       cylinder{<0,0,0><-2,-2,-1>,.15 texture{silver}}
       sphere{<0,0,0>,.35 texture{Steel_beam}}
       sphere{<-2,-2,-1>,.2 texture{Steel_beam}}
       cylinder{<-2,-2,-1> <-4,-1,-.5>,.15 texture{silver}}
       sphere{<-4,-1,-.5>,.2 texture{Steel_beam}}
       object{Scooter_Arm_Claw translate<-4.5,-1,-.5>}
}
#declare Scooter_Lamp=union{
       difference{
          sphere{<0,0,0>,.4 texture{silver}}
          sphere{<0,0,0>,.35 texture{silver}}
          box{<-.4,-.4,-.4><-.2,.4,.4>}
       }
       object{Lite_PaleGreen translate<-.1,0,0>}
}

#declare Scooter_Pod=union{
      object{Scooter_Poda}
      object{Scooter_Alt translate<1,.20,-2.6>}
      object{Scooter_Alt translate<1,.20,2.6>}
       object{Scooter_Canopy translate<1,1.6,0>}

    // wings
       triangle{<0,.30,0><9,.3,3><9,.3,-3> texture{Yellow_Strip}}
       triangle{<0,.30,0><9,3,0><9,1,0> texture{Red_Strip}}
      sphere{<9,.3,3>,.2 texture{Glow_Red}}
      sphere{<9,.3,-3>,.2 texture{Glow_Green}}

      cylinder{<1,0,0><1,.1,0>,2 texture{Green_Strip}}
      cone{<3.5,0,0>,.15 <3.5,3,0>,.1 texture{Steel_beam}}
      cone{<3.5,0,0>.1 <3.5,6,0>,.05 texture{silver}}        // antenna
      object{Scooter_Exhaust}
      object{Scooter_Lamp translate<-2.,1.4,-.71>}
      object{Scooter_Lamp translate<-2.,1.4,.71>}
      object{Scooter_L_Arm translate<-2.1,1,-1.5>}
      object{Scooter_R_Arm translate<-2.1,1,1.5>}
      object{SLite_Gray50 translate<-1.5,.5,0>}

      scale .3048       // rescale to meter size
}
#declare Scooter_Pod_Pilot=union{
      object{Scooter_Pod scale 3}
      object{SpacemanT scale 3 rotate<0,90,0>  translate<1,-1.5,0>}
      scale .3048       // rescale to meter size
}
