/* CHO SKIES - careful, with skies this deep, you could fall in and fly
               away forever! Altogether, five layers, and two of those
			   have multilayer textures.
*/

// LAYER ONE (REARMOST) - THE RANDOM STAR BACKMAP
#declare Darkwithstars =
texture {
	pigment {
		wrinkles
			color_map {
			[ 0.0 rgb<0,0,0.004> ]
			[ 0.85 rgb<0,0,0.004> ]
			[ 0.85 rgb<.88,.88,.9> ]
			[ 1.0 rgb<.88,.88,.9> ]
			}
			frequency 1
			ramp_wave
	}
	finish { ambient 30 } //antialiasing no-rub'em out
	scale 1/2100
	}


#declare Midnightblue =
texture {
	pigment { rgb<0,0,.004> }
	finish { ambient 30 } //gotta match Darkwithstars or arg!!!
}

sphere {
	<0,0,0>, 3000 hollow

	texture { //Skybackdrop #1 --- rearmost layer
		wood
		texture_map { //gradually fades the stars around the bright moon
		[ 0.00 Midnightblue ]
		[ 0.033 Midnightblue ]
		[ 0.04 Darkwithstars ]
		[ 1.0 Darkwithstars ]
		}
		scale <3100,3100,3100>
	}
	rotate<-0.25,0,0> rotate Skyrotate

}

// LAYER TWO - THE MAPPED CONSTELLATIONS
sphere {
	<0,0,0>, 2750 hollow

	texture { //one constellation map
		pigment {
			image_map {
				gif "hunter4.gif" //orion
				interpolate 2
				once
				transmit 0,1
			}
			translate <-.5,-.5,0>
			scale <102,102,102>
			rotate <.002,-3,0>
		}
		finish { ambient 30 }
	}
	texture { //the other constellation map
		pigment {
			image_map {
				gif "ram4.gif" //ares
				interpolate 2
				once
				transmit 0,1
			}
			translate <-.5,-.5,0>
			scale <102,102,102>
			rotate <1,2.95,0>
		}
		finish { ambient 30 }
	}
	texture { //the shooting star
		pigment {
			image_map {
				gif "sstar.gif"
				interpolate 2
				once
				transmit 0,1
			}
			translate <-.5,-.5,0>
			scale 10
			rotate <-1,3.25,0>
		}
		finish { ambient 30 }
	}

	rotate Skyrotate //the whole sphere.
}

//LAYER THREE - THE MOON'S ICY GLARE
#declare FrozenFire =
texture {
    pigment { colour rgbt<1,1,1,1> }
    halo {
      linear
      max_value 1
      spherical_mapping
      emitting
      color_map {
        [0 color rgbt <.75, .75, 1, .97> ]
		[.8 color rgbt <1,1,1,.85> ]
        [1 color rgbt <1, 1, 1, .75> ]
      }
      turbulence <.25,.25,0> lambda 10 omega .65
      samples 32
      aa_level 3
      aa_threshold 0.3
    }
}

sphere {
	<0,0,0>,1.1 hollow
	texture { FrozenFire }
	scale <75,65,65> translate <0,0,2500>
	rotate<-0.5,0,0> rotate Skyrotate
}


// LAYER FOUR - THE STAR OF THE SHOW (SO TO SPEAK)
sphere { <0,0,0>, 1
 	texture  { //Lunar sphere texture
    	pigment{
        	agate  agate_turb 1.1
         	color_map {
            [ 0.0     rgbft <0.39, 0.39, 0.39, 0.0, 0.0> ]
            [ 0.483986  rgbft <0.447067, 0.447067, 0.447067, 0.0, 0.0> ]
            [ 1.0     rgbft <0.489567, 0.489567, 0.489567, 0.0, 0.0> ]
         	}
        turbulence 0.5
        frequency 0.75
        rotate <100,-10.0,0>
      	}
      	finish  {
        	ambient 0.661867
        	diffuse 1.0
        	brilliance 0.300667
      	}
    }
	scale 35 translate <0,0,2500> rotate <-.5,0,0>
	rotate Skyrotate
}

// LAYER FIVE - A FEW CLOUDS

sphere {
	0,2250 hollow no_shadow
	texture { //one cloud...(UL)
		pigment {
			image_map {
				gif "cloud8.gif"
				interpolate 2
				once
				// and since there's no "transparency_map"
				transmit 0,1 transmit 1,.49 transmit 2,.48
				transmit 3,.47 transmit 4,.46 transmit 5,.45
				transmit 6,.44 transmit 7,.43 transmit 8,.42
				transmit 9,.41 transmit 10,.40 transmit 11,.39
				transmit 12,.38 transmit 13,.37 transmit 14,.36
				transmit 15,.35 transmit 16,.34 transmit 17,.33
				transmit 18,.32 transmit 19,.31 transmit 20,.30
				transmit 21,.29 transmit 22,.28 transmit 23,.27
				transmit 24,.26 transmit 25,.25 transmit 26,.24
				transmit 27,.23 transmit 28,.22 transmit 29,.21
				transmit 30,.20 transmit 31,.19 transmit 32,.18
				transmit 33,.17 transmit 34,.16 transmit 35,.15
				transmit 36,.14 transmit 37,.13 transmit 38,.12
				transmit 39,.11 transmit 40,.10 transmit 41,.09
				transmit 42,.08 transmit 43,.07 transmit 44,.06
				transmit 45,.05 transmit 46,.04 transmit 47,.03
				transmit 48,.02 transmit 49,.01 transmit 50,0
			}
			translate <-.5,-.5,0>
			scale <122,52,102>
			rotate <-1.475,-3.21,0>
		}
	}//end first cloud...
		texture { //and another cloud, (MR)
		pigment {
			image_map {
				gif "cloud6.gif"
				interpolate 2
				once
				// and since there's no "transparency_map"
				transmit 0,1 transmit 1,.49 transmit 2,.48
				transmit 3,.47 transmit 4,.46 transmit 5,.45
				transmit 6,.44 transmit 7,.43 transmit 8,.42
				transmit 9,.41 transmit 10,.40 transmit 11,.39
				transmit 12,.38 transmit 13,.37 transmit 14,.36
				transmit 15,.35 transmit 16,.34 transmit 17,.33
				transmit 18,.32 transmit 19,.31 transmit 20,.30
				transmit 21,.29 transmit 22,.28 transmit 23,.27
				transmit 24,.26 transmit 25,.25 transmit 26,.24
				transmit 27,.23 transmit 28,.22 transmit 29,.21
				transmit 30,.20 transmit 31,.19 transmit 32,.18
				transmit 33,.17 transmit 34,.16 transmit 35,.15
				transmit 36,.14 transmit 37,.13 transmit 38,.12
				transmit 39,.11 transmit 40,.10 transmit 41,.09
				transmit 42,.08 transmit 43,.07 transmit 44,.06
				transmit 45,.05 transmit 46,.04 transmit 47,.03
				transmit 48,.02 transmit 49,.01 transmit 50,0
			}
			translate <-.5,-.5,0>
			scale <122,50,102>
			rotate <0.25,3.5,0>
		}
	}
	texture { //third cloud... (LL)
		pigment {
			image_map {
				gif "cloud7.gif"
				interpolate 2
				once
				// and since there's no "transparency_map"
				transmit 0,1 transmit 1,.49 transmit 2,.48
				transmit 3,.47 transmit 4,.46 transmit 5,.45
				transmit 6,.44 transmit 7,.43 transmit 8,.42
				transmit 9,.41 transmit 10,.40 transmit 11,.39
				transmit 12,.38 transmit 13,.37 transmit 14,.36
				transmit 15,.35 transmit 16,.34 transmit 17,.33
				transmit 18,.32 transmit 19,.31 transmit 20,.30
				transmit 21,.29 transmit 22,.28 transmit 23,.27
				transmit 24,.26 transmit 25,.25 transmit 26,.24
				transmit 27,.23 transmit 28,.22 transmit 29,.21
				transmit 30,.20 transmit 31,.19 transmit 32,.18
				transmit 33,.17 transmit 34,.16 transmit 35,.15
				transmit 36,.14 transmit 37,.13 transmit 38,.12
				transmit 39,.11 transmit 40,.10 transmit 41,.09
				transmit 42,.08 transmit 43,.07 transmit 44,.06
				transmit 45,.05 transmit 46,.04 transmit 47,.03
				transmit 48,.02 transmit 49,.01 transmit 50,0
			}
			translate <-.5,-.5,0>
			scale <122,52,102>
			rotate <1.2,-4.4,0>
		}
	} //end third cloud
	rotate Skyrotate
}

