/* Abstract Mosaic Tiles -- for use on the top of the stacks in the dais
   of CHO. This began life as a very basic cobblestone texture, and was
   adapted, poked, and tweaked until it served this new duty.
*/

#declare Tilebumps =
normal {
	bump_map {
		gif "coblbmp.gif" //from that old cobblestone
		interpolate 2
		bump_size 12
	}
}

#declare Grout =
texture {
	pigment {
    	granite
	    color_map {
    	    [0.0 rgb <0.55,0.425,0.461>]
        	[0.25 rgb <0.55,0.425,0.461> ]
	        [0.25 rgb <0.525,0.469,0.333> ]
    	    [0.5  rgb <0.502,0.425,0.361> ]
        	[0.5  rgb <0.502,0.425,0.361> ]
	        [0.75 rgb <0.525,0.469,0.333> ]
    	    [0.75 rgb <0.502,0.425,0.361> ]
        	[1.00 rgb <0.402,0.325,0.361> ]
	     }
     frequency 25
   }
	normal { Tilebumps }
	finish { crand .1 } //crand is optional...don't use for animation!
}

#declare Greystone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.65, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Tilebumps }
      finish { ambient 0.1 crand 0.2 }
}

#declare Palestone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.7, 0.7, 0.7, 0.0, 0.0> ]
            [ 1.0 rgbft <0.75, 0.75, 0.75, 0.0, 0.0> ]
         }
         frequency 50.0
	}
    normal { Tilebumps }
    finish {
         ambient 0.1
         crand 0.25
    }
}

#declare Mudstone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.677067, 0.65, 0.65, 0.0, 0.0> ]
            [ 0.5 rgbft <0.625, 0.552067, 0.531233, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.5104, 0.489567, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Tilebumps }
      finish {
         ambient 0.1
         crand 0.15
      }
}

#declare Bluestone =
texture {
      pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.5729, 0.5729, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.536, 0.536, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Tilebumps }
      finish {
         ambient 0.1
         crand 0.2
      }
}

#declare Pepperstone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.593733, 0.552067, 0.0, 0.0> ]
            [ 0.323843  rgbft <0.8, 0.8, 0.8, 0.0, 0.0> ]
            [ 0.430605  rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
            [ 1.0 rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
         }
         frequency 45.0
      }
      normal { Tilebumps }
      finish
      {
         ambient 0.1
         crand 0.15
      }
}


#declare Mosaic =
texture {
	material_map {
		gif "coblmat.gif"
		interpolate 2
		texture { Grout } 
		texture { Greystone } 
		texture { Palestone } 
		texture { Mudstone }
		texture { Bluestone }
		texture { Pepperstone }
	}
	scale 10
	rotate <90,0,0> //this is intended as a floor, so orient on the
	                //XZ plane.
}
