/* HEXAGON STONE STACKS - (components in CHO temple set) */

// FIRST, ARE ALL THE VARIABLES HERE?
#ifndef (H)
	#debug "Hexagon radial length not declared. Using default.\n"
	#declare H = 75
#end

#ifndef (Altitude)
	#debug "Height of tower not declared. Using default.\n"
	#declare Altitude = 0
#end

#ifndef (Stonecount) //and if we haven't been here before...
	#declare Stonecount=1
#end

//SOME DECLARATIONS SO I DON'T HAVE TO WORK IN RADIANS...
#declare A = radians(60) //sixty degrees...
#declare B= radians(30)  //and thirty degrees
                         //(oh, them magical right triangles!)

//VERTEX POINTS FOR A HEXAGON...
#declare X1 =cos(A)*H
	#declare Z1 = sin(A)*H
#declare X2 = -X1
	#declare Z2 = Z1
#declare X3 = X2 - (tan(B)*Z1)
	#declare Z3 = 0
#declare X4 = X2
	#declare Z4 = -Z1
#declare X5 = X1
	#declare Z5 = -Z1
#declare X6 = X1 + (tan(B)*Z1)
	#declare Z6 = 0

//GET THE TEXTURE DECLARATIONS ON BOARD..
#include "mosaic2.inc"
#include "wstone.inc"

//AND AWAY WE GO...
#declare Stepstone=
texture { //just like Bluestone but without the stone map
      pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.5729, 0.5729, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.536, 0.536, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { crackle .3 turbulence .52 scale .03 }
      finish {
         ambient 0.1
         crand 0.2
      }
}

#include "ctable.inc"

#declare Window =
union {
	superellipsoid { // Uframe
	    <0.1, 0.1>
    	scale <3.0, 2.25, 0.5>
	    translate  5.3*z
	}
	superellipsoid { // Lsupport
	    <0.1, 0.1>
    	scale <0.5, 2.0, 5.0>
	    translate  -2.5*x
	}
	superellipsoid { // Rsupport
    	<0.1, 0.1>
	    scale <0.5, 2.0, 5.0>
		translate  2.5*x
	}
	superellipsoid { // Lframe
    	<0.1, 0.1>
	scale <3.0, 2.25, 0.5>
    translate  -5.3*z
	}
	texture { Stepstone }
	translate  <0,1.5,-20>
	/*RHC -> LHC conversion*/ rotate -90*x  scale <1,1,-1>
	translate <0,0,Z4>
}

#declare Wall =
box { //one wall of the hexagonal stack
	<X4,-60,-0.05>, <X5,Altitude,0.05>
	translate <0,0,Z4> //arbitrarily chosen: Z4 = Z5 anyway.
}

#declare Wall2 =
union {
	difference { //the other wall, for when we need windows
		box { <X4,-60,-0.05>, <X5,Altitude,0.05> }
		box { <-1, -1, -1>, <1, 1, 1>
			scale <2.5, 5.0, 5.0> translate <0,-20,1.5>
		}
		translate <0,0,Z4> //arbitrarily chosen: Z4=Z5 anyway
	}
	object { Window }
}


#if (Main= yes)
	#declare Postthickness = 1
#else
	#declare Postthickness = .5
#end

#declare TopPost =
union {
	box { //beam
		<X4,Altitude-Postthickness,Z4-Postthickness>,
		<X5,Altitude+Postthickness,Z5+Postthickness>

		pigment {  rgb <0.690765, 0.427616, 0.246702> }
    	normal { granite .75 scale <50,.2,.2> }
	}
	cylinder { //spike to secure beam
		<X4+Postthickness, Altitude, Z4-Postthickness*1.10>,
		<X4+Postthickness, Altitude, Z4+Postthickness*1.10>,
		Postthickness/4

		pigment { rgb<.2,.2,.2> }
	}
	cylinder { //spike to secure beam
		<X5-Postthickness, Altitude, Z5-Postthickness*1.10>,
		<X5-Postthickness, Altitude, Z5+Postthickness*1.10>,
		Postthickness/4

		pigment { rgb<.2,.2,.2> }
	}
}//end toppost

#declare VerticalColumn =
union {
	box { //beam
		<X1-Postthickness,-60,Z1-Postthickness>,
		<X1+Postthickness,Altitude,Z1+Postthickness>

		pigment { rgb  <0.690765, 0.427616, 0.246702> }
		normal { granite .75 scale <.2,50,.2> }
	}
	cylinder { //spike to hold beam
		<X1-Postthickness*1.10, Altitude-Postthickness, Z1>,
		<X1+Postthickness*1.10, Altitude-Postthickness, Z1>,
		Postthickness/4
		pigment { rgb<.2,.2,.2> }
	}
}

//AND NOW WHAT WE CAME HERE FOR...
#declare Stack =
union {
	//THE SIX WALLS...
	#declare Count = 0
	#while ( Count < 360 )
		#if ( Count < 120 & Main = no | Count =300 & Main = no )
			#switch (Stonecount) //the alternate switch
				#case (1)
					object { Wall2 rotate <0,Count,0>
						texture { Wallstone1 }
					}
					#declare Stonecount=2
				#break
				#case (2)
					object { Wall2 rotate <0,Count,0>
						texture { Wallstone2 }
					}
					#declare Stonecount=1
				#break
			#end //end alternate switch
		#else
			#switch (Stonecount) //primary switch
				#case (1)
					object { Wall  rotate <0,Count,0> texture { Wallstone1 } }
					#declare Stonecount=2
				#break
				#case (2)
					object { Wall  rotate <0,Count,0> texture { Wallstone2 } }
					#declare Stonecount=1
				#break
			#end //end primary switch
		#end //end if

		#declare Count = Count + 60
	#end //end while

	//THE WOODEN TOP POSTS...
	#if (Main = yes)
		#declare Count = 60
		difference {
			object { TopPost }
			box { <X4+16,-4,Z4-4>, <X5-16,+4,Z5+4> }
			pigment { rgb  <0.690765, 0.427616, 0.246702> }
			normal { granite 1 scale <.3,50,.3> }
		}
	#else
		#declare Count = 0
	#end

	#while ( Count < 360 )
		object { TopPost rotate<0,Count,0> }
		#declare Count = Count + 60
	#end

	//THE VERTICAL COLUMNS
	#declare Count = 0
		#while ( Count < 360 )
			object { VerticalColumn rotate<0,Count,0> }
			#declare Count = Count + 60
		#end

	//THE TOP OF THE STACK
	polygon {
		7,
		<X1,Z1>, <X2,Z2>, <X3,Z3>, <X4,Z4>, <X5,Z5>, <X6,Z6>, <X1,Z1>
		rotate<90,0,0>
		translate <0,Altitude,0>

		texture { Mosaic scale 3 }
	}
	//THE FLOOR WITHIN
	polygon {
		7,
		<X1,Z1>, <X2,Z2>, <X3,Z3>, <X4,Z4>, <X5,Z5>, <X6,Z6>, <X1,Z1>
		rotate<90,0,0>
		translate <0,-30.5,0>

		texture { Mosaic scale 3 }
	}
	object { Candletable }

}//end of stack declaration.
