/* Wallstone textures - Began life as a simpler form of wallstone. This
   file has to declare not one, but two mapped stone textures, as they
   will alternate on the walls of the towers as finally applied. See
   stack.inc if your interested in the code that alternates them. These
   are just the texture declarations
*/

#declare Stonemap =
normal {
	bump_map {
		gif "stnbmp1.gif"
		interpolate 2
		bump_size 12
	}
}

#declare Stonemap2 =
normal {
	bump_map {
		gif "stnbmp2.gif"
		interpolate 2
		bump_size 12
	}
}


/*The first use is to make it part of a more complex normal...*/
#declare Bumping =
normal {
	average
	normal_map {
	[ Stonemap ]
	[ crackle .25 turbulence .52 scale .03 ]
	}
}

#declare Bumping2 =
normal {
	average
	normal_map {
	[ Stonemap2 ]
	[ crackle .25 turbulence .52 scale .03 ]
	}
}



/*...and then again as a normal for this, (we don't want the
  crackle bumping on the mortar, just the stones).*/
#declare Mortar =
texture {
	pigment {
    	granite
	    color_map {
    	    [0.0 rgb <0.55,0.425,0.461>]
        	[0.25 rgb <0.55,0.425,0.461> ]
	        [0.25 rgb <0.525,0.469,0.333> ]
    	    [0.5  rgb <0.502,0.425,0.361> ]
        	[0.5  rgb <0.502,0.425,0.361> ]
	        [0.75 rgb <0.525,0.469,0.333> ]
    	    [0.75 rgb <0.502,0.425,0.361> ]
        	[1.00 rgb <0.402,0.325,0.361> ]
	     }
     frequency 25
   }
	normal { Stonemap }
	finish { crand .075 } //crand is optional...don't use for animation!
}

/* THIS STUFF MAY BE TEMPORARY */
#declare Greystone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.65, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping }
      finish { ambient 0.1 crand 0.2 }
}

#declare Palestone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.7, 0.7, 0.7, 0.0, 0.0> ]
            [ 1.0 rgbft <0.75, 0.75, 0.75, 0.0, 0.0> ]
         }
         frequency 50.0
	}
    normal { Bumping }
    finish {
         ambient 0.1
         crand 0.25
    }
}

#declare Mudstone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.677067, 0.65, 0.65, 0.0, 0.0> ]
            [ 0.5 rgbft <0.625, 0.552067, 0.531233, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.5104, 0.489567, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping }
      finish {
         ambient 0.1
         crand 0.15
      }
}

#declare Bluestone =
texture {
      pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.5729, 0.5729, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.536, 0.536, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping }
      finish {
         ambient 0.1
         crand 0.2
      }
}

#declare Pepperstone =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.593733, 0.552067, 0.0, 0.0> ]
            [ 0.323843  rgbft <0.8, 0.8, 0.8, 0.0, 0.0> ]
            [ 0.430605  rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
            [ 1.0 rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
         }
         frequency 45.0
      }
      normal { Bumping }
      finish
      {
         ambient 0.1
         crand 0.15
      }
}

#declare Greystone2 =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.65, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping2 }
      finish { ambient 0.1 crand 0.2 }
}

#declare Palestone2 =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.7, 0.7, 0.7, 0.0, 0.0> ]
            [ 1.0 rgbft <0.75, 0.75, 0.75, 0.0, 0.0> ]
         }
         frequency 50.0
	}
    normal { Bumping2 }
    finish {
         ambient 0.1
         crand 0.25
    }
}

#declare Mudstone2 =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.677067, 0.65, 0.65, 0.0, 0.0> ]
            [ 0.5 rgbft <0.625, 0.552067, 0.531233, 0.0, 0.0> ]
            [ 1.0 rgbft <0.55, 0.5104, 0.489567, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping2 }
      finish {
         ambient 0.1
         crand 0.15
      }
}

#declare Bluestone2 =
texture {
      pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.5729, 0.5729, 0.65, 0.0, 0.0> ]
            [ 1.0 rgbft <0.536, 0.536, 0.55, 0.0, 0.0> ]
         }
         frequency 50.0
      }
      normal { Bumping2 }
      finish {
         ambient 0.1
         crand 0.2
      }
}

#declare Pepperstone2 =
texture {
	pigment {
         granite
         color_map {
            [ 0.0 rgbft <0.65, 0.593733, 0.552067, 0.0, 0.0> ]
            [ 0.323843  rgbft <0.8, 0.8, 0.8, 0.0, 0.0> ]
            [ 0.430605  rgbft <0.55, 0.55, 0.55, 0.0, 0.0> ]
            [ 1.0 rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
         }
         frequency 45.0
      }
      normal { Bumping2 }
      finish
      {
         ambient 0.1
         crand 0.15
      }
}

/*ABOVE MAY BE TEMPORARY*/




/*The first wall's stone*/
#declare Stone1 =
texture {
	pigment {
		granite
			color_map {
				[ 0 rgb .65 ]
				[ 1 rgb .75 ]
			}
		frequency 50
	}
	normal { Bumping }
	finish { crand .2 }
}

/*The second wall's stone*/
#declare Stone2 =
texture {
	pigment {
		granite
			color_map {
				[ 0 rgb .68 ]
				[ 1 rgb .72 ]
			}
		frequency 50
	}
	normal { Bumping2 }
	finish { crand .2 }
}


#declare Wallstone1 =
texture {
	material_map {
		gif "stnmat1.gif"
		interpolate 2
		texture { Mortar } //'Mortar' must be the first, but the
		texture { Greystone } // stones that follow could be in any
		texture { Palestone } // order, actually.
		texture { Mudstone }
		texture { Bluestone }
		texture { Pepperstone }
	}
	scale 30
}

#declare Wallstone2 =
texture {
	material_map {
		gif "stnmat2.gif"
		interpolate 2
		texture { Mortar } //'Mortar' must be the first, but the
		texture { Mudstone2 } // stones that follow could be in any
		texture { Greystone2 } // order, actually.
		texture { Palestone2 }
		texture { Pepperstone2 }
		texture { Bluestone2 }
	}
	scale 45
}
