
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "textest"
#include "bdome.inc" // main dome
#include "sdome.inc" // small buckyballs
#include "metals.inc"
#include "plan.pov"
#include "dome.inc"// green dome
#include "rdgranit.map"
//camera { location <0,50,-540> look_at <0,25,-250> }
camera {  cylinder 1 angle 360 up <0,1,0> right <-1,0,0> location  <0,14,-116> look_at <-1,14,-116>  } //// <0,700,-245>

light_source { <0,1000,0> color rgb <.55,.55,.6> rotate <-45,-67,0> }

// light_source { <-50,700,-120> color White }

background { Gray10 }


// temporary work area =========================================

#declare tilenormal = normal { quilted 2
  control0 0
  control1 0
  scale .5 }

#declare tilefinish = finish { phong 1  brilliance 1 diffuse .5 }


#declare basetile1 = texture { pigment  { gradient y triangle_wave
  color_map {
   [ 0 color rgb <1,1,.9> ]
   [ .1 color rgb <1,1,.9> ]
   [ .11 color rgb <149/255,89/255,0> ]
   [ 1 color rgb <149/255,89/255,0> ] }
  scale .5  }
 normal { tilenormal }
 finish { tilefinish } scale 6}

#declare overtile1 = texture { pigment { gradient x triangle_wave
  color_map {
   [ 0 color rgb <1,1,.9> ]
   [ .1 color rgb <1,1,.9> ]
   [ .11 color rgbt <149/255,89/255,0,1> ]
   [ 1 color rgbt <149/255,89/255,0,1> ] }
  scale .5  }
 normal { tilenormal }
 finish { tilefinish } scale 6}





//====================================red inner base
#declare pillarbase = superellipsoid { <1,.1> // pigment { color Red } finish { phong 1 }
  rotate x*90  translate y*-1 scale <11,10,11> translate x*64 rotate y*45 hollow}

merge {
 superellipsoid { <1,.1> // pigment { color Red } finish { phong 1 }
  rotate x*90  translate y*-1 scale <66,10,66> hollow }
 object { pillarbase rotate y*90 }
 object { pillarbase rotate y*180 }
 object { pillarbase rotate y*270 }
 object { pillarbase }
  texture { basetile1 }
  texture { overtile1 }
  texture { overtile1 }
}


// walkway
merge {
 //middle
superellipsoid { <.1,.1>//  pigment { SkyBlue } finish { phong 1 }
     translate z*-1 scale .5 scale <8,5,88> translate y*-2.7 hollow
        }
 //right
superellipsoid { <.1,.1>// pigment { SkyBlue } finish { phong 1 }
 translate z*-1 scale .5 scale <5,5,88> translate <-5,-2.7,0> hollow }

 //left
superellipsoid { <.1,.1> // pigment { SkyBlue } finish { phong 1 }
 translate z*-1 scale .5 scale <5,5,88> translate <5,-2.7,0> hollow }
 // two slanted ones
superellipsoid { <.1,.1>// pigment { SkyBlue } finish { phong 1 }
 translate <0,1,-1>  scale .5 scale <5,5,88> rotate z*45  translate <9.5,-6.1,0> hollow }
superellipsoid { <.1,.1>// pigment { SkyBlue } finish { phong 1 }
 translate <0,1,-1>  scale .5 scale <5,5,88> rotate z*-45  translate <-9.5,-6.1,0> hollow }
texture { basetile1 }
       texture { overtile1 }
       texture { overtile1 rotate y*90 }
}

//============================green n' yellow outer base
#declare greenoutershell = superellipsoid { <1,.1> // pigment { color Green } finish { phong 1 }
  rotate x*90 translate y*-1 scale <91,15,91,> translate y*-.2
   }



difference {
 object { greenoutershell }
 superellipsoid { <1,.1> // pigment { color Yellow } finish { phong 1 }
  rotate x*90 translate y*-1 scale <87,8,87,> translate y*2
  } hollow
texture { basetile1 }
       texture { overtile1 }
       texture { overtile1 rotate y*90 }
}


// water-------------------------------------------------------------------------

cylinder { <0,-.5,0>, <0,.5,0> .5 pigment { Clear }
 halo {
  emitting
  cylindrical_mapping
  linear
    color_map  {
   [ 0 color rgbt <0,1,0,1> ]
   [ 1 color rgbt <0,0,1,-.5> ]
   }
   samples 10
   }
   normal { ripples 1 frequency 3 scale <1/176,1/16,1/176> scale 2 }
   finish { refraction on ior 1.33 phong 1 phong_size 150 reflection .3 caustics 1  }
  hollow  scale <176,16,176> translate y*-12 }

//==========================outer shelf
// two slanted bars
#declare tiltedrim = superellipsoid { <.1,.1> texture { cement }
 translate <0,-1,-1> scale .5   scale <3,10,200>  }// really 200
difference {
 union {
  object { tiltedrim rotate y*45 }
  object { tiltedrim rotate y*-45 }
 }
 object { greenoutershell translate y scale <1,100,1> }
}

// boundary bar
#declare bbar = superellipsoid { <.1,.1> texture { cement }
 translate <0,-1,-1> scale .5 scale <200*sqrt(2),10,5> translate <0,0,-100*sqrt(2)> }

object { bbar }
object { bbar translate z*-400 }

 // two side bars
superellipsoid { <.1,.1> texture { cement }
 translate <0,-1,-1> scale .5 scale <3,10,400> translate <100*sqrt(2),1,-100*sqrt(2)> }

superellipsoid { <.1,.1> texture { cement }
 translate <0,-1,-1> scale .5 scale <3,10,400> translate <-100*sqrt(2),1,-100*sqrt(2)> }

// 2nd walkway on outer courtyard

superellipsoid { <.1,.1,> texture { cement }
 translate <0,-1,-1> scale .5  scale <15,10,400> translate z*-100*sqrt(2) }
// =========================island

plane { y,-99.8 texture { pigment { color rgb <0,.35,.96>    }
 finish { specular 1 roughness .0005 reflection .35   }
 normal { wrinkles 1 frequency 3   } scale 100  }
  }

  #declare size1 = 491 + 100*sqrt(2)

height_field {
 tga "C:\unzipped\dome46(1)\island.tga"
 smooth
 pigment { granite color_map { M_RedGranite } scale 2   }
 finish { phong 1 phong_size 50  crand .07  }

translate <-.5,-1,-1>
scale 2
 // for grassscale <5,.3,5> }

scale <size1,100,size1>  translate y*-4  translate z*405 }


//================================trees

#declare l_base = cylinder { <0,0,0>, <0,2,0> , 1 }
#declare t_base = finish { ambient 0.3 diffuse 0.7 phong .5 phong_size 50   }
#declare col_12 = colour rgb <128/255,64/255,0>
#include "output.inc"
#declare basicd = -141

/*cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/1.1,0,-400/1.1>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/2,0,-400/10>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/3,0,-400/4>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/2.5,0,-400/1.2>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/4.8,0,-400/2>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/1.89,0,-400/1.5>}
cylinder { <0,-4,0>, <0,32,0>,10 pigment { rgb <1,0,0,> }
 translate z*basicd  translate <134/1.345,0,-400/2.05>}
*/

#declare trees = union {
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/1.1,-2,-400/1.1>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/2,-2,-400/20>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/3,-2,-400/4>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/2.5,-2,-400/1.2>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/4.8,-2,-400/2>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/1.89,-2,-400/1.5>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/1.345,-2,-400/2.05>}
object { fractal  scale 1/70  scale 9/8 scale 2
           translate z*basicd translate <134/13.9,-2,-400/10>}
}

object { trees translate x*-1*basicd translate z*200 rotate y*180 translate <-1*basicd,0,-541> }
object { trees }

//=====================================grass
#declare grassfield =
height_field {
 tga "C:\unzipped\dome46(1)\grass.tga"
 smooth
 pigment { rgb <0,.5,0> }
 translate z*-1
 scale <133.92,3.5,400>
 translate <7.5,-4,-141.42>
 }

object { grassfield }
object  { grassfield translate x*-141.42 }



//=================================lights

#declare slight = union {sphere { <0,0,0>, 1.5 pigment { crackle
 color_map {
  [ 0 color rgb <1,1,.5> ]
  [ 1 color rgb <1,1,1,> ] }
  }
  finish { ambient .9 diffuse .1 } }
 cylinder { <0,0,0>, <0,-7,0>, .5 pigment { color Gray50 } } no_shadow }

light_source { <8,2,-181.42>
 color rgb <.25,.2,.174>
 fade_distance 110
 fade_power 2
}
light_source { <-8,2,-261.42>
 color rgb <.25.2,.175>
 fade_distance 110
 fade_power 2
}
light_source { <8,2,-341.42>
 color rgb <.25,.2,.175>
 fade_distance 110
 fade_power 2
}
light_source { <-8,2,-421.42>
 color rgb <.25,.2,.175>
 fade_distance 110
 fade_power 2
}
light_source { <8,2,-501.42>
 color rgb <.25,.2,.175>
 fade_distance 110
 fade_power 2
 }
light_source { <8,2,-171.42>
 color rgb <.25,.2,.175>
 fade_distance 110
 fade_power 2
 }

//-----
// object { slight translate <8,2,-181.42>}

object { slight translate  <-8,2,-261.42> }

object { slight translate <8,2,-341.42> }

object { slight translate  <-8,2,-421.42> }

object { slight translate <8,2,-501.42> }

object { slight translate  <8,2,-171.42> }



//========================================================bridge
#declare Bolt_Texture = texture {
    pigment {
        granite         // Going for a galvanized appearance
        color_map {
            [0.0 color Gray70]
            [0.3 color Gray75]
            [0.6 color Gray85]
            [1.0 color Gray70]
        }
        scale <0.25, 0.25, 0.25>
        turbulence 0.15
    }
    finish {
        ambient 0.2
        diffuse 0.6
        reflection 0.1
        brilliance 10
        specular 0.35
        roughness 0.05
    }
    // Fuzz the surface with tiny ripples
    normal { ripples 0.25 frequency 2000 scale <0.05, 0.05, 0.05> }
}

union {
// 2 base rails
cylinder { <7.5,-1.2,-90>, <7.5,-.9,-100*sqrt(2)>, .7
}// pigment { color Gold } }

cylinder { <-7.5,-1.2,-90>, <-7.5,-.9,-100*sqrt(2)>, .7
}// pigment { color Gold } }

// first two joiner rails

cylinder { <7.5,-1.2,-90>, <7.5,8,-90-((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }

cylinder { <-7.5,-1.2,-90>, <-7.5,8,-90-((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }

sphere { <7.5,8,-100.0842>, .7 }// pigment { Gold } }
sphere { <-7.5,8,-100.0842>, .7 }// pigment { Gold } }
// second two joiner rails

cylinder { <7.5,-1.2,-100*sqrt(2)>, <7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }

cylinder { <-7.5,-1.2,-100*sqrt(2)>, <-7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }

sphere { <7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }
sphere { <-7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, .7
}// pigment { color Gold } }

// two handrails

cylinder { <7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, <7.5,8,-90-((100*sqrt(2)-91)/5)>, .7
} // pigment { color Gold } }

cylinder { <-7.5,8,-100*sqrt(2)+((100*sqrt(2)-91)/5)>, <-7.5,8,-90-((100*sqrt(2)-91)/5)>, .7
} // pigment { color Gold } }

// side edges =======

#declare d1 = (((100*sqrt(2)-91)/5)*3)/10

#declare se = cylinder { <7.5,8,-90-((100*sqrt(2)-91)/5)>, <7.5,-.9,-90-((100*sqrt(2)-91)/5)>, .7
}// pigment { Gold } }

#declare railings = union {
 object { se }
 object { se translate z*-1*d1*1 }
 object { se translate z*-1*d1*2 }
 object { se translate z*-1*d1*3 }
 object { se translate z*-1*d1*4 }
 object { se translate z*-1*d1*5 }
 object { se translate z*-1*d1*6 }
 object { se translate z*-1*d1*7 }
 object { se translate z*-1*d1*8 }
 object { se translate z*-1*d1*9 }
 object { se translate z*-1*d1*10 }
}

object { railings }
object { railings translate x*-15 }

//=bottom planks of bridge
// #declare plankd = 1.68
#declare plank = box { <-.5,-.5,-.5>, <.5,.5,.5> // pigment { Gold }
   translate <0,-.5,-.5> scale <14.5,.6,.78> translate z*(-91.78) }

object { plank }
object { plank translate z*1.68 }

#declare counter2 =  1
#while ( counter2 < 30 )
object { plank translate z*-1.68*counter2 }
#declare counter2 = counter2 + 1
#end
 texture { Bolt_Texture } }

// ========================green dome===============
#declare EdgeTexture=
texture{
        pigment{Silver}
        finish{
               specular 1
               roughness .00002
               ambient 0
               diffuse 1
               crand .0005
               reflection .15
        }
}
#declare PointTexture=
texture{
        pigment{Silver}
        finish{
               specular 1
               roughness .00001
               ambient 0
               diffuse 1
               crand .0005
               reflection .15
        }
}
#declare FaceTexture=
texture{
        pigment{ Green filter .50}
        finish{
               specular 1
               roughness .00005
               ambient 0
               diffuse 1
               crand .005
               reflection .15

        }
}



#declare Dome=
union{
object {DomeEdges1 no_shadow texture{EdgeTexture}}
object {DomePoints1 no_shadow texture{PointTexture}}
object {DomeFaces1 no_shadow texture{FaceTexture}}
}
object{Dome scale 200 translate <-750,-100,-170> }
light_source { <-750,-99,-170> color rgb <.9,.9,1> fade_distance 200 fade_power 2 }

