// create the fence
// part of "Night Vision" by Darren Izzard

// object is Fence

#include "colors.inc"
#include "textures.inc"

// for testing
//camera { location <0,0,-3> look_at <0,0,0>}
//light_source { <0,10,-15> color White }

#declare FenceRail=object {
         union {
               cylinder { <0,0,0.1>,<0,0.9,0.1>,0.05 }
               lathe {
                     cubic_spline
                     8,
                     <0.05,-0.05>,<0.05,0>,
                     <0.1,0.05>,<0.05,0.1>,
                     <0.1,0.15>,<0.05,0.2>,
                     <0,0.3>,<-0.05,0.35>
                     translate <0,0.9,0.1>
                     }
               }
         }

#declare FenceRing=object {
         union {
               torus {
                     0.25,0.025
                     sturm
                     }
           #declare X45=0.25*sin(radians(45))
               difference {
                          union {
                                cylinder {
                                         <-X45,0,-X45>,
                                         <X45,0,X45>,
                                         0.0125
                                         }
                                cylinder {
                                         <X45,0,-X45>,
                                         <-X45,0,X45>,
                                         0.0125
                                         }
                                }
                          sphere { <0,0,0>,0.125 }
                          bounded_by { box { <-X45,-0.0125,-X45>,<X45,0.0125,X45> } }
                          }
               torus {
                     0.125,0.025
                     sturm
                     }
               }
         rotate x*90
         scale <1.25,0.75,1.0>
         }

#declare TPaint=texture {
         pigment { color rgb <0.5,0.4,0.2> }
         normal { bumps scale 0.25 }
         finish { specular 0.125 roughness 0.1 }
         }

#declare RustyPaint=texture { bozo
                                texture_map {
                                            [0.0 Rust]
                                            [0.25 Rust]
                                            [0.5 TPaint]
                                            [1.0 TPaint]
                                            }
                                scale 0.15
                                }

#declare Fence=object {
         union {
               box { <0,0,0>,<1,0.025,0.2> }
               box { <0,0.4,0>,<1,0.425,0.2> }
               box { <0,0.875,0>,<1,0.9,0.2> }
               object { FenceRing translate <0.5,0.2,0.1> }
               object { FenceRing translate <0.5,0.65,0.1> }
               object { FenceRing translate <0,0.425,0.1> }
               object { FenceRail translate x*0.25 }
               object { FenceRail translate x*0.75 }
               }
         texture {RustyPaint}
         }

// for testing
//object {
//       union {
//             object { Fence }
//             object { Fence translate -x }
//             }
//       }
