// Create the hillside
//   from "Night Vision" by Darren Izzard

#include "colors.inc"
#include "daztree3.inc"

// object is HillSide

// for testing
//camera { location <3,2,-8> look_at <0,3.5,0> angle 30}
//light_source { <3,10,-8> color White }

#declare Hill=object {       //this generates a hill
         intersection {
                      sphere { <0,0,0>,1 }
                      box { <-2,0,-2>,<2,2,2> }
                      bounded_by { box{<-2,0,-2>,<2,2,2>} }
                      }
         texture {
                 pigment { granite
                           color_map {
                                     [0.0 color rgb <0,0.5,0>]
                                     [0.25 color rgb <0.1,0.6,0>]
                                     [0.5 color rgb <0,0.4,0.2>]
                                     [0.75 color rgb <0,0.7,0>]
                                     [1.0 color rgb <0,0.3,0>]
                                     }
                           scale 0.1
                           }
                 }
         scale <3,3.5,3>
         }

#declare HutColorMap=color_map {
         [0.0 color rgb <1,0,0>]
         [1.0 color rgb <0.75,0.45,0>]
         }

#declare Hut=union {       //the small log cabin on the hillside
         difference {
                  box { <0,0,0>,<3,2,2>
                      texture {
                              pigment { gradient y
                                      color_map { HutColorMap }
                                      scallop_wave
                                      }
                              normal { gradient y scallop_wave }
                              scale 0.25
                              }
                      }
                  box { <4,1.5,0.75>,<0.5,0,1.25>   //doorway
                      texture {
                              pigment{color Yellow}
                              finish{ambient 0.3}  //this makes it look self-lit
                              }
                      }
                  box { <0.5,0.5,-1>,<1.5,1.5,1.5> //window
                      texture {
                              pigment{color Yellow}
                              finish{ambient 0.8}  //this makes it look self-lit
                              }
                      }
                  bounded_by { box {<0,0,0>,<3,2,2>}}
                  }
         light_source {     //light bulb inside the hut
                      <2.75,0.5,1>
                      color Yellow
                      fade_distance 2
                      fade_power 2
                      }
         box { <0,0,0>,<3.25,-2,2>
             texture {
                     pigment { brick color Yellow,color Red
                               scale 0.05  //smaller than logs
                               }
                     }
             }
         object {
            prism { linear_spline //roof
               0,3,
               4,
               <0,-0.2>,<0,2.2>,<1,1>,<0,-0.2>
               }
            rotate z*90
            scale <-1,1,1>
            translate y*2
            texture {
                    pigment { gradient x
                            color_map { HutColorMap }
                            scallop_wave
                            }
                    normal { gradient x scallop_wave }
                    scale 0.25
                    }
            }
         }

#ifdef (USE_BOX_TREE)
#declare Tree=box{<0,0,0>,<0.25,1,0.25> pigment{color Red}}
#end

#declare HillSide=union {
         object {Hill}
         object {Hut
                 scale 0.25
                 translate y*2.75
                 translate -z*2
                 }
         object {
                union {
                      object { Tree translate y*3.5 }
                      object { Tree rotate y*45 translate <-1.5,3.3,0>}
                      object { Tree rotate y*72 translate <0.75,3.2,0>}
                      object { Tree rotate y*192 translate <1.4,2.5,-0.8>}
                      object { Tree rotate y*80 translate <1.4,2.4,-1.25>}
                      object { Tree rotate y*55 translate <1.3,2.4,-1.3>}
                      object { Tree rotate y*92 translate <1.2,2.2,-1.5>}
                      object { Tree rotate y*25 translate <1.6,1.8,-1.5>}
                      object { Tree rotate y*40 translate <1.6,2,-1.2>}
                      }
                }
         }

// for testing
//object {
//       HillSide
//       }

