
// draw a smiling star at the origin
//   from "Night Vision" by Darren Izzard

// object name is HappyStar
// size is approx. <6,6,1.5>
// faces towards negative Z

#include "colors.inc"
#include "starface.inc"

// for testing
//camera { location <3,2,-7> look_at <0,0,0>}
//light_source { <3,10,-15> color White }

#declare StarTexture=texture {
         pigment { spiral2 25
                   color_map {
                             [0.0 color rgb <0.5,0.75,0.2>]
                             [0.5 color rgb <1,1,0>]
                             [1.0 color rgb <0.8,0.5,0.75>]
                             }
                   }
         finish {
                ambient 0.1
                irid {
                     0.65
                     thickness 0.5
                     turbulence <0.3,0.3,0.3>
                     }
                }
         }

#declare DarkStarTexture=texture {
         pigment { spiral2 25
                   color_map {
                             [0.0 color rgb <0.25,0.4,0.1>]
                             [0.5 color rgb <0.5,0.5,0>]
                             [1.0 color rgb <0.4,0.25,0.4>]
                             }
                   }
         finish {
                ambient 0.05
                irid {
                     0.3
                     thickness 0.5
                     turbulence <0.3,0.3,0.3>
                     }
                }
         }

#declare StarFaceTexture=texture {
         pigment {color Yellow}
         finish {
                ambient 0.1
                specular 0.5
                roughness 0.1
                }
         }

#declare SSin=cos(radians(36))  //I got these confused, and the cross-naming fixes it
#declare SCos=sin(radians(36))

#declare StarSegment=union {
         polygon {
                 5,
                 <0,-0.5,0>,<SCos,SSin,0>,<0,3,0>,<-SCos,SSin,0>,<0,-0.5,0>
                 }
         triangle {
                  <SCos,SSin,1>,<-SCos,SSin,1>,<0,-0.5,1>
                  }
         triangle {
                  <SCos,SSin,1>,<-SCos,SSin,1>,<0,3,0>
                  }
         triangle {
                  <-SCos,SSin,0>,<-SCos,SSin,1>,<0,3,0>
                  }
         triangle {
                  <SCos,SSin,0>,<SCos,SSin,1>,<0,3,0>
                  }
         }

#declare HappyStar=union {
         union {
               object { StarSegment rotate z*72*4 }
               object { StarSegment rotate z*72*3 }
               object { StarSegment rotate z*72*2 }
               object { StarSegment rotate z*72 }
               object { StarSegment }
               texture {StarTexture}
               }
         object {
                StarFace
                translate z*-0.05
                scale <1.6,1.6,2>
                texture {StarFaceTexture}
                }
         }

#declare DarkStar=union {
         union {
               object { StarSegment rotate z*72*4 }
               object { StarSegment rotate z*72*3 }
               object { StarSegment rotate z*72*2 }
               object { StarSegment rotate z*72 }
               object { StarSegment }
               texture {DarkStarTexture}
               }
         object {
                StarFace
                translate z*-0.05
                scale <1.6,1.6,2>
                texture {StarFaceTexture}
                }
         }

// for testing
//object {
//       HappyStar
//       }
