//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 20 textures and 152 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/16/1998    (16.04.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera EndCamera
  location  <21.500, -76.500, 10.500>
  direction <0.0,     0.0,  3.4941>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <1.797, 3.278, 8.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera DeckCam
  location  <0.500, -43.700, 12.400>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-5.200, 0.000, 4.300>
}

*/

/*
camera {  //  Camera DoorWallCam
  location  <77.500, -6.500, 21.500>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-11.500, -1.500, 7.000>
}

*/

/*
camera {  //  Camera EclipseCam
  location  <21.500, -76.500, 10.500>
  direction <0.0,     0.0,  21.8289>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <15.265, 5.179, 17.476>
}

*/

//
// *******  L I G H T S *******
//

light_source { // AreaLite001
  <-10.000, -9.000, 17.000>
  color  rgb<1.000, 1.000, 1.000>
  area_light <-0.000, 0.000, -2.000>, <-1.000, 1.732, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Sun
  <-45.000, 823.000, 85.000>
  color rgb <1.000, 0.657, 0.500>
}


//
// ********  TEXTURES  *******
//

#include "eclipse2.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

sphere { // Sphere002
  <0,0,0>,1
  texture {
    Black
  }
  scale 25.0
  translate  <-76.5, 1256.5, 121.5>
}




sphere { // Sphere2
  <0,0,0>,1
  texture {
    Painted_Wood
  }
  translate  <10.0, 14.9, 6.0>
}


sphere { // Sphere001
  <0,0,0>,1
  texture {
    Painted_Wood
  }
  translate  <10.0, -15.1, 6.0>
}


text {   // WelcomeX
  ttf    "C:\WINDOWS\Fonts\Verdanab.ttf",
  "WELCOME!",
  1.0,  // Depth
  <0.0,   0.0, 0.0> // Offset
  texture {
    Welcome
  }
  scale <2.5, 2.5, 1.0>
  rotate 90.0*z
  translate  <-8.0, -7.5, -0.695>
}



box { // WelcomeMat
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WelcomeMat
  }
  scale <3.0, 8.0, 0.4>
  translate  <-9.0, 0.0, -0.1>
}


#declare WallBoards = union {
  box { // Wall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  -11.9*x
  }
  box { // Wall3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 4.0>
  }
  box { // Wall2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 2.0>
  }
  box { // Wall4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 6.0>
  }
  box { // Wall5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 8.0>
  }
  box { // Wall7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 12.0>
  }
  box { // Wall6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 10.0>
  }
  box { // Wall8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 14.0>
  }
  box { // Wall9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 16.0>
  }
  box { // Wall10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 18.0>
  }
  box { // Wall11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 20.0>
  }
  box { // Wall12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <0.3, 20.0, 1.0>
    rotate -10.0*y
    translate  <-11.9, 0.0, 22.0>
  }
}
difference { // WallwithDoorHole
  object { WallBoards }
  box { // DoorHole
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall
    }
    scale <1.0, 9.5, 9.5>
    translate  <-12.0, 0.0, 9.5>
  }
}


cylinder { // BackRailing
  <0,0,1>, <0,0,0>, 1 
  texture {
    Painted_Wood
    scale <1.0, 1.0, 0.1>
  }
  bounded_by { // Bound3
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.033333, 1.033333, 0.533333>
      translate  <0.0, 0.0, 0.5>
    }
  }
  scale <0.3, 0.3, -25.0>
  rotate <-0.0, 90.0, 0.0>
  translate  <9.7, 15.1, 4.0>
}


sphere { // Land
  <0,0,0>,1
  texture {
    Grass
  }
  scale <60.0, 60.0, 3.0>
  translate  <-52.0, 7.0, -3.5>
}


sphere { // SkySphere2
  <0,0,0>,1
  texture {
    Stars
  }
  hollow
  scale 1500.0
  translate  <3.5, -13.0, 0.0>
}


sphere { // SkySphere1
  <0,0,0>,1
  texture {
    Sky
  }
  hollow
  scale <1000.0, 1000.0, 500.0>
}


plane { // Water3
  z,0
  texture {
    Water
  }
  hollow
  translate  <16.6, -19.3, -1.9>
}


union { // Planks
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  8.9*x
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  6.8*x
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  4.7*x
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  2.6*x
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  0.5*x
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  -1.6*x
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  -3.7*x
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  -5.8*x
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  -7.9*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 15.0, 0.2>
    translate  -10.0*x
  }
  texture {
    Planks
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <15.048, 15.398, 0.598>
      translate  3.65*x
    }
  }
}


union { // Posts
  cylinder { // BackRightPost
    <0,0,1>, <0,0,0>, 1 
    texture {
      Painted_Wood
      scale <1.0, 1.0, 0.1>
    }
    bounded_by { // Bound4
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <0.6, 0.6, 10.0>
    translate  <18.0, 15.0, -6.0>
  }
  cylinder { // FrontRightPost
    <0,0,1>, <0,0,0>, 1 
    texture {
      Painted_Wood
      scale <1.0, 1.0, 0.1>
    }
    bounded_by { // Bound00003
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <0.6, 0.6, 10.0>
    translate  <18.0, -15.0, -6.0>
  }
  scale <1.0, 1.0, 1.3>
  translate  <-8.0, -0.1, 0.0>
}


union { // Railings
  cylinder { // RightRailing
    <0,0,1>, <0,0,0>, 1 
    texture {
      Painted_Wood
      scale <1.0, 1.0, 0.1>
    }
    bounded_by { // Bound00004
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <0.3, 0.3, 30.0>
    rotate <90.0, 90.0, 0.0>
    translate  <10.0, 15.0, 4.0>
  }
  cylinder { // FrontRailing
    <0,0,1>, <0,0,0>, 1 
    texture {
      Painted_Wood
      scale <1.0, 1.0, 0.1>
    }
    bounded_by { // Bound00002
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <0.3, 0.3, -25.0>
    rotate <-0.0, 90.0, 0.0>
    translate  <9.7, -15.1, 4.0>
  }
}




#declare WholeLeg3 = union {
  cylinder { // LegBottom3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -19.3>
  }
  box { // SquareLeg7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, 0.4, -11.3>
  }
  box { // SquareLeg8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, -0.4, -11.3>
  }
  cylinder { // LegTop3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -3.3>
  }
}
#declare LegHoles3 = union {
  cylinder { // TopLegHole18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -7.3>
  }
  cylinder { // TopLegHole19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -10.3>
  }
  cylinder { // TopLegHole20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -13.3>
  }
  cylinder { // TopLegHole21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -16.3>
  }
  cylinder { // TopLegHole22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -19.3>
  }
  cylinder { // TopLegHole23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -3.3>
  }
}
#declare MainLeg3 = difference {
  object { WholeLeg3 }
  object { LegHoles3 }
  rotate 15.0*y
  translate  <0.6, 0.0, -0.9>
}
#declare Leg3 = union {
  object { MainLeg3 }
  rotate 15.0*y
  translate  <2.9, 0.0, -0.4>
}
#declare LegAndFoot4 = union {
  object { Leg3 }
  cylinder { // Foot5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <-8.9, 0.0, -17.4>
  }
  rotate 90.0*z
  translate  <0.5, -0.5, 0.0>
}
#declare WholeLeg2 = union {
  cylinder { // LegBottom2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -19.3>
  }
  box { // SquareLeg5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, 0.4, -11.3>
  }
  box { // SquareLeg6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, -0.4, -11.3>
  }
  cylinder { // LegTop2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.4, -3.3>
  }
}
#declare LegHoles2 = union {
  cylinder { // TopLegHole12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -7.3>
  }
  cylinder { // TopLegHole13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -10.3>
  }
  cylinder { // TopLegHole14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -13.3>
  }
  cylinder { // TopLegHole15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -16.3>
  }
  cylinder { // TopLegHole16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -19.3>
  }
  cylinder { // TopLegHole17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -3.3>
  }
}
#declare MainLeg2 = difference {
  object { WholeLeg2 }
  object { LegHoles2 }
  rotate 15.0*y
  translate  <0.6, 0.0, -0.9>
}
#declare Leg2 = union {
  object { MainLeg2 }
  rotate 15.0*y
  translate  <2.9, 0.0, -0.4>
}
#declare LegAndFoot3 = union {
  object { Leg2 }
  cylinder { // Foot4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <-8.9, 0.0, -17.4>
  }
  rotate -90.0*z
  translate  <0.6, 0.5, 0.0>
}
#declare WholeLeg1 = union {
  cylinder { // LegBottom1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -19.3>
  }
  box { // SquareLeg3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, 0.4, -11.3>
  }
  box { // SquareLeg4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, -0.4, -11.3>
  }
  cylinder { // LegTop1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -3.3>
  }
}
#declare LegHoles1 = union {
  cylinder { // TopLegHole6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -7.3>
  }
  cylinder { // TopLegHole7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -10.3>
  }
  cylinder { // TopLegHole8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -13.3>
  }
  cylinder { // TopLegHole9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -16.3>
  }
  cylinder { // TopLegHole10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -19.3>
  }
  cylinder { // TopLegHole11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -3.3>
  }
}
#declare MainLeg1 = difference {
  object { WholeLeg1 }
  object { LegHoles1 }
  rotate 15.0*y
  translate  <0.6, -0.1, -0.9>
}
#declare Leg1 = union {
  object { MainLeg1 }
  rotate 15.0*y
  translate  <2.9, 0.0, -0.4>
}
#declare LegAndFoot2 = union {
  object { Leg1 }
  cylinder { // Foot3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <-8.9, 0.0, -17.4>
  }
  rotate -180.0*z
  translate  <1.0, -0.1, 0.0>
}
#declare WholeLeg = union {
  cylinder { // LegBottom
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -19.3>
  }
  box { // SquareLeg2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, 0.4, -11.3>
  }
  box { // SquareLeg1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty
    }
    scale <0.5, 0.1, 8.0>
    translate  <-2.8, -0.4, -11.3>
  }
  cylinder { // LegTop
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.5, 0.5, 1.0>
    rotate 90.0*x
    translate  <-2.8, 0.5, -3.3>
  }
}
#declare LegHoles = union {
  cylinder { // TopLegHole5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -7.3>
  }
  cylinder { // TopLegHole4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -10.3>
  }
  cylinder { // TopLegHole3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -13.3>
  }
  cylinder { // TopLegHole2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -16.3>
  }
  cylinder { // TopLegHole1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -19.3>
  }
  cylinder { // TopLegHole
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <-2.8, 0.6, -3.3>
  }
}
#declare MainLeg = difference {
  object { WholeLeg }
  object { LegHoles }
  rotate 15.0*y
  translate  <0.6, 0.0, -0.9>
}
#declare Leg = union {
  object { MainLeg }
  rotate 15.0*y
  translate  <2.9, 0.0, -0.4>
}
#declare LegAndFoot1 = union {
  object { Leg }
  cylinder { // Foot2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <-8.9, 0.0, -17.4>
  }
}
#declare Plate = union {
  cylinder { // PlateBolt4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.05, 0.05, 0.8>
    translate  <-0.9, -0.9, -3.3>
  }
  cylinder { // PlateBolt3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.05, 0.05, 0.8>
    translate  <-0.9, 0.9, -3.3>
  }
  cylinder { // PlateBolt2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.05, 0.05, 0.8>
    translate  <0.9, 0.9, -3.3>
  }
  cylinder { // PlateBolt1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.05, 0.05, 0.8>
    translate  <0.9, -0.9, -3.3>
  }
  box { // StandPlate3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 0.1>
    translate  -3.1*z
  }
  cylinder { // StandPlate2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty
    }
    scale <1.0, 1.0, 0.2>
    translate  -3.0*z
  }
  box { // StandPlate1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 0.1>
    translate  -2.7*z
  }
  translate  0.5*x
}
#declare AttachmentHoles = union {
  cylinder { // AttachmentHole2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.2, 0.2, 1.2>
    rotate 90.0*x
    translate  <0.0, 0.6, -0.7>
  }
  cylinder { // AttachmentHole1
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.45, 0.45, 1.2>
    rotate 90.0*y
    translate  <-0.6, 0.0, -1.0>
  }
}
#declare Attachment = difference {
  cylinder { // JointAttachment
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.5, 0.5, 2.8>
    translate  -1.0*z
  }
  object { AttachmentHoles }
  translate  -1.7*z
}
#declare BaseTubeHoles = union {
  cylinder { // BaseTubeHole2
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.3, 0.3, 4.0>
    rotate 90.0*x
    translate  <1.2, 2.0, -0.2>
  }
  cylinder { // BaseTubeHole1
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.3, 0.3, 4.0>
    rotate 90.0*x
    translate  <0.2, 2.0, -0.2>
  }
}
#declare CSG001 = difference {
  cylinder { // BaseTube
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 3.6>
    rotate 90.0*x
    translate  <0.7, 1.8, -0.2>
  }
  object { BaseTubeHoles }
}
#declare Base = union {
  box { // StandBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Aluminum
    }
    scale <2.5, 2.0, 0.2>
    translate  <0.7, 0.0, 0.4>
  }
  cylinder { // BasePivitPoint
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.5, 0.5, 2.0>
    rotate <-0.0, 90.0, 0.0>
    translate  <-1.1, 0.0, -2.6>
  }
  cylinder { // TighteningRodHandle
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale 0.5
    rotate 90.0*y
    translate  <-3.8, 0.0, -0.8>
  }
  cylinder { // TighteningRod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.1, 0.1, 6.0>
    rotate 90.0*y
    translate  <-3.6, 0.0, -0.8>
  }
  cylinder { // HandleRod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.5, 0.5, 4.0>
    translate  <-1.0, 0.0, -3.5>
  }
  cylinder { // BaseTubeRod2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.1, 0.1, 4.0>
    rotate 90.0*x
    translate  <1.2, 2.0, -0.2>
  }
  cylinder { // BaseTubeRod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.1, 0.1, 4.0>
    rotate 90.0*x
    translate  <0.2, 2.0, -0.2>
  }
  object { CSG001 }
  torus { // HandleHandle
    0.2, 0.2  rotate -x*90
    texture {
      ShinyBlack
    }
    translate  <-1.0, 0.0, -5.3>
  }
  cylinder { // LowerHandle
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.1, 0.1, 2.0>
    translate  <-1.0, 0.0, -5.3>
  }
}
#declare ViewFinderStrut2 = difference {
  box { // ViewFinderStrutBase2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShinyBlack
    }
    scale <0.3, 0.1, 1.0>
    rotate 30.0*y
    translate  <-16.8, 0.0, 3.6>
  }
  cylinder { // ViewFinderStrutHole2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate -90.0*x
    translate  <-16.8, -0.7, 3.6>
  }
  texture {
    ShinyBlack
  }
  translate  2.4*x
}
#declare ViewFinderStrut1 = difference {
  box { // ViewFinderStrutBase1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ShinyBlack
    }
    scale <0.3, 0.1, 1.0>
    rotate 30.0*y
    translate  <-16.8, 0.0, 3.6>
  }
  cylinder { // ViewFinderStrutHole1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    rotate -90.0*x
    translate  <-16.8, -0.7, 3.6>
  }
  texture {
    ShinyBlack
  }
  translate  -0.1*x
}
#declare EyeTube = union {
  cylinder { // EyeTube2
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.55, 0.55, 0.75>
    translate  -0.8*z
  }
  cylinder { // EyeTube1
    <0,0,1>, <0,0,0>, 1 open
    texture {
      ShinyBlack
    }
    scale <0.5, 0.5, 1.5>
    translate  -1.5*z
  }
  sphere { // EyeLens
    <0,0,0>,1
    texture {
      Lens
    }
    scale <0.5, 0.5, 0.1>
    translate  -1.5*z
  }
  torus { // Torus001
    0.55, 0.05  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 3.0>
    translate  -1.4*z
  }
  rotate 125.0*x
  translate  <-16.0, 3.7, 1.6>
}
#declare Telescope = union {
  cylinder { // ViewFinderDial
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.1, 0.1, 1.6>
    rotate 90.0*x
    translate  <-15.4, 0.8, 4.8>
  }
  torus { // ViewFinderLensCap2
    0.65, 0.05  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 4.0>
    rotate -90.0*y
    translate  <-12.9, 0.0, 4.8>
  }
  torus { // ViewFinderLensCap
    0.65, 0.05  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 4.0>
    rotate -90.0*y
    translate  <-17.7, 0.0, 4.8>
  }
  sphere { // ViewFinderLens1
    <0,0,0>,1
    texture {
      Lens
    }
    scale <0.1, 0.6, 0.6>
    translate  <-12.8, 0.0, 4.8>
  }
  sphere { // ViewFinderLens
    <0,0,0>,1
    texture {
      Lens
    }
    scale <0.1, 0.6, 0.6>
    translate  <-17.8, 0.0, 4.8>
  }
  cylinder { // ViewFinder
    <0,0,1>, <0,0,0>, 1 open
    texture {
      ShinyBlack
    }
    scale <0.6, 0.6, 5.0>
    rotate -90.0*y
    translate  <-12.8, 0.0, 4.8>
  }
  object { ViewFinderStrut2 }
  object { ViewFinderStrut1 }
  object { EyeTube }
  torus { // EyePlateBracket2
    3.05, 0.05  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*y
    translate  -17.2*x
  }
  torus { // EyePlateBracket1
    3.05, 0.05  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*y
    translate  -14.7*x
  }
  cylinder { // EyePieceHinge1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.35, 0.35, 3.0>
    rotate -90.0*y
    translate  <-14.5, 3.5, 1.5>
  }
  cylinder { // EyePieceHinge
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.7, 0.7, 2.5>
    rotate -90.0*y
    translate  <-14.75, 3.5, 1.5>
  }
  superellipsoid { // EyePlate
    <0.1, 0.1>
    texture {
      ShinyBlack
    }
    scale <2.0, 1.0, 1.0>
    translate  <-16.0, 2.5, 1.5>
  }
  cylinder { // Dial
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale 0.3
    rotate 90.0*x
    translate  <-17.0, 3.3, 0.0>
  }
  sphere { // Lens
    <0,0,0>,1
    texture {
      Lens
    }
    scale <0.1, 2.9, 2.9>
    translate  -19.7*x
  }
  torus { // LensTube
    3.1, 0.1  rotate -x*90
    texture {
      ShinyBlack
    }
    scale <1.0, 1.0, -4.0>
    rotate -90.0*y
    translate  -19.7*x
  }
  cylinder { // SecondTube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <3.1, 3.1, 1.0>
    rotate -90.0*y
    translate  -10.0*x
  }
  cylinder { // FirstTube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <3.1, 3.1, 1.0>
    rotate -90.0*y
    translate  -6.0*x
  }
  cylinder { // BigEndTube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <3.2, 3.2, 1.0>
    rotate -90.0*y
  }
  cylinder { // SmallEndTube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <3.1, 3.1, 1.5>
    rotate -90.0*y
  }
  cylinder { // Tube
    <0,0,1>, <0,0,0>, 1 open
    texture {
      ShinyBlack
    }
    hollow
    scale <3.0, 3.0, 20.0>
    rotate -90.0*y
  }
  translate  <9.2, 0.0, 3.4>
}
#declare TelescopeANDBase = union {
  object { Base }
  object { Telescope }
  translate  <-0.9, 0.0, 2.6>
}
#declare RotatableTelescope = union {
  object { TelescopeANDBase }
  rotate <0.0, 25.0, 25.0>
}
union { // TelescopeAndStand
  object { LegAndFoot4 }
  object { LegAndFoot3 }
  object { LegAndFoot2 }
  object { LegAndFoot1 }
  object { Plate }
  object { Attachment }
  cylinder { // HingeDial2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale 0.2
    rotate 90.0*x
    translate  1.0*y
  }
  cylinder { // HingeDial1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale 0.2
    rotate 90.0*x
    translate  -0.8*y
  }
  cylinder { // HingeRod
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyBlack
    }
    scale <0.1, 0.1, 2.2>
    rotate -90.0*x
    translate  -1.1*y
  }
  sphere { // StandMBaseHinge
    <0,0,0>,1
    texture {
      ShinyBlack
    }
    scale 0.5
  }
  object { RotatableTelescope }
  scale 0.45
  rotate 125.0*z
  translate  <3.0, -0.5, 8.0>
}


difference { // Eclipse
  sphere { // Sun1
    <0,0,0>,1
    texture {
      Eclipse
    }
    hollow
  }
  cylinder { // HoleInSun
    <0,0,1>, <0,0,0>, 1 
    texture {
      Clear
    }
    scale <0.75, 0.75, 2.0>
    rotate <-0.125671, -4.94045, 0.482142>
    translate  <0.103946, 0.047068, -1.004118>
  }
  scale 20.0
  rotate -85.0*x
  translate  <-44.0, 799.0, 85.0>
}


union { // Door
  box { // HandleNear
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.1, 0.3, 0.75>
    translate  <1.0, -1.2, 6.0>
  }
  box { // HandleFar
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.1, 0.3, 0.75>
    translate  <1.0, 1.2, 6.0>
  }
  box { // HandleBaseNear
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.5, 0.1, 0.75>
    translate  <0.5, -1.0, 6.0>
  }
  box { // HandleBaseFar
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.5, 0.1, 0.75>
    translate  <0.5, 1.0, 6.0>
  }
  box { // InnerEdgeClose
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.3, 0.2, 7.5>
    translate  <0.0, -0.26, 7.5>
  }
  box { // InnerEdgeFar
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.3, 0.2, 7.5>
    translate  <0.0, 0.26, 7.5>
  }
  sphere { // CloseCorner
    <0,0,0>,1
    texture {
      B_Silver
    }
    scale 0.3
    translate  <0.0, -7.5, 15.0>
  }
  sphere { // FarCorner
    <0,0,0>,1
    texture {
      B_Silver
    }
    scale 0.3
    translate  <0.0, 7.5, 15.0>
  }
  cylinder { // TopFrame
    <0,0,1>, <0,0,0>, 1 
    texture {
      B_Silver
    }
    scale <0.3, 0.3, 15.0>
    rotate 90.0*x
    translate  <0.0, 7.5, 15.0>
  }
  box { // FrameBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      B_Silver
    }
    scale <0.5, 7.5, 0.15>
    translate  <0.2, 0.0, 0.15>
  }
  cylinder { // FrameFar
    <0,0,1>, <0,0,0>, 1 
    texture {
      B_Silver
    }
    scale <0.3, 0.3, 15.0>
    translate  7.5*y
  }
  cylinder { // FrameClose
    <0,0,1>, <0,0,0>, 1 
    texture {
      B_Silver
    }
    scale <0.3, 0.3, 15.0>
    translate  -7.5*y
  }
  box { // WindowPane
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass
    }
    scale <0.1, 7.5, 7.5>
    translate  7.5*z
  }
  scale <0.5, 1.25, 1.25>
  translate  -12.0*x
}


