#include "colors.inc"#include "mestex.inc"#include "facelem.inc"#include "lampad.inc"
#declare galaxy_seed=4 #include "galaxy.inc"

#include "Tree1.inc" object {Arbre1 pigment {Black} scale 10 rotate y*180 translate <1000,900,0>}
#include "Tree2.inc" object {Arbre1 pigment {Black} scale 3 rotate y*90 translate <600,0,1500>}

#declare Trotex1=texture{pigment{Gray70} normal {quilted .7 scale 20 rotate y*45}}
#declare Trotex2=texture{PierreBleue2 finish {diffuse .2 specular .5} normal {bumps .3}}

#declare Banc=union {
box {<0,0,0>,<20,35,54> texture {BetPour}}
box {<120,0,0>,<100,35,54> texture {BetPour}}
box {<-10,35,0>,<130,45,6> texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*1 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*2 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*3 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*4 texture {T_Wood23 scale 10}}
}

object {Banc translate <0,18,1420>}
object {Banc translate <200,18,1420>}
object {Banc translate <-700,18,1500>}


//============================================================================
//      CAMERA, SOME ENVIRONNEMENT...
//============================================================================
camera {location <600,700,2500> direction z*1 look_at <-400,500,-700>}
//camera {location <600,700,2500> direction z*8 look_at <0,0,1500>}

plane {y,-22 pigment {Gray40}}
//============================================================================
//      SWITCHING MISCELLANEOUS ELEMENTS
//============================================================================

#declare maison1=1;
#declare maison2=1;
#declare maison3=1;
#declare maison4=1;
#declare maison5=1;
#declare maison6=1;
#declare maison7=1;
#declare maison8=1;
#declare maison9=1;

#declare cobbleswitch=on;  //cobblestones
#declare PignonSwitch=on;  //gable
#declare LampadSwitch=on;  //street lamps
#declare MonsterHalo =on;  //halo for the "monster"
#declare MonsterShow =on;  //the "monster"
#declare LuneSwitch  =on;  //the moon
#declare WaterFlotte =on;  //some water on the ground
#declare BaraqLight  =on;
#declare AreaSwitch  =on;

//=========================================================================
//      CORNER HOUSE, STREET INDICATOR (declare), WATER
//=========================================================================
#if (maison9=on) 
        #include "maison2.inc" 
        object {MaisonCoin rotate y*-135 translate <800,0,800>} 
union {#include "TROTT.INC" scale <-1,1,1> rotate y*-30 translate <1120,0,100>}
#else #end

#declare PlaqueRue=
        box {<0,0,0>,<100,60,-.5> 
        pigment {image_map {png "pvstreet.png"} scale <100,60,1>}
        }

#if (WaterFlotte=on) 
        height_field {
        gif "flotte.gif" 
        scale <2000,(250/153)*25,2000> 
        translate <-1000,-30,-1000> 
        pigment {Clear} finish {phong .6 reflection .5} normal {ripples .1}
        } 
        height_field {
        gif "mousse.gif" 
        scale <1200,50,1200> 
        rotate y*90 
        pigment {Clear} finish {phong .6 reflection .5} normal {ripples .1}
        translate <0,-20,1200> 
        }
#else #end

//=========================================================================
//      PLACEMENT DES LAMPES DE RUE
//=========================================================================
#if (LampadSwitch=on) 
        object {StreetLamp rotate y*90 translate <400,0,1350>}
        object {StreetLamp rotate y*90 translate <-100,0,1350>}
        object {StreetLamp rotate y*90 translate <-600,0,1350>}
        object {StreetLamp rotate y*90 translate <-1100,0,1350>} 
#else #end
//=========================================================================
//      PAVEMENT
//=========================================================================
union {
box {<-1500,0,1200>,<1500,20,1230> texture {Trotex2}}
box {<-1500,0,1230>,<1500,18,1800> texture {Trotex1}} 
translate z*100
}

#declare CoinTrott=union{
        difference {
                cylinder {<0,3,720>,<-0,-33,720>,175}
                cylinder {<0,4,720>,<0,-33,720>,150} 
        clipped_by {plane {z,720 inverse}}
        clipped_by {plane {x,0 inverse}}
       texture {Trotex2}
}
cylinder {<0,0,720>,<0,-33,720>,150 texture {Trotex1}}
                        }

object {CoinTrott}
object {CoinTrott scale <-1,1,1> translate x*-720}

union {
        box {<-50,0,-30>,<150,-30,750> texture {Trotex1}}
        box {<175,3,0>,<150,-30,720> texture {Trotex2}}
        rotate y*-90 translate z*720
        }
//=========================================================================
//      COBBLESTONES
//=========================================================================
#if (cobbleswitch=on)
union {
#declare boucle1=0;
#while (boucle1 < 16)      //16
  #declare boucle2=0;
  #while (boucle2 < 20)    //20

    object {EnsCobble texture {PierreBleue3} finish {phong 1.3}
    translate <boucle1*50-500,0,boucle2*50-450>
    }
        #declare boucle2=boucle2+1;
  #end
  #declare boucle1=boucle1+1;
#end
scale 4 translate y*-20 //translate z*1800
}
#else #end

//=========================================================================
//      WOODEN BENCHS
//=========================================================================
#declare Banc=union {
box {<0,0,0>,<20,35,54> texture {BetPour}}
box {<120,0,0>,<100,35,54> texture {BetPour}}
box {<-10,35,0>,<130,45,6> texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*1 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*2 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*3 texture {T_Wood23 scale 10}}
box {<-10,35,0>,<130,45,6> translate z*12*4 texture {T_Wood23 scale 10}}}

object {Banc translate <0,18,1420>}
object {Banc translate <200,18,1420>}
object {Banc translate <-700,18,1500>}
//=========================================================================
//      AVOIDING UNDECLARED THINGS
//=========================================================================
#declare CAmp1A=Orange+Pink;   #declare CAmp1B=Orange+Pink; #declare CAmp1C=Orange+Pink;
#declare CAmp2A=Orange+Yellow  #declare CAmp2B=Blue+Pink;   #declare CAmp2C=Orange+Pink;
#declare CAmp3A=Orange+Blue;   #declare CAmp3B=Red;         #declare CAmp3C=Orange+Pink;
//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING
//=========================================================================
#if (maison1=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau2}
#declare sousseuil   = object {sousseuil1}
#declare seuil       = object {seuil1}
#declare trumeau     = object {trumeau2}
#declare piedroitG   = object {piedroitG2}
#declare piedroitD   = object {piedroitD2}
#declare carrelint   = object {carelint2}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color Firebrick} scale 3}
#declare fenetre     = object {fenetre1}

#declare Amp1A=1; #declare Amp1B=0 #declare Amp1C=1;
#declare Amp2A=0; #declare Amp2B=0 #declare Amp2C=0;
#declare Amp3A=1; #declare Amp3B=1 #declare Amp3C=0;

#include "facade.inc"

object {facade}
#if (PignonSwitch=on) object {PignonRug} #else #end
#include "TROTT.INC"
union {#include "TROTT.INC" scale <-1,1,1> translate x*-720}
#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (2)
//=========================================================================
#if (maison2=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
//#declare TexParement = texture {pigment {brick color Gray90 color Firebrick} scale 3}
#declare TexParement = texture {pigment {Pink}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=1 #declare Amp1B=0 #declare Amp1C=0
#declare Amp2A=0 #declare Amp2B=1 #declare Amp2C=0
#declare Amp3A=0 #declare Amp3B=0 #declare Amp3C=0

#include "facade.inc"

object {facade scale 1.05 translate <20,0,720*-1> rotate y*-20}
union {#include "TROTT.INC" translate <20,0,720*-1> rotate y*-20}
#else #end
//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (3)
//=========================================================================
#if (maison3=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color Orange/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=0 #declare Amp1B=0 #declare Amp1C=1
#declare Amp2A=0 #declare Amp2B=1 #declare Amp2C=1
#declare Amp3A=1 #declare Amp3B=0 #declare Amp3C=0

#declare CAmp1A=Orange+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange+Pink
#declare CAmp2A=Orange+Yellow #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange+Pink

#declare CAmp3A=Orange+Blue   #declare CAmp3B=Red         #declare CAmp3C=Orange+Pink


#include "facade.inc"

object {facade scale <.95,.95,-.95> translate <270,0,-720+50>}
union {#include "TROTT.INC" scale <1,1,-1> translate <270,0,-720+50>}
#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (4)
//=========================================================================
#if (maison4=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color Orange/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=0 #declare Amp1B=0 #declare Amp1C=1
#declare Amp2A=0 #declare Amp2B=1 #declare Amp2C=1
#declare Amp3A=1 #declare Amp3B=0 #declare Amp3C=0

#declare CAmp1A=Orange+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange+Pink
#declare CAmp2A=Orange+Yellow #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange+Pink
#declare CAmp3A=Orange+Blue   #declare CAmp3B=Red         #declare CAmp3C=Orange+Pink

#include "facade.inc"

object {facade scale <.95,.95,.95> rotate y*-30 translate <600,0,-1900>}
union {#include "TROTT.INC" rotate y*-30 translate <600,0,-1900>}
#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (5)
//=========================================================================
#if (maison5=on)
#declare porte       = object {porte3}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color Orange/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=0 #declare Amp1B=0 #declare Amp1C=1
#declare Amp2A=0 #declare Amp2B=1 #declare Amp2C=1
#declare Amp3A=1 #declare Amp3B=0 #declare Amp3C=0

#declare CAmp1A=Orange+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange+Pink
#declare CAmp2A=Orange+Yellow #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange+Pink
#declare CAmp3A=Orange+Blue   #declare CAmp3B=Red         #declare CAmp3C=Orange+Pink

#include "facade.inc"

object {facade scale 1.06 rotate y*-60 translate <1250,0,-2290>}
union {#include "TROTT.INC" rotate y*-60 translate <1250,0,-2290>}
#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (6) 
//=========================================================================
#if (maison6=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color Orange/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=1 #declare Amp1B=0 #declare Amp1C=0
#declare Amp2A=1 #declare Amp2B=0 #declare Amp2C=0
#declare Amp3A=1 #declare Amp3B=0 #declare Amp3C=0

#declare CAmp1A=Red+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange/2+Pink/2
#declare CAmp2A=Orange/3+Pink/3 #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange/3+Pink/3
#declare CAmp3A=Orange/2+Pink/2   #declare CAmp3B=Red         #declare CAmp3C=Red+Pink

#include "facade.inc"

union {
object {facade} 

disc {<0,0,0>,x,70
pigment {image_map {gif "chat1.gif" once filter all .9} rotate y*90 scale 60} 
translate <-10,145,165>}
scale <1,1,-1> rotate y*-90 translate x*-720 translate <1650,0,830>}

union {#include "TROTT.INC" scale <1,1,-1> rotate y*-90 translate x*-720 translate <1650,0,830>}

#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (7)
//=========================================================================
#if (maison7=on)
#declare porte       = object {porte1}
#declare linteau     = object {linteau3}
#declare sousseuil   = object {sousseuil3}
#declare seuil       = object {seuil3}
#declare trumeau     = object {trumeau3}
#declare piedroitG   = object {piedroitG3}
#declare piedroitD   = object {piedroitD3}
#declare carrelint   = object {carelint3}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement3}
#declare TexParement = texture {pigment {brick color Gray90 color LightBlue/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=0 #declare Amp1B=0 #declare Amp1C=0
#declare Amp2A=0 #declare Amp2B=0 #declare Amp2C=0
#declare Amp3A=0 #declare Amp3B=1 #declare Amp3C=0

#declare CAmp1A=Orange+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange+Pink
#declare CAmp2A=Orange+Yellow #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange+Pink
#declare CAmp3A=Orange+Blue   #declare CAmp3B=Red         #declare CAmp3C=Orange+Pink

#include "facade.inc"
union {
object {facade} 
object {PlaqueRue rotate y*-90 translate <40,360,350> finish {ambient .5}}
scale 1 rotate y*-20 translate <-1550,0,200>}

union {#include "TROTT.INC" rotate y*-20 translate <-1550,0,200>}
#else #end

//=========================================================================
//      CHOOSING FACADE ELEMENTS AND PLACING THE WHOLE THING (8)
//=========================================================================
#if (maison8=on)
#declare porte       = object {porte3}
#declare linteau     = object {linteau1}
#declare sousseuil   = object {sousseuil2}
#declare seuil       = object {seuil2}
#declare trumeau     = object {trumeau1}
#declare piedroitG   = object {piedroitG1}
#declare piedroitD   = object {piedroitD1}
#declare carrelint   = object {carelint1}
#declare larmier40   = box {<0,0,0>,<40,20,720> texture {PierreBleue}}
#declare larmier30   = box {<0,0,0>,<28,20,720> texture {PierreBleue}}
#declare soubassement= object {soubassement1}
#declare TexParement = texture {pigment {brick color Gray90 color LightBlue/2} scale 3}
//#declare TexParement = texture {pigment {rgb <1,1,.8>} normal {bumps .1 scale 10}}
#declare fenetre     = object {fenetre1}

#declare Amp1A=0 #declare Amp1B=0 #declare Amp1C=0
#declare Amp2A=0 #declare Amp2B=0 #declare Amp2C=0
#declare Amp3A=0 #declare Amp3B=1 #declare Amp3C=0

#declare CAmp1A=Orange+Pink   #declare CAmp1B=Orange+Pink #declare CAmp1C=Orange+Pink
#declare CAmp2A=Orange+Yellow #declare CAmp2B=Blue+Pink   #declare CAmp2C=Orange+Pink
#declare CAmp3A=Orange+Blue   #declare CAmp3B=Orange+Pink         #declare CAmp3C=Orange+Yellow

#include "facade.inc"

object {facade scale .97 rotate y*-10 translate <-1450,0,-480>}
union {#include "TROTT.INC" rotate y*-10 translate <-1450,0,-480>}
#else #end

//=========================================================================
//      LIGHTS AND FOG
//=========================================================================

light_source {<1500,5000,1500> White*.4 
        spotlight point_at <0,400,720> radius 40 falloff 60 
        atmosphere off
#if (AreaSwitch=on) area_light <300,0,0>,<0,0,300>,5,5 adaptive 1 jitter #else #end
        }
light_source {<50,5000,5000> rgb <1,1,1.2>*.4 
        atmosphere off
#if (AreaSwitch=on) area_light <300,0,0>,<0,0,300>,5,5 adaptive 1 jitter #else #end
        }

fog {distance 6000 fog_type 2 rgb <.3,.3,.4> transmit .3 fog_alt 1 fog_offset 1500 turbulence 1}
fog {distance 8000 fog_type 2 rgb <.3,.3,.4>*2 transmit .6 fog_alt 1 fog_offset 500 turbulence 1}

//=========================================================================
//      PROJECTOR AND MONSTER SCULPTURE
//=========================================================================
#if (MonsterShow=on)
        #include "dragon.inc" 
        object {Positif translate x*-400}
        light_source {<-400,200,1800> White*2.5 
                spotlight point_at <-400,200,0> radius 20 falloff 22}

        #declare Gelatine = texture {
                              pigment {waves 
                              color_map { 
                              [ 0.0     rgbft <0.281233, 0.281233, 0.281233, 0.5208, 0.0> ]
                              [ 0.234875  rgbft <0.274503, 0.261395, 0.20463, 0.0, 0.312467> ]
                              [ 0.483986  rgbft <1.0, 1.0, 1.0, 0.468733, 0.312467> ]
                              [ 1.0     rgbft <1.0, 1.0, 1.0, 0.437467, 0.3958> ]
                              } 
                              scale  0.1 
                              warp  {turbulence <0.2, 0.2, 0.2> }}
                              }

        disc {<0,0,0>,z,1 texture {Gelatine scale .4} 
              translate <-400,200,1798>}
        
        #if (MonsterHalo=on)
                #declare MyHalo=sphere {<0,0,0>,1 hollow no_shadow
                        pigment {Clear} 
                        halo {dust dust_type 1 
                        spherical_mapping constant 
                        colour_map {[0 color rgbt <1,1,1,1>]
                                    [1 color rgbt <1,1,1,.8>]}
                                    samples 50}
                                    }
                object {MyHalo scale <450,1800-750,450> 
                        rotate x*90 translate <-400,200,720>}
        #else #end
#else #end

//=========================================================================
//      THE MOON
//=========================================================================
#if (LuneSwitch=on)
        sphere {<0,0,0>,500 
                pigment {image_map {png "lune.png" map_type 2} 
                translate y*-.5 scale 500} finish {ambient 1.5} 
                translate <-10000,5000,-10000>}
        sphere {<0,0,0>,1 hollow pigment {Clear} 
                halo {glowing spherical_mapping 
                constant colour_map {[0 color rgbt <1,1,1,.6>]
                [1 color rgbt <1,1,1,.4>]} samples 10}
                scale 700 translate <-10000,5000,-10000>}
#else #end 

//=========================================================================
//      HOW DOES IT CAME HERE ?
//=========================================================================

global_settings {max_trace_level 15}

//============================================================================
//      GUTTERS
//============================================================================
union {
        cylinder {<0,0,0>,<0,980,0>,6 open}
        cylinder {<0,30,0>,<0,6,30>,6 open} 
        torus {6 2 translate y*100}
        torus {6 2 translate y*200}
        torus {6 2 translate y*300}
        torus {6 2 translate y*400}
        torus {6 2 translate y*500}
        torus {6 2 translate y*600}
        torus {6 2 translate y*700}
        torus {6 2 translate y*800}
        texture {T_Chrome_5E} 
        translate <0,0,730>
        }
union {
        cylinder {<0,0,0>,<0,980,0>,6 open}
        cylinder {<0,30,0>,<0,6,30>,6 open} 
        torus {6 2 translate y*100}
        torus {6 2 translate y*200}
        torus {6 2 translate y*300}
        torus {6 2 translate y*400}
        torus {6 2 translate y*500}
        torus {6 2 translate y*600}
        torus {6 2 translate y*700}
        torus {6 2 translate y*800}
        texture {T_Chrome_5E} 
        translate <930,0,900>
        }

