//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 8 textures and 127 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/06/1998    (06.04.1998)
//



/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.678> }

camera {  //  Camera StdCam
  location  <0.000, 1.799, 4.500>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 1.800, 0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light4
  <1.249, 2.806, 0.653>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light003
  <-1.400, 2.806, 0.653>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light002
  <-0.045, 1.743, 0.804>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light001
  <-0.038, 0.662, 0.729>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "garfield.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//









#declare Bubble__colors_ = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  12  // control points
  <0.097152, 1.075377>,
  <-1.686767, 0.941374>,
  <-1.628141, -0.020101>,
  <0.334807, -0.096683>,
  <0.61966, -0.538101>,
  <0.455611, -0.991625>,
  <1.033424, -0.219687>,
  <1.184255, 0.438861>,
  <0.947647, 0.998693>,
  <0.097152, 1.075377>,
  <-1.686767, 0.941374>,
  <-1.628141, -0.020101>
  rotate -x*90
  texture {
    Bubble__white_
  }
  scale <0.98, 0.588, 0.01>
  translate  <1.032929, 2.588398, 0.01>
}
#declare Bubble__lines_ = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  12  // control points
  <0.097152, 1.075377>,
  <-1.686767, 0.941374>,
  <-1.628141, -0.020101>,
  <0.334807, -0.096683>,
  <0.586159, -0.554851>,
  <0.413735, -1.008375>,
  <1.033424, -0.219687>,
  <1.184255, 0.438861>,
  <0.947647, 0.998693>,
  <0.097152, 1.075377>,
  <-1.686767, 0.941374>,
  <-1.628141, -0.020101>
  rotate -x*90
  texture {
    Lines__black_
  }
  scale <1.0, 0.6, 0.005>
  translate  <1.032929, 2.588398, 0.0>
}
union { // Bubble
  object { Bubble__colors_ }
  object { Bubble__lines_ }
  text {   // MIRAUUR
    ttf      "C:\WINDOWS\Fonts\ozhandin.ttf",
    "MIRAUUR",
    1.0,  // Depth
    <0.08,     0.0, 0.0> // Offset
    texture {
      Lines__black_
    }
    no_shadow
    scale <0.7, 0.6, 0.01>
    translate  <-0.322728, 2.647679, 0.1>
  }

  no_shadow
  translate  <-0.729153, 0.017361, 0.0>
}


union { // Moon
  disc { // Moon__color_
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Moon__yellow_
    }
    scale 0.98
    translate  <-0.094086, 0.866535, 0.01>
  }
  disc { // Moon__Lines_
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black_
    }
    translate  <-0.094086, 0.866535, 0.0>
  }
  no_shadow
  translate  -0.2*z
}


#declare Fence__color_ = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  73  // control points
  <-1.0, -1.0>,
  <0.559548, -1.0>,
  <2.465662, -1.0>,
  <2.460861, 0.919062>,
  <2.192204, 0.917468>,
  <2.175249, 0.734404>,
  <2.174441, 0.917296>,
  <2.08876, 0.916854>,
  <2.083399, 0.809765>,
  <2.077016, 0.919431>,
  <2.006215, 0.916344>,
  <1.934467, -0.95087>,
  <1.980185, 0.531394>,
  <1.898142, 0.543306>,
  <1.872001, 0.256332>,
  <1.870794, 0.548912>,
  <1.779099, 0.560591>,
  <1.734178, -0.890367>,
  <1.766695, 0.885917>,
  <1.680286, 0.882424>,
  <1.679278, 0.761753>,
  <1.664845, 0.891689>,
  <1.591749, 0.891294>,
  <1.575126, 0.85811>,
  <1.56208, 0.892206>,
  <1.474387, 0.894901>,
  <1.450557, 0.670168>,
  <1.465329, 0.898686>,
  <1.385652, 0.897628>,
  <1.342198, -0.812418>,
  <1.370412, 0.863463>,
  <1.226548, 0.862458>,
  <1.209606, 0.718712>,
  <1.195068, 0.856588>,
  <0.974502, 0.860697>,
  <0.95852, -0.988526>,
  <0.94163, -0.980081>,
  <0.960799, 0.932858>,
  <0.810513, 0.933571>,
  <0.801393, 0.677456>,
  <0.798067, 0.933697>,
  <0.559396, 0.934762>,
  <0.545701, 0.819463>,
  <0.546642, 0.937758>,
  <0.455635, 0.935255>,
  <0.447901, -0.963697>,
  <0.445798, 0.915175>,
  <0.330423, 0.90801>,
  <0.317604, 0.693268>,
  <0.32025, 0.906329>,
  <0.28084, 0.906329>,
  <0.279088, 0.722367>,
  <0.269949, 0.904254>,
  <0.152716, 0.896974>,
  <0.120419, -0.977309>,
  <0.121446, 0.56974>,
  <-0.17995, 0.546192>,
  <-0.181832, 0.215672>,
  <-0.198629, 0.546633>,
  <-0.379518, 0.533523>,
  <-0.390779, -0.989429>,
  <-0.397465, 0.985925>,
  <-0.436823, 0.98311>,
  <-0.43962, 0.867692>,
  <-0.443696, 0.985925>,
  <-0.508648, 0.985925>,
  <-0.520961, 0.746644>,
  <-0.524871, 0.985925>,
  <-0.87376, 0.985925>,
  <-0.892457, 0.619966>,
  <-0.889914, 0.985925>,
  <-1.0, 0.985925>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Fence__brown_
  }
  scale <1.0, 1.0, 0.001>
  translate  0.01*z
}
#declare Fence_Lines = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  19  // control points
  <-1.0, -1.0>,
  <2.465662, -1.0>,
  <2.469306, 0.944397>,
  <1.983695, 0.941679>,
  <1.971063, 0.555193>,
  <1.790479, 0.579099>,
  <1.782066, 0.920205>,
  <1.360316, 0.920148>,
  <1.364782, 0.874724>,
  <0.985762, 0.880402>,
  <0.974874, 0.949749>,
  <0.44719, 0.94933>,
  <0.434537, 0.92925>,
  <0.133011, 0.916679>,
  <0.120419, 0.596315>,
  <-0.368258, 0.564489>,
  <-0.379785, 0.996678>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Lines__black_
  }
  scale <1.0, 1.0, 0.01>
}
union { // Fence
  object { Fence__color_ }
  object { Fence_Lines }
  no_shadow
  scale <1.25, 1.0, 1.0>
  translate  <-0.877463, -0.334115, 0.0>
}


#declare Nose = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.789272, 0.617487>,
  <1.023884, 0.589083>,
  <1.150093, 0.412932>,
  <1.317662, 0.593737>,
  <1.521599, 0.624238>,
  <1.425626, 0.76757>,
  <1.138393, 0.834698>,
  <0.867934, 0.756523>,
  <0.789272, 0.617487>,
  <1.023884, 0.589083>,
  <1.150093, 0.412932>
  rotate -x*90
  texture {
    Nose__pink_
  }
  no_shadow
  scale <0.95, 0.95, 0.0098>
  translate  <2.275367, 0.269976, 0.01>
}
#declare Lips = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  16  // control points
  <-1.260416, 0.287385>,
  <-0.954128, 0.163711>,
  <-0.706868, 0.20603>,
  <0.026413, 0.622164>,
  <0.248889, 0.619471>,
  <0.551978, 0.432731>,
  <1.025126, 0.130653>,
  <1.42923, 0.212491>,
  <1.574079, 0.759808>,
  <1.142379, 1.067002>,
  <0.119668, 0.826459>,
  <-0.685877, 1.20425>,
  <-1.276382, 1.025126>,
  <-1.260416, 0.287385>,
  <-0.954128, 0.163711>,
  <-0.706868, 0.20603>
  rotate -x*90
  texture {
    Lips__yellow_
  }
  no_shadow
  scale <1.0, 1.0, 0.01>
  translate  <3.21284, -0.005777, 0.0>
}
#declare Head = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  12  // control points
  <-1.556873, 0.134294>,
  <-1.986411, -1.590243>,
  <-1.393635, -3.060302>,
  <0.095477, -3.152429>,
  <0.82835, -2.953487>,
  <0.865997, 0.840871>,
  <0.540503, 1.460637>,
  <-0.575879, 1.435511>,
  <-1.0, 1.0>,
  <-1.556873, 0.134294>,
  <-1.986411, -1.590243>,
  <-1.393635, -3.060302>
  rotate -x*90
  texture {
    Fur__orange_
  }
  no_shadow
  scale <1.0, 1.0, 0.01>
  translate  <3.342031, -0.807544, -0.02>
}
#declare Torso = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  26  // control points
  <-2.12879, 1.807998>,
  <-1.681677, 2.27948>,
  <-1.393635, 3.060302>,
  <0.095477, 3.152429>,
  <0.82835, 2.953487>,
  <1.976484, 1.330704>,
  <1.636516, -0.631491>,
  <1.409387, -0.98243>,
  <1.099282, -1.165758>,
  <0.772607, -1.355171>,
  <0.540503, -1.460637>,
  <0.028167, -1.507727>,
  <-0.256096, -1.550558>,
  <-0.492127, -1.628141>,
  <-0.618606, -1.735493>,
  <-0.871027, -1.731653>,
  <-0.984357, -1.649486>,
  <-1.250106, -1.625718>,
  <-1.918137, -1.569669>,
  <-2.691792, -1.519263>,
  <-2.64405, -1.175383>,
  <-2.705627, -0.793641>,
  <-2.957491, 0.636257>,
  <-2.12879, 1.807998>,
  <-1.681677, 2.27948>,
  <-1.393635, 3.060302>
  rotate -x*90
  texture {
    Fur__orange_
  }
  scale <1.0, 1.0, 0.01>
  translate  <3.431635, -6.833458, -0.02>
}
#declare Mouth = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.677476, 0.19292>,
  <-0.889259, -1.28036>,
  <-0.757119, -2.348409>,
  <-0.47621, -2.652613>,
  <-0.281407, -2.633166>,
  <0.474305, -2.442639>,
  <0.25657, -1.970504>,
  <0.267596, -0.046719>,
  <0.564489, 1.268007>,
  <0.331122, 1.502513>,
  <-0.090117, 1.469012>,
  <-0.422111, 1.117253>,
  <-0.677476, 0.19292>,
  <-0.889259, -1.28036>,
  <-0.757119, -2.348409>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <1.0, 1.0, 0.01>
  translate  <3.184295, -0.860122, -0.01>
}
#declare Right_hand = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  35  // control points
  <-0.842546, 0.045226>,
  <-1.025126, -0.373534>,
  <-0.798995, -1.025126>,
  <0.924623, -0.991625>,
  <1.156268, -0.695279>,
  <1.042747, -0.520121>,
  <0.774273, -0.510931>,
  <0.710376, -0.644506>,
  <0.636951, -0.756933>,
  <0.025284, -0.480827>,
  <-0.687647, -0.60369>,
  <0.02165, -0.423135>,
  <0.611812, -0.679158>,
  <0.718433, -0.489007>,
  <0.909476, -0.456103>,
  <1.000491, -0.465417>,
  <1.025777, -0.36488>,
  <0.988263, -0.14632>,
  <0.777737, -0.05252>,
  <0.575906, -0.216198>,
  <0.654766, -0.065553>,
  <0.836416, 0.03905>,
  <0.843606, 0.215947>,
  <0.71616, 0.343944>,
  <0.570453, 0.326377>,
  <0.44065, 0.169418>,
  <0.322781, -0.012671>,
  <-0.108349, 0.025392>,
  <-0.211745, 0.231858>,
  <0.081977, 0.494359>,
  <-0.121363, 0.678836>,
  <-0.622504, 0.387324>,
  <-0.842546, 0.045226>,
  <-1.025126, -0.373534>,
  <-0.798995, -1.025126>
  rotate -x*90
  texture {
    Fur__orange_
  }
  scale <0.640796, 0.640796, 0.006408>
  translate  <6.205093, -3.091146, -0.02>
}
#declare Lines1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <0.61474, -1.058626>,
  <-1.284757, -0.916248>,
  <-1.205193, -0.623451>,
  <-1.053601, -0.395913>,
  <-1.01675, 0.078727>,
  <-0.466164, -0.31742>,
  <0.505863, -0.499162>,
  <0.61474, -1.058626>
  rotate -x*90
  texture {
    Lines__black__1
  }
  scale <0.640796, 0.640796, 0.006408>
  rotate 25.979584*z
  translate  <0.028185, -4.237568, -0.03>
}
#declare Left_hand = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  35  // control points
  <0.842546, 0.045226>,
  <1.025126, -0.373534>,
  <0.798995, -1.025126>,
  <-0.924623, -0.991625>,
  <-1.156268, -0.695279>,
  <-1.042747, -0.520121>,
  <-0.774273, -0.510931>,
  <-0.710376, -0.644506>,
  <-0.636951, -0.756933>,
  <-0.025284, -0.480827>,
  <0.687647, -0.60369>,
  <-0.02165, -0.423135>,
  <-0.611812, -0.679158>,
  <-0.718433, -0.489007>,
  <-0.909476, -0.456103>,
  <-1.000491, -0.465417>,
  <-1.025777, -0.36488>,
  <-0.988263, -0.14632>,
  <-0.777737, -0.05252>,
  <-0.575906, -0.216198>,
  <-0.654766, -0.065553>,
  <-0.836416, 0.03905>,
  <-0.843606, 0.215947>,
  <-0.71616, 0.343944>,
  <-0.570453, 0.326377>,
  <-0.44065, 0.169418>,
  <-0.322781, -0.012671>,
  <0.108349, 0.025392>,
  <0.211745, 0.231858>,
  <-0.081977, 0.494359>,
  <0.121363, 0.678836>,
  <0.622504, 0.387324>,
  <0.842546, 0.045226>,
  <1.025126, -0.373534>,
  <0.798995, -1.025126>
  rotate -x*90
  texture {
    Fur__orange_
  }
  scale <0.640796, 0.640796, 0.006408>
  rotate 23.538982*z
  translate  <-0.047943, -4.411368, -0.02>
}
#declare Lines2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.61474, -1.058626>,
  <1.284757, -0.916248>,
  <1.205193, -0.623451>,
  <1.053601, -0.395913>,
  <1.01675, 0.078727>,
  <0.466164, -0.31742>,
  <-0.505863, -0.499162>,
  <-0.61474, -1.058626>
  rotate -x*90
  texture {
    Lines__black__1
  }
  scale <0.640796, 0.640796, 0.006408>
  rotate -2.322747*z
  translate  <6.076717, -2.965955, -0.03>
}
#declare TraSwp30 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp31 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp32 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp33 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp34 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M3 = union {
  object { TraSwp30 }
  object { TraSwp31 }
  object { TraSwp32 }
  object { TraSwp33 }
  object { TraSwp34 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.428858
  rotate -103.47818*z
  translate  <2.61966, -7.227858, -0.01>
}
#declare TraSwp25 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp26 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp27 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp28 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp29 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M4 = union {
  object { TraSwp25 }
  object { TraSwp26 }
  object { TraSwp27 }
  object { TraSwp28 }
  object { TraSwp29 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.358571
  rotate -29.518881*z
  translate  <2.180762, -6.070764, -0.01>
}
#declare TraSwp20 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp21 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.717902, 0.717902, 0.007179>
  rotate 10.450035*z
  translate  <0.075226, 0.05642, 0.0>
}
#declare TraSwp22 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.469056, 0.469056, 0.004691>
  rotate 1.03129*z
  translate  <-0.031344, 0.062689, 0.0>
}
#declare TraSwp23 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.328681, 0.328681, 0.003287>
  rotate 1.03129*z
  translate  <-0.075226, 0.025075, 0.0>
}
#declare TraSwp24 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.207448, 0.207448, 0.002074>
  rotate 1.03129*z
  translate  <-0.087764, 0.037613, 0.0>
}
#declare Stripes_3M3 = union {
  object { TraSwp20 }
  object { TraSwp21 }
  object { TraSwp22 }
  object { TraSwp23 }
  object { TraSwp24 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.569682
  rotate -62.198875*z
  translate  <2.426332, -6.650207, -0.01>
}
#declare TraSwp15 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp16 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp17 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp18 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp19 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M5 = union {
  object { TraSwp15 }
  object { TraSwp16 }
  object { TraSwp17 }
  object { TraSwp18 }
  object { TraSwp19 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.412717, 0.553188, 0.44014>
  rotate 107.328522*z
  translate  <1.362816, -7.227858, -0.01>
}
#declare TraSwp003 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp45 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.759314, 0.759314, 0.007593>
  rotate -10.668032*z
  translate  <-0.076006, 0.057005, 0.0>
}
#declare TraSwp46 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.548958, 0.548958, 0.00549>
  rotate -0.368428*z
  translate  <-0.050671, 0.08234, 0.0>
}
#declare TraSwp47 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.421469, 0.421469, 0.004215>
  rotate -0.368428*z
  translate  <-0.044337, 0.095008, 0.0>
}
#declare TraSwp48 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.24936, 0.24936, 0.002494>
  rotate -0.368428*z
  translate  <-0.025335, 0.16468, 0.0>
}
#declare Stripes_1M2 = union {
  object { TraSwp003 }
  object { TraSwp45 }
  object { TraSwp46 }
  object { TraSwp47 }
  object { TraSwp48 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.45541
  rotate 89.680916*z
  translate  <1.917071, -2.331561, -0.01>
}
#declare TraSwp49 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp50 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.717902, 0.717902, 0.007179>
  rotate 10.450035*z
  translate  <0.075226, 0.05642, 0.0>
}
#declare TraSwp51 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.469056, 0.469056, 0.004691>
  rotate 1.03129*z
  translate  <-0.031344, 0.062689, 0.0>
}
#declare TraSwp52 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.328681, 0.328681, 0.003287>
  rotate 1.03129*z
  translate  <-0.075226, 0.025075, 0.0>
}
#declare TraSwp53 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.207448, 0.207448, 0.002074>
  rotate 1.03129*z
  translate  <-0.087764, 0.037613, 0.0>
}
#declare Stripes_3M1 = union {
  object { TraSwp49 }
  object { TraSwp50 }
  object { TraSwp51 }
  object { TraSwp52 }
  object { TraSwp53 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.301872
  rotate 65.64473*z
  translate  <1.841478, -1.698394, -0.01>
}
#declare TraSwp54 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp55 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp56 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp57 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp58 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M1 = union {
  object { TraSwp54 }
  object { TraSwp55 }
  object { TraSwp56 }
  object { TraSwp57 }
  object { TraSwp58 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.300867, 0.403269, 0.320858>
  rotate 70.845261*z
  translate  <2.118897, -1.23815, -0.01>
}
#declare TraSwp59 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp60 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.759314, 0.759314, 0.007593>
  rotate -10.668032*z
  translate  <-0.076006, 0.057005, 0.0>
}
#declare TraSwp61 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.548958, 0.548958, 0.00549>
  rotate -0.368428*z
  translate  <-0.050671, 0.08234, 0.0>
}
#declare TraSwp62 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.421469, 0.421469, 0.004215>
  rotate -0.368428*z
  translate  <-0.044337, 0.095008, 0.0>
}
#declare TraSwp63 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.24936, 0.24936, 0.002494>
  rotate -0.368428*z
  translate  <-0.025335, 0.16468, 0.0>
}
#declare Stripes_1M1 = union {
  object { TraSwp59 }
  object { TraSwp60 }
  object { TraSwp61 }
  object { TraSwp62 }
  object { TraSwp63 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.292222
  rotate 53.092674*z
  translate  <2.264828, -0.494244, -0.01>
}
#declare TraSwp40 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp41 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.717902, 0.717902, 0.007179>
  rotate 10.450035*z
  translate  <0.075226, 0.05642, 0.0>
}
#declare TraSwp42 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.469056, 0.469056, 0.004691>
  rotate 1.03129*z
  translate  <-0.031344, 0.062689, 0.0>
}
#declare TraSwp43 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.328681, 0.328681, 0.003287>
  rotate 1.03129*z
  translate  <-0.075226, 0.025075, 0.0>
}
#declare TraSwp44 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.207448, 0.207448, 0.002074>
  rotate 1.03129*z
  translate  <-0.087764, 0.037613, 0.0>
}
#declare Stripes_3M2 = union {
  object { TraSwp40 }
  object { TraSwp41 }
  object { TraSwp42 }
  object { TraSwp43 }
  object { TraSwp44 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.386246
  rotate 108.747719*z
  translate  <1.986377, -3.014075, -0.01>
}
#declare TraSwp35 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp36 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp37 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp38 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp39 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M2 = union {
  object { TraSwp35 }
  object { TraSwp36 }
  object { TraSwp37 }
  object { TraSwp38 }
  object { TraSwp39 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.300867, 0.403269, 0.320858>
  rotate 135.067581*z
  translate  <2.240612, -3.417428, -0.01>
}
#declare TraSwp002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp11 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.717902, 0.717902, 0.007179>
  rotate 10.450035*z
  translate  <0.075226, 0.05642, 0.0>
}
#declare TraSwp12 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.469056, 0.469056, 0.004691>
  rotate 1.03129*z
  translate  <-0.031344, 0.062689, 0.0>
}
#declare TraSwp13 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.328681, 0.328681, 0.003287>
  rotate 1.03129*z
  translate  <-0.075226, 0.025075, 0.0>
}
#declare TraSwp14 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>,
  <0.003141, 1.039573>,
  <0.907873, 0.901173>,
  <1.0, 1.0>,
  <-0.011516, 1.221734>,
  <-1.0, 1.0>,
  <-0.991625, 0.901173>
  rotate -x*90
  scale <0.207448, 0.207448, 0.002074>
  rotate 1.03129*z
  translate  <-0.087764, 0.037613, 0.0>
}
#declare Stripes_3M4 = union {
  object { TraSwp002 }
  object { TraSwp11 }
  object { TraSwp12 }
  object { TraSwp13 }
  object { TraSwp14 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.569682
  rotate 45.902668*z
  translate  <1.347981, -6.046459, -0.01>
}
#declare TraSwp6 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp7 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp8 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp9 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp10 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M7 = union {
  object { TraSwp6 }
  object { TraSwp7 }
  object { TraSwp8 }
  object { TraSwp9 }
  object { TraSwp10 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.525084
  rotate 89.715599*z
  translate  <1.142842, -6.615707, -0.01>
}
#declare TraSwp001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp3 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp4 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M6 = union {
  object { TraSwp001 }
  object { TraSwp2 }
  object { TraSwp3 }
  object { TraSwp4 }
  object { TraSwp5 }
  texture {
    Lines__black__1
  }
  no_shadow
  scale 0.405723
  rotate 48.110092*z
  translate  <1.739255, -5.305288, -0.01>
}
#declare Dots = union {
  disc { // Dot_6
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    scale -0.040358
    translate  <4.662062, 0.822188, 0.01>
  }
  disc { // Dot_4
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    scale -0.040358
    translate  <4.701804, 0.716209, 0.01>
  }
  disc { // Dot_5
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    scale -0.040358
    translate  <4.542835, 0.848682, 0.01>
  }
  disc { // Dot_3
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    scale -0.040358
    translate  <2.443126, 1.001027, 0.01>
  }
  disc { // Dot_2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    scale -0.040358
    translate  <2.277533, 0.948038, 0.01>
  }
  disc { // Dot_1
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Lines__black__1
    }
    no_shadow
    scale -0.040358
    translate  <2.118565, 0.828811, 0.01>
  }
  translate  <-0.092001, -0.0, 0.0>
}
#declare Toe4 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <0.991625, 1.393635>,
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.654788, 0.654788, 0.006548>
  rotate -69.24852*z
  translate  <1.830247, -7.87206, -0.01>
}
#declare Toe5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <0.991625, 1.393635>,
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.654788, 0.654788, 0.006548>
  rotate -24.405819*z
  translate  <2.025333, -8.535352, -0.01>
}
#declare Toe_5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <0.991625, 1.393635>,
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.758093, 0.758093, 0.007581>
  translate  <2.267239, -8.878703, 0.0>
}
#declare Left_Foot = union {
  object { Toe4 }
  object { Toe5 }
  object { Toe_5 }
  translate  <-0.092001, -0.0, 0.0>
}
#declare TraSwp005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  20  // control points
  <0.080518, 0.84391>,
  <0.356594, 0.643495>,
  <0.410939, 0.628162>,
  <0.462888, 0.605644>,
  <0.527457, 0.586383>,
  <0.60052, 0.572953>,
  <0.651457, 0.575464>,
  <0.729974, 0.582522>,
  <0.891122, 0.59129>,
  <1.027219, 0.647404>,
  <1.079564, 0.737018>,
  <1.090243, 0.897571>,
  <1.0, 1.0>,
  <0.927867, 1.083001>,
  <0.808887, 1.102922>,
  <0.741136, 1.102594>,
  <0.664079, 1.132257>,
  <0.420248, 1.102811>,
  <0.314908, 0.949749>,
  <0.080518, 0.84391>
  rotate -x*90
  texture {
    Fur__orange_
  }
  scale <1.0, 1.0, 0.01>
  translate  <4.282119, -8.900465, -0.02>
}
#declare Toe1 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <1.290272, 1.371421>,
  <1.50204, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <1.059045, 1.403144>,
  <0.924452, 1.233004>,
  <1.076046, 1.372842>,
  <1.290272, 1.371421>,
  <1.50204, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.775323, 0.775323, 0.007753>
  rotate -44.382984*z
  translate  <3.83573, -7.989111, -0.01>
}
#declare Toe2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <0.991625, 1.393635>,
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.775323, 0.775323, 0.007753>
  rotate -44.382984*z
  translate  <3.617234, -7.957898, -0.01>
}
#declare Toe3 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>,
  <1.326633, 0.700168>,
  <1.584896, 0.974151>,
  <1.551298, 1.288107>,
  <1.305898, 1.40394>,
  <0.991625, 1.393635>,
  <1.290272, 1.371421>,
  <1.487437, 1.259631>,
  <1.537688, 0.984925>
  rotate -x*90
  texture {
    Lines__black__1
  }
  no_shadow
  scale <0.654788, 0.654788, 0.006548>
  rotate -80.716873*z
  translate  <3.874747, -7.34923, -0.01>
}
#declare Right_Foot = union {
  object { TraSwp005 }
  object { Toe1 }
  object { Toe2 }
  object { Toe3 }
  translate  <-0.099114, 0.014225, 0.0>
}
#declare TraSwp68 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.151043, 0.237677, 0.000171>
  rotate 17.665129*z
  translate  <5.073146, 0.721504, 0.0>
}
#declare TraSwp67 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.110991, 0.174091, 0.000093>
  rotate 23.867865*z
  translate  <4.962237, 0.844191, 0.0>
}
#declare TraSwp66 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.108412, 0.226123, 0.000114>
  rotate 43.532677*z
  translate  <4.924751, 0.945983, 0.0>
}
#declare TraSwp65 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.121647, 0.196618, 0.000114>
  rotate -45.97934*z
  translate  <1.773341, 1.200677, 0.0>
}
#declare TraSwp64 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.163367, 0.234374, 0.000153>
  rotate -17.119278*z
  translate  <1.641306, 1.020019, 0.0>
}
#declare TraSwp004 = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  8  // control points
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>,
  <-0.357504, 1.116397>,
  <2.247906, 0.850921>,
  <2.214405, 0.924623>,
  <0.155913, 1.164623>,
  <-1.335008, 1.100503>,
  <-1.326633, 1.026801>
  rotate -x*90
  scale <0.165509, 0.258233, 0.000153>
  translate  <1.651201, 0.837969, 0.0>
}
#declare Hair = union {
  object { TraSwp68 }
  object { TraSwp67 }
  object { TraSwp66 }
  object { TraSwp65 }
  object { TraSwp64 }
  object { TraSwp004 }
  texture {
    Lines__black__1
  }
  no_shadow
  translate  <-0.092001, -0.0, -0.01>
}
union { // Garfield
  object { Nose }
  object { Lips }
  object { Head }
  object { Torso }
  object { Mouth }
  object { Right_hand }
  object { Lines1 }
  box { // right_arm
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Fur__orange_
    }
    no_shadow
    scale <0.2, 0.8, 0.01>
    rotate -72.840073*z
    translate  <4.913162, -3.821129, -0.02>
  }
  box { // Left_arm
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Fur__orange_
    }
    scale <0.2, 0.8, 0.01>
    rotate -72.840073*z
    translate  <1.263968, -4.429328, -0.02>
  }
  object { Left_hand }
  object { Lines2 }
  object { Stripes_2M3 }
  object { Stripes_2M4 }
  object { Stripes_3M3 }
  object { Stripes_2M5 }
  object { Stripes_1M2 }
  object { Stripes_3M1 }
  object { Stripes_2M1 }
  object { Stripes_1M1 }
  object { Stripes_3M2 }
  object { Stripes_2M2 }
  object { Stripes_3M4 }
  object { Stripes_2M7 }
  object { Stripes_2M6 }
  object { Dots }
  object { Left_Foot }
  object { Right_Foot }
  object { Hair }
  no_shadow
  scale 0.19
  translate  <-0.572994, 2.19234, 0.03>
}


#declare TraSwp84 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp85 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp86 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp87 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp88 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M9 = union {
  object { TraSwp84 }
  object { TraSwp85 }
  object { TraSwp86 }
  object { TraSwp87 }
  object { TraSwp88 }
  texture {
    Lines__black_
  }
  scale <0.198966, 0.266686, 0.212186>
  rotate -15.007757*z
  translate  <-0.479223, -8.183221, 0.01>
}
#declare TraSwp79 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp80 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.557771, 0.557771, 0.005578>
  translate  <-0.05054, 0.334831, 0.0>
}
#declare TraSwp81 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.406149, 0.406149, 0.004061>
  translate  <-0.05054, 0.385371, 0.0>
}
#declare TraSwp82 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.235575, 0.235575, 0.002356>
  translate  <-0.075811, 0.499087, 0.0>
}
#declare TraSwp83 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>,
  <-0.02879, 1.047425>,
  <0.974874, 0.917923>,
  <1.0, 1.0>,
  <-0.000523, 1.259946>,
  <-1.0, 1.0>,
  <-0.966499, 0.917923>
  rotate -x*90
  scale <0.096589, 0.096589, 0.000966>
  translate  <-0.094763, 0.593851, 0.0>
}
#declare Stripes_2M8 = union {
  object { TraSwp79 }
  object { TraSwp80 }
  object { TraSwp81 }
  object { TraSwp82 }
  object { TraSwp83 }
  texture {
    Lines__black_
  }
  scale <0.198966, 0.266686, 0.212186>
  rotate -8.585279*z
  translate  <0.014069, -8.351814, 0.01>
}
#declare TraSwp74 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp75 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.759314, 0.759314, 0.007593>
  rotate -10.668032*z
  translate  <-0.076006, 0.057005, 0.0>
}
#declare TraSwp76 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.548958, 0.548958, 0.00549>
  rotate -0.368428*z
  translate  <-0.050671, 0.08234, 0.0>
}
#declare TraSwp77 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.421469, 0.421469, 0.004215>
  rotate -0.368428*z
  translate  <-0.044337, 0.095008, 0.0>
}
#declare TraSwp78 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.24936, 0.24936, 0.002494>
  rotate -0.368428*z
  translate  <-0.025335, 0.16468, 0.0>
}
#declare Stripes_1M4 = union {
  object { TraSwp74 }
  object { TraSwp75 }
  object { TraSwp76 }
  object { TraSwp77 }
  object { TraSwp78 }
  texture {
    Lines__black_
  }
  scale 0.206968
  rotate 59.791901*z
  translate  <-0.8054, -8.132423, 0.01>
}
#declare TraSwp69 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <1.0, 1.0, 0.01>
}
#declare TraSwp70 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.759314, 0.759314, 0.007593>
  rotate -10.668032*z
  translate  <-0.076006, 0.057005, 0.0>
}
#declare TraSwp71 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.548958, 0.548958, 0.00549>
  rotate -0.368428*z
  translate  <-0.050671, 0.08234, 0.0>
}
#declare TraSwp72 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.421469, 0.421469, 0.004215>
  rotate -0.368428*z
  translate  <-0.044337, 0.095008, 0.0>
}
#declare TraSwp73 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>,
  <0.189231, 1.004445>,
  <0.949749, 0.917923>,
  <1.0, 1.0>,
  <0.225667, 1.171534>,
  <-1.0, 1.0>,
  <-1.0, 0.901173>
  rotate -x*90
  scale <0.24936, 0.24936, 0.002494>
  rotate -0.368428*z
  translate  <-0.025335, 0.16468, 0.0>
}
#declare Stripes_1M3 = union {
  object { TraSwp69 }
  object { TraSwp70 }
  object { TraSwp71 }
  object { TraSwp72 }
  object { TraSwp73 }
  texture {
    Lines__black_
  }
  scale 0.168856
  rotate 14.673994*z
  translate  <0.661987, -8.176133, 0.01>
}
#declare TraSwp006 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  10  // control points
  <0.489112, 0.589615>,
  <-1.0, 1.0>,
  <-1.40201, -0.187605>,
  <1.01675, -0.087102>,
  <2.126434, 0.189213>,
  <1.839767, 0.79692>,
  <1.296578, 0.613315>,
  <0.489112, 0.589615>,
  <-1.0, 1.0>,
  <-1.40201, -0.187605>
  rotate -x*90
  texture {
    Fur__orange_
  }
  scale <0.594599, 0.594599, 0.005946>
  translate  <-0.216339, -8.356958, 0.0>
}
union { // Tail
  object { Stripes_2M9 }
  object { Stripes_2M8 }
  object { Stripes_1M4 }
  object { Stripes_1M3 }
  object { TraSwp006 }
  no_shadow
  scale 0.19
  rotate 22.878386*z
  translate  <-1.162429, 2.048606, -0.02>
}


