
///////////////////////////////////////////////////////////
// Persistence of Vision Ray Tracer Scene Description File
// File : nightafh.pov
// Vers : 3
// Desc : IRTC Competition entry
// Date : 12th April 1998
// Auth : Andrew James Johnson
// Email: andy@sharry.demon.co.uk
// WWW  : http://www.sharry.demon.co.uk
///////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////
//INCLUDES
///////////////////////////////////////////////////////////
#include "colors.inc"
#include "textures.inc"
#include "STONES.INC"
#include "METALS.INC"
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// Camera and Lights
///////////////////////////////////////////////////////////
camera
{
  //panoramic
  location  <0.0 , 140.0 ,-50>
  look_at   <0.0 , 80.0 , 5000.0>
}

//light_source
//{
//  0*x
//  color Yellow//White//*0.25
//  spotlight
//  translate <-6000, 380, 2500>  //-1000>
//  point_at <-00.0 , 80.0 , 1450>
//  radius 290
//  tightness 10
//  falloff 2
//}

/*
light_source
{
  0*x
  color White*0.25
  spotlight
  translate <-3000, 800, -2000>  //-1000>
  point_at <-500, 0.0 , 1000> //2500>
  radius 50000 //1290
  tightness 0
  falloff 8
}
*/

light_source
{
  0*x
  color White*0.25
  spotlight
  translate <-3000, 400, -2000>  //-1000>
  point_at <-500, 0.0 , 1000> //2500>
  radius 290
  tightness 0
  falloff 8
}

///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// Atmospherics
///////////////////////////////////////////////////////////

fog
{
  fog_type   2
  distance   2500
  color      Gray
  fog_offset 100
  fog_alt    105//120
  turbulence 8
}

/*
#declare ISOTROPIC_SCATTERING         = 1
#declare MIE_HAZY_SCATTERING          = 2
#declare MIE_MURKY_SCATTERING         = 3
#declare RAYLEIGH_SCATTERING          = 4
#declare HENYEY_GREENSTEIN_SCATTERING = 5
atmosphere
{
  type ISOTROPIC_SCATTERING
  samples 30//20
  distance 20
  scattering 0.9
  aa_level 6
  aa_threshold 0.2
  jitter 0.5
  color rgbft <1.00,1.00,0.9,.4,.8>
}
*/
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
// The Ocean/Water
///////////////////////////////////////////////////////////
plane { y, 5.0
   texture {
      T_Chrome_2D
      normal {
         dents 0.45
         frequency 15//25
         scale 3//scale 5
      }
   }
}

///////////////////////////////////////////////////////////
// The Land
///////////////////////////////////////////////////////////
//BACKGROUND
height_field {
  gif "night.ghf"
  texture {T_Stone18a scale 0.25 finish {Glossy} }
  scale <5750,350,950>
  smooth
  translate <-2250,-30,3000>
}


//LEFT SIDE
height_field {
  gif "night1.ghf"
  texture {T_Stone18a scale 0.25 finish {Glossy} }
  scale <1750,250,5640>
  smooth
  translate <-2200,-30,-10>
}
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
//  The Sky
///////////////////////////////////////////////////////////

//---------------------------------
// The Background Galaxy (Purple and Green)
// & Starfield
//---------------------------------

//#declare  galaxy_intensity = 0.3
#declare galaxy_nebula_ambient = <0.25,0.25,0.25>
#declare galaxy_seed = 1451962.1451962
#declare galaxy_scale = 9
#declare galaxy_objects = true
#include "galaxy.inc"


//---------------------------------
// Yellow and Green Nebula, front and center
//---------------------------------
#declare galaxy_colour1 = <1.3, 1.2, .8>
#declare galaxy_colour2 = <1, .5, .3>
#declare galaxy_colour3 = <1.6, 1.5, .3>
#declare galaxy_object_name = "Nebula4"
#declare galaxy_cluster_name = ""
#declare galaxy_object_scale = 1.5
//#declare galaxy_object_flatten = 0.75
#declare galaxy_object_position = <20,10,6000000>
#include "GALAXY.OBJ"

//---------------------------------
// Pinky/Purply Gas clouds on the horizon,
// left of center with a
// Blue Comet/Black Hole Emitter
//---------------------------------
#declare galaxy_colour1 = <1.0, 0.4, 0.6>
#declare galaxy_colour2 = <1, .5, 1.3>
#declare galaxy_colour3 = <0.6, 0.5, 1.0>
#declare galaxy_object_name = "Galaxy2"
#declare galaxy_cluster_name = ""
#declare galaxy_object_scale = 1.5
#declare galaxy_object_position = <-0,-10,6000000>
#include "GALAXY.OBJ"

#declare galaxy_colour1 = <0, 0.5, 1.3>
#declare galaxy_colour2 = <0.6, 0.5, 0.7>
#declare galaxy_colour3 = <0.3, 0.2, 0.8>
#declare galaxy_object_name = "Comet1"
#declare galaxy_cluster_name = ""
#declare galaxy_object_scale = 6.5
#declare galaxy_object_flatten = 20.75
#declare galaxy_object_rotate = 45
#declare galaxy_object_position = <0,-10,6000000>
#include "GALAXY.OBJ"

//---------------------------------
// Purple SpiralArm ????
//---------------------------------
#declare galaxy_colour1 = <0.9, 0.2, 0.8>
#declare galaxy_colour2 = <0, 0.5, 0.3>
#declare galaxy_colour3 = <0.6, 0.5, 0.3>
#declare galaxy_object_name = "Galaxy4"
#declare galaxy_cluster_name = ""
#declare galaxy_object_scale = 0.5
#declare galaxy_object_flatten = 0.75
#declare galaxy_object_position = <15,-25,6000000>
#include "GALAXY.OBJ"

//---------------------------------
//Blue SpiralArm ????
//---------------------------------
#declare galaxy_colour1 = <0.6, 0.5, 0.3>
#declare galaxy_colour2 = <0.9, 0.2, 0.8>
#declare galaxy_colour3 = <0, 0.5, 0.3>
#declare galaxy_object_name = "Nebula6"
#declare galaxy_cluster_name = ""
#declare galaxy_object_scale = 1.5
#declare galaxy_object_position = <15,-25,6000000>
#include "GALAXY.OBJ"

///////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////
//THe Enterprise
///////////////////////////////////////////////////////////
#include "sship.inc"
object {
  ssEnterprise
  rotate <-35,45,-10>
  translate <-20,550,2300>
}//

