////////////////////////////
//CRYSTAL RIVER ////////////
//ASHLEY McGLONE////////////
//1st Qtr, 1998 ////////////
///////////////////////////////////////////////////////////////////////////////////////////
//Revelation 22:1-5
//Then he showed me the river of the water of life, bright as crystal,
//flowing from the throne of God and of the Lamb through the middle of the
//street of the city; also, on either side of the river, the tree of life with its twelve
//kinds of fruit, yielding its fruit each month; and the leaves of the tree were
//for the healing of the nations.  There shall no more be anything accursed, but
//the throne of God and of the Lamb shall be in it, and his servants shall worship
//him; they shall see his face, and his name shall be on their foreheads.  And night shall
//be no more; they need no light of lamp or sun, for the Lord God will be their light, and
//they shall reign for ever and ever.
///////////////////////////////////////////////////////////////////////////////////////////

  #include "colors.inc"
  #include "finish.inc"
  #include "textures.inc"
  #include "shapes.inc"
  #include "water.inc"

/*
//Down
camera {
     location < 6, 20, -25>
     look_at  < 3, 0, 0>
     }
*/

/*
//DownLeft
camera {
     location < -6.5, 0, -35>
     look_at  < 12, 2, 0>
     }
*/

/*
//Center
camera {
     location <-10,10,-30>
     look_at  <0,0,0>
     }
*/

//Seraphim
camera {
     location < 20, 4, -20>
     look_at  < 0, 0, 0>
     }

background { color SkyBlue }

light_source { <0, 20, -5> color White
              shadowless }


//GROUND///////////////////////////////////////////
//union{
difference {
plane { <0, 1, 0>, -1
    pigment { color BrightGold }
    finish { reflection .3 }
    }
cone { <0, 0, -70>, 12, <0, 0, .1>, 3.5
    pigment { color BrightGold }
    normal { wrinkles .5 scale .75 turbulence .25 }
    }
}
//cylinder { <7, -1.5, -50>, <3.55, -1.5, .1>, .5
//    pigment { color BrightGold }
//    normal { wrinkles .5 scale .75 turbulence .25 }
//    }
//}

//WATER///////////////////////////////////////////
plane
{ y, -1.25
  texture { WaterTexture }
  }

//RAINBOW//////////////////////////////////////////
  #declare r_violet1 = colour rgbf<1.0, 0.5, 1.0, 1.0>
  #declare r_violet2 = colour rgbf<1.0, 0.5, 1.0, 0.8>
  #declare r_indigo  = colour rgbf<0.5, 0.5, 1.0, 0.8>
  #declare r_blue    = colour rgbf<0.2, 0.2, 1.0, 0.8>
  #declare r_cyan    = colour rgbf<0.2, 1.0, 1.0, 0.8>
  #declare r_green   = colour rgbf<0.2, 1.0, 0.2, 0.8>
  #declare r_yellow  = colour rgbf<1.0, 1.0, 0.2, 0.8>
  #declare r_orange  = colour rgbf<1.0, 0.5, 0.2, 0.8>
  #declare r_red1    = colour rgbf<1.0, 0.2, 0.2, 0.8>
  #declare r_red2    = colour rgbf<1.0, 0.2, 0.2, 1.0>

  rainbow {
    angle 32.5
    width 10
    arc_angle 150
    falloff_angle 30
    distance 1.0e7
    direction <0, -0.2, 1>
    //jitter 0.01
    color_map { [0.00 DarkGreen transmit 0.5]
                [0.33 Green transmit 0.6]
                [0.66 Green transmit 0.6]
                [1.00 SpringGreen transmit 0.75]
                }
/*
    colour_map {
      [0.000  colour r_violet1 transmit 0.88]
      [0.100  colour r_violet2 transmit 0.86]
      [0.214  colour r_indigo  transmit 0.84]
      [0.328  colour r_blue    transmit 0.82]
      [0.442  colour r_cyan    transmit 0.80]
      [0.556  colour r_green   transmit 0.82]
      [0.670  colour r_yellow  transmit 0.84]
      [0.784  colour r_orange  transmit 0.86]
      [0.900  colour r_red1    transmit 0.88]
*/
  }

//THRONE///////////////////////////////////////////
#declare Throne=
merge {
difference {
box { <-3.5,-1,.1>, <3.5,6,7> } //chair box
box { <-3.6,2.25,-.1>, <3.6,6.1,5> } //cut out the arms
box { <-2,1.25,0>, <2,6.1,4.99> } //cut out the seat
box { <2.5,-1,4.99>, <3.6,6.1,7.1> } //cut out left chair back corner
box { <-2.5,-1,4.99>, <-3.6,6.1,7.1> } //cut out right chair back corner
}
cylinder { <0,6,5>, <0,6,7>, 2.5 }  //round back
torus { 2.5, 1
        rotate x*-90
        translate y*6
        translate z*6 }  //round back
cylinder { <2.75,2.25,0>, <2.75,2.25,5.1>, .75 }  //left chair arm
cylinder { <-2.75,2.25,0>, <-2.75,2.25,5.1>, .75 }  //right chair arm
cylinder { <-2.75,-1,0>, <-2.75,2.25,0>, .75 }  //right chair post
cylinder { <2.75,-1,0>, <2.75,2.25,0>, .75 }  //left chair post
sphere { <2.75,2.25,0>, .75 }  //left chair arm ball
sphere { <-2.75,2.25,0>, .75 }  //right chair arm ball
cylinder { <2.5,-1,6>, <2.5,6,6>, 1 }  //round back left corner
cylinder { <-2.5,-1,6>, <-2.5,6,6>, 1 }  //round back right corner
      //texture { White_Marble
      //          scale 7
      //          rotate z*90 }
      pigment { color Silver }
      //pigment { checker pigment{Orange}, pigment{Red} }
      finish { ambient .5 }
      //         reflection .1}
}

object { Throne }

//GOD/////////////////////////////////////////////////////
//#declare GOD=
merge {
sphere { <0,7.5,4>, 1 } //Head
cylinder { <0,6.75,4>, <0,7.5,4>, 1 }
sphere { <0,6.75,4>, 1 } //Head
sphere { <0,6.25,4>, .75 } //TopNeck
cylinder { <0,5.5,4>, <0,6.25,4>, .75 } //Neck

cylinder { <0,1.26,4>, <0,4.25,4>, 1.5 } //Torso
sphere { <0,4.25,4>, 1.5 } //TorsoTop
cylinder { <1.75,5,4>, <-1.75,5,4>, .65 } //Shoulders

sphere { <1.75,5,4>, .65 } //LeftShoulder
cylinder { <1.75,5,4>, <2.75,3.5,2>, .65 } //LeftTopArm
sphere { <2.75,3.5,2>, .65 } //LeftElbow
cone { <2.8,3.5,2>, .65, <2,3.5,-.25>, .55 } //LeftForeArm
sphere { <2,3.5,-.25>, .55 } //LeftWrist
sphere { <1.75,3.4,-.6>, .625 } //LeftHand

sphere { <-1.75,5,4>, .65 } //RightShoulder
cylinder { <-1.75,5,4>, <-2.75,3.5,2>, .65 } //RightTopArm
sphere { <-2.75,3.5,2>, .65 } //RightElbow
cone { <-2.8,3.5,2>, .65, <-2,3.5,-.25>, .55 } //RightForeArm
sphere { <-2,3.5,-.25>, .55 } //RightWrist
sphere { <-1.75,3.4,-.6>, .625 } //RightHand

cone { <.75,1.75,3>, .8, <1.25,1.75,-.5>, .7 } //LeftThigh
sphere { <1.25,1.75,-.5>, .7 } //LeftKnee
cone { <1.25,1.75,-.6>, .6, <1.25,-1.1,-.6>, .55 } //LeftCalf
sphere { <1.25,-1,-.6>, .55 } //LeftAnkle
cylinder { <1.25,-1.1,-.6>, <1.25,-1.1,-1.8>, .55 } //LeftFoot
sphere { <1.25,-1.1,-1.8>, .55 } //LeftToes

cone { <-.75,1.75,3>, .8, <-1.25,1.75,-.5>, .7 } //RightThigh
sphere { <-1.25,1.75,-.5>, .7 } //RightKnee
cone { <-1.25,1.75,-.6>, .6, <-1.25,-1,-.6>, .55 } //RightCalf
sphere { <-1.25,-1,-.6>, .55 } //RightAnkle
cylinder { <-1.25,-1.1,-.6>, <-1.25,-1.1,-1.8>, .55 } //RightFoot
sphere { <-1.25,-1.1,-1.8>, .55 } //RightToes

//texture { Ruby_Glass }
//finish { ambient .3 }
//pigment { color Yellow }
//pigment { color Firebrick }
//pigment { gradient y scale 9
//          color_map{[0.0 color Red][1.0 color Yellow] }
//          }
//finish { Mirror }
//hollow
//normal { dents .5 scale .2 }
//normal { bumps 1 scale .2 }
//normal { waves }
/*
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      planar_mapping
      cubic
      colour_map { [0 rgbt<1, 1, 1, .5>]
                   [1 rgbt<1, 1, 1, .5>] }
      //frequency .75
      scale 14
      samples 10
    }
    //finish { ambient .3 }
    hollow
*/
  pigment {
    marble
    turbulence 3
    lambda .15
    omega 1
    octaves 15
    frequency 2
    color_map {
      //[0.00 color DarkGreen]
      [0.00 color Red]
      [0.50 color Gold]
      [1.00 color Yellow]
              }
  rotate 45*z
  scale 25 }
  finish { ambient .9 }
    }


//SERAPHIM/////////////////////////////////////////////////
merge {
sphere { <10,8.5,2.2>, 1 } //TopHead
cylinder { <10,7.75,2.1>, <10,8.5,2.2>, 1 } //Face
sphere { <10,7.75,2.1>, 1 } //BottomHead
sphere { <10,7.25,2.1>, .75 } //TopNeck
cylinder { <10,6.5,2>, <10,7.25,2.1>, .75 } //Neck

sphere { <10,5.25,2>, 1.5 } //TorsoTop
cone { <10,2.26,2>, 1.35, <10,5.25,2>, 1.5 } //Torso
sphere { <10,2.26,2>, 1.35 } //TorsoBottom
cylinder { <11.75,6,2>, <8.25,6,2>, .65 } //Shoulders

sphere { <11.75,6,2>, .65 } //RightShoulder
cylinder { <11.75,6,2>, <12.75,7.5,4>, .65 } //RightTopArm
sphere { <12.75,7.5,4>, .65 } //RightElbow
cone { <12.8,7.5,4>, .65, <13.6,9,5>, .55 } //RightForeArm
sphere { <13.6,9,5>, .55 } //RightWrist
sphere { <13.85,9.5,5.35>, .625 } //RightHand

sphere { <8.25,6,2>, .65 } //LefttShoulder
cylinder { <8.25,6,2>, <7.25,7.5,4>, .65 } //LeftTopArm
sphere { <7.25,7.5,4>, .65 } //LeftElbow
cone { <7.2,7.5,4>, .65, <6.4,9,5>, .55 } //LeftForeArm
sphere { <6.4,9,5>, .55 } //LeftWrist
sphere { <6.15,9.5,5.35>, .625 } //LeftHand

sphere { <10.75,1.75,2>, .8 } //RightHip
cone { <10.75,1.75,2>, .8, <11.25,-.5,3>, .7 } //RightThigh
sphere { <11.25,-.5,3>, .7 } //RightKnee
cone { <11.25,-.5,3>, .6, <11.25,-.2,-.6>, .55 } //RightCalf
sphere { <11.25,-.2,-.6>, .55 } //RightAnkle
cylinder { <11.25,-.2,-.6>, <11.25,-.5,-1.8>, .55 } //RightFoot
sphere { <11.25,-.5,-1.8>, .55 } //RightToes

sphere { <9.25,1.75,2>, .8 } //LeftHip
cone { <9.25,1.75,2>, .8, <8.75,-.5,3>, .7 } //LeftThigh
sphere { <8.75,-.5,3>, .7 } //LeftKnee
cone { <8.75,-.5,3>, .6, <8.75,-.2,-.6>, .55 } //LeftCalf
sphere { <8.75,-.2,-.6>, .55 } //LeftAnkle
cylinder { <8.7,-.2,-.6>, <8.75,-.5,-1.8>, .55 } //LeftFoot
sphere { <8.75,-.5,-1.8>, .55 } //LeftToes

   pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      planar_mapping
      cubic
      turbulence 1.0
      color_map {
        [ 0.0 color rgbt <1, 1, 0, .75> ]
        [ 0.5 color rgbt <1, 0, 0, .8> ]
        [ 1.0 color rgbt <1, 1, 0, .75> ]
       }
      frequency 1
      samples 20
      scale 15
      translate <0,5,0>
    }
    halo {
      emitting
      planar_mapping
      cubic
      turbulence 1.0
      color_map {
        [ 0.0 color rgbt <1, 0, 0, .75> ]
        [ 0.5 color rgbt <1, 1, 0, .8> ]
        [ 1.0 color rgbt <1, 0, 0, .75> ]
       }
      frequency 3
      samples 20
      scale 7
      //rotate z*-90
      translate <0,0,-10>
    }
    normal { ripples }
    normal { bumps 1 scale 1 }
    finish { ambient .3 }
    scale .5
    hollow

//pigment { color Yellow }
translate <-2,-.5,-14>
rotate y*-24
}


/*
light_source { <0, 0, 0> color White
             looks_like { GOD }
              shadowless }
*/

/*
//------------------------------------------------------------------->
//PTD-TREE.INC
//Created by: Paul T. Dawson
//            ptdawson@voicenet.com
//            http://www.voicenet.com/~ptdawson
//
// Now set all of the variables for the tree. read "ptd_tree.txt" to
// find out what all these things do!

        #declare TREE_RAND = seed(0)
        #declare Wiggle_Flag = on
        #declare Branches_On_End_Flag = on

        #declare Number_Of_Large_Branches = 8
        #declare Number_Of_Medium_Branches = 8
        #declare Number_Of_Small_Branches = 8

        #declare Large_Branch_Minimum_Angle = 20
        #declare Large_Branch_Maximum_Angle = 80

        #declare Medium_Branch_Minimum_Angle = 20
        #declare Medium_Branch_Maximum_Angle = 80

        #declare Small_Branch_Minimum_Angle = 20
        #declare Small_Branch_Maximum_Angle = 80

        #declare Tree_Trunk_Size = 9

        #declare Large_Branch_Size_Min = 2
        #declare Large_Branch_Size_Max = 4

        #declare Medium_Branch_Size_Min = 2
        #declare Medium_Branch_Size_Max = 3

        #declare Small_Branch_Size_Min = 2
        #declare Small_Branch_Size_Max = 4

        #declare Leaf_Type = 5

        #declare TREE_MESH_SIZE = 200

//        #declare Leaf_Texture = texture { T_Stone18 scale 0.5 }
        #declare Leaf_Texture = texture { pigment { color Green } }
        #declare Bark_Texture = texture { T_Stone14
                normal { bumps 2.0 scale 0.1 } }

// Now go and build the tree, then show it.

        #include "ptd_tree.inc"

        #declare TREE_RAND = seed(7)
        object { Complete_Tree
                 //rotate y * 180
                 translate <-14,-1.5,-30>
                 scale .75 }

        #declare TREE_RAND = seed(3)
        #declare Branches_On_End_Flag = off
        object { Complete_Tree
                 rotate y * 180
                 translate <14,-1.5,-30>
                 scale .75 }
//------------------------------------------------------------------->
*/

//THE SEVEN SPIRITS OF GOD///////////////////////////////////////////
#declare FireBall=
merge {
       difference { sphere { <0,1,-2>, 1 }
                    box { <-1.1,2.1,-3.1>, <1.1,1.1,.9> }
                  }
       cone { <0,1,-2>, 1, <0,4,-2>, 0 }
       pigment { color rgbt <1, 1, 1, 1> }
           halo {
                 emitting
                 spherical_mapping
                 linear
                 turbulence .5
                 color_map {
                 [ 0.0 color rgbt <1, 0, 0, .9> ]
                 [ 0.5 color rgbt <1, 1, 0,-.3> ]
                 [ 1.0 color rgbt <1, 0, 0, .9> ]
                }
           frequency 7
           samples 20
           scale 7
           }
        hollow
        //scale 1.5
}
object { FireBall translate <-6,-.9,6> normal { dents .5 } }
object { FireBall translate < 6,-.9,6> normal { dents .5 } }
object { FireBall translate <-5,3.5,6> normal { dents .5 } }
object { FireBall translate < 5,3.5,6> normal { dents .5 } }
object { FireBall translate <-3.5,7.33,6> normal { dents .5 } }
object { FireBall translate < 3.5,7.33,6> normal { dents .5 } }
object { FireBall translate < 0,9.33,6> normal { dents .5 } }

//24 THRONES//////////////////////////////////////////////
#declare Yoffset=138
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Throne
         scale .75
         rotate <0,90,0>
         translate <36,-.25,0>
         rotate <0,RotY,0>
         pigment { color Yellow }
         }
#declare counter=counter-1
#end

#declare Yoffset=148
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Throne
         scale .75
         rotate <0,90,0>
         translate <64,-.25,0>
         rotate <0,RotY,0>
         pigment { color Yellow }
         }
#declare counter=counter-1
#end

//24 ELDERS///////////////////////////////////////////////////
#declare Elder=
merge {
merge {
sphere { <0,8.5,2.2>, 1 } //TopHead
cylinder { <0,7.75,2.1>, <0,8.5,2.2>, 1 } //Face
sphere { <0,7.75,2.1>, 1 } //BottomHead
sphere { <0,7.25,2.1>, .75 } //TopNeck
cylinder { <0,6.5,2>, <0,7.25,2.1>, .75 } //Neck

sphere { <0,5.25,2>, 1.65 } //TorsoTop
cone { <0,2.26,2>, 1.35, <0,5.25,2>, 1.65 } //Torso
sphere { <0,2.26,2>, 1.35 } //TorsoBottom
cylinder { <1.75,6,2>, <-1.75,6,2>, .65 } //Shoulders

sphere { <1.75,6,2>, .65 } //RightShoulder
cylinder { <1.75,6,2>, <2.75,7.5,4>, .65 } //RightTopArm
sphere { <2.75,7.5,4>, .65 } //RightElbow
cone { <2.8,7.5,4>, .65, <2.4,9,4.25>, .55 } //RightForeArm
sphere { <2.4,9,4.25>, .55 } //RightWrist
sphere { <2.2,9.5,4.5>, .625 } //RightHand

sphere { <-1.75,6,2>, .65 } //LefttShoulder
cylinder { <-1.75,6,2>, <-2.75,7.5,4>, .65 } //LeftTopArm
sphere { <-2.75,7.5,4>, .65 } //LeftElbow
cone { <-2.8,7.5,4>, .65, <-2.4,9,4.25>, .55 } //LeftForeArm
sphere { <-2.4,9,4.25>, .55 } //LeftWrist
sphere { <-2.2,9.5,4.5>, .625 } //LeftHand

rotate <90,0,0>
translate <0,4,0>
}

sphere { <0.75,1.75,2>, .8 } //RightHip
cone { <0.75,1.75,2>, .8, <1.25,-.5,3>, .7 } //RightThigh
sphere { <1.25,-.5,3>, .7 } //RightKnee
cone { <1.25,-.5,3>, .6, <1.25,-.2,-.6>, .55 } //RightCalf
sphere { <1.25,-.2,-.6>, .55 } //RightAnkle
cylinder { <1.25,-.2,-.6>, <1.25,-.5,-1.8>, .55 } //RightFoot
sphere { <1.25,-.5,-1.8>, .55 } //RightToes

sphere { <-0.75,1.75,2>, .8 } //LeftHip
cone { <-0.75,1.75,2>, .8, <-1.25,-.5,3>, .7 } //LeftThigh
sphere { <-1.25,-.5,3>, .7 } //LeftKnee
cone { <-1.25,-.5,3>, .6, <-1.25,-.2,-.6>, .55 } //LeftCalf
sphere { <-1.25,-.2,-.6>, .55 } //LeftAnkle
cylinder { <-1.3,-.2,-.6>, <-1.25,-.5,-1.8>, .55 } //LeftFoot
sphere { <-1.25,-.5,-1.8>, .55 } //LeftToes

pigment { color White }
finish { ambient .3 }
rotate y*180
translate <0,-.25,0>
//scale .75
}

#declare Yoffset=138
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Elder
         rotate <0,90,0>
         translate <32,0,0>
         rotate <0,RotY,0>
         }
#declare counter=counter-1
#end

#declare Yoffset=148
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Elder
         rotate <0,90,0>
         translate <60,0,0>
         rotate <0,RotY,0>
         }
#declare counter=counter-1
#end

//24 CROWNS DOWN///////////////////////////////////////////
/*
prism {
    linear_sweep
    linear_spline
    .1,  // sweep the following shape from here ...
    1,  // ... up through here
    13, // the number of points making up the shape ...

    <1,0>, <.8,.2>, <.8,.2>, <0,1>, <-.2,.8>, <-.8,.2>, <-1,0>, <-.8,-.2>, <-.2,-.8>, <0,-1>, <.2,-.8>, <.8,-.2>, <1,0>

    pigment { Green }
  }

difference {
blob { threshold 0.1
#declare counter=6
#while (counter>0)
#declare RotY = counter * (360/12) - (360/12/2)
cylinder { <0,1,1>, <0,1,-1>, .5, .5
           rotate y*RotY
         }
#declare counter=counter-1
#end

//sphere { <0,1,0>, .75, .75
//         scale <1.5,1,1.5>
//         }
}

cylinder { <0,.5,0>, <0,1.5,0>, .75 }
pigment { color Green }
}
*/

#declare Crown=
merge {
 intersection {
  union {
  #declare counter=6
  #while (counter>0)
  #declare RotY = counter * (360/12) - (360/12/2)
  box { <.22,.75,1>, <-.22,1.25,-1>
        rotate y*RotY
        }
  #declare counter=counter-1
  #end
  }
  sphere { <0,1,0>, 1
          scale <1,.75,1>
          translate <0,.125,0>
          }
  torus { 1, .375
          translate <0,1,0>
          }
 pigment { color Green }
 finish { ambient .3 }
 }
 #declare counter=12
 #while (counter>0)
 #declare RotY = counter * (360/12) - (360/12/2)
 sphere { <0,1,0>, .1
       translate <0,0,.95>
       rotate y*RotY
       pigment { color Red }
       finish { ambient .75 }
       }
 #declare counter=counter-1
 #end
//scale .75
}
#declare Yoffset=138
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Crown
         translate <21,-1.75,0>
         rotate <0,RotY,0>
         }
#declare counter=counter-1
#end

#declare Yoffset=148
#declare counter=12
#while (counter>0)
#declare RotY = counter * (240/12) + Yoffset
object { Crown
         translate <49,-1.75,0>
         rotate <0,RotY,0>
         }
#declare counter=counter-1
#end
