// EMAIL: nk80300@ltu.edu
// NAME: Nathan Kopp
// TOPIC: Night
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
// TITLE: Psalm 119:105
// COUNTRY: United States
// WEBPAGE: http://www.grfn.org/~nkopp/pov/gallery.html
// 
// See the file PS119105.TXT for more information.
//
// This file requires
//   _candle.pov, _candle.inc
//   _flashlight.pov, _flashlight.inc
//   _lamp.pov, _lamp.inc
//   placement.inc
//   _lamp_beam.inc
//
// Some of the objects in this scene (and the textures) have been changed
// since the scene was exported from moray.  The objects that were most
// changed are Page, Page1, and Page2.  Textures with "map_type 8" were
// put on these objects.
//
// map_type 8 is a feature of the IsoSurface version of Povray.  Go to
//      http://www.public.usit.net/rsuzuki/e/povray/iso/index.html
// to get your own copy of this unofficial version.
//



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 4    // Rayleigh
  distance     10.0
  color <0.8,0.8,1.0,0.0,0.498039>
  scattering   0.25
  samples      15
  jitter       0.1
  aa_threshold 1.0
  aa_level     3
}

camera {  //  Camera StdCam
  location  <6.051, -11.747, 2.367>
  direction <0.0,     0.0,  0.8597>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-1.078, 0.341, 5.667>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <2.793, -3.376, 0.941>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  1.0
  fade_power 1.0
  atmosphere off
}

light_source {   // Light1
  <-2.473, -0.046, 20.282>
  color rgb <0.451, 0.451, 0.722>
  fade_distance  5.0
  fade_power 2.0
  atmosphere off
}


//
// ********  TEXTURES  *******
//

#include "placement.inc"

//
// ********  OTHER FILES  *******
//


#include "_lamp.pov"
#include "_candle.pov"
#include "_flashlight.pov"
#include "_flash_beam.pov"

//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//



box { // Table
  <-1, -1, -1>, <1, 1, 1>
  scale <10.0, 20.0, 0.1>
  rotate -51.605507*z
  translate  -0.1*z
  texture {
    Parquet_Wood
  }
}

/*
sphere { // Sky
  <0,0,0>,1
  texture {
    Plasma
  }
  no_shadow
  hollow
  scale 100.0
}
*/



#declare Ribbon = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.337373, -14.913380, -1.702737>, <-0.168687, -14.913380, -1.702737>, <0.000000, -14.913380, -1.702737>, <0.168687, -14.913380, -1.702737>,
      <-0.337373, -11.651570, -0.838730>, <-0.168687, -11.651570, -0.838730>, <0.000000, -11.651570, -0.838730>, <0.168687, -11.651570, -0.838730>,
      <-0.355984, -13.985977, -0.325613>, <-0.247028, -13.985977, -0.112458>, <-0.138073, -13.985977, 0.100698>, <-0.029117, -13.985977, 0.313853>,
      <-0.286947, -12.459893, -0.375962>, <-0.177992, -12.459893, -0.162806>, <-0.069036, -12.459893, 0.050349>, <0.039919, -12.459893, 0.263504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.286947, -12.459893, -0.375962>, <-0.177992, -12.459893, -0.162806>, <-0.069036, -12.459893, 0.050349>, <0.039919, -12.459893, 0.263504>,
      <-0.217911, -10.933810, -0.426311>, <-0.108955, -10.933810, -0.213155>, <0.000000, -10.933810, 0.000000>, <0.108955, -10.933810, 0.213155>,
      <-0.217911, 7.320999, -0.426311>, <-0.108955, 7.320999, -0.213155>, <0.000000, 7.320999, 0.000000>, <0.108955, 7.320999, 0.213155>,
      <-0.003678, 9.727685, -0.582553>, <0.105278, 9.727685, -0.369398>, <0.214233, 9.727685, -0.156242>, <0.323188, 9.727685, 0.056913>
    }
  }
  texture {
    RibbonTex
  }
  scale <0.2, 0.25, 0.2>
  translate  <0.037239, 0.125974, 0.347944>
}
#declare BibleBinding = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.072330, -2.198943, 0.042041>, <-4.271018, -2.146051, 0.042041>, <-3.416814, -2.146051, 0.169391>, <-2.408126, -2.146051, 0.105716>,
      <-5.125222, -1.430701, 0.042041>, <-6.835255, -4.562789, 0.000000>, <-4.595395, -2.789470, 0.000000>, <-3.446546, -2.789470, 0.063675>,
      <-5.125222, -0.715350, 0.042041>, <-5.744244, -1.394735, 0.000000>, <-5.643307, -3.302041, 0.000000>, <-4.245703, -3.302041, 0.063675>,
      <-5.125222, 0.000000, 0.042041>, <-5.744244, 0.000000, 0.000000>, <-5.669753, 0.000000, 0.000000>, <-4.258926, 0.000000, 0.071133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.125222, 0.000000, 0.042041>, <-5.744244, 0.000000, 0.000000>, <-5.669753, 0.000000, 0.000000>, <-4.258926, 0.000000, 0.071133>,
      <-5.125222, 0.715350, 0.042041>, <-5.744244, 1.394735, 0.000000>, <-5.696199, 3.302041, 0.000000>, <-4.272149, 3.302041, 0.063675>,
      <-5.125222, 1.430701, 0.042041>, <-6.835255, 4.562789, 0.000000>, <-4.595395, 2.789470, 0.000000>, <-3.446546, 2.789470, 0.063675>,
      <-5.125222, 2.146051, 0.042041>, <-4.271018, 2.146051, 0.042041>, <-3.416814, 2.146051, 0.169391>, <-2.408126, 2.146051, 0.105716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.408126, -2.146051, 0.105716>, <-1.399437, -2.146051, 0.042041>, <-0.699719, -2.146051, 0.042041>, <0.000000, -2.146051, 0.042041>,
      <-3.446546, -2.789470, 0.063675>, <-2.297698, -2.789470, 0.127350>, <-0.941077, -2.789470, 0.000000>, <0.000000, -2.789470, 0.000000>,
      <-4.245703, -3.302041, 0.063675>, <-2.848099, -3.302041, 0.127350>, <-1.166507, -3.302041, 0.000000>, <0.000000, -3.302041, 0.000000>,
      <-4.258926, 0.000000, 0.071133>, <-2.848099, 0.000000, 0.127350>, <-1.166507, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.258926, 0.000000, 0.071133>, <-2.848099, 0.000000, 0.127350>, <-1.166507, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>,
      <-4.272149, 3.302041, 0.063675>, <-2.848099, 3.302041, 0.127350>, <-1.166507, 3.302041, 0.000000>, <0.000000, 3.302041, 0.000000>,
      <-3.446546, 2.789470, 0.063675>, <-2.297698, 2.789470, 0.127350>, <-0.941077, 2.789470, 0.000000>, <0.000000, 2.789470, 0.000000>,
      <-2.408126, 2.146051, 0.105716>, <-1.399437, 2.146051, 0.042041>, <-0.699719, 2.146051, 0.042041>, <0.000000, 2.146051, 0.042041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.146051, 0.042041>, <0.699719, -2.146051, 0.042041>, <1.399437, -2.146051, 0.042041>, <2.408126, -2.146051, 0.105716>,
      <0.000000, -2.789470, 0.000000>, <0.941077, -2.789470, 0.000000>, <2.297698, -2.789470, 0.127350>, <3.446546, -2.789470, 0.063675>,
      <0.000000, -3.302041, 0.000000>, <1.166507, -3.302041, 0.000000>, <2.848099, -3.302041, 0.127350>, <4.272149, -3.302041, 0.063675>,
      <0.000000, 0.000000, 0.000000>, <1.166507, 0.000000, 0.000000>, <2.848099, 0.000000, 0.127350>, <4.272149, 0.000000, 0.071133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <1.166507, 0.000000, 0.000000>, <2.848099, 0.000000, 0.127350>, <4.272149, 0.000000, 0.071133>,
      <0.000000, 3.302041, 0.000000>, <1.166507, 3.302041, 0.000000>, <2.848099, 3.302041, 0.127350>, <4.272149, 3.302041, 0.063675>,
      <0.000000, 2.789470, 0.000000>, <0.941077, 2.789470, 0.000000>, <2.297698, 2.789470, 0.127350>, <3.446546, 2.789470, 0.063675>,
      <0.000000, 2.146051, 0.042041>, <0.699719, 2.146051, 0.042041>, <1.399437, 2.146051, 0.042041>, <2.408126, 2.146051, 0.105716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.408126, -2.146051, 0.105716>, <3.416814, -2.146051, 0.169391>, <4.271018, -2.146051, 0.042041>, <5.125222, -2.146051, 0.042041>,
      <3.446546, -2.789470, 0.063675>, <4.595395, -2.789470, 0.000000>, <7.181674, -5.023160, 0.000000>, <5.125222, -1.430701, 0.042041>,
      <4.272149, -3.302041, 0.063675>, <5.696199, -3.302041, 0.000000>, <5.744244, -1.394735, 0.000000>, <5.125222, -0.715350, 0.042041>,
      <4.272149, 0.000000, 0.071133>, <5.696199, 0.000000, 0.000000>, <5.744244, 0.000000, 0.000000>, <5.125222, 0.000000, 0.042041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.272149, 0.000000, 0.071133>, <5.696199, 0.000000, 0.000000>, <5.744244, 0.000000, 0.000000>, <5.125222, 0.000000, 0.042041>,
      <4.272149, 3.302041, 0.063675>, <5.696199, 3.302041, 0.000000>, <5.744244, 1.394735, 0.000000>, <5.125222, 0.715350, 0.042041>,
      <3.446546, 2.789470, 0.063675>, <4.595395, 2.789470, 0.000000>, <7.181674, 5.023160, 0.000000>, <5.125222, 1.430701, 0.042041>,
      <2.408126, 2.146051, 0.105716>, <3.416814, 2.146051, 0.169391>, <4.271018, 2.146051, 0.042041>, <5.125222, 2.146051, 0.042041>
    }
  }
  texture {
    BibleLeatherTex
  }
  scale <0.795889, 1.081644, 1.0>
  translate  -0.01*z
}
#declare BibleSweepLft = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-3.502067, 0.909502>,
  <-3.730686, 0.475392>,
  <-4.032949, 0.076786>,
  <-3.9523, 0.002979>,
  <-2.219281, 0.071512>,
  <-0.306402, 0.017749>,
  <-0.000313, 0.078244>,
  <-0.280274, 0.724487>,
  <-1.627103, 1.061864>,
  <-3.266635, 0.961024>,
  <-3.502067, 0.909502>,
  <-3.730686, 0.475392>,
  <-4.032949, 0.076786>
  rotate -x*90
  scale <1.0, 0.75, 5.0>
  rotate 90.0*x
  translate  2.5*y
  texture {
    PagesTexture
  }
}
#declare BibleSweepRt = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-3.502067, 0.909502>,
  <-3.730686, 0.475392>,
  <-4.032949, 0.076786>,
  <-3.9523, 0.002979>,
  <-2.219281, 0.071512>,
  <-0.306402, 0.017749>,
  <-0.000313, 0.078244>,
  <-0.280274, 0.724487>,
  <-1.627103, 1.061864>,
  <-3.266635, 0.961024>,
  <-3.502067, 0.909502>,
  <-3.730686, 0.475392>,
  <-4.032949, 0.076786>
  rotate -x*90
  scale <1.0, 0.75, 5.0>
  rotate <90.0, 0.0, 180.0>
  translate  -2.5*y
  texture {
    PagesTexture
  }
}
// page1 (right side bottom)
bicubic_patch
{ type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.011120, -2.494650, 0.185316>, <0.078613, -2.494650, 1.018775>, <2.231415, -2.494650, 0.848993>, <3.470632, -2.500000, 0.744052>,
      <0.011120, -0.829974, 0.185316>, <0.078613, -0.829974, 1.018775>, <2.231415, -0.829974, 0.848993>, <3.470632, -0.800000, 0.744052>,
      <0.011120, 0.834702, 0.185316>, <0.078613, 0.834702, 1.018775>, <2.231415, 0.834702, 0.848993>, <3.470632, 0.800000, 0.744052>,
      <0.011120, 2.499378, 0.185316>, <0.078613, 2.499378, 1.018775>, <2.231415, 2.499378, 0.848993>, <3.470632, 2.500000, 0.744052>
  texture
  {
      pigment
      {
         image_map
         {
            gif   "Page2.gif"
            map_type 8
         }
      }
      finish
      {
         ambient 0.1
         diffuse 0.798533
         brilliance 1.052333
      }
  }
  translate  -0.004054*x
  rotate 42.0*z
  translate  <-0.38079, -0.163196, 0.0>
}

// page2 (left side bottom)
bicubic_patch
{ type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.003903, -2.494650, 0.252703>, <-0.141173, -2.494650, 0.992311>, <-2.231415, -2.494650, 0.848993>, <-3.470632, -2.500000, 0.744052>,
      <-0.003903, -0.829974, 0.252703>, <-0.141173, -0.829974, 0.992311>, <-2.231415, -0.829974, 0.848993>, <-3.470632, -0.800000, 0.744052>,
      <-0.003903, 0.834702, 0.252703>, <-0.141173, 0.834702, 0.992311>, <-2.231415, 0.834702, 0.848993>, <-3.470632, 0.800000, 0.744052>,
      <-0.003903, 2.499378, 0.252703>, <-0.141173, 2.499378, 0.992311>, <-2.231415, 2.499378, 0.848993>, <-3.470632, 2.500000, 0.744052>
  texture
  {
      pigment
      {
         image_map
         {
            gif   "Page1.gif"
            map_type 8
         }
      }
      finish
      {
         ambient 0.1
         diffuse 0.798533
         brilliance 1.052333
      }
  }
  translate  -0.004054*x
  rotate 42.0*z
  translate  <-0.38079, -0.163196, 0.0>
}

// page (right side top - flipping)
bicubic_patch
{ type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.003903, -2.494650, 0.204738>, <-0.025214, -2.494650, 1.031784>, <2.231415, -2.494650, 0.882687>, <3.220487, -2.494650, 1.257775>,
      <0.003903, -0.829974, 0.204738>, <-0.025214, -0.829974, 1.031784>, <2.231415, -0.829974, 0.882687>, <3.220487, -0.829974, 1.257775>,
      <0.003903, 0.834702, 0.204738>, <-0.025214, 0.834702, 1.031784>, <2.231415, 0.834702, 0.882687>, <3.220487, 0.834702, 1.257775>,
      <0.003903, 2.499378, 0.204738>, <-0.025214, 2.499378, 1.031784>, <2.231415, 2.499378, 0.882687>, <2.721853, 2.196465, 1.755007>
      pigment
      {
         image_map
         {
            gif   "Page2.gif"
            map_type 8
         }
      }
      finish
      {
         ambient 0.1
         diffuse 0.798533
         brilliance 1.052333
      }

   translate  -0.004054*x
   rotate 42.0*z
   translate  <-0.38079, -0.163196, 0.0>
 }
union { // Bible
  object { Ribbon }
  object { BibleBinding }
  object { BibleSweepLft }
  object { BibleSweepRt }
  rotate 42.0*z
  translate  <-0.38079, -0.163196, 0.0>
}




